/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.script.npm.AbstractKingScriptBasePlugin;
import kd.bos.devportal.script.npm.KingScriptConfig;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.kingscript.debug.endpoint.DebugServerEndpoint;

public abstract class AbstractKingScriptCheckPlugin
extends AbstractKingScriptBasePlugin {
    private static Log logger = LogFactory.getLog(AbstractKingScriptCheckPlugin.class);
    protected static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static String noSrcISV = "";
    private static String[] FIX_NO_SRC_ISV = new String[]{"kingdee", "kdxk"};
    private static String KINGSCRIPT_PUSH_NOSRC = "kingscript.push.nosrc";

    @Override
    protected boolean check(Map<String, Object> args) {
        if (EnvTypeHelper.isProductEnv()) {
            this.showNotification(args, ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u811a\u672c\u3002", (String)"KingScriptPlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ErrorLevel.Warning);
            return false;
        }
        String isv = ISVService.getISVInfo().getId();
        ArrayList<String> splitISVKeys = new ArrayList<String>(Arrays.asList(FIX_NO_SRC_ISV));
        if (StringUtils.isNotBlank((CharSequence)noSrcISV)) {
            splitISVKeys.addAll(Arrays.asList(StringUtils.split((String)noSrcISV, (String)",")));
        }
        if (splitISVKeys.contains(isv)) {
            this.showNotification(args, "The current ISV disallows saving", ErrorLevel.Warning);
            return false;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.VIEW) {
            this.showNotification(args, "Disable saving in view mode.", ErrorLevel.Warning);
            return false;
        }
        if (!super.check(args)) {
            return false;
        }
        String scriptId = KingScriptConfig.getScriptId(this.getPageCache());
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return true;
        }
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        if (!this.checkScriptVersion(scriptInfo, args)) {
            return false;
        }
        String sriptIsv = scriptInfo.getString("isv");
        if (isv == null || !isv.equalsIgnoreCase(sriptIsv)) {
            this.showNotification(args, DevportalUtil.getNoPermissionTip(), ErrorLevel.Warning);
            return false;
        }
        String debugInfo = this.getDebugInfo();
        if (StringUtils.isNotBlank((CharSequence)debugInfo)) {
            String debugUser = debugInfo.indexOf(":") == -1 ? debugInfo : debugInfo.substring(debugInfo.indexOf(":") + 1);
            this.showNotification(args, String.format(ResManager.loadKDString((String)"\u7528\u6237\u3010%s\u3011\u6b63\u5728\u8c03\u8bd5\u811a\u672c\uff0c\u6682\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"KingScriptPlugin_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), debugUser), ErrorLevel.Warning);
            return false;
        }
        return true;
    }

    private boolean checkScriptVersion(DynamicObject scriptInfo, Map<String, Object> args) {
        String saveModifyId = scriptInfo.getString("modifier_id");
        Long saveModifyDate = scriptInfo.getDate("modifydate").getTime();
        String openModifyDate = KingScriptConfig.getOpenmodifytime(this.getPageCache());
        String userId = RequestContext.get().getUserId();
        if (openModifyDate != null && saveModifyDate != null && saveModifyDate >= Long.parseLong(openModifyDate) + 5000L) {
            if (StringUtils.isNotBlank((CharSequence)saveModifyId)) {
                Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(saveModifyId));
                if (userInfo != null) {
                    this.showNotification(args, String.format(ResManager.loadKDString((String)"\u8be5\u811a\u672c\u6570\u636e\u5df2\u7ecf\u88ab%1$s\u5728%2$s\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u8be5\u811a\u672c\u540e\u518d\u4fee\u6539\u3002", (String)"KDEPlugin_47", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), userInfo.get("name"), DateFormat.getDateTimeInstance().format(saveModifyDate)), ErrorLevel.Error);
                }
            } else {
                this.showNotification(args, ResManager.loadKDString((String)"\u8be5\u811a\u672c\u6570\u636e\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u8be5\u811a\u672c\u540e\u518d\u4fee\u6539\u3002", (String)"KDEPlugin_50", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            }
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String scriptId = KingScriptConfig.getScriptId(this.getPageCache());
        String status = KingScriptConfig.getViewStatus(this.getPageCache());
        Object obj = null;
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String bizAppId = (String)parameter.getCustomParam("bizappid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
            String description = dynamicObject.getString("description");
            if ("edit".equals(status)) {
                Object plugin = parameter.getCustomParam("plugin");
                if (plugin != null) {
                    Map pluginMap = (Map)plugin;
                    pluginMap.put("Description", description);
                    this.getView().returnDataToParent(plugin);
                }
            } else {
                String className = dynamicObject.getString("classname");
                this.returnDataToParent(bizAppId, scriptId, className, description, false);
            }
        }
    }

    private String getDebugInfo() {
        String className = KingScriptConfig.getClassName(this.getPageCache());
        DebugServerEndpoint debugServer = new DebugServerEndpoint();
        String debugInfo = StringUtils.isBlank((CharSequence)className) ? "" : DebugServerEndpoint.getDebuggingInfo((String)className);
        return debugInfo;
    }

    static {
        String tenantId = RequestContext.get().getTenantId();
        noSrcISV = SystemPropertyUtils.getProptyByTenant((String)KINGSCRIPT_PUSH_NOSRC, (String)tenantId);
        ConfigurationUtil.observeChange((String)KINGSCRIPT_PUSH_NOSRC, (key, newValue) -> {
            noSrcISV = SystemPropertyUtils.getProptyByTenant((String)KINGSCRIPT_PUSH_NOSRC, (String)tenantId);
        });
    }
}

