/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.devportal.common.kingscript.KingScriptPluginType;
import kd.bos.devportal.common.kingscript.KingScriptType;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

class AbstractKingScriptPlugin
extends AbstractFormPlugin
implements KingScriptEditorListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    protected static final String FORMTS = "p1MEoP47";
    protected static final String BILLTS = "rnry3Wse";
    protected static final String LISTTS = "ZMJMZ50L";
    protected static final String OPERATIONTS = "npsEzBqI";
    protected static final String MOBILE_FORM = "J1oZDEE4";
    protected static final String MOBILE_BILL = "H0j7Vznm";
    protected static final String MOBILE_BILL_LIST = "RIe5s2q5";
    protected static final String TEMPLATE_CONVERTTS = "6cIzjiU6";
    protected static final String TEMPLATE_WRITEBACKTS = "Y4UMjaPu";
    protected static final String TEMPLATE_PRINTTS = "LuEmc1Gj";
    protected static final String TEMPLATE_WORKFLOW = "7TwWERnM";
    protected static final String DATEFM = "yyyy-MM-dd HH:mm:ss";
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String PLUGIN_FPK_NAME = "FPK";
    protected static final String ROW_KEY_NAME = "RowKey";
    protected static final String SCRIPTNUMBER = "scriptnumber";
    protected static final String CODE = "kingscripteditap";
    protected static final String SCRIPTNAME = "scriptname";
    protected static final String DESCRIPTION = "description";
    protected static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    protected static final String TXT_SCRIPTNAME = "txt_scriptname";
    protected static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    protected static final String TXT_SCRIPTCONTENT = "txt_scriptcontext";
    protected static final String TXT_SCRIPTCONTENT_TAG = "txt_scriptcontext_tag";
    protected static final String KEY_BIZAPPID = "bizappid";
    protected static final String KEY_BIZUNITID = "bizunitid";
    protected static final String CLASSNAME = "classname";
    protected static final String MODIFYDATE = "modifydate";
    protected static final String MODIFIER_ID = "modifier_id";
    protected static final String SCRIPTMODULE = "scriptmodule";
    protected static final String ENGINETYPE = "enginetype";
    protected static final String ID = "id";
    protected static final String suffix = ".ts";
    protected static final String DESIGNERNAME = "designerName";
    protected static final String OPENMODIFYTIME = "openmodifytime";
    protected static final String EDITOROPENTYPE = "editorOpenType";
    protected static final String AUTOGENERATE = "autogenerate";
    protected static final String AUTOGENERATE_LABEL = "autogeneratelabel";
    protected static final String AUTOGENERATE_ICON = "autogenerateicon";

    AbstractKingScriptPlugin() {
    }

    public void afterCreateNewData(EventObject e) {
        this.initParam();
    }

    protected void initParam() {
        String bizAppId;
        IFormView designerView;
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        String designerName = propertyEditHelper.getSubDesignerName(this.getView());
        if (designerName != null) {
            this.getPageCache().put(DESIGNERNAME, designerName);
        }
        if ((designerView = propertyEditHelper.getDesignFormView(this.getView())) != null) {
            this.getPageCache().put(EDITOROPENTYPE, "designer");
        }
        if ((bizAppId = propertyEditHelper.getBizAppId(this.getView())) == null) {
            bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BIZAPPID);
        }
        if (bizAppId != null) {
            this.getPageCache().put(KEY_BIZAPPID, bizAppId);
        }
    }

    protected String getSubDesignerName() {
        return this.getPageCache().get(DESIGNERNAME);
    }

    protected String getCode() {
        KingScriptEdit codeEdit = (KingScriptEdit)this.getControl(CODE);
        String content = codeEdit.getText();
        if (content == null) {
            content = this.getPageCache().get(CODE);
        }
        return content;
    }

    protected String getMetaId() {
        DynamicObject obj = this.getForm();
        return obj == null ? "" : obj.getString(ID);
    }

    protected DynamicObject getForm() {
        String number = (String)this.getView().getFormShowParameter().getCustomParam("bizpagenumber");
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject[] forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number,isv,bizappid,modeltype", (QFilter[])qFilters);
        return forms == null || forms.length <= 0 ? null : forms[0];
    }

    protected String getBizunit(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return "";
        }
        QFilter qFormId = new QFilter("form", "=", (Object)formId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizunit,bizapp", (QFilter[])new QFilter[]{qFormId});
        return pageRelInfo.getString("bizunit");
    }

    protected String getModule(String bizAppId) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return "";
        }
        AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String BizCloudId = appInfo.getBizCloudID();
        String bizCloudNumber = (String)BusinessDataServiceHelper.loadSingleFromCache((Object)BizCloudId, (String)"bos_devportal_bizcloud", (String)"number").get("number");
        String productPrefix = System.getProperty("kingscript.product.module", "cosmic");
        String module = "@" + productPrefix + "/" + bizCloudNumber;
        return module;
    }

    protected String getClassName(String bizAppId, String scriptNumber, String seperator) {
        AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appInfo.getNumber();
        String className = bizAppNumber + seperator + scriptNumber;
        return className.toLowerCase();
    }

    private String getBillScriptType(IFormView view) {
        String designerName = this.getSubDesignerName();
        String type = "2";
        if (StringUtils.isNotBlank((CharSequence)designerName)) {
            switch (designerName) {
                case "MobListMeta": 
                case "ListMeta": {
                    type = "3";
                    break;
                }
                case "MobMeta": {
                    type = "2";
                }
            }
        }
        return type;
    }

    protected String getBillTemplate(String modelType) {
        String id = BILLTS;
        String designerName = this.getSubDesignerName();
        if (StringUtils.isNotBlank((CharSequence)designerName)) {
            switch (designerName) {
                case "ListMeta": {
                    id = LISTTS;
                    break;
                }
                case "MobMeta": {
                    id = MOBILE_BILL;
                    break;
                }
                case "MobListMeta": {
                    id = MOBILE_BILL_LIST;
                }
            }
        } else if ("MobileBillFormModel".equals(modelType)) {
            id = MOBILE_BILL;
        }
        return id;
    }

    protected void setFocus(String fieldKey) {
        FieldEdit fieldEdit = (FieldEdit)this.getControl(fieldKey);
        fieldEdit.setFocus(true);
    }

    protected void returnDataToParent(String bizAppId, String id, String className, String scriptName, String description, Boolean enable) {
        HashMap<String, Object> plugin = new HashMap<String, Object>();
        plugin.put("Description", description);
        plugin.put("ClassName", className);
        plugin.put("ScriptName", scriptName);
        plugin.put(PLUGIN_FPK_NAME, id);
        plugin.put("BizAppId", bizAppId);
        plugin.put("Enabled", enable);
        plugin.put("Type", 4);
        Object rowKey = this.getView().getFormShowParameter().getCustomParam(ROW_KEY_NAME);
        if (rowKey == null) {
            rowKey = this.getView().getFormShowParameter().getCustomParam("rowKey");
        }
        plugin.put(ROW_KEY_NAME, rowKey);
        this.getView().returnDataToParent(plugin);
    }

    protected boolean check(Map<String, Object> args) {
        String scriptName;
        String scriptNumber = (String)this.getModel().getValue(SCRIPTNUMBER);
        if (scriptNumber != null) {
            scriptNumber = scriptNumber.trim();
        }
        if ((scriptName = (String)this.getModel().getValue(SCRIPTNAME)) != null) {
            scriptName = scriptName.trim();
        }
        if (StringUtils.isBlank((CharSequence)scriptNumber)) {
            this.setFocus(SCRIPTNUMBER);
            this.showNotification(args, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KingScriptPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ErrorLevel.Warning);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            this.setFocus(SCRIPTNAME);
            this.showNotification(args, ResManager.loadKDString((String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KingScriptPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ErrorLevel.Warning);
            return false;
        }
        String regex = "[a-z0-9A-Z_]+";
        if (!Pattern.matches(regex, scriptNumber)) {
            this.showNotification(args, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u53ea\u80fd\u4ee5\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"KingScriptPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ErrorLevel.Warning);
            return false;
        }
        QFilter qName = new QFilter(TXT_SCRIPTNAME, "=", (Object)scriptName);
        QFilter qNumber = new QFilter(TXT_SCRIPTNUMBER, "=", (Object)scriptNumber);
        String scriptId = this.getPageCache().get(ID);
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            QFilter qID = new QFilter(ID, "not in", (Object)new Object[]{scriptId});
            qName.and(qID);
            qNumber.and(qID);
        }
        this.getModel().setValue(SCRIPTNUMBER, (Object)scriptNumber);
        this.getModel().setValue(SCRIPTNAME, (Object)scriptName);
        return true;
    }

    protected void showNotification(Map<String, Object> args, String msg, ErrorLevel errorLevel) {
        boolean isDebugSave = false;
        if (args != null && args.get("isDebugSave") != null) {
            isDebugSave = (Boolean)args.get("isDebugSave");
        }
        switch (errorLevel) {
            case Info: {
                if (!isDebugSave) {
                    this.getView().showSuccessNotification(msg);
                    break;
                }
                this.sendMessage(args, msg, true, "");
                break;
            }
            case Warning: {
                this.getView().showTipNotification(msg);
                if (!isDebugSave) break;
                this.sendMessage(args, msg, false, "-4");
                break;
            }
            case Error: {
                this.getView().showErrorNotification(msg);
                if (!isDebugSave) break;
                this.sendMessage(args, msg, false, "-4");
            }
        }
    }

    protected void sendMessage(Map<String, Object> args, String msg, boolean success, String errorCode) {
        if (!success) {
            HashMap<String, String> error = new HashMap<String, String>(16);
            error.put("code", errorCode);
            error.put("message", msg);
            args.put("error", error);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(CODE, "codeEditorDebugProtocolResponse", new Object[]{args});
    }

    protected StringBuffer initTitleContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("/**\n * @author ").append(RequestContext.get().getUserName()).append("\n * @date ").append(new SimpleDateFormat("yyyy-MM-dd").format(new Date())).append("\n */\n");
        return sb;
    }

    protected String getTemplateId() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        String scriptType = KingScriptType.getScriptType((IFormView)this.getView(), (String)modelType, this::getBillScriptType);
        KingScriptPluginType kingScriptPluginType = KingScriptPluginType.fromValue((String)scriptType);
        if (kingScriptPluginType == null) {
            return "";
        }
        String id = kingScriptPluginType.getTemplateId();
        String scriptTypeFilter = (String)this.getView().getFormShowParameter().getCustomParams().get("scripttypefilter");
        if (StringUtils.isNotBlank((CharSequence)scriptTypeFilter) && !"page".equals(scriptTypeFilter) && StringUtils.isNotBlank((CharSequence)id)) {
            return id;
        }
        if (StringUtils.isBlank((CharSequence)modelType)) {
            return "";
        }
        if ("writebackplugin".equalsIgnoreCase(modelType)) {
            modelType = "WriteBackRuleModel";
        }
        switch (modelType) {
            case "BillFormModel": 
            case "BaseFormModel": 
            case "MobileBillFormModel": {
                id = this.getBillTemplate(modelType);
                break;
            }
            case "DynamicFormModel": {
                id = FORMTS;
                break;
            }
            case "MobileFormModel": {
                id = MOBILE_FORM;
                break;
            }
            case "MobileListModel": {
                id = MOBILE_BILL_LIST;
                break;
            }
            case "WORKFLOW_PLUGIN_MODEL": {
                id = TEMPLATE_WORKFLOW;
            }
        }
        return id;
    }
}

