/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.script.npm.AbstractKingScriptBasePlugin;
import kd.bos.devportal.script.npm.KingScriptConfig;
import kd.bos.devportal.script.npm.gpt.GPTScriptServiceImpl;
import kd.bos.devportal.script.npm.gpt.KingScriptGPTService;
import kd.bos.devportal.script.npm.gpt.service.GPTServiceFactory;
import kd.bos.devportal.script.npm.helper.KingScriptConfigHelper;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.utils.LogPrintUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class KingScriptGPTPlusPlugin
extends AbstractKingScriptBasePlugin {
    Log logger = LogFactory.getLog(KingScriptGPTPlusPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String ACTION_SCRIPT_CODE_NAMING = "kingscript_code_naming";
    private static final String ACTION_GET_CODEEDITOR_GPT_CONFIG = "getCodeEditorGptConfig";
    private static final String ACTION_SCRIPT_CODE_STOPAIANSWER = "kingscript_code_stopAIAnswer";
    private static final String AUTOGENERATE = "autogenerate";
    private static final String AUTOGENERATE_LABEL = "autogeneratelabel";
    private static final String AUTOGENERATE_ICON = "autogenerateicon";
    private static final int KINGSCRIPT_TOP = 20;
    private KingScriptGPTService scriptGPTService = KingScriptGPTService.create();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{AUTOGENERATE, AUTOGENERATE_ICON, AUTOGENERATE_LABEL});
        KingScriptEdit edit = (KingScriptEdit)this.getControl("kingscripteditap");
        edit.addScriptEditorListener((KingScriptEditorListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!KingScriptConfigHelper.enableGPT()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AUTOGENERATE});
        }
    }

    public void codeEditorAction(KingScriptEditorEvent e) {
        String key = e.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (ACTION_GET_CODEEDITOR_GPT_CONFIG.equals(key)) {
            this.getCodeEditorGptConfig();
            return;
        }
        if (ACTION_SCRIPT_CODE_STOPAIANSWER.equals(key)) {
            this.scriptGPTService.stopCodeAction(this.getView(), e.getParam());
            return;
        }
        if (GPTServiceFactory.searchServiceByName(key)) {
            this.scriptGPTService.codeAction(this.getView(), key, e.getParam());
            return;
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "autogenerate": 
            case "autogenerateicon": 
            case "autogeneratelabel": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String content = KingScriptConfig.getConfig(this.getPageCache()).getCodeNow(this.getView());
                if (StringUtils.isBlank((CharSequence)content)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7f16\u5199\u4ee3\u7801\u3002", (String)"KingScriptPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String bizPageId = (String)this.getView().getFormShowParameter().getCustomParam("bizPageId");
                map.put("content", content);
                map.put("code", content);
                map.put("bizPageId", bizPageId);
                map.put("page_id", this.getView().getPageId());
                map.put("modelType", this.scriptGPTService.getModelType(this.getView()));
                this.autoGenerate(ACTION_SCRIPT_CODE_NAMING, map);
            }
        }
    }

    private void getCodeEditorGptConfig() {
        ArrayList args = new ArrayList(10);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("gptEnable", this.enableGPT());
        map.put("codeGenTips", this.getCodeGenlib());
        args.add(map);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getControl("kingscripteditap").getKey(), "setCodeEditorGptConfig", new Object[]{args});
    }

    private boolean enableGPT() {
        Object isOnlyCodeEditor = this.getView().getFormShowParameter().getCustomParam("isOnlyCodeEditor");
        if (isOnlyCodeEditor != null && Boolean.TRUE.toString().equals(isOnlyCodeEditor.toString())) {
            return false;
        }
        Object isOnlyViewEditor = this.getView().getFormShowParameter().getCustomParam("isOnlyViewEditor");
        if (isOnlyViewEditor != null && Boolean.TRUE.toString().equals(isOnlyViewEditor.toString())) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)"kingscript.editor.gpt.enable", (String)tenantId);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return Boolean.FALSE;
    }

    private List<Map<String, Object>> getCodeGenlib() {
        String sql = String.format("select TOP %s a.fid,a.fseq,b.fcomment from t_bas_kingscriptlib a join t_bas_kingscriptlib_l b on a.fid = b.fid where fscripttype = ? and b.flocaleid = ? order by a.fseq", 20);
        String modelType = this.scriptGPTService.getModelType(this.getView());
        Object[] param = new Object[]{KingScriptConfigHelper.getScriptType(this.getView(), modelType), Locale.getDefault().toString()};
        ResultSetHandler<List<Map<String, Object>>> action = new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> codeLibs = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, Object> codeMap = new HashMap<String, Object>(2);
                    codeMap.put("id", rs.getLong("fid"));
                    codeMap.put("tips", rs.getString("fcomment"));
                    codeLibs.add(codeMap);
                }
                return codeLibs;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])param, (ResultSetHandler)action);
    }

    private void autoGenerate(String key, Map<String, Object> param) {
        Map<String, Object> result = GPTScriptServiceImpl.invokeAiService(key, param);
        String message = (String)result.get("message");
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        Map data = (Map)result.get("data");
        if (data == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"KingScriptPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String value = (String)data.get("llmValue");
        if (ACTION_SCRIPT_CODE_NAMING.equals(key)) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject jsonObject;
                JSONObject map = jsonObject = (JSONObject)parser.parse(value);
                this.getModel().beginInit();
                String scriptNumber = this.formatScriptNumber((String)map.get("number"));
                this.getModel().setValue("scriptnumber", (Object)scriptNumber);
                this.getModel().setValue("scriptname", map.get("name"));
                this.getModel().setValue("description", map.get("desc"));
                this.getModel().endInit();
                this.getView().updateView();
            }
            catch (ParseException ex) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"KingScriptPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                LogPrintUtil.printExceptionMessage((Exception)((Object)ex), (String)(key + " error"));
            }
        } else {
            this.sendEditorGptData(key, value);
        }
    }

    private String formatScriptNumber(String number) {
        if (number == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(number.length());
        int n = number.length();
        for (int i = 0; i < n; ++i) {
            int ch = number.charAt(i);
            if (ch != 95 && !Character.isLetterOrDigit((char)ch)) {
                ch = 95;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private void sendEditorGptData(String key, String value) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add(key);
        list.add(value);
        proxy.invokeControlMethod(this.getControl("kingscripteditap").getKey(), "sendEditorGptData", new Object[]{list});
    }
}

