/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.script.npm.AbstractKingScriptCheckPlugin;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.ProjectInitializerManager;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.ModuleExports;
import kd.sdk.kingscript.exception.EnginePoolNotReadyException;
import kd.sdk.kingscript.exception.ScriptException;

public class KingScriptListModulePlugin
extends AbstractKingScriptCheckPlugin {
    private static Log logger = LogFactory.getLog(KingScriptListModulePlugin.class);
    private static final String ACTION_SCRIPT_LISTMODULE_EXPORTS = "listModuleExports";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        KingScriptEdit edit = (KingScriptEdit)this.getControl("kingscripteditap");
        edit.addScriptEditorListener((KingScriptEditorListener)this);
    }

    public void codeEditorAction(KingScriptEditorEvent e) {
        String key = e.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "listModuleExports": {
                this.listModuleExports(e.getParam());
            }
        }
    }

    private void listModuleExports(Map<String, Object> args) {
        if (args == null || args.isEmpty() || !args.containsKey("modules")) {
            return;
        }
        List modules = (List)args.get("modules");
        String moduleExportsStr = "";
        if (!Plugin.enableRunKingScript()) {
            return;
        }
        try (KingScriptEngine engine = ProjectInitializerManager.getEngine((boolean)false);){
            ModuleExports moduleExports = engine.listModuleExports(modules.toArray(new String[modules.size()]));
            moduleExportsStr = moduleExports.toJSONString();
        }
        catch (EnginePoolNotReadyException e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f15\u64ce\u6c60\u6b63\u5728\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002", (String)"KingScriptPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        }
        catch (ScriptException e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u811a\u672c\u5f15\u64ce\u83b7\u53d6\u5931\u8d25:%s", (String)"KingScriptEdit_1", (String)"bos-form-metadata", (Object[])new Object[0]), e.getMessage()));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("kingscripteditap", "setModuleExports", new Object[]{moduleExportsStr});
    }
}

