/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.devportal.script.npm.AbstractKingScriptPlugin;
import kd.bos.devportal.script.npm.helper.KingScriptConfigHelper;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sdk.kingscript.debug.endpoint.DebugServerEndpoint;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.ModuleExports;
import kd.sdk.kingscript.exception.EnginePoolNotReadyException;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;

public class KingScriptPlugin
extends AbstractKingScriptPlugin {
    private static Log logger = LogFactory.getLog(KingScriptPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String OK = "ok";
    private static final String SAVE = "save";
    private static final String EXIT = "exit";
    private static final String EXPORT = "export";
    private static final String EXPORTICON = "exporticon";
    private static final String GUIDE = "guide";
    private static final String GUIDE_LABEL = "guidelabel";
    private static final String CODE = "kingscripteditap";
    private static final String ACTION_SCRIPT_CODE_SAVE = "saveCodeEditorCont";
    private static final String ACTION_SCRIPT_LISTMODULE_EXPORTS = "listModuleExports";
    private static final String CONFIRM_CALL_BACK_EDITOR_SAVE = "editorSaveCallBack";
    private static final String GET_CODEEDITOR_CONFIG = "getCodeEditorConfig";
    private static final String SEND_CODE_EDITOR_DEBUG_PROTOCOL = "sendCodeEditorDebugProtocol";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OK, EXIT, SAVE, EXPORT, EXPORTICON, GUIDE, GUIDE_LABEL});
        KingScriptEdit edit = (KingScriptEdit)this.getControl(CODE);
        edit.addScriptEditorListener((KingScriptEditorListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String scriptId = (String)this.getView().getFormShowParameter().getCustomParam("bizscriptid");
        Object plugin = this.getView().getFormShowParameter().getCustomParam("plugin");
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            this.loadScript(scriptId);
        } else if (plugin instanceof Map) {
            Map pluginMap = (Map)plugin;
            scriptId = (String)pluginMap.get("FPK");
            this.loadScript(scriptId);
        } else {
            String templateId = this.getTemplateId();
            if (StringUtils.isNotBlank((CharSequence)templateId)) {
                DynamicObject scriptObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"ide_pluginscript");
                String content = scriptObj == null ? "" : scriptObj.getString("txt_scriptcontext_tag");
                StringBuffer title = this.initTitleContent();
                title.append(content);
                this.setCode(title.toString());
            }
        }
        String viewStatus = this.getPageCache().get("viewStatus");
        if ("edit".equals(viewStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"scriptnumber"});
        }
    }

    private void loadScript(String scriptId) {
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            DynamicObject scriptObj = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
            String name = scriptObj.getString("txt_scriptname");
            String number = scriptObj.getString("txt_scriptnumber");
            String description = scriptObj.getString("description");
            String content = scriptObj.getString("txt_scriptcontext_tag");
            String className = scriptObj.getString("classname");
            String bizAppId = scriptObj.getString("bizappid");
            this.getPageCache().put("id", scriptId);
            this.getPageCache().put("classname", className);
            this.getPageCache().put("bizappid", bizAppId);
            this.getPageCache().put("viewStatus", "edit");
            String modifiDateTime = String.valueOf(scriptObj.getDate("modifydate").getTime());
            this.getPageCache().put("openmodifytime" + scriptId, modifiDateTime);
            this.getModel().setValue("scriptnumber", (Object)number);
            this.getModel().setValue("scriptname", (Object)name);
            this.getModel().setValue("description", (Object)description);
            this.setCode(content);
        }
    }

    private void setCodeEditorConfig() {
        ArrayList args = new ArrayList(10);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String className = this.getPageCache().get("classname");
        String number = (String)this.getModel().getValue("scriptnumber");
        String name = (String)this.getModel().getValue("scriptname");
        String scriptId = this.getPageCache().get("id");
        String viewStatus = this.getPageCache().get("viewStatus");
        String bizAppId = this.getPageCache().get("bizappid");
        boolean debugEnable = this.isDebugEnable(className);
        boolean editEnable = true;
        boolean codeDemo = this.isCodeDemoEnable();
        if ("edit".equals(viewStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"scriptnumber"});
            editEnable = this.isEditEnable(scriptId);
            if (!this.requireLock(scriptId)) {
                debugEnable = false;
                editEnable = false;
            }
            if (!editEnable) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"scriptnumber", "scriptname", "description", CODE, SAVE, OK, "autogenerate", "autogenerateicon", "autogeneratelabel"});
            }
        }
        map.put("scriptPath", className);
        map.put("scriptCode", number);
        map.put("scriptName", name);
        map.put("debugEnable", debugEnable);
        map.put("editEnable", editEnable);
        map.put("codeDemoEnable", codeDemo);
        map.put("appid", bizAppId);
        args.add(map);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getControl(CODE).getKey(), "setCodeEditorConfig", new Object[]{args});
    }

    private boolean isDebugEnable(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return false;
        }
        String debugEnable = System.getProperty("kingscript.debug.enable", "true");
        return Boolean.parseBoolean(debugEnable);
    }

    private boolean isEditEnable(String scriptId) {
        boolean editEnable = true;
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        String sriptIsv = scriptInfo.getString("isv");
        String isv = ISVService.getISVInfo().getId();
        if (isv == null || !isv.equalsIgnoreCase(sriptIsv)) {
            editEnable = false;
        }
        return editEnable;
    }

    private boolean isCodeDemoEnable() {
        String codeDemoEnable = System.getProperty("kingscript.codedemo.enable", "true");
        return Boolean.parseBoolean(codeDemoEnable);
    }

    private boolean isBindScript() {
        String editOpenType = this.getPageCache().get("editorOpenType");
        if (!"designer".equals(editOpenType)) {
            return true;
        }
        String className = this.getPageCache().get("classname");
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("bizpagenumber");
        String scriptTypeFilter = (String)this.getView().getFormShowParameter().getCustomParams().get("scripttypefilter");
        if ("operate".equalsIgnoreCase(scriptTypeFilter)) {
            String id = this.getMetaId();
            if (StringUtils.isBlank((CharSequence)id)) {
                return true;
            }
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
            List operations = entityMetadata.getRootEntity().getOperations();
            if (operations == null || operations.isEmpty()) {
                return false;
            }
            for (Operation operation : operations) {
                List pluginList = operation.getPlugins();
                if (pluginList == null || pluginList.isEmpty()) continue;
                for (Plugin plugin : pluginList) {
                    String pluginName = plugin.getClassName();
                    if (!className.equalsIgnoreCase(pluginName)) continue;
                    return true;
                }
            }
        } else {
            List<Plugin> plugins = this.getPluginsByType(formId);
            if (plugins == null || plugins.isEmpty()) {
                return false;
            }
            for (Plugin plugin : plugins) {
                if (!plugin.getClassName().equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Plugin> getPluginsByType(String formId) {
        List plugins = null;
        String designerName = this.getSubDesignerName();
        String id = this.getMetaId();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        FormAp rootAp = formMetadata.getRootAp();
        if (StringUtils.isBlank((CharSequence)designerName)) {
            return rootAp == null ? null : rootAp.getPlugins();
        }
        switch (designerName) {
            case "MobListMeta": {
                if (!(rootAp instanceof BillFormAp)) break;
                plugins = ((BillFormAp)rootAp).getMobListMeta().getRootAp().getPlugins();
                break;
            }
            case "ListMeta": {
                if (!(rootAp instanceof BillFormAp)) break;
                plugins = ((BillFormAp)rootAp).getListMeta().getRootAp().getPlugins();
                break;
            }
            case "MobMeta": {
                if (!(rootAp instanceof BillFormAp)) break;
                plugins = ((BillFormAp)rootAp).getMobMeta().getRootAp().getPlugins();
                break;
            }
            default: {
                plugins = rootAp.getPlugins();
            }
        }
        return plugins;
    }

    private void sendCodeEditorDebugProtocol(Map<String, Object> args) {
        if (args == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u52a8\u8c03\u8bd5\u53c2\u6570\u4e3a\u7a7a\uff0c\u542f\u52a8\u5931\u8d25\u3002", (String)"KingScriptPlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if ("Debugger.prepare".equals(args.get("method"))) {
            if (!this.isBindScript()) {
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u811a\u672c\u672a\u4e0e\u8868\u5355\u7ed1\u5b9a\uff0c\u8bf7\u5148\u4fdd\u5b58\u8bbe\u8ba1\u5668\u3002", (String)"KingScriptPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                this.sendMessage(args, msg, false, "-3");
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u8c03\u8bd5\u6210\u529f\uff0c\u53ef\u5230\u672c\u4f1a\u8bdd\u4e2d\u5bf9\u5e94\u9875\u9762\u8fdb\u884c\u6d4b\u8bd5\u3002", (String)"KingScriptPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        String debugId = (String)args.get("debugId");
        DebugServerEndpoint debugServer = new DebugServerEndpoint();
        debugServer.request(debugId, SerializationUtils.toJsonString(args));
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void codeEditorAction(KingScriptEditorEvent e) {
        String key = e.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "saveCodeEditorCont": {
                if (!this.check(e.getParam())) break;
                this.save(false, e.getParam());
                break;
            }
            case "listModuleExports": {
                this.listModuleExports(e.getParam());
                break;
            }
            case "getCodeEditorConfig": {
                this.setCodeEditorConfig();
                break;
            }
            case "sendCodeEditorDebugProtocol": {
                this.sendCodeEditorDebugProtocol(e.getParam());
            }
        }
    }

    private void listModuleExports(Map<String, Object> args) {
        if (args == null || args.isEmpty() || !args.containsKey("modules")) {
            return;
        }
        List modules = (List)args.get("modules");
        String moduleExportsStr = "";
        try (KingScriptEngine engine = ProjectInitializerManager.getEngine((boolean)false);){
            ModuleExports moduleExports = engine.listModuleExports(modules.toArray(new String[modules.size()]));
            moduleExportsStr = moduleExports.toJSONString();
        }
        catch (EnginePoolNotReadyException e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f15\u64ce\u6c60\u6b63\u5728\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002", (String)"KingScriptPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(CODE, "setModuleExports", new Object[]{moduleExportsStr});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "ok": {
                if (!this.check(null)) break;
                this.save(true, null);
                break;
            }
            case "save": {
                if (!this.check(null)) break;
                this.save(false, null);
                break;
            }
            case "exit": {
                String code = this.getPageCache().get(CODE);
                if (this.getModel().getDataChanged() || !StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)this.getCode())) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7f16\u8f91\u5668\u6570\u636e\u6709\u672a\u4fdd\u5b58\u7684\u6539\u52a8\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"KingScriptPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALL_BACK_EDITOR_SAVE));
                    return;
                }
                this.getView().close();
                break;
            }
            case "export": 
            case "exporticon": {
                String scriptId = this.getPageCache().get("id");
                if (StringUtils.isBlank((CharSequence)scriptId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u811a\u672c\u5185\u5bb9\u3002", (String)"KingScriptPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                DevportalUtil.exportScriptCallBack(scriptId, this.getView());
                break;
            }
            case "guide": 
            case "guidelabel": {
                this.getView().openUrl("https://vip.kingdee.com/article/474603833033832192");
            }
        }
    }

    @Override
    protected boolean check(Map<String, Object> args) {
        if (!super.check(args)) {
            return false;
        }
        String scriptId = this.getPageCache().get("id");
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            return true;
        }
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        if (!this.checkScriptVersion(scriptInfo, args)) {
            return false;
        }
        String sriptIsv = scriptInfo.getString("isv");
        String isv = ISVService.getISVInfo().getId();
        if (isv == null || !isv.equalsIgnoreCase(sriptIsv)) {
            this.showNotification(args, DevportalUtil.getNoPermissionTip(), ErrorLevel.Warning);
            return false;
        }
        String debugInfo = this.getDebugInfo();
        if (StringUtils.isNotBlank((CharSequence)debugInfo)) {
            String debugUser = debugInfo.indexOf(":") == -1 ? debugInfo : debugInfo.substring(debugInfo.indexOf(":") + 1);
            this.showNotification(args, String.format(ResManager.loadKDString((String)"\u7528\u6237\u3010%s\u3011\u6b63\u5728\u8c03\u8bd5\u811a\u672c\uff0c\u6682\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"KingScriptPlugin_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), debugUser), ErrorLevel.Warning);
            return false;
        }
        return true;
    }

    private boolean checkScriptVersion(DynamicObject scriptInfo, Map<String, Object> args) {
        String scriptId = this.getPageCache().get("id");
        String saveModifyId = scriptInfo.getString("modifier_id");
        Long saveModifyDate = scriptInfo.getDate("modifydate").getTime();
        String openModifyDate = this.getPageCache().get("openmodifytime" + scriptId);
        String userId = RequestContext.get().getUserId();
        if (openModifyDate != null && saveModifyDate != null && saveModifyDate >= Long.parseLong(openModifyDate) + 5000L) {
            if (StringUtils.isNotBlank((CharSequence)saveModifyId)) {
                Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(saveModifyId));
                if (userInfo != null) {
                    this.showNotification(args, String.format(ResManager.loadKDString((String)"\u8be5\u811a\u672c\u6570\u636e\u5df2\u7ecf\u88ab%1$s\u5728%2$s\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u8be5\u811a\u672c\u540e\u518d\u4fee\u6539\u3002", (String)"KDEPlugin_47", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), userInfo.get("name"), DateFormat.getDateTimeInstance().format(saveModifyDate)), ErrorLevel.Error);
                }
            } else {
                this.showNotification(args, ResManager.loadKDString((String)"\u8be5\u811a\u672c\u6570\u636e\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u8be5\u811a\u672c\u540e\u518d\u4fee\u6539\u3002", (String)"KDEPlugin_50", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            }
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String scriptId = this.getPageCache().get("id");
        String status = this.getPageCache().get("viewStatus");
        Object obj = null;
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String bizAppId = (String)parameter.getCustomParam("bizappid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
            String description = dynamicObject.getString("description");
            if ("edit".equals(status)) {
                Object plugin = parameter.getCustomParam("plugin");
                if (plugin != null) {
                    Map pluginMap = (Map)plugin;
                    pluginMap.put("Description", description);
                    this.getView().returnDataToParent(plugin);
                }
            } else {
                String scriptName = dynamicObject.getString("txt_scriptname");
                String className = dynamicObject.getString("classname");
                this.returnDataToParent(bizAppId, scriptId, className, scriptName, description, false);
            }
        }
    }

    private void save(boolean close, Map<String, Object> args) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam("bizappid");
        String description = (String)this.getModel().getValue("description");
        String scriptId = this.getPageCache().get("id");
        DynamicObject obj = null;
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            obj = this.addNew(args);
            if (obj == null) {
                return;
            }
            scriptId = obj.getString("id");
            this.getPageCache().put("id", scriptId);
            this.requireLock(scriptId);
        } else {
            obj = this.update(scriptId);
        }
        this.getPageCache().put(CODE, this.getCode());
        this.showNotification(args, ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"KingScriptPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), ErrorLevel.Info);
        String className = obj.getString("classname");
        String scriptName = obj.getString("txt_scriptname");
        String id = obj.getString("id");
        this.getPageCache().put("id", id);
        long newModifyDate = Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).getTime();
        String modifiDateTime = String.valueOf(newModifyDate);
        this.getPageCache().put("openmodifytime" + scriptId, modifiDateTime);
        this.getModel().setDataChanged(false);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            Date modifyDate = obj.getDate("modifydate");
            long version = System.currentTimeMillis();
            if (modifyDate != null) {
                try {
                    version = this.dateFormat.parse(this.dateFormat.format(modifyDate)).getTime();
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            ScriptVersionManager.setVersion((String)className, (String)String.valueOf(version), null);
        }
        if (!close) {
            return;
        }
        this.getPageCache().put("viewStatus", "edit");
        this.returnDataToParent(bizAppId, id, className, scriptName, description, true);
        this.getView().close();
    }

    private DynamicObject update(String scriptId) {
        String scriptNumber = (String)this.getModel().getValue("scriptnumber");
        String scriptName = (String)this.getModel().getValue("scriptname");
        String description = (String)this.getModel().getValue("description");
        String content = this.getCode();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        dynamicObject.set("txt_scriptnumber", (Object)scriptNumber);
        dynamicObject.set("txt_scriptname", (Object)scriptName);
        dynamicObject.set("description", (Object)description);
        dynamicObject.set("txt_scriptcontext_tag", (Object)content);
        dynamicObject.set("txt_scriptcontext", (Object)" ");
        dynamicObject.set("enginetype", (Object)"1");
        dynamicObject.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
        String isv = dynamicObject.getString("isv");
        if (StringUtils.isBlank((CharSequence)isv)) {
            isv = ISVService.getISVInfo().getId();
            dynamicObject.set("isv", (Object)isv);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    private DynamicObject addNew(Map<String, Object> args) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String formNumber = (String)parameter.getCustomParam("bizpagenumber");
        DynamicObject form = this.getForm();
        String formId = form == null ? "" : form.getPkValue().toString();
        String bizAppId = (String)parameter.getCustomParam("bizappid");
        if (StringUtils.isBlank((CharSequence)bizAppId) && form != null) {
            bizAppId = form.getString("bizappid");
        }
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return null;
        }
        String modelType = (String)parameter.getCustomParam("modelType");
        if (StringUtils.isBlank((CharSequence)modelType) && form != null) {
            modelType = form.getString("modeltype");
        }
        String scriptNumber = (String)this.getModel().getValue("scriptnumber");
        String scriptName = (String)this.getModel().getValue("scriptname");
        String description = (String)this.getModel().getValue("description");
        String content = this.getCode();
        String id = Uuid8.generateShortUuid();
        String bizUnitId = this.getBizunit(formId);
        String className = this.getClassName(bizAppId, scriptNumber, "/");
        String scriptType = KingScriptConfigHelper.getScriptType(this.getView(), modelType);
        String module = this.getModule(bizAppId);
        className = module + "/" + className + ".ts";
        QFilter qClassName = new QFilter("classname", "=", (Object)className);
        QFilter[] filters = new QFilter[]{qClassName};
        if (QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])filters)) {
            this.setFocus("scriptnumber");
            this.showNotification(args, String.format(ResManager.loadKDString((String)"\u811a\u672c\u8def\u5f84%s\u5df2\u5b58\u5728\u3002", (String)"KingScriptPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), className), ErrorLevel.Warning);
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ide_pluginscript");
        dynamicObject.set("enginetype", (Object)"1");
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("txt_scriptname", (Object)scriptName);
        dynamicObject.set("txt_scriptnumber", (Object)scriptNumber);
        dynamicObject.set("description", (Object)description);
        dynamicObject.set("classname", (Object)className);
        dynamicObject.set("scriptmodule", (Object)module);
        dynamicObject.set("cbox_script_type", (Object)scriptType);
        dynamicObject.set("bizunitid", (Object)bizUnitId);
        dynamicObject.set("bizappid", (Object)bizAppId);
        dynamicObject.set("txt_scriptcontext_tag", (Object)content);
        dynamicObject.set("txt_scriptcontext", (Object)" ");
        dynamicObject.set("creater", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set("createdate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
        dynamicObject.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
        String isv = dynamicObject.getString("isv");
        if (StringUtils.isBlank((CharSequence)isv)) {
            isv = ISVService.getISVInfo().getId();
            dynamicObject.set("isv", (Object)isv);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    private void setCode(String content) {
        KingScriptEdit codeEdit = (KingScriptEdit)this.getControl(CODE);
        codeEdit.setText(content);
        this.getPageCache().put(CODE, content);
    }

    private String getDebugInfo() {
        String className = this.getPageCache().get("classname");
        DebugServerEndpoint debugServer = new DebugServerEndpoint();
        String debugInfo = StringUtils.isBlank((CharSequence)className) ? "" : DebugServerEndpoint.getDebuggingInfo((String)className);
        return debugInfo;
    }

    private boolean requireLock(String scriptId) {
        StringBuilder errorMsg = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo(scriptId, "", "", "ide_pluginscript", "modify", false, "kingScriptEdit");
        boolean success = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errorMsg);
        if (!success) {
            this.getView().showErrorNotification(errorMsg.toString());
        }
        return success;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_CALL_BACK_EDITOR_SAVE.equals(actionId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }
}

