/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.dao.FieldsPromptBuilder;
import kd.bos.devportal.script.npm.gpt.IGPTScriptService;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.utils.LogPrintUtil;

@Deprecated
public class GPTScriptServiceImpl
implements IGPTScriptService {
    private static Log logger = LogFactory.getLog(GPTScriptServiceImpl.class);
    private static final String KING_SCRIPT = "kingscript_asyncaiservice";
    public static final String ROOT_PAGE_ID = "root_page_id";
    public static final String ROOT_PAGE_INFO = "root_page_info";
    public static final String PAGE_ID = "page_id";
    public static final String MODELTYPE = "modelType";
    private static final String ACTION = "action";
    private static final String GLOBAL_SESSION_ID = "global_session_id";
    private static final int CACHE_TIMEOUT = 3600;
    private static final int INPUT_LENGTH = 3000;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public static Map<String, Object> invokeAiService(String key, Map<String, Object> param) {
        String cloudId = "ai";
        String appId = "gai";
        String serviceName = "GaiPromptService";
        String methodName = "syncCall";
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)key)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_prompt", (QFilter[])filters);
        if (obj == null) {
            String message = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u76f8\u5e94\u7684GPT\u63d0\u793a\u3002", (String)"GPTScriptServiceImpl_0", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            return GPTScriptServiceImpl.buildErrorResult(message);
        }
        long promptId = obj.getLong("id");
        String input = (String)param.get("content");
        input = GPTScriptServiceImpl.formatInput(input);
        HashMap<String, String> varParams = new HashMap<String, String>();
        String bizPageId = (String)param.get("bizPageId");
        String fieldsDesc = FieldsPromptBuilder.getDescWithJson((String)bizPageId);
        varParams.put("model", fieldsDesc);
        String full_script_code = (String)param.get("code");
        varParams.put("full_script_code", full_script_code);
        String modelType = (String)param.get(MODELTYPE);
        varParams.put("model_type", modelType);
        logger.debug(String.format("\u6784\u5efa\u5b57\u6bb5\u6a21\u578bfield_desc:%s", fieldsDesc));
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{promptId, input, varParams});
            logger.debug(String.format("GPT\u670d\u52a1\u8c03\u7528\u6210\u529f\uff0cresult\uff1a%s", result == null ? "" : SerializationUtils.toJsonString((Object)result)));
            return result;
        }
        catch (Exception e) {
            LogPrintUtil.printExceptionMessage((Exception)e, (String)(key + " error"));
            return GPTScriptServiceImpl.buildErrorResult(String.format(ResManager.loadKDString((String)"GPT\u670d\u52a1\u8c03\u7528\u5931\u8d25\u3002\u9519\u8bef\uff1a%1$s\uff0c\u53d8\u91cf\u53c2\u6570\uff1a%2$s\u3002", (String)"GPTScriptServiceImpl_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), e.getMessage(), SerializationUtils.toJsonString(varParams)));
        }
    }

    public static Map<String, Object> invokeAsyncAiService(String key, Map<String, Object> param) {
        block5: {
            try {
                boolean status;
                String cloudId = "ai";
                String appId = "gai";
                String serviceName = "GaiPromptService";
                String methodName = "asyncCall";
                QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)key)};
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_prompt", (QFilter[])filters);
                if (obj == null) {
                    String message = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u76f8\u5e94\u7684GPT\u63d0\u793a\u3002", (String)"GPTScriptServiceImpl_0", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                    return GPTScriptServiceImpl.buildErrorResult(message);
                }
                long promptId = obj.getLong("id");
                String input = (String)param.get("content");
                input = GPTScriptServiceImpl.formatInput(input);
                HashMap<String, String> varParams = new HashMap<String, String>();
                String bizPageId = (String)param.get("bizPageId");
                String fieldsDesc = (String)param.get("fieldsDesc");
                if (StringUtils.isBlank((String)fieldsDesc)) {
                    fieldsDesc = FieldsPromptBuilder.getDescWithJson((String)bizPageId);
                }
                varParams.put("model", fieldsDesc);
                String full_script_code = (String)param.get("code");
                varParams.put("full_script_code", full_script_code);
                String modelType = (String)param.get(MODELTYPE);
                varParams.put("model_type", modelType);
                HashMap<String, String> callBackInfo = new HashMap<String, String>();
                callBackInfo.put("cloudId", "bos");
                callBackInfo.put("appId", "bos");
                callBackInfo.put("serviceName", "IGPTScriptService");
                callBackInfo.put("methodName", "callBack");
                boolean stream = true;
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{callBackInfo, stream, promptId, input, varParams});
                logger.debug(String.format("GaiPromptService \u8fd4\u56de\u7ed3\u679c\uff1a%s", result == null ? "" : SerializationUtils.toJsonString((Object)result)));
                if (null == result) break block5;
                boolean bl = status = result.get("status") == null ? false : (Boolean)result.get("status");
                if (status) {
                    Map data = (Map)result.get("data");
                    String taskId = (String)data.get("task_id");
                    String rootPageId = (String)param.get(ROOT_PAGE_ID);
                    String pageId = (String)param.get(PAGE_ID);
                    GPTScriptServiceImpl.CachePageInfo(taskId, key, rootPageId, pageId);
                    break block5;
                }
                String errMsg = (String)result.get("errMsg");
                String message = String.format(ResManager.loadKDString((String)"GPT\u670d\u52a1\u8c03\u7528\u5931\u8d25\u3002\u9519\u8bef\uff1a%1$s\uff0c\u53d8\u91cf\u53c2\u6570\uff1a%2$s\u3002", (String)"GPTScriptServiceImpl_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), errMsg, SerializationUtils.toJsonString(varParams));
                GPTScriptServiceImpl.pushWSMessage(param, "", true);
                return GPTScriptServiceImpl.buildErrorResult(message);
            }
            catch (Exception e) {
                LogPrintUtil.printExceptionMessage((Exception)e, (String)(key + " error"));
                GPTScriptServiceImpl.pushWSMessage(param, "", true);
            }
        }
        return GPTScriptServiceImpl.buildResult(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u529f", (String)"GPTScriptServiceImpl_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
    }

    @Override
    public void callBack(Map<String, Object> response) {
        boolean status;
        logger.debug(String.format("\u5fae\u670d\u52a1\u56de\u8c03\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%s", SerializationUtils.toJsonString(response)));
        Object errMsg = response.get("errMsg");
        boolean bl = status = response.get("status") == null ? false : (Boolean)response.get("status");
        if (status) {
            Map data = (Map)response.get("data");
            String taskId = (String)data.get("taskId");
            boolean isEnd = (Boolean)data.get("isEnd");
            String llmValue = (String)data.get("llmValue");
            Map<String, Object> pageInfo = GPTScriptServiceImpl.getRootPageInfo(taskId);
            GPTScriptServiceImpl.pushWSMessage(pageInfo, llmValue, isEnd);
        } else {
            Map data = (Map)response.get("data");
            String taskId = data == null ? "" : (String)data.get("taskId");
            logger.debug(String.format("\u56de\u8c03\u5931\u8d25\uff0c errMsg:%s, response\uff1a%s", errMsg, SerializationUtils.toJsonString(response)));
            Map<String, Object> pageInfo = GPTScriptServiceImpl.getRootPageInfo(taskId);
            GPTScriptServiceImpl.pushWSMessage(pageInfo, "", true);
        }
    }

    private static void pushWSMessage(Map<String, Object> pageInfo, String llmValue, boolean isEnd) {
        String rootPageId = (String)pageInfo.get(ROOT_PAGE_ID);
        String pageId = (String)pageInfo.get(PAGE_ID);
        String action = (String)pageInfo.get(ACTION);
        if (llmValue == null) {
            llmValue = "";
        }
        logger.debug(String.format("\u5f00\u59cb\u53d1\u9001ws\u6d88\u606f\uff0crootpageId:%s, pageId:%s", rootPageId, pageId));
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        IFormView rootView = SessionManager.getCurrent().getView(rootPageId);
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(action);
        list.add(llmValue);
        list.add(isEnd);
        proxy.invokeControlMethod("kingscripteditap", "sendEditorGptData", new Object[]{list});
        rootView.sendFormAction(formView);
        String sessionId = pageInfo.get(GLOBAL_SESSION_ID) == null ? RequestContext.get().getGlobalSessionId() : (String)pageInfo.get(GLOBAL_SESSION_ID);
        PushMessage message = new PushMessage(PushMessageRange.Session, sessionId, (Object)JSON.toJSONString((Object)rootView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
    }

    private static Map<String, Object> buildErrorResult(String message) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", false);
        result.put("message", message);
        return result;
    }

    private static Map<String, Object> buildResult(String message) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", true);
        result.put("message", message);
        return result;
    }

    private static Map<String, Object> getRootPageInfo(String taskId) {
        String pageInfoStr = (String)cache.get(GPTScriptServiceImpl.getRootPageInfoKey(taskId));
        logger.debug(String.format("taskId\u4e3a\uff1a%s\uff0c\u7684\u9875\u9762\u4fe1\u606f\uff1a%s", taskId, pageInfoStr));
        if (StringUtils.isBlank((String)pageInfoStr)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)pageInfoStr, Map.class);
    }

    private static String getPageId(String taskId) {
        return (String)cache.get(GPTScriptServiceImpl.getPageIdKey(taskId));
    }

    private static void CachePageInfo(String taskId, String key, String rootPageId, String pageId) {
        HashMap<String, String> pageInfo = new HashMap<String, String>(16);
        pageInfo.put(ROOT_PAGE_ID, rootPageId);
        pageInfo.put(PAGE_ID, pageId);
        pageInfo.put(ACTION, key);
        pageInfo.put(GLOBAL_SESSION_ID, RequestContext.get().getGlobalSessionId());
        String pageInfoStr = SerializationUtils.toJsonString(pageInfo);
        logger.debug(String.format("\u8bb0\u5f55\u672c\u6b21\u9875\u9762\u4fe1\u606f\uff0ctaskId\uff1a%s\uff0cpageInfo:%s", taskId, pageInfoStr));
        cache.put(GPTScriptServiceImpl.getRootPageInfoKey(taskId), (Object)pageInfoStr, 3600);
    }

    private static String getRootPageInfoKey(String taskId) {
        return "kingscript_asyncaiservice_" + taskId + "_" + ROOT_PAGE_ID;
    }

    private static String getPageIdKey(String taskId) {
        return "kingscript_asyncaiservice_" + taskId + "_" + PAGE_ID;
    }

    private static String formatInput(String input) {
        if (input.length() < 3000) {
            return input;
        }
        return input.substring(0, 3000);
    }
}

