/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt;

import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.script.npm.gpt.AbstractKingScriptGPTService;
import kd.bos.devportal.script.npm.gpt.process.GPTCache;
import kd.bos.devportal.script.npm.gpt.process.GPTParam;
import kd.bos.devportal.script.npm.gpt.process.ScriptGPTProcess;
import kd.bos.form.IFormView;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KingScriptGPTServiceImpl
extends AbstractKingScriptGPTService {
    private static Log logger = LogFactory.getLog(KingScriptGPTServiceImpl.class);

    @Override
    public void codeAction(IFormView formView, String key, Map<String, Object> param) {
        IFormView parentView;
        String bizPageId = (String)formView.getFormShowParameter().getCustomParam("bizPageId");
        String rootPageId = bizPageId;
        if (StringUtils.isBlank((CharSequence)rootPageId) && (parentView = formView.getParentView()) != null) {
            rootPageId = parentView.getFormShowParameter().getRootPageId();
        }
        param.put("code", this.getCode(formView));
        param.put("bizPageId", bizPageId);
        param.put("page_id", formView.getPageId());
        param.put("root_page_id", rootPageId);
        param.put("modelType", this.getModelType(formView));
        ScriptGPTProcess.doProcess(GPTParam.convertFromParam(key, param), arg_0 -> ((IFormView)formView).showTipNotification(arg_0));
    }

    @Override
    public void stopCodeAction(IFormView formView, Map<String, Object> param) {
        String cid = GPTParam.analysisCid(param);
        GPTCache gptCache = GPTCache.searchByCid(cid);
        gptCache.changeCidStatus(false);
    }

    private String getCode(IFormView formView) {
        KingScriptEdit codeEdit = (KingScriptEdit)formView.getControl("kingscripteditap");
        String content = codeEdit.getText();
        if (content == null) {
            content = formView.getPageCache().get("kingscripteditap");
        }
        return content;
    }
}

