/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt.process;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import org.apache.commons.lang3.StringUtils;

public class GPTCache {
    private static Log logger = LogFactory.getLog(GPTCache.class);
    private static String PREFIX_TASK = "kingscript_task_";
    private static String PREFIX_CID = "kingscript_cid_";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final int CACHE_TIMEOUT = 3600;
    private String taskId;
    private TaskPageInfo pageInfo;

    public static void recordCache(String taskId, String cid, String action, String rootPageId, String pageId) {
        TaskPageInfo pageInfo = new TaskPageInfo();
        pageInfo.taskId = taskId;
        pageInfo.cid = cid;
        pageInfo.action = action;
        pageInfo.rootPageId = rootPageId;
        pageInfo.pageId = pageId;
        pageInfo.globalSessionId = RequestContext.get().getGlobalSessionId();
        String pageInfoStr = SerializationUtils.toJsonString((Object)pageInfo);
        logger.info(String.format("\u8bb0\u5f55\u672c\u6b21\u9875\u9762\u4fe1\u606f\uff0ccid:%s, taskId\uff1a%s\uff0cpageInfo:%s", cid, taskId, pageInfoStr));
        cache.put(PREFIX_TASK + taskId, (Object)pageInfoStr, 3600);
        cache.put(PREFIX_CID + cid, (Object)taskId, 3600);
    }

    public static void recordQuestionToPageCache(String pageId, String taskId, String context) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        pageCache.put("question_" + taskId, context);
    }

    public static void recordLinkedQuestionToPageCache(String pageId, String context) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        List questLinkeds = new ArrayList<String>(1);
        String questionLinkedStr = pageCache.get("question_linked");
        if (StringUtils.isNotBlank((CharSequence)questionLinkedStr)) {
            questLinkeds = JSON.parseArray((String)questionLinkedStr, String.class);
        }
        questLinkeds.add(context);
        if (questLinkeds.size() > 10) {
            questLinkeds = new LinkedList(questLinkeds);
            ((LinkedList)questLinkeds).pollFirst();
        }
        pageCache.put("question_linked", JSON.toJSONString(questLinkeds));
    }

    public static String getQuestionFromPageCache(String pageId, String taskId) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        String question = pageCache.get("question_" + taskId);
        return StringUtils.isBlank((CharSequence)question) ? "" : question;
    }

    public static List<String> getLinkedQuestionFromPageCache(String pageId) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        String question = pageCache.get("question_linked");
        return StringUtils.isBlank((CharSequence)question) ? Collections.EMPTY_LIST : JSON.parseArray((String)question, String.class);
    }

    public static void recordAnswerToPageCache(String pageId, String taskId, String llmValue) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        String answer = pageCache.get("answer_" + taskId);
        if (StringUtils.isBlank((CharSequence)answer)) {
            answer = "";
        }
        pageCache.put("answer_" + taskId, answer + llmValue);
    }

    public static String getAnswerFromPageCache(String pageId, String taskId) {
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        String answer = pageCache.get("answer_" + taskId);
        return StringUtils.isBlank((CharSequence)answer) ? "" : answer;
    }

    public static GPTCache searchByCid(String cid) {
        String taskId = (String)cache.get(PREFIX_CID + cid);
        return GPTCache.searchByTask(taskId);
    }

    public static GPTCache searchByTask(String taskId) {
        String pageInfoStr = (String)cache.get(PREFIX_TASK + taskId);
        if (StringUtils.isBlank((CharSequence)pageInfoStr)) {
            logger.error("searchByTask taskid:" + taskId + ", pageInfoStr:" + pageInfoStr);
            return new GPTCache(taskId, new TaskPageInfo());
        }
        TaskPageInfo pageInfo = (TaskPageInfo)SerializationUtils.fromJsonString((String)pageInfoStr, TaskPageInfo.class);
        return new GPTCache(taskId, pageInfo);
    }

    private GPTCache(String taskId, TaskPageInfo pageInfo) {
        this.taskId = taskId;
        this.pageInfo = pageInfo;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskPageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void changeCidStatus(boolean status) {
        this.pageInfo.cidStatus = status;
        String pageInfoStr = SerializationUtils.toJsonString((Object)this.pageInfo);
        cache.put(PREFIX_TASK + this.pageInfo.taskId, (Object)pageInfoStr);
    }

    public static class TaskPageInfo {
        private String taskId;
        private String cid;
        private boolean cidStatus = true;
        private String action;
        private String rootPageId;
        private String pageId;
        private String globalSessionId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getCid() {
            return this.cid;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }

        public boolean isCidStatus() {
            return this.cidStatus;
        }

        public void setCidStatus(boolean cidStatus) {
            this.cidStatus = cidStatus;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getRootPageId() {
            return this.rootPageId;
        }

        public void setRootPageId(String rootPageId) {
            this.rootPageId = rootPageId;
        }

        public String getPageId() {
            return this.pageId;
        }

        public void setPageId(String pageId) {
            this.pageId = pageId;
        }

        public String getGlobalSessionId() {
            return this.globalSessionId;
        }

        public void setGlobalSessionId(String globalSessionId) {
            this.globalSessionId = globalSessionId;
        }
    }
}

