/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt.process;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.designer.dao.FieldsPromptBuilder;
import kd.bos.devportal.script.npm.gpt.process.GPTCache;
import kd.bos.util.StringUtils;

public class GPTParam {
    private static final int INPUT_LENGTH = 3000;
    private String action;
    private String cid;
    private String context;
    private String bizPageId;
    private String fieldsDesc;
    private String code;
    private String modelType;
    private String rootPageId;
    private String pageId;
    private String globalSessionId;

    public static GPTParam convertFromParam(String action, Map<String, Object> param) {
        GPTParam gptParam = new GPTParam();
        gptParam.action = action;
        gptParam.cid = (String)param.get("cid");
        gptParam.context = (String)param.get("content");
        gptParam.bizPageId = (String)param.get("bizPageId");
        gptParam.fieldsDesc = (String)param.get("fieldsDesc");
        if (StringUtils.isBlank((String)gptParam.fieldsDesc)) {
            gptParam.fieldsDesc = FieldsPromptBuilder.getDescWithJson((String)gptParam.bizPageId);
        }
        gptParam.code = (String)param.get("code");
        gptParam.modelType = (String)param.get("modelType");
        gptParam.rootPageId = (String)param.get("root_page_id");
        gptParam.pageId = (String)param.get("page_id");
        gptParam.globalSessionId = RequestContext.get().getGlobalSessionId();
        return gptParam;
    }

    public static String analysisCid(Map<String, Object> param) {
        return (String)param.get("cid");
    }

    public GPTCache.TaskPageInfo getPageInfo() {
        GPTCache.TaskPageInfo pageInfo = new GPTCache.TaskPageInfo();
        pageInfo.setAction(this.action);
        pageInfo.setCid(this.cid);
        pageInfo.setGlobalSessionId(this.globalSessionId);
        pageInfo.setRootPageId(this.rootPageId);
        pageInfo.setPageId(this.pageId);
        return pageInfo;
    }

    public String getCid() {
        return this.cid;
    }

    public String getContext() {
        return GPTParam.formatInput(this.context);
    }

    public String getBizPageId() {
        return this.bizPageId;
    }

    public String getFieldsDesc() {
        return this.fieldsDesc;
    }

    public String getCode() {
        return this.code;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getRootPageId() {
        return this.rootPageId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getAction() {
        return this.action;
    }

    private static String formatInput(String input) {
        if (input.length() < 3000) {
            return input;
        }
        return input.substring(0, 3000);
    }

    public void setContext(String context) {
        this.context = context;
    }
}

