/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt.process;

import java.util.function.Consumer;
import kd.bos.devportal.script.npm.gpt.ScriptGPTJson;
import kd.bos.devportal.script.npm.gpt.process.GPTCache;
import kd.bos.devportal.script.npm.gpt.process.GPTParam;
import kd.bos.devportal.script.npm.gpt.process.GPTResultAsny;
import kd.bos.devportal.script.npm.gpt.service.GPTService;
import kd.bos.devportal.script.npm.gpt.service.GPTServiceFactory;
import kd.bos.devportal.script.npm.helper.PushMessageHelper;
import kd.bos.utils.LogPrintUtil;

public class ScriptGPTProcess {
    public static void doProcess(GPTParam gptParam, Consumer<String> failProcess) {
        GPTResultAsny gptResult = ScriptGPTProcess.answerAI(gptParam);
        if (!gptResult.isStatus()) {
            failProcess.accept(gptResult.getErrMsg());
            return;
        }
        GPTCache.recordCache(gptResult.getTaskId(), gptParam.getCid(), gptParam.getAction(), gptParam.getRootPageId(), gptParam.getPageId());
        GPTCache.recordQuestionToPageCache(gptParam.getPageId(), gptResult.getTaskId(), gptParam.getContext());
        GPTCache.recordLinkedQuestionToPageCache(gptParam.getPageId(), gptParam.getContext());
    }

    private static GPTResultAsny answerAI(GPTParam gptParam) {
        try {
            GPTService gptService = GPTServiceFactory.create(gptParam.getAction(), gptParam.getContext());
            return gptService.invokeAsynAI(gptParam);
        }
        catch (Exception e) {
            LogPrintUtil.printExceptionMessage((Exception)e, (String)(gptParam.getAction() + " error"));
            PushMessageHelper.sendMessage(gptParam.getPageInfo(), ScriptGPTJson.failObject(gptParam.getCid()));
            return GPTResultAsny.error(e.getMessage());
        }
    }
}

