/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.dao.FieldsPromptBuilder;
import kd.bos.devportal.script.npm.gpt.ScriptGPTJson;
import kd.bos.devportal.script.npm.gpt.process.GPTCache;
import kd.bos.devportal.script.npm.gpt.process.GPTParam;
import kd.bos.devportal.script.npm.gpt.process.GPTResult;
import kd.bos.devportal.script.npm.gpt.process.GPTResultAsny;
import kd.bos.devportal.script.npm.gpt.process.GPTResultCallback;
import kd.bos.devportal.script.npm.gpt.service.GPTService;
import kd.bos.devportal.script.npm.helper.PushMessageHelper;
import kd.bos.gpt.api.DevAssistantService;
import kd.bos.gptas.autoact.agent.Agents;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGPTService
implements GPTService {
    protected static Log logger = LogFactory.getLog(AbstractGPTService.class);
    protected DevAssistantService devAssistantService = (DevAssistantService)ServiceFactory.getService(DevAssistantService.class);

    @Override
    public GPTResult invokeAI(GPTParam gptParam) {
        try {
            Object build = Agents.builder((Class)this.getTool()).build();
            String llmvalue = (String)Agents.callAgent((Object)build, (Object)gptParam.getContext());
            return GPTResult.success("", llmvalue);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
            return GPTResult.error(e.getMessage());
        }
    }

    @Override
    public GPTResultAsny invokeAsynAI(GPTParam gptParam) {
        return this.invokeAsynAI0(gptParam, this.getTool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GPTResultAsny invokeAsynAI0(GPTParam gptParam, Class tool) {
        int seqNo = 1;
        try {
            Object result = this.devAssistantService.process(this.getModel(), gptParam.getContext());
            if (result instanceof MessageStream) {
                MessageStream messageStream = (MessageStream)result;
                while (messageStream.hasNext()) {
                    String llmValue = (String)messageStream.next();
                    ScriptGPTJson gptJson = new ScriptGPTJson(gptParam.getCid(), seqNo++, llmValue, false, Collections.emptyList());
                    PushMessageHelper.sendMessage(gptParam.getPageInfo(), gptJson);
                }
            } else {
                String llmValue = result.toString();
                ScriptGPTJson gptJson = new ScriptGPTJson(gptParam.getCid(), seqNo++, llmValue, false, Collections.emptyList());
                PushMessageHelper.sendMessage(gptParam.getPageInfo(), gptJson);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
            GPTResultAsny gPTResultAsny = GPTResultAsny.error(e.getMessage());
            return gPTResultAsny;
        }
        finally {
            ScriptGPTJson gptJson = new ScriptGPTJson(gptParam.getCid(), seqNo, "", true, Collections.emptyList());
            PushMessageHelper.sendMessage(gptParam.getPageInfo(), gptJson);
        }
        return GPTResultAsny.success("");
    }

    private void callBack(GPTResultCallback gptResultCallback) {
        GPTCache gptPacheCache = GPTCache.searchByTask(gptResultCallback.getTaskId());
        boolean cidStatus = gptPacheCache.getPageInfo().isCidStatus();
        if (!cidStatus) {
            return;
        }
        GPTCache.TaskPageInfo pageInfo = gptPacheCache.getPageInfo();
        if (gptResultCallback.isStatus()) {
            boolean isEnd = gptResultCallback.isEnd();
            String llmValue = gptResultCallback.getLlmValue();
            int seqNo = gptResultCallback.getSeqNo();
            this.recordQuestionForRecomend(pageInfo.getPageId(), gptResultCallback.getTaskId(), llmValue);
            List<String> tips = Collections.emptyList();
            if (isEnd) {
                tips = this.searchRecomendQa(pageInfo);
            }
            ScriptGPTJson gptJson = new ScriptGPTJson(pageInfo.getCid(), seqNo, llmValue, isEnd, tips);
            PushMessageHelper.sendMessage(pageInfo, gptJson);
        } else {
            logger.error(String.format("\u56de\u8c03\u5931\u8d25\uff0c errMsg:%s, response\uff1a%s", gptResultCallback.getErrMsg(), SerializationUtils.toJsonString((Object)gptResultCallback)));
            PushMessageHelper.sendMessage(pageInfo, ScriptGPTJson.failObject(pageInfo.getCid()));
        }
    }

    protected void recordQuestionForRecomend(String pageId, String taskId, String llmValue) {
    }

    protected List<String> searchRecomendQa(GPTCache.TaskPageInfo pageInfo) {
        return Collections.emptyList();
    }

    protected abstract String getGptPromptNumber();

    private Optional<Long> findPromptId() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)this.getGptPromptNumber())};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_prompt", (QFilter[])filters);
        if (obj == null) {
            return Optional.empty();
        }
        return Optional.of((Long)obj.getPkValue());
    }

    private Map<String, String> buildCallBackInfo() {
        HashMap<String, String> callBackInfo = new HashMap<String, String>();
        callBackInfo.put("cloudId", "bos");
        callBackInfo.put("appId", "bos");
        callBackInfo.put("serviceName", "IGPTScriptService");
        callBackInfo.put("methodName", "callBack");
        return callBackInfo;
    }

    protected Map<String, String> buildVarParams(GPTParam gptParam) {
        HashMap<String, String> varParams = new HashMap<String, String>();
        String bizPageId = gptParam.getBizPageId();
        String fieldsDesc = gptParam.getFieldsDesc();
        if (StringUtils.isBlank((CharSequence)fieldsDesc)) {
            fieldsDesc = FieldsPromptBuilder.getDescWithJson((String)bizPageId);
        }
        varParams.put("model", fieldsDesc);
        String full_script_code = gptParam.getCode();
        varParams.put("full_script_code", full_script_code);
        String modelType = gptParam.getModelType();
        varParams.put("model_type", modelType);
        return varParams;
    }
}

