/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.devportal.script.npm.gpt.service.AbstractGPTService;
import kd.bos.devportal.script.npm.gpt.service.GPTRecomendQaService;
import kd.bos.devportal.script.npm.gpt.service.GPTService;
import kd.bos.devportal.script.npm.gpt.service.tool.AnswerKnowledgeService;
import kd.bos.devportal.script.npm.gpt.service.tool.CodeCompletionService;
import kd.bos.devportal.script.npm.gpt.service.tool.CodeExplainService;
import kd.bos.devportal.script.npm.gpt.service.tool.CodeGenService;
import kd.bos.devportal.script.npm.gpt.service.tool.CodeOptimizeService;
import kd.bos.devportal.script.npm.gpt.service.tool.CommentGenService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GPTServiceFactory {
    protected static Log logger = LogFactory.getLog(AbstractGPTService.class);
    private static final String ACTION_SCRIPT_CODE_GEN = "kingscript_code_gen";
    private static final String ACTION_SCRIPT_COMMENT_GEN = "kingscript_comment_gen";
    private static final String ACTION_SCRIPT_CODE_EXPLAIN = "kingscript_code_explain";
    private static final String ACTION_SCRIPT_CODE_OPTIMIZE = "kingscript_code_optimize";
    private static final String ACTION_SCRIPT_CODE_COMPLETION = "kingscript_code_completion";
    private static final String ACTION_SCRIPT_CODE_KNOWLEDGE = "kingscript_code_knowledgeQA";
    private static Map<String, Class<? extends GPTService>> serviceNames = new HashMap<String, Class<? extends GPTService>>();

    public static boolean searchServiceByName(String name) {
        return serviceNames.containsKey(name);
    }

    public static GPTService create(String action) {
        Class<? extends GPTService> aClass = serviceNames.get(action);
        try {
            return aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new AnswerKnowledgeService();
        }
    }

    public static GPTService create(String action, String context) {
        boolean recomendQa;
        Class<? extends GPTService> aClass = serviceNames.get(action);
        GPTService gptService = null;
        try {
            gptService = aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (gptService instanceof GPTRecomendQaService && (recomendQa = ((GPTRecomendQaService)gptService).isRecomendQa(context))) {
            try {
                gptService = (GPTService)((GPTRecomendQaService)gptService).recomendQaClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (gptService != null) {
            return gptService;
        }
        return new AnswerKnowledgeService();
    }

    static {
        serviceNames.put(ACTION_SCRIPT_CODE_GEN, CodeGenService.class);
        serviceNames.put(ACTION_SCRIPT_COMMENT_GEN, CommentGenService.class);
        serviceNames.put(ACTION_SCRIPT_CODE_EXPLAIN, CodeExplainService.class);
        serviceNames.put(ACTION_SCRIPT_CODE_OPTIMIZE, CodeOptimizeService.class);
        serviceNames.put(ACTION_SCRIPT_CODE_COMPLETION, CodeCompletionService.class);
        serviceNames.put(ACTION_SCRIPT_CODE_KNOWLEDGE, AnswerKnowledgeService.class);
    }
}

