/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt.service.tool;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.devportal.script.npm.gpt.process.GPTCache;
import kd.bos.devportal.script.npm.gpt.service.AbstractGPTService;
import kd.bos.devportal.script.npm.gpt.service.IRecomendQAService;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.sdk.kingscript.config.ConfigurableItem;
import org.apache.commons.lang3.StringUtils;

public class AnswerKnowledgeService
extends AbstractGPTService {
    @ConfigurableItem(desc="GPT knowledge recomendqa enable")
    public static final String GPT_KNOWLEDGE_RECOMENDQA_ENABLE = "gpt.knowledge.recomendqa.enable";
    private static Log logger = LogFactory.getLog(AnswerKnowledgeService.class);
    private static final String ACTION_SCRIPT_CODE_KNOWLEDGE = "kingscript_code_knowledgeQA";

    @Override
    public Class getTool() {
        return AnswerKnow.class;
    }

    @Override
    public String getModel() {
        return "Dev QA";
    }

    @Override
    protected String getGptPromptNumber() {
        return ACTION_SCRIPT_CODE_KNOWLEDGE;
    }

    @Override
    protected void recordQuestionForRecomend(String pageId, String taskId, String llmValue) {
        GPTCache.recordAnswerToPageCache(pageId, taskId, llmValue);
    }

    @Override
    protected List<String> searchRecomendQa(GPTCache.TaskPageInfo pageInfo) {
        String tenantId = RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)GPT_KNOWLEDGE_RECOMENDQA_ENABLE, (String)tenantId);
        if (StringUtils.isBlank((CharSequence)value) || !String.valueOf(Boolean.TRUE).equals(value)) {
            return Collections.emptyList();
        }
        String question = GPTCache.getQuestionFromPageCache(pageInfo.getPageId(), pageInfo.getTaskId());
        String answer = GPTCache.getAnswerFromPageCache(pageInfo.getPageId(), pageInfo.getTaskId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("question", question);
        params.put("answer", answer);
        params.put("action", "QA_RECOM_cosmic_qa");
        String recomendQAAction = "kd.bos.gptas.qa.recommend.RecomendQAAction";
        try {
            Class<?> cls = Class.forName(recomendQAAction);
            IRecomendQAService recomendQAService = (IRecomendQAService)cls.newInstance();
            return recomendQAService.getRecomendQa(params);
        }
        catch (Exception e) {
            logger.warn("Create monitor reporter failed: " + recomendQAAction + ", cause by" + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Agent(value="./answer_know.json")
    public static interface AnswerKnow {
    }
}

