/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.gpt.service.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.script.npm.gpt.ScriptGPTJson;
import kd.bos.devportal.script.npm.gpt.process.GPTCache;
import kd.bos.devportal.script.npm.gpt.process.GPTParam;
import kd.bos.devportal.script.npm.gpt.process.GPTResultAsny;
import kd.bos.devportal.script.npm.gpt.service.AbstractGPTService;
import kd.bos.devportal.script.npm.gpt.service.GPTRecomendQaService;
import kd.bos.devportal.script.npm.gpt.service.tool.CodeExplainQAService;
import kd.bos.devportal.script.npm.helper.PushMessageHelper;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.gptas.autoact.message.MessageStream;

public class CodeExplainService
extends AbstractGPTService
implements GPTRecomendQaService {
    private static final String ACTION_SCRIPT_CODE_EXPLAIN = "kingscript_code_explain";
    protected static final List<String> qa = new ArrayList<String>(3);

    @Override
    public boolean isRecomendQa(String question) {
        return qa.contains(question);
    }

    @Override
    public Class recomendQaClass() {
        return CodeExplainQAService.class;
    }

    @Override
    public Class getTool() {
        return CodeExplain.class;
    }

    @Override
    public String getModel() {
        return "Code Explain";
    }

    @Override
    protected String getGptPromptNumber() {
        return ACTION_SCRIPT_CODE_EXPLAIN;
    }

    @Override
    protected List<String> searchRecomendQa(GPTCache.TaskPageInfo pageInfo) {
        return qa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GPTResultAsny invokeAsynAI0(GPTParam gptParam, Class tool) {
        int seqNo = 1;
        try {
            Object result = this.devAssistantService.process(this.getModel(), gptParam.getContext());
            if (result instanceof MessageStream) {
                MessageStream messageStream = (MessageStream)result;
                while (messageStream.hasNext()) {
                    String llmValue = (String)messageStream.next();
                    ScriptGPTJson gptJson = new ScriptGPTJson(gptParam.getCid(), seqNo++, llmValue, false, Collections.emptyList());
                    PushMessageHelper.sendMessage(gptParam.getPageInfo(), gptJson);
                }
            } else {
                String llmValue = result.toString();
                ScriptGPTJson gptJson = new ScriptGPTJson(gptParam.getCid(), seqNo++, llmValue, false, Collections.emptyList());
                PushMessageHelper.sendMessage(gptParam.getPageInfo(), gptJson);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
            GPTResultAsny gPTResultAsny = GPTResultAsny.error(e.getMessage());
            return gPTResultAsny;
        }
        finally {
            ScriptGPTJson gptJson = new ScriptGPTJson(gptParam.getCid(), seqNo, "", true, Collections.emptyList());
            PushMessageHelper.sendMessage(gptParam.getPageInfo(), gptJson);
        }
        return GPTResultAsny.success("");
    }

    static {
        qa.add(ResManager.loadKDString((String)"\u5173\u952e\u4ee3\u7801\u5757\u89e3\u91ca", (String)"CodeExplainService_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        qa.add(ResManager.loadKDString((String)"\u4ee3\u7801\u6d4b\u8bd5\u5efa\u8bae", (String)"CodeExplainService_1", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        qa.add(ResManager.loadKDString((String)"\u4ee3\u7801\u6539\u8fdb\u610f\u89c1", (String)"CodeExplainService_2", (String)"bos-devportal-plugin", (Object[])new Object[0]));
    }

    @Agent(value="./code_explain.json")
    public static interface CodeExplain {
    }
}

