/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.script.npm.AbstractKingScriptPlugin;
import kd.bos.devportal.script.npm.gpt.GPTScriptServiceImpl;
import kd.bos.devportal.script.npm.helper.KingScriptConfigHelper;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.utils.LogPrintUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class kingScriptGPTPlugin
extends AbstractKingScriptPlugin {
    Log logger = LogFactory.getLog(kingScriptGPTPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String ACTION_SCRIPT_CODE_NAMING = "kingscript_code_naming";
    private static final String ACTION_SCRIPT_CODE_GEN = "kingscript_code_gen";
    private static final String ACTION_SCRIPT_COMMENT_GEN = "kingscript_comment_gen";
    private static final String ACTION_SCRIPT_CODE_EXPLAIN = "kingscript_code_explain";
    private static final String ACTION_SCRIPT_CODE_OPTIMIZE = "kingscript_code_optimize";
    private static final String ACTION_SCRIPT_CODE_COMPLETION = "kingscript_code_completion";
    private static final String ACTION_GET_CODEEDITOR_GPT_CONFIG = "getCodeEditorGptConfig";
    private static final String ACTION_SCRIPT_CODE_GEN_COMPACT_MODEL = "kingscript_compact_model";
    private static final int KINGSCRIPT_TOP = 20;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"autogenerate", "autogenerateicon", "autogeneratelabel"});
        KingScriptEdit edit = (KingScriptEdit)this.getControl("kingscripteditap");
        edit.addScriptEditorListener((KingScriptEditorListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        KingScriptEdit edit = (KingScriptEdit)this.getControl("kingscripteditap");
        if (!this.enableGPT()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"autogenerate"});
        }
    }

    public void codeEditorAction(KingScriptEditorEvent e) {
        String key = e.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "kingscript_code_gen": 
            case "kingscript_comment_gen": 
            case "kingscript_code_explain": 
            case "kingscript_code_optimize": 
            case "kingscript_code_completion": {
                this.codeAction(key, e.getParam());
                break;
            }
            case "getCodeEditorGptConfig": {
                this.getCodeEditorGptConfig();
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "autogenerate": 
            case "autogenerateicon": 
            case "autogeneratelabel": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String content = this.getCode();
                if (StringUtils.isBlank((CharSequence)content)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7f16\u5199\u4ee3\u7801\u3002", (String)"KingScriptPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String bizPageId = (String)this.getView().getFormShowParameter().getCustomParam("bizPageId");
                map.put("content", content);
                map.put("code", content);
                map.put("bizPageId", bizPageId);
                map.put("page_id", this.getView().getPageId());
                map.put("modelType", this.getModelType());
                this.autoGenerate(ACTION_SCRIPT_CODE_NAMING, map);
            }
        }
    }

    private void codeAction(String key, Map<String, Object> param) {
        boolean success;
        String code = this.getCode();
        String bizPageId = (String)this.getView().getFormShowParameter().getCustomParam("bizPageId");
        String rootPageId = bizPageId;
        if (StringUtils.isBlank((CharSequence)rootPageId)) {
            rootPageId = this.getView().getParentView().getFormShowParameter().getRootPageId();
        }
        param.put("code", code);
        param.put("bizPageId", bizPageId);
        param.put("page_id", this.getView().getPageId());
        param.put("root_page_id", rootPageId);
        param.put("modelType", this.getModelType());
        HashMap<String, Object> compactParam = new HashMap<String, Object>(16);
        compactParam.putAll(param);
        param.put("fieldsDesc", this.getCompactFieldDesc(compactParam));
        Map<String, Object> result = GPTScriptServiceImpl.invokeAsyncAiService(key, param);
        boolean bl = success = result.get("success") == null ? false : (Boolean)result.get("success");
        if (!success) {
            this.getView().showTipNotification((String)result.get("message"));
        }
    }

    private boolean enableGPT() {
        String tenantId = RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)"kingscript.editor.gpt.enable", (String)tenantId);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return Boolean.FALSE;
    }

    private void getCodeEditorGptConfig() {
        ArrayList args = new ArrayList(10);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("gptEnable", this.enableGPT());
        map.put("codeGenTips", this.getCodeGenlib());
        args.add(map);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getControl("kingscripteditap").getKey(), "setCodeEditorGptConfig", new Object[]{args});
    }

    private List<Map<String, Object>> getCodeGenlib() {
        String sql = String.format("select TOP %s a.fid,a.fseq,b.fcomment from t_bas_kingscriptlib a join t_bas_kingscriptlib_l b on a.fid = b.fid where fscripttype = ? and b.flocaleid = ? order by a.fseq", 20);
        String modelType = this.getModelType();
        Object[] param = new Object[]{KingScriptConfigHelper.getScriptType(this.getView(), modelType), Locale.getDefault().toString()};
        ResultSetHandler<List<Map<String, Object>>> action = new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> codeLibs = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, Object> codeMap = new HashMap<String, Object>(2);
                    codeMap.put("id", rs.getLong("fid"));
                    codeMap.put("tips", rs.getString("fcomment"));
                    codeLibs.add(codeMap);
                }
                return codeLibs;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])param, (ResultSetHandler)action);
    }

    private String getCompactFieldDesc(Map<String, Object> param) {
        if (!this.enableCompactModel()) {
            this.logger.debug("\u5b57\u6bb5\u7cbe\u7b80\u6a21\u578b\u672a\u542f\u7528\u3002");
            return "";
        }
        try {
            Map data;
            String value;
            Map<String, Object> result = GPTScriptServiceImpl.invokeAiService(ACTION_SCRIPT_CODE_GEN_COMPACT_MODEL, param);
            if (result != null && result.get("data") != null && StringUtils.isNotBlank((CharSequence)(value = (String)(data = (Map)result.get("data")).get("llmValue")))) {
                return this.formatFieldDesc(value);
            }
            this.logger.debug(String.format("\u83b7\u53d6\u7cbe\u7b80\u5b57\u6bb5\u6a21\u578b\u5931\u8d25\u5c06\u4f7f\u7528\u5168\u91cf\u5b57\u6bb5\u6a21\u578b\u5931\u8d25\uff0cresult\uff1a%s", result == null ? "" : SerializationUtils.toJsonString(result)));
        }
        catch (Exception e) {
            this.logger.info(String.format("\u83b7\u53d6\u7cbe\u7b80\u5b57\u6bb5\u6a21\u578b\u5931\u8d25\u5c06\u4f7f\u7528\u5168\u91cf\u5b57\u6bb5\u6a21\u578b\uff0cerr:%s", e.getMessage()), (Object)e);
        }
        return "";
    }

    private boolean enableCompactModel() {
        String value = System.getProperty("kingscript.gpt.code_gen.compact_model", "true");
        return Boolean.parseBoolean(value);
    }

    private void sendEditorGptData(String key, String value) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add(key);
        list.add(value);
        proxy.invokeControlMethod(this.getControl("kingscripteditap").getKey(), "sendEditorGptData", new Object[]{list});
    }

    private void autoGenerate(String key, Map<String, Object> param) {
        Map<String, Object> result = GPTScriptServiceImpl.invokeAiService(key, param);
        String message = (String)result.get("message");
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getView().showTipNotification(message);
            return;
        }
        Map data = (Map)result.get("data");
        if (data == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"KingScriptPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String value = (String)data.get("llmValue");
        if (ACTION_SCRIPT_CODE_NAMING.equals(key)) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject jsonObject;
                JSONObject map = jsonObject = (JSONObject)parser.parse(value);
                this.getModel().beginInit();
                String scriptNumber = this.formatScriptNumber((String)map.get("number"));
                this.getModel().setValue("scriptnumber", (Object)scriptNumber);
                this.getModel().setValue("scriptname", map.get("name"));
                this.getModel().setValue("description", map.get("desc"));
                this.getModel().endInit();
                this.getView().updateView();
            }
            catch (ParseException ex) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"KingScriptPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                LogPrintUtil.printExceptionMessage((Exception)((Object)ex), (String)(key + " error"));
            }
        } else {
            this.sendEditorGptData(key, value);
        }
    }

    private String formatScriptNumber(String number) {
        if (number == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(number.length());
        int n = number.length();
        for (int i = 0; i < n; ++i) {
            int ch = number.charAt(i);
            if (ch != 95 && !Character.isLetterOrDigit((char)ch)) {
                ch = 95;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (StringUtils.isBlank((CharSequence)modelType)) {
            DynamicObject form = this.getForm();
            if (form != null) {
                modelType = form.getString("modeltype");
            } else {
                this.logger.debug(String.format("formId:%s\u5bf9\u5e94\u7684\u8868\u5355\u4e0d\u5b58\u5728\u53ef\u80fd\u88ab\u5220\u9664,modelType\u9ed8\u8ba4\u4f7f\u7528\u5355\u636e\u6a21\u578b", (Object[])this.getView().getFormShowParameter().getCustomParam("bizpagenumber")));
                modelType = "BillFormModel";
            }
        }
        return modelType;
    }

    private String formatFieldDesc(String value) {
        try {
            Map map = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            return value;
        }
        catch (Exception e) {
            this.logger.info(String.format("json\u89e3\u6790\u5931\u8d25\u3002%s", value));
            if (value.indexOf("{") != -1 && value.indexOf("}") != -1) {
                this.logger.info("\uff0cGPT\u751f\u6210\u5b57\u6bb5\u6a21\u578b\u63cf\u8ff0\u53ef\u80fd\u6709\u8bef\uff0c\u5c1d\u8bd5\u53bb\u9664\u591a\u4f59\u5b57\u7b26\u8fdb\u884c\u683c\u5f0f\u5316.");
                value = value.substring(value.indexOf("{"), value.lastIndexOf("}") + 1);
                try {
                    Map map = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
                    return value;
                }
                catch (Exception e1) {
                    this.logger.info(String.format("GPT\u751f\u6210\u5b57\u6bb5\u6a21\u578b\u63cf\u8ff0\u5c1d\u8bd5\u53bb\u9664\u591a\u4f59\u5b57\u7b26\u683c\u5f0f\u5316\u540e\u5931\u8d25\u3002%s", value));
                }
            }
            return "";
        }
    }
}

