/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class ChangeCloudAndAppPlugin
extends AbstractFormPlugin {
    private static final String KEY_BIZAPP = "bizapp";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_BIZCLOUDID = "bizcloudid";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BIZAPP, "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(KEY_BIZAPPID);
        String bizAppName = DevportalUtil.getBizAppNameById(bizAppId);
        this.getModel().setValue(KEY_BIZAPP, (Object)bizAppName);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("selectapp".equals(e.getActionId()) && e.getReturnData() != null) {
            ListSelectedRowCollection rt = (ListSelectedRowCollection)e.getReturnData();
            ListSelectedRow listSelectedRow = rt.get(0);
            String bizAppId = (String)listSelectedRow.getPrimaryKeyValue();
            if (StringUtils.isBlank((CharSequence)bizAppId)) {
                this.getModel().setValue(KEY_BIZAPP, (Object)"");
                this.getModel().setValue(KEY_BIZAPPID, (Object)"");
                this.getModel().setValue(KEY_BIZCLOUDID, (Object)"");
            } else {
                String bizAppName = listSelectedRow.getName();
                this.getModel().setValue(KEY_BIZAPP, (Object)bizAppName);
                this.getModel().setValue(KEY_BIZAPPID, (Object)bizAppId);
                AppMetadata meta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                if (meta != null) {
                    String bizCloudId = meta.getBizCloudID();
                    this.getModel().setValue(KEY_BIZCLOUDID, (Object)bizCloudId);
                } else {
                    this.getModel().setValue(KEY_BIZCLOUDID, (Object)"");
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "bizapp": {
                this.chooseApp();
                break;
            }
            case "btnok": {
                this.btnok();
                break;
            }
        }
    }

    private void chooseApp() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_devportal_app_layout", (boolean)false);
        if (listShowParameter != null) {
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u901a\u7528\u5e94\u7528\u9009\u62e9", (String)"ChangeCloudAndAppPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            listShowParameter.setFormId("bos_devp_apptreelistf7");
            listShowParameter.setCustomParam("runtime", (Object)Boolean.FALSE);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectapp"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void btnok() {
        String bizCloudId = (String)this.getModel().getValue(KEY_BIZCLOUDID);
        String bizAppId = (String)this.getModel().getValue(KEY_BIZAPPID);
        String bizAppName = (String)this.getModel().getValue(KEY_BIZAPP);
        if (StringUtils.isBlank((CharSequence)bizCloudId) && StringUtils.isBlank((CharSequence)bizAppId)) {
            this.getView().close();
            return;
        }
        JSONObject ret = new JSONObject();
        ret.put(KEY_BIZCLOUDID, (Object)bizCloudId);
        ret.put(KEY_BIZAPPID, (Object)bizAppId);
        ret.put("bizappname", (Object)bizAppName);
        this.getView().returnDataToParent((Object)ret);
        this.getView().close();
    }
}

