/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CodeJarPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String BIZAPPID = "bizappid";
    private static final String BOS_DEVP_APPREFJAR = "bos_devp_apprefjar";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_NUMBER = "number";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String appRefJar;
        String scriptId = (String)this.getView().getFormShowParameter().getCustomParam("scriptid");
        DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)"ide_pluginscript", (String)BIZAPPID);
        String bizAppId = scriptObject.getString(BIZAPPID);
        QFilter qfilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        DynamicObject appRefJarObject = BusinessDataServiceHelper.loadSingle((String)BOS_DEVP_APPREFJAR, (String)"jar", (QFilter[])new QFilter[]{qfilter});
        JSONArray appRefJars = new JSONArray();
        if (appRefJarObject != null && !StringUtils.isEmpty((CharSequence)(appRefJar = appRefJarObject.getString("jar")))) {
            String[] jars = appRefJar.split(";");
            for (int i = 0; i < jars.length; ++i) {
                appRefJars.add((Object)jars[i]);
            }
        }
        JSONArray jarNames = new JSONArray();
        String[] jarPaths = null;
        String classPath = System.getProperty("java.class.path");
        jarPaths = classPath.contains(";") ? classPath.split(";") : classPath.split(":");
        JSONArray relationAppNumbers = this.getRelationAppNumbers(bizAppId);
        for (String jarPath : jarPaths) {
            String jarAppName;
            String[] paths;
            String jarName;
            String[] split;
            if (!jarPath.endsWith(".jar") || (split = (jarName = (paths = jarPath.replace("/", "\\\\").split("\\\\"))[paths.length - 1]).split("-")).length < 2 || !relationAppNumbers.contains((Object)(jarAppName = split[1].toLowerCase()))) continue;
            jarNames.add((Object)jarName);
        }
        Object[] classInfosArray = jarNames.toArray();
        Arrays.sort(classInfosArray, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        JSONArray selectItems = new JSONArray();
        if (jarNames.size() > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, jarNames.size());
            for (int i = 0; i < jarNames.size(); ++i) {
                if (appRefJars.contains(jarNames.get(i))) {
                    selectItems.add((Object)i);
                }
                this.getModel().setValue("jarname", jarNames.get(i), i);
            }
        }
        this.getPageCache().put("selectItems", selectItems.toJSONString());
    }

    private JSONArray getRelationAppNumbers(String bizAppId) {
        String inheritpath;
        JSONArray relationAppNumbers = new JSONArray();
        DynamicObject bizAppObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"number,refappid,inheritpath");
        relationAppNumbers.add((Object)bizAppObject.getString(KEY_NUMBER));
        JSONArray refAppIds = new JSONArray();
        String refAppId = bizAppObject.getString("refappid");
        if (StringUtils.isNotBlank((CharSequence)refAppId)) {
            refAppIds.add((Object)refAppId);
        }
        if (StringUtils.isNotBlank((CharSequence)(inheritpath = bizAppObject.getString("inheritpath")))) {
            String[] inheritpaths;
            for (String string : inheritpaths = inheritpath.split(",")) {
                refAppIds.add((Object)string);
            }
        }
        if (refAppIds.size() > 0) {
            DynamicObject[] appObjects = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)KEY_NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)refAppIds)});
            for (String string : appObjects) {
                relationAppNumbers.add((Object)string.getString(KEY_NUMBER));
            }
        }
        return relationAppNumbers;
    }

    public void afterBindData(EventObject e) {
        JSONArray selectItems = JSONArray.parseArray((String)this.getPageCache().get("selectItems"));
        if (selectItems != null && selectItems.size() > 0) {
            int[] items = new int[selectItems.size()];
            for (int i = 0; i < selectItems.size(); ++i) {
                items[i] = selectItems.getIntValue(i);
            }
            EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            grid.selectRows(items, items[0]);
        }
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btnok": {
                this.btnok();
                break;
            }
        }
    }

    private void btnok() {
        AbstractGrid grid = (AbstractGrid)this.getControl(KEY_ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"CodeJarPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder jars = new StringBuilder();
        for (int i = 0; i < selectIndex.length; ++i) {
            jars.append(this.getModel().getValue("jarname", selectIndex[i]));
            if (i >= selectIndex.length - 1) continue;
            jars.append(';');
        }
        String scriptId = (String)this.getView().getFormShowParameter().getCustomParam("scriptid");
        DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)"ide_pluginscript", (String)BIZAPPID);
        String bizAppId = scriptObject.getString(BIZAPPID);
        QFilter qfilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        DynamicObject appRefJarObject = BusinessDataServiceHelper.loadSingle((String)BOS_DEVP_APPREFJAR, (String)"jar", (QFilter[])new QFilter[]{qfilter});
        if (appRefJarObject == null) {
            appRefJarObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVP_APPREFJAR);
            appRefJarObject.set("id", (Object)DB.genLongId((String)"t_meta_apprefjar"));
            appRefJarObject.set(BIZAPPID, (Object)bizAppId);
        }
        appRefJarObject.set("jar", (Object)jars);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appRefJarObject});
        this.getView().returnDataToParent((Object)jars);
        this.getView().close();
    }
}

