/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileUtils;

public class InsertClassPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String KEY_INSERTJAR = "insertjar";
    private static final String SCRIPTID = "scriptid";
    private static final String BIZAPPID = "bizappid";
    private static final String BOS_DEVP_APPREFJAR = "bos_devp_apprefjar";
    private static final String CLASSNAME = "classname";
    private static final String PACKAGENAME = "packagename";
    private static final String DESCRIPTION = "description";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FULLNAME = "fullname";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm", KEY_INSERTJAR});
    }

    public void afterCreateNewData(EventObject e) {
        JSONArray appRefJars = new JSONArray();
        String scriptId = (String)this.getView().getFormShowParameter().getCustomParam(SCRIPTID);
        DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)"ide_pluginscript", (String)BIZAPPID);
        String bizAppId = scriptObject.getString(BIZAPPID);
        QFilter qfilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        DynamicObject appRefJarObject = BusinessDataServiceHelper.loadSingle((String)BOS_DEVP_APPREFJAR, (String)"jar", (QFilter[])new QFilter[]{qfilter});
        if (appRefJarObject != null) {
            String appRefJar = appRefJarObject.getString("jar");
            this.getModel().setValue(KEY_INSERTJAR, (Object)appRefJar);
            if (!StringUtils.isEmpty((CharSequence)appRefJar)) {
                String[] jars = appRefJar.split(";");
                for (int i = 0; i < jars.length; ++i) {
                    appRefJars.add((Object)jars[i]);
                }
            }
        }
        this.refreshClassInJar(appRefJars);
    }

    private void refreshClassInJar(JSONArray appRefJars) {
        appRefJars.add((Object)"bos-entity-core-1.0.jar");
        appRefJars.add((Object)"bos-form-core-1.0.jar");
        appRefJars.add((Object)"bos-servicehelper-1.0.jar");
        appRefJars.add((Object)"bos-sdk-1.0.jar");
        appRefJars.add((Object)"bos-serverscript-1.0.jar");
        String[] jarPaths = null;
        String classPath = System.getProperty("java.class.path");
        jarPaths = classPath.contains(";") ? classPath.split(";") : classPath.split(":");
        JSONArray classInfos = new JSONArray();
        for (String jarPath : jarPaths) {
            String[] paths;
            String jarName;
            if (!jarPath.endsWith(".jar") || !appRefJars.contains((Object)(jarName = (paths = jarPath.replace("/", "\\\\").split("\\\\"))[paths.length - 1]))) continue;
            try (JarFile jarFile = new JarFile(new File(FileUtils.cleanString((String)jarPath)));){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String className;
                    Class<?> info;
                    KSObject annotation;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class") || (annotation = (info = Class.forName(className = name.substring(0, name.length() - 6).replaceAll("/", "."), false, Thread.currentThread().getContextClassLoader())).getAnnotation(KSObject.class)) == null) continue;
                    JSONObject classInfo = new JSONObject();
                    classInfo.put(CLASSNAME, (Object)info.getSimpleName());
                    classInfo.put("classfullname", (Object)info.getCanonicalName());
                    classInfo.put(PACKAGENAME, (Object)className.substring(0, className.lastIndexOf(46)));
                    classInfo.put(DESCRIPTION, (Object)annotation.description());
                    classInfos.add((Object)classInfo);
                }
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
        Object[] classInfosArray = classInfos.toArray();
        Arrays.sort(classInfosArray, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String str1 = ((JSONObject)o1).getString(InsertClassPlugin.CLASSNAME);
                String str2 = ((JSONObject)o2).getString(InsertClassPlugin.CLASSNAME);
                return str1.compareToIgnoreCase(str2);
            }
        });
        classInfos = new JSONArray(Arrays.asList(classInfosArray));
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (classInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, classInfos.size());
            for (int i = 0; i < classInfos.size(); ++i) {
                JSONObject classInfo = classInfos.getJSONObject(i);
                this.getModel().setValue(CLASSNAME, (Object)classInfo.getString(CLASSNAME), i);
                this.getModel().setValue(PACKAGENAME, (Object)classInfo.getString(PACKAGENAME), i);
                this.getModel().setValue(DESCRIPTION, (Object)classInfo.getString(DESCRIPTION), i);
                this.getModel().setValue(FULLNAME, (Object)classInfo.getString("classfullname"), i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_INSERTJAR.equals(e.getProperty().getName())) {
            JSONArray appRefJars = new JSONArray();
            String insertJar = this.getModel().getValue(KEY_INSERTJAR).toString();
            if (!StringUtils.isEmpty((CharSequence)insertJar)) {
                String[] jars = insertJar.split(";");
                for (int i = 0; i < jars.length; ++i) {
                    appRefJars.add((Object)jars[i]);
                }
            }
            this.refreshClassInJar(appRefJars);
            String scriptId = (String)this.getView().getFormShowParameter().getCustomParam(SCRIPTID);
            DynamicObject scriptObject = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)"ide_pluginscript", (String)BIZAPPID);
            String bizAppId = scriptObject.getString(BIZAPPID);
            QFilter qfilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
            DynamicObject appRefJarObject = BusinessDataServiceHelper.loadSingle((String)BOS_DEVP_APPREFJAR, (String)"jar", (QFilter[])new QFilter[]{qfilter});
            if (appRefJarObject == null) {
                appRefJarObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVP_APPREFJAR);
                appRefJarObject.set("id", (Object)DB.genLongId((String)"t_meta_apprefjar"));
                appRefJarObject.set(BIZAPPID, (Object)bizAppId);
            }
            appRefJarObject.set("jar", (Object)insertJar);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appRefJarObject});
        }
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "confirm": {
                this.returnClickRowData();
                break;
            }
            case "insertjar": {
                this.insertJar();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "insertcodejaraction".equals(e.getActionId())) {
            String[] jars;
            this.getModel().setValue(KEY_INSERTJAR, e.getReturnData());
            String appRefJar = e.getReturnData().toString();
            JSONArray appRefJars = new JSONArray();
            for (String jar : jars = appRefJar.split(";")) {
                appRefJars.add((Object)jar);
            }
            this.refreshClassInJar(appRefJars);
        }
    }

    private void insertJar() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_codejar");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "insertcodejaraction"));
        parameter.setCustomParam(SCRIPTID, this.getView().getFormShowParameter().getCustomParam(SCRIPTID));
        this.getView().showForm(parameter);
    }

    private void returnClickRowData() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"InsertClassPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String classes = "";
        for (int i = 0; i < selectIndex.length; ++i) {
            if (this.getModel().getValue(FULLNAME, selectIndex[i]) == null) continue;
            classes = "".equals(classes) ? this.getModel().getValue(FULLNAME, selectIndex[i]).toString() : classes + "&" + this.getModel().getValue(FULLNAME, selectIndex[i]);
        }
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("classes", classes);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

