/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.script.plugin.util.ScriptUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InsertEventPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener {
    private static final Log logger = LogFactory.getLog(InsertEventPlugin.class);
    private static final String PARAMCOUNT = "paramcount";
    private static final String METHODNAME = "methodname";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String scriptType = (String)parameter.getCustomParam("scripttype");
        String classFullName = ScriptUtil.getClassFullNameByIndex(Integer.parseInt(scriptType));
        JSONArray supportedMethods = new JSONArray();
        try {
            Method[] methods;
            Class<?> pluginClass = Class.forName(classFullName);
            for (Method method : methods = pluginClass.getMethods()) {
                if (!ScriptUtil.isKSInsertMethod(method)) continue;
                JSONObject methodInfo = new JSONObject();
                methodInfo.put("name", (Object)method.getName());
                methodInfo.put(PARAMCOUNT, (Object)method.getParameterCount());
                supportedMethods.add((Object)methodInfo);
            }
        }
        catch (ClassNotFoundException exception) {
            logger.error(exception.getMessage());
        }
        if ("kd.bos.unittest.KDUnitTestScriptPlugIn".equals(classFullName)) {
            JSONObject methodInfo = new JSONObject();
            methodInfo.put("name", (Object)"sort");
            methodInfo.put(PARAMCOUNT, (Object)0);
            supportedMethods.add((Object)methodInfo);
        }
        Object[] supportedMethodsArray = supportedMethods.toArray();
        Arrays.sort(supportedMethodsArray, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String str1 = ((JSONObject)o1).getString("name");
                String str2 = ((JSONObject)o2).getString("name");
                return str1.compareToIgnoreCase(str2);
            }
        });
        Map ksmethods = BusinessDataServiceHelper.loadFromCache((String)"bos_devp_ksmethodinfo", (String)"methodname,description", null);
        HashMap<String, ILocaleString> ksmethodsInfo = new HashMap<String, ILocaleString>(ksmethods.size());
        for (DynamicObject ksmethod : ksmethods.values()) {
            ksmethodsInfo.put(ksmethod.getString(METHODNAME), ksmethod.getLocaleString("description"));
        }
        supportedMethods = new JSONArray(Arrays.asList(supportedMethodsArray));
        if (supportedMethods.size() > 0) {
            this.getModel().batchCreateNewEntryRow("buildinmethods", supportedMethods.size());
            for (int i = 0; i < supportedMethods.size(); ++i) {
                JSONObject methodInfo = supportedMethods.getJSONObject(i);
                this.getModel().setValue(METHODNAME, (Object)methodInfo.getString("name"), i);
                this.getModel().setValue("description", ksmethodsInfo.get(methodInfo.getString("name")), i);
                this.getModel().setValue(PARAMCOUNT, (Object)methodInfo.getString(PARAMCOUNT), i);
            }
        }
    }

    private void confirm() {
        AbstractGrid grid = (AbstractGrid)this.getControl("buildinmethods");
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        String methodName = "";
        String paramCount = "";
        String methodType = "";
        for (int i = 0; i < selectIndex.length; ++i) {
            if ("".equals(methodName) && "".equals(paramCount)) {
                methodName = this.getModel().getValue(METHODNAME, selectIndex[i]).toString();
                paramCount = this.getModel().getValue(PARAMCOUNT, selectIndex[i]).toString();
                methodType = "buildin";
                continue;
            }
            methodName = methodName + "&" + this.getModel().getValue(METHODNAME, selectIndex[i]);
            paramCount = paramCount + "&" + this.getModel().getValue(PARAMCOUNT, selectIndex[i]);
            methodType = methodType + "&buildin";
        }
        if ("".equals(methodName) && "".equals(paramCount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u4e2a\u65b9\u6cd5\u3002", (String)"InsertEventPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put(METHODNAME, methodName);
        returnData.put(PARAMCOUNT, paramCount);
        returnData.put("methodtype", methodType);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

