/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.script.plugin.util.ScriptUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class InsertMethodPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(InsertMethodPlugin.class);
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_PARAMCOUNT = "paramcount";
    private static final String KEY_METHODNAME = "methodname";
    private static final String CONFIRM = "confirm";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM});
        this.getControl(KEY_ENTRYENTITY);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String functions = (String)parameter.getCustomParam("insertfun");
        JSONArray selectItems = new JSONArray();
        String classFullName = (String)parameter.getCustomParam("classfullname");
        JSONArray supportedMethods = new JSONArray();
        try {
            Method[] methods;
            Class<?> pluginClass = Class.forName(classFullName);
            for (Method method : methods = pluginClass.getMethods()) {
                if (!ScriptUtil.isKSInsertMethod(method)) continue;
                JSONObject methodInfo = new JSONObject();
                methodInfo.put("name", (Object)method.getName());
                methodInfo.put(KEY_PARAMCOUNT, (Object)method.getParameterCount());
                supportedMethods.add((Object)methodInfo);
            }
        }
        catch (ClassNotFoundException exception) {
            logger.error(exception.getMessage());
        }
        if ("kd.bos.unittest.KDUnitTestScriptPlugIn".equals(classFullName)) {
            JSONObject methodInfo = new JSONObject();
            methodInfo.put("name", (Object)"sort");
            supportedMethods.add((Object)methodInfo);
        }
        Object[] supportedMethodsArray = supportedMethods.toArray();
        Arrays.sort(supportedMethodsArray, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String str1 = ((JSONObject)o1).getString("name");
                String str2 = ((JSONObject)o2).getString("name");
                return str1.compareToIgnoreCase(str2);
            }
        });
        Map ksmethods = BusinessDataServiceHelper.loadFromCache((String)"bos_devp_ksmethodinfo", (String)"methodname,description", null);
        HashMap<String, ILocaleString> ksmethodsInfo = new HashMap<String, ILocaleString>(ksmethods.size());
        for (DynamicObject ksmethod : ksmethods.values()) {
            ksmethodsInfo.put(ksmethod.getString(KEY_METHODNAME), ksmethod.getLocaleString("description"));
        }
        supportedMethods = new JSONArray(Arrays.asList(supportedMethodsArray));
        if (supportedMethods.size() > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, supportedMethods.size());
            for (int i = 0; i < supportedMethods.size(); ++i) {
                JSONObject methodInfo = supportedMethods.getJSONObject(i);
                this.getModel().setValue(KEY_METHODNAME, (Object)methodInfo.getString("name"), i);
                this.getModel().setValue("description", ksmethodsInfo.get(methodInfo.getString("name")), i);
                this.getModel().setValue(KEY_PARAMCOUNT, (Object)methodInfo.getString(KEY_PARAMCOUNT), i);
                if (!functions.contains(methodInfo.getString("name"))) continue;
                selectItems.add((Object)i);
            }
            if (!functions.isEmpty()) {
                this.getPageCache().put("selectItems", selectItems.toJSONString());
            }
        }
    }

    public void afterBindData(EventObject e) {
        JSONArray selectItems = JSONArray.parseArray((String)this.getPageCache().get("selectItems"));
        if (selectItems != null) {
            int[] items = new int[selectItems.size()];
            for (int i = 0; i < selectItems.size(); ++i) {
                items[i] = selectItems.getIntValue(i);
            }
            EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            grid.selectRows(items, items[0]);
        }
    }

    public void click(EventObject e) {
        String key = ((Control)e.getSource()).getKey();
        if (CONFIRM.equals(key)) {
            this.returnClickRowData();
        }
    }

    private void returnClickRowData() {
        AbstractGrid grid = (AbstractGrid)this.getControl(KEY_ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"InsertMethodPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        String methodName = "";
        String paramCount = "";
        for (int i = 0; i < selectIndex.length; ++i) {
            if ("".equals(methodName) && "".equals(paramCount)) {
                methodName = this.getModel().getValue(KEY_METHODNAME, selectIndex[i]).toString();
                paramCount = this.getModel().getValue(KEY_PARAMCOUNT, selectIndex[i]).toString();
                continue;
            }
            methodName = methodName + "," + this.getModel().getValue(KEY_METHODNAME, selectIndex[i]);
            paramCount = paramCount + "," + this.getModel().getValue(KEY_PARAMCOUNT, selectIndex[i]);
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put(KEY_METHODNAME, methodName);
        returnData.put(KEY_PARAMCOUNT, paramCount);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

