/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class NewBlankScriptPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BIZUNIT = "bizunit";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZAPP = "bizapp";
    private static final String SCENE = "scene";
    private static final String SCRIPTNUMBER = "scriptnumber";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String PAGE = "page";
    private static final String UNIT = "unit";
    private static final String SCRIPT_SAVEAS = "scriptsaveas";
    private static final String APP = "app";
    private static final String BLANK = " ";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BIZUNIT, "save"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam("type");
        String bizAppId = (String)parameter.getCustomParam("bizappid");
        String nodeType = (String)parameter.getCustomParam("nodetype");
        if (PAGE.equals(nodeType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BIZUNIT});
        }
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
        }
        if (UNIT.equals(type)) {
            String bizUnitId = (String)parameter.getCustomParam(BIZUNITID);
            this.getModel().setValue(BIZAPP, (Object)bizAppId);
            String bizUnitName = DevportalUtil.getBizUnitNameById(bizAppId, bizUnitId);
            this.getModel().setValue(BIZUNIT, (Object)bizUnitName);
            this.getPageCache().put(BIZUNITID, bizUnitId);
        } else if (APP.equals(type)) {
            this.getModel().setValue(BIZAPP, (Object)bizAppId);
        }
        if (SCRIPT_SAVEAS.equals(parameter.getCustomParam(SCENE))) {
            String scriptNumber = (String)parameter.getCustomParam(SCRIPTNUMBER);
            this.getModel().setValue(SCRIPTNUMBER, (Object)(scriptNumber + "1"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (BIZAPP.equals(propertyName)) {
            this.getModel().setValue(BIZUNIT, (Object)BLANK);
            this.getPageCache().remove(BIZUNITID);
        }
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "save": {
                this.saveBlankScript();
                break;
            }
        }
    }

    private void saveBlankScript() {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(BIZAPP);
        String bizAppId = bizApp.getString(0);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        if (this.checkValidation()) {
            String scriptName = this.getModel().getValue("scriptname").toString();
            String scriptNumber = this.getModel().getValue(SCRIPTNUMBER).toString().toLowerCase();
            String bizUnitId = this.getPageCache().get(BIZUNITID);
            String className = DevportalUtil.getClassNameByBizUnitId(bizAppId, bizUnitId, scriptNumber);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String content = parameter.getCustomParam(SCENE) != null && SCRIPT_SAVEAS.equals(parameter.getCustomParam(SCENE)) ? (String)parameter.getCustomParam("content") : this.initScriptContent(scriptNumber);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)IDE_PLUGINSCRIPT);
            String id = Uuid8.generateShortUuid();
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("enginetype", (Object)"0");
            dynamicObject.set("txt_scriptname", (Object)scriptName);
            dynamicObject.set("txt_scriptnumber", (Object)scriptNumber);
            dynamicObject.set("classname", (Object)className);
            dynamicObject.set("cbox_script_type", (Object)"6");
            dynamicObject.set(BIZUNITID, (Object)bizUnitId);
            dynamicObject.set("bizappid", (Object)bizAppId);
            dynamicObject.set("txt_scriptcontext_tag", (Object)content);
            dynamicObject.set("txt_scriptcontext", (Object)BLANK);
            dynamicObject.set("creater", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dynamicObject.set("createdate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date())));
            dynamicObject.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dynamicObject.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
            String isv = dynamicObject.getString("isv");
            if (StringUtils.isBlank((CharSequence)isv)) {
                isv = ISVService.getISVInfo().getId();
                dynamicObject.set("isv", (Object)isv);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "NewBlankScriptPlugin_0", BOS_DEVPORTAL_PLUGIN);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u811a\u672c", "NewBlankScriptPlugin_1", BOS_DEVPORTAL_PLUGIN);
            AppUtils.addOpLog((String)IDE_PLUGINSCRIPT, (String)"save", (String)IDE_PLUGINSCRIPT, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            returnData.put("content", content);
            returnData.put(SCRIPTNUMBER, scriptNumber);
            returnData.put("id", id);
            returnData.put("bizAppId", bizAppId);
            returnData.put(BIZUNITID, bizUnitId);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private String initScriptContent(String scriptNumber) {
        StringBuilder title = this.initTitleContent();
        StringBuilder mainContent = new StringBuilder();
        mainContent.append("var ");
        mainContent.append(scriptNumber);
        mainContent.append(" = {\n\n};");
        return title.append((CharSequence)mainContent).toString();
    }

    private StringBuilder initTitleContent() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/**\n* @author ");
        stringBuilder.append(RequestContext.get().getUserName());
        stringBuilder.append("\n* @date ");
        stringBuilder.append(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        stringBuilder.append("\n*/\n");
        return stringBuilder;
    }

    private boolean checkValidation() {
        String scriptName = this.getModel().getValue("scriptname").toString();
        String scriptNumber = this.getModel().getValue(SCRIPTNUMBER).toString();
        if (BLANK.equalsIgnoreCase(scriptName) || BLANK.equalsIgnoreCase(scriptNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u811a\u672c\u540d\u79f0\u201d\u548c\u201c\u811a\u672c\u7f16\u7801\u201d\u3002", (String)"NewBlankScriptPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue(BIZAPP) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NewBlankScriptPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String bizUnit = this.getModel().getValue(BIZUNIT).toString();
        if (BLANK.equalsIgnoreCase(bizUnit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NewBlankScriptPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String reg = "[0-9]+";
        if (Pattern.matches(reg, scriptNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u811a\u672c\u7f16\u7801\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u4e0d\u80fd\u4e3a\u7eaf\u6570\u5b57\u3002", (String)"NewBlankScriptPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String regex = "[a-z0-9A-Z_]+";
        if (!Pattern.matches(regex, scriptNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u53ea\u80fd\u4ee5\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"NewBlankScriptPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (Character.isDigit(scriptNumber.charAt(0))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u811a\u672c\u7f16\u7801\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u5e94\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u6570\u5b57\u4e0d\u80fd\u7528\u4e8e\u5f00\u5934\u3002", (String)"NewBlankScriptPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        QFilter qNumber = new QFilter("txt_scriptnumber", "=", (Object)scriptNumber.toLowerCase());
        QFilter qName = new QFilter("txt_scriptname", "=", (Object)scriptName);
        QFilter[] filters = new QFilter[]{qNumber};
        if (QueryServiceHelper.exists((String)IDE_PLUGINSCRIPT, (QFilter[])filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"NewBlankScriptPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        filters = new QFilter[]{qName};
        if (QueryServiceHelper.exists((String)IDE_PLUGINSCRIPT, (QFilter[])filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"NewBlankScriptPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

