/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.isv.ISVService;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class SceneCodeListPlugin
extends AbstractListPlugin
implements ItemClickListener,
IConfirmCallBack,
ClickListener {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String DELETE_CALLBACK = "deletecallback";

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (DELETE_CALLBACK.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.delete();
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (!"kingdee".equals(ISVService.getISVInfo().getId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_addnew", "btn_modify", "btn_checkin", "btn_view", "btn_delete", "btn_refresh"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_confirm": {
                this.confirm();
                break;
            }
            case "btn_delete": {
                this.beforeDelete();
                break;
            }
        }
    }

    private void confirm() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SceneCodeListPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SceneCodeListPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        String sceneId = listSelectedRow.getPrimaryKeyValue().toString();
        DynamicObject sceneObject = BusinessDataServiceHelper.loadSingle((Object)sceneId, (String)"bos_devp_scenecode");
        this.getView().returnDataToParent(sceneObject.get("scriptcontent"));
        this.getView().close();
    }

    private void beforeDelete() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SceneCodeListPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684 %s \u6761\u8bb0\u5f55?", (String)"SceneCodeListPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), selectedRows.size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_CALLBACK));
    }

    private void delete() {
        if (!"kingdee".equals(AppUtils.getDeveloperInfo())) {
            this.getView().showTipNotification(AppUtils.getNoPermissionTips());
            return;
        }
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        JSONArray sceneIds = new JSONArray();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            String sceneId = listSelectedRow.getPrimaryKeyValue().toString();
            sceneIds.add((Object)sceneId);
        }
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)sceneIds)};
        DeleteServiceHelper.delete((String)"bos_devp_scenecode", (QFilter[])filter);
        ((IListView)this.getView()).updateView();
        ((IListView)this.getView()).clearSelection();
        this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SceneCodeListPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
    }
}

