/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ScriptDetailsPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String CREATER = "creater";
    private static final String MODIFIER = "modifier";
    private static final String PAGEID = "pageid";
    private static final String ENABLE = "enable";
    private static final String NUMBER = "number";

    public void initialize() {
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String scriptId = (String)parameter.getCustomParam("scriptid");
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        this.getModel().setValue("scriptnumber", scriptInfo.get("txt_scriptnumber"));
        this.getModel().setValue("scriptname", scriptInfo.get("txt_scriptname"));
        this.getModel().setValue("scripttype", scriptInfo.get("cbox_script_type"));
        this.getModel().setValue("bizapp", (Object)DevportalUtil.getBizAppNameById(scriptInfo.getString("bizappid")));
        this.getModel().setValue("bizunit", (Object)DevportalUtil.getBizUnitNameById(scriptInfo.getString("bizappid"), scriptInfo.getString("bizunitid")));
        DynamicObject creater = (DynamicObject)scriptInfo.get(CREATER);
        this.getModel().setValue(CREATER, (Object)(scriptInfo.get(CREATER) == null ? ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"ScriptDetailsPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]) : (creater.getLocaleString("name").getLocaleValue() == null ? creater.getLocaleString("name").getLocaleValue_zh_CN() : creater.getLocaleString("name").getLocaleValue())));
        this.getModel().setValue("createdate", scriptInfo.get("createdate"));
        DynamicObject modifier = (DynamicObject)scriptInfo.get(MODIFIER);
        this.getModel().setValue(MODIFIER, (Object)(scriptInfo.get(MODIFIER) == null ? ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"ScriptDetailsPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]) : (modifier.getLocaleString("name").getLocaleValue() == null ? modifier.getLocaleString("name").getLocaleValue_zh_CN() : modifier.getLocaleString("name").getLocaleValue())));
        this.getModel().setValue("modifydate", scriptInfo.get("modifydate"));
        this.renderGrid(scriptId, scriptInfo.get("txt_scriptnumber").toString());
    }

    private void renderGrid(String scriptId, String scriptNumber) {
        JSONArray formIds = new JSONArray();
        HashMap<String, Boolean> scriptStateInfo = new HashMap<String, Boolean>();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devp_pagerelscript", (String)"scriptid,pageid,enable", (QFilter[])new QFilter[]{new QFilter("scriptid", "=", (Object)scriptId)});
        if (dynamicObjects.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            String formId = (String)dynamicObject.get(PAGEID);
            formIds.add((Object)formId);
            scriptStateInfo.put(formId, dynamicObject.getBoolean(ENABLE));
        }
        QFilter qFilter = new QFilter("id", "in", (Object)formIds);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject[] appObjects = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,name,number", (QFilter[])filters, (String)"number asc");
        if (appObjects.length > 0) {
            int i;
            JSONArray listPages = new JSONArray();
            for (i = 0; i < appObjects.length; ++i) {
                JSONObject page = new JSONObject();
                DynamicObject dynamicObject = appObjects[i];
                String pageId = dynamicObject.getString("id");
                String pageNumber = dynamicObject.getString(NUMBER);
                page.put("id", (Object)pageId);
                page.put(NUMBER, (Object)pageNumber);
                page.put("name", (Object)dynamicObject.getLocaleString("name").getLocaleValue());
                page.put(ENABLE, scriptStateInfo.get(pageId));
                listPages.add((Object)page);
            }
            if (listPages.size() > 0) {
                this.getModel().batchCreateNewEntryRow("entryentity", listPages.size());
                for (i = 0; i < listPages.size(); ++i) {
                    JSONObject row = (JSONObject)listPages.get(i);
                    this.getModel().setValue(PAGEID, (Object)row.getString("id"), i);
                    this.getModel().setValue("pagenumber", (Object)row.getString(NUMBER), i);
                    this.getModel().setValue("pagename", (Object)row.getString("name"), i);
                    this.getModel().setValue(ENABLE, (Object)(row.getString(ENABLE) != null && "true".equals(row.getString(ENABLE)) ? 1 : 0), i);
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        String pageId = this.getModel().getValue(PAGEID, rowIndex).toString();
        DevportalUtil.gotoPageDesinger(this.getView(), pageId, "bos_devportal_bizpagelist");
    }
}

