/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class ScriptImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ScriptImportPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String IMPORTPOSITION = "importposition";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZUNITID = "bizunitid";
    private static final String URLARR = "urlarr";
    private long LIMITSIZ = 0x100000L;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"import"});
        IAttachmentPanel dbspanel = (IAttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
        TextEdit bizUnit = (TextEdit)this.getView().getControl(IMPORTPOSITION);
        bizUnit.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(BIZAPPID);
        String bizUnitId = (String)parameter.getCustomParam(BIZUNITID);
        AppFunctionPacketElement functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        String bizunitName = functionPacket.getName().getLocaleValue();
        this.getModel().setValue(IMPORTPOSITION, (Object)bizunitName);
        this.getModel().setValue(BIZUNITID, (Object)bizUnitId);
        this.getModel().setValue(BIZAPPID, (Object)bizAppId);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "import": {
                this.confirm();
                break;
            }
            case "importposition": {
                this.chooseUnit();
                break;
            }
        }
    }

    public void upload(UploadEvent arg0) {
        Object[] args = arg0.getUrls();
        for (int n = 0; n < args.length; ++n) {
            Map urlMsg = (Map)args[n];
            String urlName = (String)urlMsg.get("name");
            String url = (String)urlMsg.get("url");
            JSONArray urlArr = new JSONArray();
            JSONObject urlObj = new JSONObject();
            urlObj.put(urlName, (Object)url);
            urlArr.add((Object)urlObj);
            JSONArray urlCaheArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
            if (urlCaheArr != null && urlCaheArr.size() > 0) {
                for (int i = 0; i < urlCaheArr.size(); ++i) {
                    JSONObject urlCatchObj = (JSONObject)urlCaheArr.get(i);
                    if (!urlCatchObj.containsKey((Object)urlName)) continue;
                    urlCaheArr.remove((Object)urlCatchObj);
                }
                urlCaheArr.addAll((Collection)urlArr);
                this.getPageCache().put(URLARR, urlCaheArr.toJSONString());
                continue;
            }
            this.getPageCache().put(URLARR, urlArr.toJSONString());
        }
    }

    public void remove(UploadEvent arg0) {
        Map urlMsg = (Map)arg0.getUrls()[0];
        String urlName = (String)urlMsg.get("name");
        JSONArray urlCacheArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        if (urlCacheArr != null && urlCacheArr.size() > 0) {
            for (int i = 0; i < urlCacheArr.size(); ++i) {
                JSONObject urlCatchObj = (JSONObject)urlCacheArr.get(i);
                if (!urlCatchObj.containsKey((Object)urlName)) continue;
                urlCacheArr.remove((Object)urlCatchObj);
            }
            this.getPageCache().put(URLARR, urlCacheArr.toJSONString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirm() {
        JSONArray urlArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        JSONObject message = new JSONObject();
        String bizUnitId = (String)this.getModel().getValue(BIZUNITID);
        String bizAppId = (String)this.getModel().getValue(BIZAPPID);
        if (urlArr != null && urlArr.size() > 0) {
            for (int i = 0; i < urlArr.size(); ++i) {
                JSONObject urlObj = (JSONObject)urlArr.get(i);
                for (String urlName : urlObj.keySet()) {
                    String url = urlObj.getString(urlName);
                    logger.debug("url=" + url);
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    String scriptId = null;
                    String scriptNumber = null;
                    try (TXHandle tx = TX.required((String)"mdl_ScriptImportPlugin_confirm");
                         InputStream inStream = cache.getInputStream(url);){
                        byte[] bt = new byte[(int)this.LIMITSIZ];
                        int len = inStream.read(bt);
                        String content = new String(bt, 0, len);
                        DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
                        serializer.setColloctionIgnorePKValue(true);
                        DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
                        List dynamicObjects = deployNew.getScripts();
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            scriptId = dynamicObject.getString("id");
                            scriptNumber = dynamicObject.getString("number");
                            String isv = dynamicObject.getString("isv");
                            if (StringUtils.isBlank((CharSequence)isv)) {
                                throw new KDException(new ErrorCode("devp_isv", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u811a\u672c\u3010%s\u3011\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ScriptImportPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), scriptNumber)), new Object[]{ResManager.loadKDString((String)"\u90e8\u7f72\u811a\u672c\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\u3002", (String)"ScriptImportPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])});
                            }
                            String appIsv = AppUtils.getIsvByAppId((String)bizAppId);
                            if (appIsv.equals(isv)) continue;
                            throw new KDException(new ErrorCode("devp_isv", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u811a\u672c\u3010%1$s\u3011\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u3010%2$s\u3011\uff0c\u4e0e\u5f53\u524d\u5e94\u7528\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u3010%3$s\u3011\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ScriptImportPlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), scriptNumber, isv, appIsv)), new Object[]{ResManager.loadKDString((String)"\u90e8\u7f72\u811a\u672c\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\u3002", (String)"ScriptImportPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])});
                        }
                        MetadataDao.deployScript((String)content, (String)bizUnitId, (String)bizAppId);
                    }
                    message.put("SUCCESS", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ScriptImportPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    message.put("scriptid", (Object)scriptId);
                    message.put(BIZAPPID, (Object)bizAppId);
                    message.put(BIZUNITID, (Object)bizUnitId);
                    message.put("scriptnumber", (Object)scriptNumber);
                    this.getView().returnDataToParent((Object)message);
                    this.getView().close();
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5b89\u88c5\u7684\u90e8\u7f72\u5305\u3002", (String)"ScriptImportPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
    }

    private void chooseUnit() {
        String unitId = (String)this.getModel().getValue(BIZUNITID);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_chosebizunit");
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u529f\u80fd\u5206\u7ec4", (String)"ScriptImportPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BIZAPPID, (Object)appId);
        parameter.setCustomParam("thisunitid", (Object)unitId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "chooseunitcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret = (Map)e.getReturnData();
        if (ret != null && "chooseunitcallback".equals(e.getActionId())) {
            String bizUnitId = (String)ret.get("id");
            String bizUnitName = (String)ret.get("name");
            this.getModel().setValue(BIZUNITID, (Object)bizUnitId);
            this.getModel().setValue(IMPORTPOSITION, (Object)bizUnitName);
        }
    }
}

