/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class ScriptListInDevPlugin
extends AbstractFormPlugin
implements ItemClickListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String BIZPAGEID = "bizpageid";
    private static final String ADDNEW = "addnew";
    private static final String MODIFY = "modify";
    private static final String CHECKIN = "checkin";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String DELETE = "delete";
    private static final String CODEMANAGE = "codemanage";
    private static final String BIZAPPTYPE = "bizapptype";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String PAGEID = "pageid";
    private static final String BIZCUSTOMLISTAP = "bizcustomlistap";
    private static final String SVNOPERATE = "svnoperate";
    private static final String SCRIPTNUMBER = "scriptnumber";
    private static final String SCRIPTNAME = "scriptname";
    private static final String SCRIPTTYPE1 = "scripttype";
    private static final String BIZUNITNAME = "bizunitname";
    private static final String MODIFIER = "modifier";
    private static final String MODIFYDATE = "modifydate";
    private static final String CBOX_SCRIPT_TYPE = "cbox_script_type";
    private String SCRIPTTYPE = "SCRIPT_TYPE";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            if ("newscriptcloseaction".equals(e.getActionId())) {
                this.refreshScriptInfo();
            } else if ("importscriptcallback".equals(e.getActionId())) {
                JSONObject map = (JSONObject)e.getReturnData();
                if (map != null && map.get((Object)"error") != null) {
                    this.getView().getParentView().showTipNotification(map.get((Object)"error").toString());
                    this.getView().sendFormAction(this.getView().getParentView());
                    return;
                }
                if (map != null && map.get((Object)"SUCCESS") != null) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ScriptListInDevPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    String bizUnitId = map.getString(BIZUNITID);
                    this.getPageCache().put(BIZUNITID, bizUnitId);
                    String bizAppId = map.getString(BIZAPPID);
                    String bizCloudId = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getBizCloudID();
                    JSONObject args = new JSONObject();
                    args.put(BIZCLOUDID, (Object)bizCloudId);
                    args.put(BIZAPPID, (Object)bizAppId);
                    args.put(BIZUNITID, (Object)bizUnitId);
                    args.put(BIZPAGEID, (Object)map.getString("scriptid"));
                    DevportalUtil.locateResourcePos(args, this.getView().getParentView(), "script");
                    this.refreshScriptInfo();
                }
            } else if ("exportsourcecallback".equals(e.getActionId())) {
                String message = (String)e.getReturnData();
                if (StringUtils.isNotBlank((CharSequence)message) && "EXPORT_SUCCESS".equals(message)) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ScriptListInDevPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            } else if ("moveScriptCallBack".equals(e.getActionId())) {
                if (e.getReturnData() != null) {
                    JSONObject arg = (JSONObject)e.getReturnData();
                    String bizCloudId = arg.getString(BIZCLOUDID);
                    String bizAppId = arg.getString(BIZAPPID);
                    String bizUnitId = arg.getString(BIZUNITID);
                    String bizPageId = arg.getString(BIZPAGEID);
                    this.markTargetPage(bizCloudId, bizAppId, bizUnitId, bizPageId);
                    this.getPageCache().put(BIZUNITID, bizUnitId);
                    this.refreshScriptInfo();
                }
            } else if ("renameScriptCallBack".equals(e.getActionId())) {
                this.refreshScriptInfo();
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        switch (key = e.getItemKey()) {
            case "addnew": {
                this.addNewScript();
                break;
            }
            case "modify": {
                this.modifyScript();
                break;
            }
            case "checkin": {
                this.checkInScript();
                break;
            }
            case "svndiff": 
            case "svnlog": 
            case "svnrevert": 
            case "svndelete": 
            case "svnlock": 
            case "svnunlock": 
            case "svnclean": {
                this.svnOperation(key);
                break;
            }
            case "import": {
                this.importScript();
                break;
            }
            case "export": {
                this.exportScript();
                break;
            }
            case "delete": {
                this.deleteScript();
                break;
            }
            case "move": {
                this.moveScript();
                break;
            }
            case "scriptdetail": {
                this.previewScriptDetail();
                break;
            }
            case "codemanage": {
                this.codeManage();
                break;
            }
            case "commit": 
            case "push": 
            case "update": 
            case "revert": {
                this.gitOperate(key);
                break;
            }
        }
    }

    private void showPleaseSelectSingleRowTipNotification() {
        this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"ScriptListInDevPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void showCanNotModifySourcesFromExtApp() {
        this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u6269\u5c55\u5e94\u7528\u4e0b\u4e0d\u80fd\u64cd\u4f5c\u8d44\u6e90\u3002", (String)"ScriptListInDevPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void gitOperate(String operateKey) {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.showPleaseSelectSingleRowTipNotification();
            return;
        }
        String bizAppType = this.getPageCache().get(BIZAPPTYPE);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String scriptId = (String)this.getModel().getValue("scriptid", selectIndex[0]);
        if ("2".equals(bizAppType) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)BIZAPPID).getString(BIZAPPID))) {
            this.showCanNotModifySourcesFromExtApp();
            return;
        }
        String pageId = this.getView().getParentView().getPageId();
        JSONObject pageObject = new JSONObject();
        pageObject.put("id", (Object)scriptId);
        pageObject.put("operatekey", (Object)operateKey);
        pageObject.put(PAGEID, (Object)pageId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, "gitoperate", new Object[]{pageObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void codeManage() {
        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u5e94\u7528\u5361\u7247\uff0c\u8bbe\u7f6e\u4ee3\u7801\u7ba1\u7406\u65b9\u5f0f\u3002", (String)"ScriptListInDevPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        String bizAppType = this.getPageCache().get(BIZAPPTYPE);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String scriptId = (String)this.getModel().getValue("scriptid", rowIndex);
        if (StringUtils.isNotBlank((CharSequence)scriptId) && "2".equals(bizAppType)) {
            String bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)BIZAPPID).getString(BIZAPPID);
            if (!bizAppId.equals(bizSourceAppId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{DELETE, MODIFY, "move", EXPORT, CODEMANAGE, SVNOPERATE, "gitoperate"});
            } else if (StringUtils.isNotBlank((CharSequence)bizAppId) && !AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{DELETE, MODIFY, "move", EXPORT, CODEMANAGE, SVNOPERATE, "gitoperate"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{DELETE, MODIFY, "move", EXPORT});
            }
        }
    }

    private void svnOperation(String key) {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.showPleaseSelectSingleRowTipNotification();
            return;
        }
        String bizAppType = this.getPageCache().get(BIZAPPTYPE);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String scriptId = (String)this.getModel().getValue("scriptid", selectIndex[0]);
        if ("2".equals(bizAppType) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)BIZAPPID).getString(BIZAPPID))) {
            this.showCanNotModifySourcesFromExtApp();
            return;
        }
        String pageId = this.getView().getParentView().getPageId();
        JSONObject pageObject = new JSONObject();
        pageObject.put("id", (Object)scriptId);
        pageObject.put("operatekey", (Object)key);
        pageObject.put(PAGEID, (Object)pageId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, SVNOPERATE, new Object[]{pageObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void modifyScript() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.showPleaseSelectSingleRowTipNotification();
            return;
        }
        String bizAppType = this.getPageCache().get(BIZAPPTYPE);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String scriptId = (String)this.getModel().getValue("scriptid", selectIndex[0]);
        if ("2".equals(bizAppType) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)BIZAPPID).getString(BIZAPPID))) {
            this.showCanNotModifySourcesFromExtApp();
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_kde");
        parameter.setCustomParam(BIZAPPID, this.getModel().getValue(BIZAPPID, selectIndex[0]));
        parameter.setCustomParam(BIZCLOUDID, (Object)this.getPageCache().get(BIZCLOUDID));
        parameter.setCustomParam("bizscriptid", this.getModel().getValue("scriptid", selectIndex[0]));
        this.getView().showForm(parameter);
    }

    private void moveScript() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.showPleaseSelectSingleRowTipNotification();
            return;
        }
        String bizAppType = this.getPageCache().get(BIZAPPTYPE);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String scriptId = (String)this.getModel().getValue("scriptid", selectIndex[0]);
        if ("2".equals(bizAppType) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)BIZAPPID).getString(BIZAPPID))) {
            this.showCanNotModifySourcesFromExtApp();
            return;
        }
        if (AppUtils.isScriptBeReferenced((String)this.getModel().getValue("scriptid", selectIndex[0]).toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u5f15\u7528\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"ScriptListInDevPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_scriptmoving");
        parameter.setCustomParam("scriptid", this.getModel().getValue("scriptid", selectIndex[0]));
        parameter.setCustomParam(BIZAPPID, (Object)this.getPageCache().get(BIZAPPID));
        parameter.setCustomParam(BIZUNITID, (Object)this.getPageCache().get(BIZUNITID));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "moveScriptCallBack"));
        this.getView().showForm(parameter);
    }

    private void previewScriptDetail() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.showPleaseSelectSingleRowTipNotification();
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_scriptdetails");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u811a\u672c\u8be6\u60c5", (String)"ScriptListInDevPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam("scriptid", this.getModel().getValue("scriptid", selectIndex[0]));
        this.getView().showForm(parameter);
    }

    private void deleteScript() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"ScriptListInDevPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String bizAppType = this.getPageCache().get(BIZAPPTYPE);
        JSONArray scriptArray = new JSONArray();
        JSONObject scriptObject = new JSONObject();
        for (int i = 0; i < selectIndex.length; ++i) {
            String bizSourceAppId;
            String scriptId = this.getModel().getValue("scriptid", selectIndex[i]).toString();
            if ("2".equals(bizAppType) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)BIZAPPID).getString(BIZAPPID))) {
                this.showCanNotModifySourcesFromExtApp();
                return;
            }
            if (AppUtils.isScriptBeReferenced((String)scriptId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ScriptListInDevPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            scriptArray.add((Object)scriptId);
        }
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String parentPageId = this.getView().getParentView().getPageId();
        String pageId = this.getView().getPageId();
        scriptObject.put("scriptsinfo", (Object)scriptArray);
        scriptObject.put("parentpageid", (Object)parentPageId);
        scriptObject.put(PAGEID, (Object)pageId);
        scriptObject.put(BIZAPPID, (Object)bizAppId);
        scriptObject.put(BIZUNITID, (Object)bizUnitId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, "deletescript", new Object[]{scriptObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void exportScript() {
        String bizSourceAppId;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.showPleaseSelectSingleRowTipNotification();
            return;
        }
        String bizAppType = this.getPageCache().get(BIZAPPTYPE);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String scriptId = (String)this.getModel().getValue("scriptid", selectIndex[0]);
        if ("2".equals(bizAppType) && !bizAppId.equals(bizSourceAppId = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT, (String)BIZAPPID).getString(BIZAPPID))) {
            this.showCanNotModifySourcesFromExtApp();
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u811a\u672c", (String)"ScriptListInDevPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_devp_exportsource");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("bizid", (Object)scriptId);
        parameter.setCustomParam("type", (Object)this.SCRIPTTYPE);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "exportsourcecallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void importScript() {
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        AppFunctionPacketElement appFunPacketEle = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        String bizUnitType = appFunPacketEle.getType();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZUNITID, (Object)bizUnitId);
        parameter.setCustomParam("bizunittype", (Object)bizUnitType);
        parameter.setFormId("bos_devp_scriptimport");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importscriptcallback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void checkInScript() {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0 || selectIndex.length > 1) {
            this.showPleaseSelectSingleRowTipNotification();
            return;
        }
        String scriptId = (String)this.getModel().getValue("scriptid", selectIndex[0]);
        String pageId = this.getView().getParentView().getPageId();
        String bizAppId = this.getPageCache().get(BIZAPPID);
        JSONObject pageObject = new JSONObject();
        pageObject.put("bizid", (Object)scriptId);
        pageObject.put(PAGEID, (Object)pageId);
        pageObject.put(BIZAPPID, (Object)bizAppId);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).invokeControlMethod(BIZCUSTOMLISTAP, "checkinscript", new Object[]{pageObject});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void addNewScript() {
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get(BIZUNITID))) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u529f\u80fd\u5206\u7ec4\u3002", (String)"ScriptListInDevPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("type", (Object)"unit");
        parameter.setCustomParam(BIZAPPID, (Object)this.getPageCache().get(BIZAPPID));
        parameter.setCustomParam(BIZUNITID, (Object)this.getPageCache().get(BIZUNITID));
        parameter.setFormId("bos_devp_newscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newscriptcloseaction"));
        parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u5efa\u63d2\u4ef6\u811a\u672c", (String)"ScriptListInDevPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam("scene", (Object)"newscript");
        this.getView().showForm(parameter);
    }

    public void afterCreateNewData(EventObject e) {
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String codeManageType = DevportalUtil.getCodeManageTypeByBizAppId(bizAppId);
        if ("code".equals(codeManageType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SVNOPERATE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"gitoperate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{CODEMANAGE});
        } else if ("svn".equals(codeManageType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CODEMANAGE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"gitoperate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SVNOPERATE});
        } else if ("git".equals(codeManageType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CODEMANAGE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SVNOPERATE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"gitoperate"});
        }
        if (StringUtils.isNotBlank((CharSequence)bizAppId) && StringUtils.isNotBlank((CharSequence)bizUnitId)) {
            FormShowParameter parameter;
            AppFunctionPacketElement element = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
            String unitType = element.getType();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ADDNEW, MODIFY, CHECKIN, IMPORT, EXPORT, DELETE, "refresh", "move"});
            if (StringUtils.isNotBlank((CharSequence)bizAppId) && !AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ADDNEW, MODIFY, CHECKIN, IMPORT, EXPORT, DELETE, "refresh", "move", CODEMANAGE, SVNOPERATE, "gitoperate"});
            }
            if ((parameter = this.getView().getFormShowParameter()).getCustomParam("tabledata") != null) {
                JSONArray scriptInfos = JSONArray.parseArray((String)((String)parameter.getCustomParam("tabledata")));
                this.getModel().deleteEntryData(ENTRYENTITY);
                if (scriptInfos.size() > 0) {
                    this.getModel().batchCreateNewEntryRow(ENTRYENTITY, scriptInfos.size());
                    for (int i = 0; i < scriptInfos.size(); ++i) {
                        JSONObject scriptInfo = scriptInfos.getJSONObject(i);
                        this.getModel().setValue(SCRIPTNUMBER, (Object)scriptInfo.getString(SCRIPTNUMBER), i);
                        this.getModel().setValue(SCRIPTNAME, (Object)scriptInfo.getString(SCRIPTNAME), i);
                        this.getModel().setValue(SCRIPTTYPE1, (Object)scriptInfo.getString(SCRIPTTYPE1), i);
                        this.getModel().setValue(BIZUNITNAME, (Object)scriptInfo.getString(BIZUNITNAME), i);
                        this.getModel().setValue("scriptid", (Object)scriptInfo.getString("scriptid"), i);
                        this.getModel().setValue(BIZUNITID, (Object)scriptInfo.getString(BIZUNITID), i);
                        this.getModel().setValue(BIZAPPID, (Object)scriptInfo.getString(BIZAPPID), i);
                        this.getModel().setValue(MODIFIER, (Object)scriptInfo.getString(MODIFIER), i);
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                            Date date = dateFormat.parse(scriptInfo.getString(MODIFYDATE));
                            this.getModel().setValue(MODIFYDATE, (Object)date, i);
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private void refreshScriptInfo() {
        String bizUnitId = this.getPageCache().get(BIZUNITID);
        String scriptType = this.getPageCache().get(SCRIPTTYPE1);
        String sortRule = this.getPageCache().get("sortrule");
        String bizAppId = this.getPageCache().get(BIZAPPID);
        String bizUnitName = DevportalUtil.getBizUnitNameById(bizAppId, bizUnitId);
        QFilter qUnit = new QFilter(BIZUNITID, "=", (Object)bizUnitId);
        QFilter qType = new QFilter(CBOX_SCRIPT_TYPE, "=", (Object)scriptType);
        QFilter[] filters = !"all".equals(scriptType) ? new QFilter[]{qUnit, qType} : new QFilter[]{qUnit};
        JSONArray scriptInfos = new JSONArray();
        try (DataSet scriptSet = QueryServiceHelper.queryDataSet((String)IDE_PLUGINSCRIPT, (String)IDE_PLUGINSCRIPT, (String)"id,txt_scriptname,txt_scriptnumber,cbox_script_type,modifier,modifydate", (QFilter[])filters, (String)(sortRule + " asc"));
             DataSet userSet = QueryServiceHelper.queryDataSet((String)"bos_user", (String)"bos_user", (String)"id,name", null, null);
             DataSet result = scriptSet.join(userSet, JoinType.LEFT).on(MODIFIER, "id").select(new String[]{"id", "txt_scriptname", "txt_scriptnumber", CBOX_SCRIPT_TYPE, MODIFIER, MODIFYDATE}, new String[]{"name"}).finish();){
            for (Row row : result) {
                JSONObject scriptInfo = new JSONObject();
                scriptInfo.put("scriptid", row.get("id"));
                scriptInfo.put(SCRIPTNUMBER, row.get("txt_scriptnumber"));
                scriptInfo.put(SCRIPTNAME, row.get("txt_scriptname"));
                scriptInfo.put(SCRIPTTYPE1, row.get(CBOX_SCRIPT_TYPE));
                scriptInfo.put(BIZUNITID, (Object)bizUnitId);
                scriptInfo.put(BIZAPPID, (Object)bizAppId);
                scriptInfo.put(BIZUNITNAME, (Object)bizUnitName);
                scriptInfo.put(MODIFIER, row.get("name"));
                scriptInfo.put(MODIFYDATE, row.get(MODIFYDATE));
                scriptInfos.add((Object)scriptInfo);
            }
        }
        JSONObject data = new JSONObject();
        data.put("scriptitems", (Object)scriptInfos);
        ((IClientViewProxy)this.getView().getParentView().getService(IClientViewProxy.class)).addAction("INITSCRIPTITEMS", (Object)data);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (scriptInfos.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, scriptInfos.size());
            for (int i = 0; i < scriptInfos.size(); ++i) {
                JSONObject scriptInfo = scriptInfos.getJSONObject(i);
                this.getModel().setValue(SCRIPTNUMBER, (Object)scriptInfo.getString(SCRIPTNUMBER), i);
                this.getModel().setValue(SCRIPTNAME, (Object)scriptInfo.getString(SCRIPTNAME), i);
                this.getModel().setValue(SCRIPTTYPE1, (Object)scriptInfo.getString(SCRIPTTYPE1), i);
                this.getModel().setValue(BIZUNITNAME, (Object)scriptInfo.getString(BIZUNITNAME), i);
                this.getModel().setValue("scriptid", (Object)scriptInfo.getString("scriptid"), i);
                this.getModel().setValue(BIZUNITID, (Object)scriptInfo.getString(BIZUNITID), i);
                this.getModel().setValue(BIZAPPID, (Object)scriptInfo.getString(BIZAPPID), i);
                this.getModel().setValue(MODIFIER, (Object)scriptInfo.getString(MODIFIER), i);
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dateFormat.setTimeZone(KDDateUtils.getUserTimeZone());
                    Date date = dateFormat.parse(scriptInfo.getString(MODIFYDATE));
                    this.getModel().setValue(MODIFYDATE, (Object)date, i);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        String scriptId = this.getModel().getValue("scriptid", rowIndex).toString();
        String bizAppId = this.getModel().getValue(BIZAPPID, rowIndex).toString();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_kde");
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZCLOUDID, (Object)this.getPageCache().get(BIZCLOUDID));
        parameter.setCustomParam("bizscriptid", (Object)scriptId);
        this.getView().showForm(parameter);
    }

    private void markTargetPage(String bizCloudId, String bizAppId, String bizUnitId, String bizPageId) {
        JSONObject arg = new JSONObject();
        arg.put(BIZCLOUDID, (Object)bizCloudId);
        arg.put(BIZAPPID, (Object)bizAppId);
        arg.put(BIZUNITID, (Object)bizUnitId);
        arg.put(BIZPAGEID, (Object)bizPageId);
        DevportalUtil.locateResourcePos(arg, this.getView().getParentView(), "script");
        this.getView().sendFormAction(this.getView().getParentView());
    }
}

