/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ScriptMovingPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BIZUNIT = "bizunit";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZAPP = "bizapp";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BIZUNIT, "confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizUnitId = (String)parameter.getCustomParam(BIZUNITID);
        String bizAppId = (String)parameter.getCustomParam(BIZAPPID);
        this.getModel().setValue(BIZAPP, (Object)bizAppId);
        String unitName = DevportalUtil.getBizUnitNameById(bizAppId, bizUnitId);
        this.getModel().setValue(BIZUNIT, (Object)unitName);
        this.getPageCache().put(BIZUNITID, bizUnitId);
        this.getModel().setValue(BIZAPPID, (Object)bizAppId);
        this.getModel().setValue(BIZUNITID, (Object)bizUnitId);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        this.getModel().setValue("bizcloudId", (Object)appMeta.getBizCloudID());
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "bizunit": {
                this.selectUnit();
                break;
            }
            case "confirm": {
                this.movingScript();
                break;
            }
        }
    }

    private void selectUnit() {
        if (this.getModel().getValue(BIZAPP) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5e94\u7528\u3002", (String)"ScriptMovingPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(BIZAPP);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devportal_selectunit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizunitselectcloseaction"));
        JSONObject map = new JSONObject();
        map.put("appid", bizApp.get(0));
        map.put("runtime", (Object)Boolean.FALSE);
        parameter.setCustomParams((Map)map);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u529f\u80fd\u5206\u7ec4", (String)"ScriptMovingPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void movingScript() {
        if (this.getModel().getValue(BIZAPP) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptMovingPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue(BIZUNIT))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u529f\u80fd\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptMovingPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizcloudId = (String)this.getModel().getValue("bizcloudId");
        String bizAppId = (String)this.getModel().getValue(BIZAPPID);
        String bizUnitId = (String)this.getModel().getValue(BIZUNITID);
        String scriptId = (String)parameter.getCustomParam("scriptid");
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        DynamicObject scriptObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(BIZAPP);
        if (scriptObject != null) {
            scriptObject.set(BIZAPPID, bizApp.get(0));
            scriptObject.set(BIZUNITID, (Object)this.getPageCache().get(BIZUNITID));
            scriptObject.set("classname", (Object)this.getClassNameOfScript(scriptObject));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scriptObject});
            JSONObject returnData = new JSONObject();
            returnData.put("bizpageid", (Object)scriptId);
            returnData.put("bizcloudid", (Object)bizcloudId);
            returnData.put(BIZAPPID, (Object)bizAppId);
            returnData.put(BIZUNITID, (Object)bizUnitId);
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    private String getClassNameOfScript(DynamicObject scriptObject) {
        String bizAppId = scriptObject.getString(BIZAPPID);
        String bizUnitId = scriptObject.getString(BIZUNITID);
        String number = scriptObject.getString("txt_scriptnumber");
        return DevportalUtil.getClassNameByBizUnitId(bizAppId, bizUnitId, number);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "bizunitselectcloseaction".equals(e.getActionId())) {
            Map data = (Map)e.getReturnData();
            String bizUnitId = (String)data.get("nodeid");
            String bizUnitName = (String)data.get("nodename");
            String bizAppId = (String)data.get("appid");
            this.getModel().setValue(BIZUNIT, (Object)bizUnitName);
            this.getPageCache().put(BIZUNITID, bizUnitId);
            if (StringUtils.isNotBlank((CharSequence)bizAppId) && StringUtils.isNotBlank((CharSequence)bizUnitId)) {
                this.getModel().setValue(BIZUNITID, (Object)bizUnitId);
                this.getModel().setValue(BIZAPPID, (Object)bizAppId);
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                this.getModel().setValue("bizcloudid", (Object)appMeta.getBizCloudID());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (BIZAPP.equals(propertyName)) {
            this.getModel().setValue(BIZUNIT, (Object)" ");
            this.getPageCache().remove(BIZUNITID);
        }
    }
}

