/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.script.plugin.ScriptType;
import kd.bos.devportal.script.plugin.util.ScriptUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.utils.KDEncodeUtil;

public class ScriptNewPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(ScriptNewPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String KEY_INSERTFUN = "insertfun";
    private static final String KEY_BIZUNIT = "bizunit";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_BIZUNITID = "bizunitid";
    private static final String KEY_BIZAPP = "bizapp";
    private static final String INSERT_FUN = "afterBindData,afterCreateNewData,click,closedCallBack,confirmCallBack,itemClick,registerListener";
    private static final String PARAM_COUNTS = "1,1,1,1,1,1,1";
    private static final String KEY_PARAMCOUNTS = "paramcounts";
    private static final String DESCRIPTION = "description";
    private static final String RADIOFIELD3 = "radiofield3";
    private static final String RADIOFIELD4 = "radiofield4";
    private static final String RADIOFIELD5 = "radiofield5";
    private static final String RADIOFIELD6 = "radiofield6";
    private static final String RADIOFIELD7 = "radiofield7";
    private static final String RADIOFIELD8 = "radiofield8";
    private static final String RADIOFIELD9 = "radiofield9";
    private static final String RADIOFIELD10 = "radiofield10";
    private static final String SCRIPTTYPE = "scripttype";
    private static final String CUSTOMPRINTDATAENTITIES = "customPrintDataEntities";
    private static final String SCRIPTNUMBER = "scriptnumber";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String TXT_SCRIPTNAME = "txt_scriptname";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String DATEFM = "yyyy-MM-dd HH:mm:ss";
    private static final String CONTENT = "content";

    public void registerListener(EventObject e) {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BIZUNIT, KEY_INSERTFUN, "save"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String scene = (String)parameter.getCustomParam("scene");
        String type = (String)parameter.getCustomParam("type");
        String bizAppId = (String)parameter.getCustomParam(KEY_BIZAPPID);
        String nodeType = (String)parameter.getCustomParam("nodetype");
        if ("unit".equals(type)) {
            String bizUnitId = (String)parameter.getCustomParam(KEY_BIZUNITID);
            this.getModel().setValue(KEY_BIZAPP, (Object)bizAppId);
            String bizUnitName = DevportalUtil.getBizUnitNameById(bizAppId, bizUnitId);
            this.getModel().setValue(KEY_BIZUNIT, (Object)bizUnitName);
            this.getPageCache().put(KEY_BIZUNITID, bizUnitId);
            this.getModel().setValue(KEY_INSERTFUN, (Object)INSERT_FUN);
            this.getPageCache().put(KEY_INSERTFUN, INSERT_FUN);
            this.getPageCache().put(KEY_PARAMCOUNTS, PARAM_COUNTS);
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u662f\u9875\u9762\u6700\u9ad8\u8d85\u7c7b\uff0c\u8868\u5355\u63d2\u4ef6\u5305\u542b\u4e86\u57fa\u672c\u7684\u9875\u9762\u4ea4\u4e92\u5904\u7406\u903b\u8f91\u63d2\u5165\uff0c\u5176\u4ed6\u7684\u63d2\u4ef6\u5982\u5355\u636e\u63d2\u4ef6\u3001\u5217\u8868\u63d2\u4ef6\u3001\u79fb\u52a8\u7aef\u5355\u636e\u63d2\u4ef6\u7b49\u90fd\u662f\u8868\u5355\u63d2\u4ef6\u7684\u5b50\u7c7b\uff0c\u4e00\u822c\u60c5\u51b5\u4e0b\u8bf7\u4f7f\u7528\u5355\u636e\u63d2\u4ef6\u7b49\u5b50\u7c7b\uff0c\u5982\u679c\u4e0d\u662f\u5355\u636e\u7b49\u9875\u9762\uff0c\u53ef\u4ee5\u4f7f\u7528\u8868\u5355\u63d2\u4ef6", (String)"ScriptNewPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if ("app".equals(type)) {
            this.getModel().setValue(KEY_BIZAPP, (Object)bizAppId);
        }
        if ("page".equals(nodeType)) {
            String nodeId = (String)parameter.getCustomParam("nodeid");
            this.getView().setEnable(Boolean.FALSE, new String[]{RADIOFIELD4, RADIOFIELD5, RADIOFIELD6, RADIOFIELD7, RADIOFIELD8, RADIOFIELD9, RADIOFIELD10});
            DynamicObject formObj = BusinessDataServiceHelper.loadSingleFromCache((Object)nodeId, (String)"bos_formmeta", (String)"modeltype, basedatafield_id");
            String modelType = formObj.getString("modeltype");
            String entityId = formObj.getString("basedatafield_id");
            if (("BaseFormModel".equals(modelType) || "BillFormModel".equals(modelType)) && !nodeId.equals(entityId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{RADIOFIELD3});
            }
            if ("PrintModel".equals(modelType)) {
                this.getModel().setValue(SCRIPTTYPE, (Object)12);
                this.getView().setEnable(Boolean.TRUE, new String[]{RADIOFIELD10});
                this.getView().setEnable(Boolean.FALSE, new String[]{"radiofield", "radiofield1", "radiofield2", RADIOFIELD3, RADIOFIELD4, RADIOFIELD5, RADIOFIELD6, RADIOFIELD7, RADIOFIELD8, RADIOFIELD9});
                this.getModel().setValue(KEY_INSERTFUN, (Object)CUSTOMPRINTDATAENTITIES);
                this.getPageCache().put(KEY_INSERTFUN, CUSTOMPRINTDATAENTITIES);
                this.getPageCache().put(KEY_PARAMCOUNTS, "1");
                this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u8d1f\u8d23\u5bf9\u6253\u5370\u8fc7\u7a0b\u4e2d\u7684\u6570\u636e\u548c\u63a7\u4ef6\u8fdb\u884c\u5904\u7406\uff0c\u5982\u5bf9\u9ed8\u8ba4\u8bfb\u53d6\u7684\u6570\u636e\u8fdb\u884c\u4e8c\u6b21\u52a0\u5de5\u3001\u63d0\u4f9b\u5168\u65b0\u7684\u6570\u636e\u3001\u76f4\u63a5\u8bbe\u7f6e\u8f93\u51fa\u7ed3\u679c\u548c\u5bf9\u6a21\u677f\u5143\u7d20\u6309\u6761\u4ef6\u8fdb\u884c\u9690\u85cf\u7b49\u3002", (String)"ScriptNewPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                this.getModel().setValue(KEY_INSERTFUN, (Object)INSERT_FUN);
                this.getPageCache().put(KEY_INSERTFUN, INSERT_FUN);
                this.getPageCache().put(KEY_PARAMCOUNTS, PARAM_COUNTS);
                this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u662f\u9875\u9762\u6700\u9ad8\u8d85\u7c7b\uff0c\u8868\u5355\u63d2\u4ef6\u5305\u542b\u4e86\u57fa\u672c\u7684\u9875\u9762\u4ea4\u4e92\u5904\u7406\u903b\u8f91\u63d2\u5165\uff0c\u5176\u4ed6\u7684\u63d2\u4ef6\u5982\u5355\u636e\u63d2\u4ef6\u3001\u5217\u8868\u63d2\u4ef6\u3001\u79fb\u52a8\u7aef\u5355\u636e\u63d2\u4ef6\u7b49\u90fd\u662f\u8868\u5355\u63d2\u4ef6\u7684\u5b50\u7c7b\uff0c\u4e00\u822c\u60c5\u51b5\u4e0b\u8bf7\u4f7f\u7528\u5355\u636e\u63d2\u4ef6\u7b49\u5b50\u7c7b\uff0c\u5982\u679c\u4e0d\u662f\u5355\u636e\u7b49\u9875\u9762\uff0c\u53ef\u4ee5\u4f7f\u7528\u8868\u5355\u63d2\u4ef6", (String)"ScriptNewPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BIZUNIT});
        }
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
        }
        if ("scriptsaveas".equals(scene)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_INSERTFUN});
            String scriptType = (String)parameter.getCustomParam(SCRIPTTYPE);
            this.getModel().setValue(SCRIPTTYPE, (Object)scriptType);
            this.getView().setEnable(Boolean.FALSE, new String[]{"radiofield", "radiofield1", "radiofield2", RADIOFIELD3, RADIOFIELD4, RADIOFIELD5, RADIOFIELD6, RADIOFIELD7, RADIOFIELD8, RADIOFIELD9, RADIOFIELD10});
            String scriptNumber = (String)parameter.getCustomParam(SCRIPTNUMBER);
            scriptNumber = this.autoScriptNumber(scriptNumber);
            this.getModel().setValue(SCRIPTNUMBER, (Object)scriptNumber);
            this.updateDescription();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (SCRIPTTYPE.equals(propertyName)) {
            String i = e.getChangeSet()[0].getNewValue().toString();
            if (ScriptType.FormPlugin.getValue().equals(i) || ScriptType.BillPlugin.getValue().equals(i) || ScriptType.ListPlugin.getValue().equals(i) || ScriptType.MobBillPlugin.getValue().equals(i)) {
                this.getModel().setValue(KEY_INSERTFUN, (Object)INSERT_FUN);
                this.getPageCache().put(KEY_INSERTFUN, INSERT_FUN);
                this.getPageCache().put(KEY_PARAMCOUNTS, PARAM_COUNTS);
            } else if (ScriptType.OperationPlugin.getValue().equals(i)) {
                this.getModel().setValue(KEY_INSERTFUN, (Object)"afterExecuteOperationTransaction,onAddValidators");
                this.getPageCache().put(KEY_INSERTFUN, "afterExecuteOperationTransaction,onAddValidators");
                this.getPageCache().put(KEY_PARAMCOUNTS, "1,1");
            } else if (ScriptType.TestCasePlugin.getValue().equals(i)) {
                this.getModel().setValue(KEY_INSERTFUN, (Object)"initData");
                this.getPageCache().put(KEY_INSERTFUN, "initData");
                this.getPageCache().put(KEY_PARAMCOUNTS, "0");
            } else if (ScriptType.WorkflowPlugin.getValue().equals(i)) {
                this.getModel().setValue(KEY_INSERTFUN, (Object)"calcUserIds,formatFlowRecord,hasTrueCondition");
                this.getPageCache().put(KEY_INSERTFUN, "calcUserIds,formatFlowRecord,hasTrueCondition");
                this.getPageCache().put(KEY_PARAMCOUNTS, "1,1,1");
            } else if (ScriptType.BillWebApiPlugin.getValue().equals(i)) {
                this.getModel().setValue(KEY_INSERTFUN, (Object)"doAICommand,doCustomService");
                this.getPageCache().put(KEY_INSERTFUN, "doAICommand,doCustomService");
                this.getPageCache().put(KEY_PARAMCOUNTS, "1,1");
            } else if (ScriptType.PrintServicePlugin.getValue().equals(i)) {
                this.getModel().setValue(KEY_INSERTFUN, (Object)CUSTOMPRINTDATAENTITIES);
                this.getPageCache().put(KEY_INSERTFUN, CUSTOMPRINTDATAENTITIES);
                this.getPageCache().put(KEY_PARAMCOUNTS, "1");
            } else {
                this.getModel().setValue(KEY_INSERTFUN, (Object)"");
                this.getPageCache().put(KEY_INSERTFUN, "");
                this.getPageCache().put(KEY_PARAMCOUNTS, "");
            }
            this.updateDescription();
        } else if (KEY_BIZAPP.equals(propertyName)) {
            this.getModel().setValue(KEY_BIZUNIT, (Object)" ");
            this.getPageCache().remove(KEY_BIZUNITID);
        } else if (SCRIPTNUMBER.equals(propertyName)) {
            String scriptNumber = this.getModel().getValue(SCRIPTNUMBER).toString().toLowerCase();
            this.getModel().setValue(SCRIPTNUMBER, (Object)scriptNumber);
        }
    }

    private void updateDescription() {
        String value = this.getModel().getValue(SCRIPTTYPE).toString();
        if (ScriptType.FormPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u662f\u9875\u9762\u6700\u9ad8\u8d85\u7c7b\uff0c\u8868\u5355\u63d2\u4ef6\u5305\u542b\u4e86\u57fa\u672c\u7684\u9875\u9762\u4ea4\u4e92\u5904\u7406\u903b\u8f91\u63d2\u5165\uff0c\u5176\u4ed6\u7684\u63d2\u4ef6\u5982\u5355\u636e\u63d2\u4ef6\u3001\u5217\u8868\u63d2\u4ef6\u3001\u79fb\u52a8\u7aef\u5355\u636e\u63d2\u4ef6\u7b49\u90fd\u662f\u8868\u5355\u63d2\u4ef6\u7684\u5b50\u7c7b\uff0c\u4e00\u822c\u60c5\u51b5\u4e0b\u8bf7\u4f7f\u7528\u5355\u636e\u63d2\u4ef6\u7b49\u5b50\u7c7b\uff0c\u5982\u679c\u4e0d\u662f\u5355\u636e\u7b49\u9875\u9762\uff0c\u53ef\u4ee5\u4f7f\u7528\u8868\u5355\u63d2\u4ef6", (String)"ScriptNewPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.BillPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u8d1f\u8d23\u5904\u7406\u5355\u636e\u754c\u9762\u4ea4\u4e92\u903b\u8f91\u7684\u63d2\u4ef6\uff0c\u5982\u5355\u636e\u52a0\u8f7d\u903b\u8f91\u3001\u6839\u636e\u67d0\u4e9b\u5b57\u6bb5\u503c\u53d8\u5316\u6765\u63a7\u5236\u5176\u4ed6\u5b57\u6bb5\u503c\u7684\u590d\u6742\u903b\u8f91\u7b49\uff0c\u53ea\u80fd\u5728PC\u7aef\u5355\u636e\u8868\u5355\u6216\u5e03\u5c40\u7b49\u9875\u9762\u6ce8\u518c\u4f7f\u7528", (String)"ScriptNewPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.ListPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u8d1f\u8d23\u5904\u7406\u5217\u8868\u754c\u9762\u4ea4\u4e92\u903b\u8f91\u7684\u63d2\u4ef6\uff0c\u5982\u8fc7\u6ee4\u6761\u4ef6\u8bbe\u7f6e\u5904\u7406\u903b\u8f91\u3001\u5217\u8868\u6570\u636e\u52a0\u8f7d\u663e\u793a\u5904\u7406\u903b\u8f91\u7b49\uff0c\u53ea\u80fd\u5728PC\u7aef\u5217\u8868\u7c7b\u578b\u9875\u9762\u6ce8\u518c\u4f7f\u7528", (String)"ScriptNewPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.OperationPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u8d1f\u8d23\u64cd\u4f5c\u6267\u884c\u65f6\u4e1a\u52a1\u5904\u7406\u63d2\u4ef6\uff0c\u5982\u64cd\u4f5c\u524d\u7684\u590d\u6742\u6821\u9a8c\u3001\u64cd\u4f5c\u540e\u7684\u8bb0\u8d26\u903b\u8f91\u7b49\uff0c\u53ea\u80fd\u5728\u64cd\u4f5c\u8bbe\u7f6e\u5904\u6ce8\u518c\u4f7f\u7528", (String)"ScriptNewPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.TestCasePlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u5728\u5355\u5143\u6d4b\u8bd5\u7528\u4f8b\u4e2d\u6ce8\u518c\u4f7f\u7528\u7684\u63d2\u4ef6\uff0c\u5b9e\u73b0\u590d\u6742\u7684\u6d4b\u8bd5\u529f\u80fd", (String)"ScriptNewPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.WorkflowPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u5728\u5de5\u4f5c\u6d41\u6d41\u7a0b\u8bbe\u8ba1\u65f6\u6ce8\u518c\u4f7f\u7528\u7684\u63d2\u4ef6\uff0c\u53ef\u5b9e\u73b0\u590d\u6742\u7684\u53c2\u4e0e\u4eba\u8ba1\u7b97\u3001\u6d41\u5165\u6d41\u51fa\u67d0\u8282\u70b9\u65f6\u8fdb\u884c\u590d\u6742\u4e1a\u52a1\u5904\u7406\u7b49", (String)"ScriptNewPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.BillWebApiPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u4e8eOpen API\u670d\u52a1\u5b9e\u73b0\u7684\u63d2\u4ef6\uff0c\u53ea\u80fd\u5728\u5f00\u653e\u5e73\u53f0\u7684AI\u670d\u52a1\u3001\u81ea\u5b9a\u4e49API\u670d\u52a1\u4e2d\u6ce8\u518c\u4f7f\u7528", (String)"ScriptNewPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.MobBillPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5355\u636e\u9875\u9762\u4ea4\u4e92\u5904\u7406\u903b\u8f91\u63d2\u4ef6\uff0c\u7c7b\u4f3c\u4e8ePC\u7aef\u7684\u5355\u636e\u63d2\u4ef6\uff0c\u53ea\u80fd\u6ce8\u518c\u5728\u79fb\u52a8\u7aef\u5355\u636e\u9875\u9762\u6216\u5e03\u5c40\u6765\u4f7f\u7528", (String)"ScriptNewPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.BillRevertPlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u65f6\u4e1a\u52a1\u5904\u7406\u63d2\u4ef6\uff0c\u53ef\u63a7\u5236\u5355\u636e\u4e0b\u63a8\u8fc7\u7a0b\u3001\u8f6c\u6362\u540e\u76ee\u6807\u5355\u636e\u76f8\u5173\u4e1a\u52a1\u5904\u7406\u7b49\uff0c\u53ea\u80fd\u5728\u4e1a\u52a1\u6d41\u5355\u636e\u8f6c\u6362\u89c4\u5219\u8bbe\u7f6e\u4e2d\u6ce8\u518c\u4f7f\u7528", (String)"ScriptNewPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.BillRewritePlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u65f6\u4e1a\u52a1\u5904\u7406\u63d2\u4ef6\uff0c\u53ea\u80fd\u5728\u8bbe\u8ba1\u5668\u5355\u636e\u5173\u8054\u914d\u7f6e\u5c5e\u6027\u8bbe\u7f6e\u4e2d\u6ce8\u518c\u4f7f\u7528\u3002", (String)"ScriptNewPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (ScriptType.PrintServicePlugin.getValue().equals(value)) {
            this.getModel().setValue(DESCRIPTION, (Object)ResManager.loadKDString((String)"\u8d1f\u8d23\u5bf9\u6253\u5370\u8fc7\u7a0b\u4e2d\u7684\u6570\u636e\u548c\u63a7\u4ef6\u8fdb\u884c\u5904\u7406\uff0c\u5982\u5bf9\u9ed8\u8ba4\u8bfb\u53d6\u7684\u6570\u636e\u8fdb\u884c\u4e8c\u6b21\u52a0\u5de5\u3001\u63d0\u4f9b\u5168\u65b0\u7684\u6570\u636e\u3001\u76f4\u63a5\u8bbe\u7f6e\u8f93\u51fa\u7ed3\u679c\u548c\u5bf9\u6a21\u677f\u5143\u7d20\u6309\u6761\u4ef6\u8fdb\u884c\u9690\u85cf\u7b49\u3002", (String)"ScriptNewPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        switch (control.getKey()) {
            case "insertfun": {
                this.insertFunction();
                break;
            }
            case "save": {
                this.saveScript();
                break;
            }
        }
    }

    private void insertFunction() {
        if (this.getModel().getValue(SCRIPTTYPE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d2\u4ef6\u7c7b\u578b\u3002", (String)"ScriptNewPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String scriptType = this.getModel().getValue(SCRIPTTYPE).toString();
        String pluginClassFullName = ScriptUtil.getClassFullNameByIndex(Integer.parseInt(scriptType));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_insertmethod");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(KEY_INSERTFUN, this.getModel().getValue(KEY_INSERTFUN));
        parameter.setCustomParam("classfullname", (Object)pluginClassFullName);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "insertfuncloseaction"));
        this.getView().showForm(parameter);
    }

    private void saveScript() {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_BIZAPP);
        String bizAppId = bizApp.getString(0);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        if (this.checkValidation()) {
            String scriptName = this.getModel().getValue("scriptname").toString();
            String scriptNumber = this.getModel().getValue(SCRIPTNUMBER).toString().toLowerCase();
            String pluginDescription = this.getModel().getValue("plugindescription").toString().toLowerCase();
            String bizUnitId = this.getPageCache().get(KEY_BIZUNITID);
            String className = DevportalUtil.getClassNameByBizUnitId(bizAppId, bizUnitId, scriptNumber);
            String scriptType = this.getModel().getValue(SCRIPTTYPE).toString();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String scene = (String)parameter.getCustomParam("scene");
            if ("newscript".equals(scene)) {
                String content = this.initScriptContent();
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)IDE_PLUGINSCRIPT);
                String id = Uuid8.generateShortUuid();
                dynamicObject.set("id", (Object)id);
                dynamicObject.set("enginetype", (Object)"0");
                dynamicObject.set(TXT_SCRIPTNAME, (Object)scriptName);
                dynamicObject.set(TXT_SCRIPTNUMBER, (Object)scriptNumber);
                dynamicObject.set(DESCRIPTION, (Object)pluginDescription);
                dynamicObject.set("classname", (Object)className);
                dynamicObject.set("cbox_script_type", (Object)scriptType);
                dynamicObject.set(KEY_BIZUNITID, (Object)bizUnitId);
                dynamicObject.set(KEY_BIZAPPID, bizApp.get(0));
                dynamicObject.set("txt_scriptcontext_tag", (Object)content);
                dynamicObject.set("txt_scriptcontext", (Object)" ");
                dynamicObject.set("creater", (Object)Long.valueOf(RequestContext.get().getUserId()));
                dynamicObject.set("createdate", (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
                dynamicObject.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
                dynamicObject.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
                String isv = dynamicObject.getString("isv");
                if (StringUtils.isBlank((CharSequence)isv)) {
                    isv = ISVService.getISVInfo().getId();
                    dynamicObject.set("isv", (Object)isv);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ScriptNewPlugin_12", BOS_DEVPORTAL_PLUGIN);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u811a\u672c", "ScriptNewPlugin_13", BOS_DEVPORTAL_PLUGIN);
                AppUtils.addOpLog((String)IDE_PLUGINSCRIPT, (String)"save", (String)IDE_PLUGINSCRIPT, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                HashMap<String, String> returnData = new HashMap<String, String>();
                returnData.put(CONTENT, content);
                returnData.put(SCRIPTNUMBER, scriptNumber);
                returnData.put("id", id);
                returnData.put("bizAppId", bizAppId);
                returnData.put(KEY_BIZUNITID, bizUnitId);
                returnData.put(SCRIPTTYPE, scriptType);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else if ("scriptsaveas".equals(scene)) {
                String content = (String)parameter.getCustomParam(CONTENT);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)IDE_PLUGINSCRIPT);
                String id = Uuid8.generateShortUuid();
                dynamicObject.set("id", (Object)id);
                dynamicObject.set("enginetype", (Object)"0");
                dynamicObject.set(TXT_SCRIPTNAME, (Object)scriptName);
                dynamicObject.set(TXT_SCRIPTNUMBER, (Object)scriptNumber);
                dynamicObject.set("classname", (Object)className);
                dynamicObject.set("cbox_script_type", (Object)scriptType);
                dynamicObject.set(KEY_BIZUNITID, (Object)bizUnitId);
                dynamicObject.set(KEY_BIZAPPID, bizApp.get(0));
                dynamicObject.set("txt_scriptcontext_tag", (Object)content);
                dynamicObject.set("txt_scriptcontext", (Object)" ");
                dynamicObject.set("creater", (Object)Long.valueOf(RequestContext.get().getUserId()));
                dynamicObject.set("createdate", (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
                dynamicObject.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
                dynamicObject.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat(DATEFM).format(new Date())));
                String isv = dynamicObject.getString("isv");
                if (StringUtils.isBlank((CharSequence)isv)) {
                    isv = ISVService.getISVInfo().getId();
                    dynamicObject.set("isv", (Object)isv);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ScriptNewPlugin_12", BOS_DEVPORTAL_PLUGIN);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u811a\u672c\u53e6\u5b58\u4e3a", "ScriptNewPlugin_14", BOS_DEVPORTAL_PLUGIN);
                AppUtils.addOpLog((String)IDE_PLUGINSCRIPT, (String)"save", (String)IDE_PLUGINSCRIPT, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                HashMap<String, String> returnData = new HashMap<String, String>();
                String encodeType = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
                returnData.put(CONTENT, KDEncodeUtil.kdEncoding((String)encodeType, (String)content));
                returnData.put(SCRIPTNUMBER, scriptNumber);
                returnData.put("id", id);
                returnData.put(KEY_BIZUNITID, bizUnitId);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    private String initScriptContent() {
        StringBuilder title = this.initTitleContent();
        StringBuilder mainContent = this.initMainContent();
        return title.append((CharSequence)mainContent).toString();
    }

    private StringBuilder initTitleContent() {
        StringBuilder titileContent = new StringBuilder();
        titileContent.append("/**\n* @author ");
        titileContent.append(RequestContext.get().getUserName());
        titileContent.append("\n* @date ");
        titileContent.append(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        titileContent.append("\n*/\n");
        return titileContent;
    }

    private StringBuilder initMainContent() {
        String scriptType = this.getModel().getValue(SCRIPTTYPE).toString();
        String pluginJSName = "";
        try {
            Class<?> pluginClass = Class.forName(ScriptUtil.getClassFullNameByIndex(Integer.parseInt(scriptType)));
            pluginJSName = pluginClass.getAnnotation(KSObject.class).name();
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        StringBuilder mainContent = new StringBuilder();
        mainContent.append("var plugin = new ");
        mainContent.append(pluginJSName);
        mainContent.append("({\n");
        mainContent.append((CharSequence)this.initFunctionContent());
        mainContent.append("});");
        return mainContent;
    }

    private StringBuilder initFunctionContent() {
        String insertMethods = this.getModel().getValue(KEY_INSERTFUN).toString();
        StringBuilder functionContent = new StringBuilder();
        if ("".equals(insertMethods)) {
            functionContent.append('\n');
            return functionContent;
        }
        functionContent.append("");
        List<String> methods = Arrays.asList(insertMethods.split(","));
        List<String> paramCounts = Arrays.asList(this.getPageCache().get(KEY_PARAMCOUNTS).split(","));
        Iterator<String> iterator = methods.iterator();
        Iterator<String> paramIterator = paramCounts.iterator();
        while (iterator.hasNext()) {
            if (!"".equals(functionContent.toString())) {
                functionContent.append(",\n");
            }
            String methodName = iterator.next();
            int paramCount = Integer.parseInt(paramIterator.next());
            StringBuilder function = new StringBuilder();
            function.append('\t');
            function.append(methodName);
            function.append(" : function(");
            function.append((CharSequence)this.buildParam(paramCount));
            function.append("){\n\t\n\t}");
            functionContent.append((CharSequence)function);
        }
        functionContent.append('\n');
        return functionContent;
    }

    private StringBuilder buildParam(int paramCount) {
        StringBuilder paramBuilder = new StringBuilder();
        if (paramCount == 0) {
            paramBuilder.append("");
            return paramBuilder;
        }
        if (paramCount == 1) {
            paramBuilder.append('e');
            return paramBuilder;
        }
        paramBuilder.append("");
        for (int i = 0; i < paramCount; ++i) {
            if (i == 0) {
                paramBuilder.append("e1");
                continue;
            }
            paramBuilder.append(",e");
            paramBuilder.append(i + 1);
        }
        return paramBuilder;
    }

    private boolean checkValidation() {
        String scriptName = this.getModel().getValue("scriptname").toString();
        String scriptNumber = this.getModel().getValue(SCRIPTNUMBER).toString();
        if (StringUtils.isBlank((CharSequence)scriptName) || StringUtils.isBlank((CharSequence)scriptNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u811a\u672c\u540d\u79f0\u548c\u7f16\u7801\u3002", (String)"ScriptNewPlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue(SCRIPTTYPE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptNewPlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue(KEY_BIZAPP) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptNewPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String bizUnit = this.getModel().getValue(KEY_BIZUNIT).toString();
        if (StringUtils.isBlank((CharSequence)bizUnit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u529f\u80fd\u5206\u7ec4\u3002", (String)"ScriptNewPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String regex = "[a-z0-9A-Z_]+";
        if (!Pattern.matches(regex, scriptNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u5fc5\u987b\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"ScriptNewPlugin_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        QFilter qNumber = new QFilter(TXT_SCRIPTNUMBER, "=", (Object)scriptNumber.toLowerCase());
        QFilter qName = new QFilter(TXT_SCRIPTNAME, "=", (Object)scriptName);
        QFilter[] filters = new QFilter[]{qNumber};
        if (QueryServiceHelper.exists((String)IDE_PLUGINSCRIPT, (QFilter[])filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ScriptNewPlugin_20", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        filters = new QFilter[]{qName};
        if (QueryServiceHelper.exists((String)IDE_PLUGINSCRIPT, (QFilter[])filters)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"ScriptNewPlugin_21", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "insertfuncloseaction".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            String selectMethod = returnData.get("methodname").toString();
            String paramCount = returnData.get("paramcount").toString();
            this.getModel().setValue(KEY_INSERTFUN, (Object)selectMethod);
            this.getPageCache().put(KEY_PARAMCOUNTS, paramCount);
        }
    }

    private String autoScriptNumber(String scriptNumber) {
        int i = 1;
        String number = scriptNumber + i;
        while (this.checkNumber(number).booleanValue()) {
            number = scriptNumber + ++i;
        }
        return number;
    }

    private Boolean checkNumber(String number) {
        QFilter qNumber = new QFilter(TXT_SCRIPTNUMBER, "=", (Object)number.toLowerCase());
        QFilter[] filters = new QFilter[]{qNumber};
        return QueryServiceHelper.exists((String)IDE_PLUGINSCRIPT, (QFilter[])filters);
    }
}

