/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ScriptRenamePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String FORMID = "number";
    private static final String SCRIPTSAMPLE = "scriptname";
    private static final String SCRIPTSAMPLEID = "description";
    private static final String SCRIPTNUMBER = "scriptid";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String BIZUNITID = "bizunitid";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        model.setValue(FORMID, parameter.getCustomParam(FORMID));
        model.setValue(SCRIPTSAMPLE, parameter.getCustomParam("name"));
        Object description = parameter.getCustomParam(SCRIPTSAMPLEID);
        if (description != null) {
            model.setValue(SCRIPTSAMPLEID, parameter.getCustomParam(SCRIPTSAMPLEID));
        } else {
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)parameter.getCustomParam(SCRIPTNUMBER), (String)IDE_PLUGINSCRIPT);
            model.setValue(SCRIPTSAMPLEID, scriptInfo.get(SCRIPTSAMPLEID));
        }
        this.getPageCache().put(SCRIPTNUMBER, (String)parameter.getCustomParam(SCRIPTNUMBER));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "confirm": {
                this.renameScript();
                break;
            }
        }
    }

    private void renameScript() {
        String scriptId = this.getPageCache().get(SCRIPTNUMBER);
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT);
        if (scriptInfo != null) {
            String bizAppId = scriptInfo.getString("bizappid");
            if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
                this.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
                return;
            }
            if (this.checkValidation()) {
                String number = this.getModel().getValue(FORMID).toString().toLowerCase();
                String name = this.getModel().getValue(SCRIPTSAMPLE).toString();
                String description = this.getModel().getValue(SCRIPTSAMPLEID).toString();
                if (scriptInfo != null) {
                    scriptInfo.set("txt_scriptnumber", (Object)number);
                    scriptInfo.set("txt_scriptname", (Object)name);
                    scriptInfo.set(SCRIPTSAMPLEID, (Object)description);
                    scriptInfo.set("classname", (Object)this.getClassNameOfScript(scriptInfo, number));
                    scriptInfo.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    scriptInfo.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
                    Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scriptInfo});
                    String id = ((DynamicObject)save[0]).getString("id");
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "ScriptRenamePlugin_0", BOS_DEVPORTAL_PLUGIN);
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", "ScriptRenamePlugin_1", BOS_DEVPORTAL_PLUGIN);
                    AppUtils.addOpLog((String)IDE_PLUGINSCRIPT, (String)"save", (String)IDE_PLUGINSCRIPT, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                    MetaCacheUtils.removeDistributeCache((String[])new String[]{number});
                    HashMap<String, String> returnData = new HashMap<String, String>();
                    returnData.put("content", scriptInfo.getString("txt_scriptcontext_tag"));
                    returnData.put("scriptnumber", number);
                    returnData.put("id", scriptInfo.getString("id"));
                    returnData.put(BIZUNITID, scriptInfo.getString(BIZUNITID));
                    this.getView().returnDataToParent(returnData);
                    this.getView().close();
                }
            }
        }
    }

    private String getClassNameOfScript(DynamicObject scriptInfo, String number) {
        String bizAppId = scriptInfo.getString("bizappid");
        String bizUnitId = scriptInfo.getString(BIZUNITID);
        return DevportalUtil.getClassNameByBizUnitId(bizAppId, bizUnitId, number);
    }

    private boolean checkValidation() {
        IDataModel model = this.getModel();
        String scriptNumber = model.getValue(FORMID).toString();
        if (StringUtils.isBlank((CharSequence)scriptNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptRenamePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String scriptName = model.getValue(SCRIPTSAMPLE).toString();
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScriptRenamePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String regex = "[a-z0-9A-Z_]+";
        if (!Pattern.matches(regex, scriptNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u5fc5\u987b\u7531\u4ee5\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"ScriptRenamePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        QFilter qId = new QFilter("id", "!=", (Object)this.getPageCache().get(SCRIPTNUMBER));
        QFilter qNumber = new QFilter("txt_scriptnumber", "=", (Object)scriptNumber.toLowerCase());
        if (QueryServiceHelper.exists((String)IDE_PLUGINSCRIPT, (QFilter[])new QFilter[]{qNumber, qId})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ScriptRenamePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        QFilter qName = new QFilter("txt_scriptname", "=", (Object)scriptName);
        if (QueryServiceHelper.exists((String)IDE_PLUGINSCRIPT, (QFilter[])new QFilter[]{qId, qName})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u3002", (String)"ScriptRenamePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

