/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.DynamicScriptPlugin;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BizCustomList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizScriptServiceHelper;
import kd.bos.utils.KDEncodeUtil;

public class ScriptSampleDetailPlugin
extends AbstractFormPlugin
implements ItemClickListener,
IConfirmCallBack {
    private static final String FORMID = "formid";
    private static final String SCRIPTSAMPLE = "scriptsample";
    private static final String SCRIPTSAMPLEID = "scriptsampleid";
    private static final String SCRIPTNUMBER = "scriptnumber";
    private static final String FORM = "form";
    private static final String LIST = "list";
    private static final String BILL = "bill";

    public void registerListener(EventObject e) {
        BizCustomList appList = (BizCustomList)this.getView().getControl("bizcustomlistap");
        appList.addCustomListListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String formId = (String)param.getCustomParam(FORMID);
        if (formId == null) {
            return;
        }
        String caption = (String)param.getCustomParam("caption");
        Label label = (Label)this.getControl("caption");
        label.setText(caption);
        String type = (String)param.getCustomParam("type");
        if (FORM.equals(type)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(SCRIPTSAMPLE);
            parameter.setCustomParam(FORMID, (Object)formId);
            String scriptSampleId = UUID.randomUUID().toString();
            parameter.setPageId(scriptSampleId);
            this.getPageCache().put(SCRIPTSAMPLEID, scriptSampleId);
            this.getView().showForm(parameter);
        } else if (LIST.equals(type)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(formId);
            parameter.setFormId("bos_list");
            parameter.setCaption(caption);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(SCRIPTSAMPLE);
            parameter.setCustomParam(FORMID, (Object)formId);
            String scriptSampleId = UUID.randomUUID().toString();
            parameter.setPageId(scriptSampleId);
            this.getPageCache().put(SCRIPTSAMPLEID, scriptSampleId);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (BILL.equals(type)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(SCRIPTSAMPLE);
            parameter.setCustomParam(FORMID, (Object)formId);
            String scriptSampleId = UUID.randomUUID().toString();
            parameter.setPageId(scriptSampleId);
            this.getPageCache().put(SCRIPTSAMPLEID, scriptSampleId);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void itemClick(ItemClickEvent e) {
        JSONObject arg;
        String key = e.getOperationKey();
        JSONObject jSONObject = arg = e.getItemKey() == null ? null : JSONObject.parseObject((String)e.getItemKey());
        if (StringUtils.isNotBlank((CharSequence)key) && arg != null) {
            String argContent = arg.getString("scriptcontent");
            if (StringUtils.isNotBlank((CharSequence)argContent)) {
                arg.put("scriptcontent", (Object)KDEncodeUtil.kdDecoding((String)argContent));
            }
            switch (key) {
                case "initscriptsample": {
                    this.initsamplecode();
                    break;
                }
                case "runscriptsample": {
                    this.runScriptSample(arg);
                    break;
                }
            }
        }
    }

    private void initsamplecode() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"ScriptSampleDetailPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAMPLECODE", (Object)"");
            return;
        }
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formConfig = metaService.loadFormConfig(formId);
        Map formMeta = (Map)SerializationUtils.fromJsonString((String)formConfig, Map.class);
        List plugins = (List)formMeta.get("Plugins");
        if (plugins != null) {
            for (Map plugin : plugins) {
                if (plugin.get("Type") == null || 1 != (Integer)plugin.get("Type")) continue;
                String className = (String)plugin.get("ClassName");
                String scriptNumber = BizScriptServiceHelper.getScriptNumberByClassName((String)className);
                QFilter[] filters = new QFilter[]{new QFilter("txt_scriptnumber", "=", (Object)scriptNumber)};
                DynamicObject script = BusinessDataServiceHelper.loadSingle((String)"ide_pluginscript", (String)"id,txt_scriptnumber,txt_scriptname,txt_scriptcontext_tag", (QFilter[])filters);
                JSONObject map = new JSONObject();
                map.put("scriptid", (Object)script.getString("id"));
                map.put(SCRIPTNUMBER, (Object)script.getString("txt_scriptnumber"));
                map.put("scriptname", (Object)script.getString("txt_scriptname"));
                map.put("scriptcontent", (Object)KDEncodeUtil.kdEncoding((String)this.getView().getFormShowParameter().getFormConfig().getKdEncoding(), (String)script.getString("txt_scriptcontext_tag")));
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(SCRIPTSAMPLE, (Object)map);
            }
        }
    }

    private void runScriptSample(JSONObject arg) {
        String scriptContent = arg.getString("scriptcontent");
        String scriptNumber = arg.getString(SCRIPTNUMBER);
        this.getPageCache().put(SCRIPTNUMBER, scriptNumber);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        if (this.getPageCache().get(SCRIPTSAMPLEID) != null) {
            String scriptSampleId = this.getPageCache().get(SCRIPTSAMPLEID);
            this.getPageCache().remove(SCRIPTSAMPLEID);
            IFormView view = this.getView().getView(scriptSampleId);
            if (view != null) {
                view.close();
                this.getView().sendFormAction(view);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("formId", formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(SCRIPTSAMPLE);
        parameter.setCustomParam(FORMID, (Object)formId);
        String scriptSampleId = UUID.randomUUID().toString();
        parameter.setPageId(scriptSampleId);
        this.getPageCache().put(SCRIPTSAMPLEID, scriptSampleId);
        List plugins = parameter.getFormConfig().getPlugins();
        for (int i = 0; i < plugins.size(); ++i) {
            Plugin plugin = (Plugin)plugins.get(i);
            String className = plugin.getClassName();
            if (1 != plugin.getType() || !scriptNumber.equals(BizScriptServiceHelper.getScriptNumberByClassName((String)className))) continue;
            DynamicScriptPlugin newPlugin = new DynamicScriptPlugin();
            newPlugin.setClassName(plugin.getClassName());
            newPlugin.setScriptNumber(plugin.getClassName());
            newPlugin.setType(plugin.getType());
            newPlugin.setEnabled(plugin.isEnabled());
            newPlugin.setScript(scriptContent);
            plugins.set(i, newPlugin);
        }
        this.getView().showForm(parameter);
    }
}

