/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.utils.KDEncodeUtil;

public class ScriptSearchPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_SEARCHTYPE = "searchtype";
    private static final String KEY_SEARCHSCRIPT = "searchscript";
    private static final String KEY_SEARCHINSCRIPT = "searchinscript";
    private static final String KEY_BIZAPPID = "bizappid";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_PARENTUNITID = "parentunitid";
    private static final String KEY_CHILDREN = "children";
    private static final String KEY_BIZUNITID = "bizunitid";
    private static final String KEY_TXT_SCRIPTCONTEXT_TAG = "txt_scriptcontext_tag";
    private static final String KEY_TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String KEY_CONTEXT = "context";
    private static final String KEY_UNITID = "unitid";

    public void registerListener(EventObject e) {
        super.initialize();
        this.addClickListeners(new String[]{"confirm", "confirm1"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String searchType = (String)parameter.getCustomParam(KEY_SEARCHTYPE);
        if (KEY_SEARCHSCRIPT.equals(searchType)) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(KEY_SEARCHSCRIPT);
        } else if (KEY_SEARCHINSCRIPT.equals(searchType)) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab(KEY_SEARCHINSCRIPT);
        }
    }

    public void click(EventObject e) {
        String key;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam(KEY_BIZAPPID);
        String bizAppNumber = (String)parameter.getCustomParam("bizappnumber");
        QFilter qApp = new QFilter(KEY_NUMBER, "=", (Object)bizAppNumber);
        DynamicObject app = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"name", (QFilter[])new QFilter[]{qApp});
        String appPath = app.getString("name");
        switch (key = ((Control)e.getSource()).getKey()) {
            case "confirm": {
                this.searchScript(bizAppId, appPath);
                break;
            }
            case "confirm1": {
                this.searchInScript(bizAppId, appPath);
                break;
            }
        }
    }

    private JSONArray getUnitsByAppId(JSONArray bizAppIds, String bizAppId) {
        int i;
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId, (boolean)false);
        JSONArray unitArray = new JSONArray();
        JSONArray bizChildUnitObjects = new JSONArray();
        List appFunctionPackets = appMetadata.getAppFunctionPackets();
        for (i = 0; i < appFunctionPackets.size(); ++i) {
            AppFunctionPacketElement appFunctionPacketElement = (AppFunctionPacketElement)appFunctionPackets.get(i);
            JSONObject unitInfo = new JSONObject();
            String bizUnitId = appFunctionPacketElement.getId();
            unitInfo.put("id", (Object)bizUnitId);
            unitInfo.put("name", (Object)appFunctionPacketElement.getName().getLocaleValue());
            unitInfo.put(KEY_NUMBER, (Object)appFunctionPacketElement.getNumber().toLowerCase());
            String parentUnitId = appFunctionPacketElement.getParentId();
            if (StringUtils.isNotBlank((CharSequence)parentUnitId)) {
                unitInfo.put(KEY_PARENTUNITID, (Object)parentUnitId);
                bizChildUnitObjects.add((Object)unitInfo);
                continue;
            }
            unitInfo.put(KEY_CHILDREN, (Object)new JSONArray());
            unitArray.add((Object)unitInfo);
        }
        block1: for (i = 0; i < bizChildUnitObjects.size(); ++i) {
            String parentUnitId = bizChildUnitObjects.getJSONObject(i).getString(KEY_PARENTUNITID);
            for (int j = 0; j < unitArray.size(); ++j) {
                String unitId = unitArray.getJSONObject(j).getString("id");
                if (unitId == null || !unitId.equals(parentUnitId)) continue;
                unitArray.getJSONObject(j).getJSONArray(KEY_CHILDREN).add((Object)bizChildUnitObjects.getJSONObject(i));
                continue block1;
            }
        }
        return unitArray;
    }

    private JSONArray getContentInfos(JSONArray bizAppIds, Set<String> bizUnitIds, String text) {
        QFilter qAppId = new QFilter(KEY_BIZAPPID, "in", (Object)bizAppIds.toArray());
        QFilter qUnitId = new QFilter(KEY_BIZUNITID, "in", (Object)bizUnitIds.toArray());
        QFilter qContext = new QFilter(KEY_TXT_SCRIPTCONTEXT_TAG, "like", (Object)("%" + text + "%"));
        QFilter[] filters = new QFilter[]{qAppId, qUnitId, qContext};
        String fields = "id, txt_scriptname, txt_scriptnumber, txt_scriptcontext_tag, bizunitid";
        Map scripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)fields, (QFilter[])filters);
        JSONArray scriptArray = new JSONArray();
        for (DynamicObject script : scripts.values()) {
            JSONObject scriptInfo = new JSONObject();
            scriptInfo.put("id", (Object)script.getString("id"));
            scriptInfo.put("name", (Object)script.getString("txt_scriptname"));
            scriptInfo.put(KEY_NUMBER, (Object)script.getString(KEY_TXT_SCRIPTNUMBER));
            scriptInfo.put(KEY_CONTEXT, (Object)script.getString(KEY_TXT_SCRIPTCONTEXT_TAG));
            scriptInfo.put(KEY_UNITID, (Object)script.getString(KEY_BIZUNITID));
            scriptArray.add((Object)scriptInfo);
        }
        return scriptArray;
    }

    private JSONArray getScriptInfos(JSONArray bizAppIds, Set<String> bizUnitIds, String text) {
        QFilter qAppId = new QFilter(KEY_BIZAPPID, "in", (Object)bizAppIds.toArray());
        QFilter qUnitId = new QFilter(KEY_BIZUNITID, "in", (Object)bizUnitIds.toArray());
        QFilter[] filters = new QFilter[]{qAppId, qUnitId};
        String fields = "id, txt_scriptname, txt_scriptnumber, txt_scriptcontext_tag, bizunitid,classname";
        Map scripts = BusinessDataServiceHelper.loadFromCache((String)"ide_pluginscript", (String)fields, (QFilter[])filters);
        JSONArray scriptArray = new JSONArray();
        for (DynamicObject script : scripts.values()) {
            String number = script.getString(KEY_TXT_SCRIPTNUMBER) + ".ks";
            if (!number.toLowerCase().contains(text.toLowerCase())) continue;
            JSONObject scriptInfo = new JSONObject();
            scriptInfo.put("id", (Object)script.getString("id"));
            scriptInfo.put("name", (Object)script.getString("txt_scriptname"));
            scriptInfo.put(KEY_NUMBER, (Object)script.getString(KEY_TXT_SCRIPTNUMBER));
            scriptInfo.put(KEY_CONTEXT, (Object)script.getString(KEY_TXT_SCRIPTCONTEXT_TAG));
            scriptInfo.put(KEY_UNITID, (Object)script.getString(KEY_BIZUNITID));
            scriptInfo.put("classname", (Object)script.getString("classname"));
            scriptArray.add((Object)scriptInfo);
        }
        return scriptArray;
    }

    private JSONArray getPageInfos(JSONArray scriptIds, JSONArray bizAppIds) {
        JSONArray pageArray = new JSONArray();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devp_pagerelscript", (String)"scriptid,pageid,enable", (QFilter[])new QFilter[]{new QFilter("scriptid", "in", (Object)scriptIds)});
        if (dynamicObjects.isEmpty()) {
            return pageArray;
        }
        HashMap<String, HashSet<String>> pageRefScripts = new HashMap<String, HashSet<String>>(16);
        JSONArray formIds = new JSONArray();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String pageId = dynamicObject.getString("pageid");
            String scriptId = dynamicObject.getString("scriptid");
            HashSet<String> scritpSet = (HashSet<String>)pageRefScripts.get(pageId);
            if (scritpSet == null) {
                scritpSet = new HashSet<String>();
                scritpSet.add(scriptId);
                pageRefScripts.put(pageId, scritpSet);
            } else {
                scritpSet.add(scriptId);
                pageRefScripts.put(pageId, scritpSet);
            }
            if (formIds.contains((Object)pageId)) continue;
            formIds.add((Object)pageId);
        }
        String formMetaFields = "id,number,name";
        QFilter qFilter = new QFilter("id", "in", (Object)formIds);
        Map pages = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)formMetaFields, (QFilter[])new QFilter[]{qFilter, new QFilter(KEY_BIZAPPID, "in", (Object)bizAppIds.toArray())});
        for (DynamicObject page : pages.values()) {
            JSONObject pageInfo = new JSONObject();
            pageInfo.put("id", (Object)page.getString("id"));
            pageInfo.put("name", (Object)page.getString("name"));
            pageInfo.put("data", pageRefScripts.get(page.getString("id")));
            pageArray.add((Object)pageInfo);
        }
        return pageArray;
    }

    private JSONArray getScriptsWithoutLine(JSONArray scriptInfos, JSONArray pageInfos, String appPath, Map<String, String> unitPaths) {
        JSONArray scriptArray = new JSONArray();
        JSONArray extraScripts = new JSONArray();
        for (int i = 0; i < scriptInfos.size(); ++i) {
            JSONObject scriptInfo = (JSONObject)scriptInfos.get(i);
            String unitPath = unitPaths.get(scriptInfo.getString(KEY_UNITID));
            int flag = 0;
            for (int j = 0; j < pageInfos.size(); ++j) {
                JSONObject pageInfo = (JSONObject)pageInfos.get(j);
                if (pageInfo.getString("data") == null || !pageInfo.getString("data").contains(scriptInfo.getString("id"))) continue;
                String pagePath = pageInfo.getString("name");
                if (flag == 0) {
                    scriptInfo.put("path", (Object)(appPath + "/" + unitPath + "/" + pagePath));
                    scriptArray.add((Object)scriptInfo);
                } else {
                    JSONObject script = new JSONObject();
                    script.put("id", (Object)scriptInfo.getString("id"));
                    script.put("name", (Object)scriptInfo.getString("name"));
                    script.put(KEY_NUMBER, (Object)scriptInfo.getString(KEY_NUMBER));
                    script.put(KEY_CONTEXT, (Object)scriptInfo.getString(KEY_CONTEXT));
                    script.put("path", (Object)(appPath + "/" + unitPath + "/" + pagePath));
                    extraScripts.add((Object)script);
                }
                ++flag;
            }
            if (flag != 0) continue;
            scriptInfo.put("path", (Object)(appPath + "/" + unitPath));
            scriptArray.add((Object)scriptInfo);
        }
        if (!extraScripts.isEmpty()) {
            scriptArray.addAll((Collection)extraScripts);
        }
        return scriptArray;
    }

    private JSONArray getScriptsWithLine(JSONArray scriptInfos, String text) {
        JSONArray scriptArray = new JSONArray();
        for (int i = 0; i < scriptInfos.size(); ++i) {
            JSONObject scriptInfo = (JSONObject)scriptInfos.get(i);
            String[] contexts = scriptInfo.getString(KEY_CONTEXT).split("\n");
            int line = 1;
            for (String context : contexts) {
                if (context.toLowerCase().contains(text.toLowerCase())) {
                    JSONObject script = new JSONObject();
                    script.put("id", (Object)scriptInfo.getString("id"));
                    script.put("name", (Object)scriptInfo.getString("name"));
                    script.put(KEY_NUMBER, (Object)scriptInfo.getString(KEY_NUMBER));
                    script.put(KEY_CONTEXT, (Object)scriptInfo.getString(KEY_CONTEXT));
                    script.put("path", (Object)scriptInfo.getString("path"));
                    script.put("line", (Object)line);
                    scriptArray.add((Object)script);
                }
                ++line;
            }
        }
        return scriptArray;
    }

    private JSONArray getContentResource(JSONArray oriUnits, JSONArray units, JSONArray appIds, String text, Map<String, String> unitPaths, String appPath) {
        JSONArray childrenUnits = new JSONArray();
        oriUnits.addAll((Collection)units);
        HashSet<String> unitIds = new HashSet<String>(units.size());
        for (int i = 0; i < units.size(); ++i) {
            JSONArray childrenArray;
            JSONObject unit = units.getJSONObject(i);
            String unitId = unit.getString("id");
            unitIds.add(unitId);
            if (unit.containsKey((Object)KEY_PARENTUNITID)) {
                unitPaths.put(unit.getString("id"), unitPaths.get(unit.getString(KEY_PARENTUNITID)) + "/" + unit.getString("name"));
            } else {
                unitPaths.put(unit.getString("id"), unit.getString("name"));
            }
            if (!unit.containsKey((Object)KEY_CHILDREN) || (childrenArray = unit.getJSONArray(KEY_CHILDREN)).isEmpty()) continue;
            childrenUnits.addAll((Collection)childrenArray);
        }
        JSONArray scriptInfos = this.getContentInfos(appIds, unitIds, text);
        JSONArray pageInfos = new JSONArray();
        if (scriptInfos.size() > 0) {
            JSONArray scriptIds = new JSONArray();
            for (int i = 0; i < scriptInfos.size(); ++i) {
                JSONObject scriptInfo = (JSONObject)scriptInfos.get(i);
                scriptIds.add((Object)scriptInfo.getString("id"));
            }
            pageInfos = this.getPageInfos(scriptIds, appIds);
        }
        JSONArray originalScripts = this.getScriptsWithoutLine(scriptInfos, pageInfos, appPath, unitPaths);
        JSONArray returnScripts = this.getScriptsWithLine(originalScripts, text);
        if (!childrenUnits.isEmpty()) {
            JSONArray childrenScriptArray = this.getContentResource(oriUnits, childrenUnits, appIds, text, unitPaths, appPath);
            returnScripts.addAll((Collection)childrenScriptArray);
        }
        return returnScripts;
    }

    private JSONArray getScriptResource(JSONArray oriUnits, JSONArray units, JSONArray appIds, String text, Map<String, String> unitPaths, String appPath) {
        JSONObject scriptInfo;
        int i;
        JSONArray childrenUnits = new JSONArray();
        oriUnits.addAll((Collection)units);
        HashSet<String> unitIds = new HashSet<String>(units.size());
        for (int i2 = 0; i2 < units.size(); ++i2) {
            JSONArray childrenArray;
            JSONObject unit = units.getJSONObject(i2);
            String unitId = unit.getString("id");
            unitIds.add(unitId);
            if (unit.containsKey((Object)KEY_PARENTUNITID)) {
                unitPaths.put(unit.getString("id"), unitPaths.get(unit.getString(KEY_PARENTUNITID)) + "/" + unit.getString("name"));
            } else {
                unitPaths.put(unit.getString("id"), unit.getString("name"));
            }
            if (!unit.containsKey((Object)KEY_CHILDREN) || (childrenArray = unit.getJSONArray(KEY_CHILDREN)).isEmpty()) continue;
            childrenUnits.addAll((Collection)childrenArray);
        }
        JSONArray scriptArray = new JSONArray();
        JSONArray scriptInfos = this.getScriptInfos(appIds, unitIds, text);
        JSONArray pageInfos = new JSONArray();
        if (scriptInfos.size() > 0) {
            JSONArray scriptIds = new JSONArray();
            for (i = 0; i < scriptInfos.size(); ++i) {
                scriptInfo = (JSONObject)scriptInfos.get(i);
                scriptIds.add((Object)scriptInfo.getString("id"));
            }
            pageInfos = this.getPageInfos(scriptIds, appIds);
        }
        JSONArray extraScripts = new JSONArray();
        for (i = 0; i < scriptInfos.size(); ++i) {
            scriptInfo = (JSONObject)scriptInfos.get(i);
            String unitPath = unitPaths.get(scriptInfo.getString(KEY_UNITID));
            int flag = 0;
            for (int j = 0; j < pageInfos.size(); ++j) {
                JSONObject pageInfo = (JSONObject)pageInfos.get(j);
                if (!pageInfo.getString("data").contains(scriptInfo.getString("id"))) continue;
                String pagePath = pageInfo.getString("name");
                if (flag == 0) {
                    scriptInfo.put("path", (Object)(appPath + "/" + unitPath + "/" + pagePath));
                } else {
                    JSONObject script = new JSONObject();
                    script.put("id", (Object)scriptInfo.getString("id"));
                    script.put("name", (Object)scriptInfo.getString("name"));
                    script.put(KEY_NUMBER, (Object)scriptInfo.getString(KEY_NUMBER));
                    script.put(KEY_CONTEXT, (Object)scriptInfo.getString(KEY_CONTEXT));
                    script.put("path", (Object)(appPath + "/" + unitPath + "/" + pagePath));
                    extraScripts.add((Object)script);
                }
                ++flag;
            }
            if (flag != 0) continue;
            scriptInfo.put("path", (Object)(appPath + "/" + unitPath));
        }
        scriptArray.addAll((Collection)scriptInfos);
        if (!extraScripts.isEmpty()) {
            scriptArray.addAll((Collection)extraScripts);
        }
        if (!childrenUnits.isEmpty()) {
            JSONArray childrenScriptArray = this.getScriptResource(oriUnits, childrenUnits, appIds, text, unitPaths, appPath);
            scriptArray.addAll((Collection)childrenScriptArray);
        }
        return scriptArray;
    }

    private void searchScript(String bizAppId, String appPath) {
        String text = this.getModel().getValue("scriptnumber").toString();
        if ("".equals(text) || " ".equals(text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9700\u8981\u67e5\u8be2\u7684\u811a\u672c\u7f16\u7801\u3002", (String)"ScriptSearchPlugin_0", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put("searchtext", text);
        returnData.put(KEY_SEARCHTYPE, KEY_SEARCHSCRIPT);
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        JSONArray units = this.getUnitsByAppId(appIds, bizAppId);
        JSONArray scriptInfos = this.getScriptResource(new JSONArray(), units, appIds, text, new HashMap<String, String>(16), appPath);
        scriptInfos.stream().forEach(e -> ((JSONObject)e).put(KEY_CONTEXT, (Object)KDEncodeUtil.kdEncoding((String)this.getView().getFormShowParameter().getFormConfig().getKdEncoding(), (String)((JSONObject)e).getString(KEY_CONTEXT))));
        returnData.put("scriptInfos", (String)scriptInfos);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void searchInScript(String bizAppId, String appPath) {
        String text = this.getModel().getValue("scriptcontent").toString();
        if ("".equals(text) || " ".equals(text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9700\u8981\u67e5\u8be2\u7684\u811a\u672c\u5185\u5bb9\u3002", (String)"ScriptSearchPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put("searchtext", text);
        returnData.put(KEY_SEARCHTYPE, KEY_SEARCHINSCRIPT);
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        JSONArray units = this.getUnitsByAppId(appIds, bizAppId);
        JSONArray returnScripts = this.getContentResource(new JSONArray(), units, appIds, text, new HashMap<String, String>(16), appPath);
        returnScripts.stream().forEach(e -> ((JSONObject)e).put(KEY_CONTEXT, (Object)KDEncodeUtil.kdEncoding((String)this.getView().getFormShowParameter().getFormConfig().getKdEncoding(), (String)((JSONObject)e).getString(KEY_CONTEXT))));
        returnData.put("scriptInfos", (String)returnScripts);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

