/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class ScriptUseDetailPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String BIZAPPID = "bizappid";
    private static final String BIZAPPNUMBER = "bizappnumber";
    private static final String BIZAPPNAME = "bizappname";
    private static final String BIZCLOUDNAME = "bizcloudname";
    private static final String DEVELOPER = "developer";
    private static final String KSSCRIPTNUM = "ksscriptnum";

    public void registerListener(EventObject e) {
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRYENTITY);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] cloudObjects;
        JSONObject cloudsData = new JSONObject();
        for (DynamicObject dynamicObject : cloudObjects = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"id,name", null)) {
            cloudsData.put(dynamicObject.getString("id"), (Object)dynamicObject.getLocaleString("name").getLocaleValue());
        }
        ArrayList<JSONObject> datas = new ArrayList<JSONObject>(10);
        String sql = "SELECT p.fbizappId as bizappid, COUNT('p.FBIZAPPID') as scriptnum FROM t_meta_pluginscript p GROUP BY p.FBIZAPPID";
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)"SMC.ScriptUseDetailPlugin.createNewData", (DBRoute)DBRoute.meta, (String)sql, null);){
            for (Row row : ds) {
                String bizAppId = row.getString(BIZAPPID);
                int scriptNum = row.getInteger("scriptnum");
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId);
                if (appMetadata == null) continue;
                JSONObject data = new JSONObject();
                data.put(BIZAPPNUMBER, (Object)appMetadata.getNumber());
                data.put(BIZAPPNAME, (Object)appMetadata.getName().toString());
                data.put(BIZCLOUDNAME, cloudsData.get((Object)appMetadata.getBizCloudID()));
                data.put(DEVELOPER, (Object)appMetadata.getIsv());
                data.put(KSSCRIPTNUM, (Object)scriptNum);
                data.put(BIZAPPID, (Object)bizAppId);
                datas.add(data);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        Collections.sort(datas, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject a, JSONObject b) {
                Integer valA = a.getIntValue(ScriptUseDetailPlugin.KSSCRIPTNUM);
                Integer valB = b.getIntValue(ScriptUseDetailPlugin.KSSCRIPTNUM);
                return valB.compareTo(valA);
            }
        });
        if (datas.size() > 0) {
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, datas.size());
            for (int i = 0; i < datas.size(); ++i) {
                JSONObject jSONObject = (JSONObject)datas.get(i);
                this.getModel().setValue(BIZCLOUDNAME, (Object)jSONObject.getString(BIZCLOUDNAME), i);
                this.getModel().setValue(BIZAPPNAME, (Object)jSONObject.getString(BIZAPPNAME), i);
                this.getModel().setValue(BIZAPPNUMBER, (Object)jSONObject.getString(BIZAPPNUMBER), i);
                this.getModel().setValue(DEVELOPER, (Object)jSONObject.getString(DEVELOPER), i);
                this.getModel().setValue(KSSCRIPTNUM, (Object)jSONObject.getString(KSSCRIPTNUM), i);
                this.getModel().setValue(BIZAPPID, jSONObject.get((Object)BIZAPPID), i);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        String bizAppId = this.getModel().getValue(BIZAPPID, rowIndex).toString();
        FormShowParameter parameter = new FormShowParameter();
        if (KSSCRIPTNUM.equals(e.getFieldName())) {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId);
            parameter.setCaption(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u811a\u672c\u8be6\u60c5", (String)"ScriptUseDetailPlugin_0", (String)"bos-smc-plugin", (Object[])new Object[0]), appMetadata.getName().getLocaleValue()));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bos_smc_scriptdetail_app");
        } else if (BIZAPPNUMBER.equals(e.getFieldName())) {
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setFormId("bos_devp_kde");
        }
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        this.getView().showForm(parameter);
    }
}

