/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.plugin.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSInsertMethod;
import kd.bos.script.annotations.KSMethod;

public class ScriptUtil {
    private static final Log logger = LogFactory.getLog(ScriptUtil.class);
    private static final String FORMPLUGIN = "kd.bos.form.plugin.KDFormPlugin";
    private static final String BILLPLUGIN = "kd.bos.bill.KDBillPlugin";
    private static final String LISTPLUGIN = "kd.bos.list.plugin.KDListPlugin";
    private static final String OPERATIONPLUGIN = "kd.bos.entity.plugin.KDOperationPlugIn";
    private static final String TESTCASEPLUGIN = "kd.bos.unittest.KDUnitTestScriptPlugIn";
    private static final String WORKFLOWPLUGIN = "kd.bos.workflow.engine.extitf.WorkflowPlugin";
    private static final String WEBBILLAPIPLUGIN = "kd.bos.bill.KDBillWebApiPlugin";
    private static final String MOBBILLPLUGIN = "kd.bos.bill.KDMobBillPlugin";
    private static final String BILLREVERTPLUGIN = "kd.bos.entity.botp.plugin.KDConvertPlugIn";
    private static final String BILLREWRITERPLUGINB = "kd.bos.entity.botp.plugin.KDWriteBackPlugIn";
    private static final String PRINTSERVICEPLUGIN = "kd.bos.entity.plugin.AbstractKsPrintServicePlugin";

    public static String getClassFullNameByIndex(int index) {
        switch (index) {
            case 1: {
                return FORMPLUGIN;
            }
            case 2: {
                return BILLPLUGIN;
            }
            case 3: {
                return LISTPLUGIN;
            }
            case 4: {
                return OPERATIONPLUGIN;
            }
            case 5: {
                return TESTCASEPLUGIN;
            }
            case 7: {
                return WORKFLOWPLUGIN;
            }
            case 8: {
                return WEBBILLAPIPLUGIN;
            }
            case 9: {
                return MOBBILLPLUGIN;
            }
            case 10: {
                return BILLREVERTPLUGIN;
            }
            case 11: {
                return BILLREWRITERPLUGINB;
            }
            case 12: {
                return PRINTSERVICEPLUGIN;
            }
        }
        return "";
    }

    public static boolean isKSInsertMethod(Method method) {
        boolean isExist = false;
        Annotation[] annotations = method.getAnnotations();
        if (annotations.length == 0) {
            return isExist;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof KSInsertMethod)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static boolean isKSMethod(Method method) {
        boolean isExist = false;
        Annotation[] annotations = method.getAnnotations();
        if (annotations.length == 0) {
            return isExist;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof KSMethod)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static JSONObject getMethodsInfo(String classFullName, Boolean isStatic) {
        JSONObject methodInfo = new JSONObject();
        JSONArray ksMethods = new JSONArray();
        JSONArray deMethods = new JSONArray();
        try {
            Class<?> pluginClass = Class.forName(classFullName);
            if (pluginClass.isEnum()) {
                ?[] enumConstants;
                for (Object enumConstant : enumConstants = pluginClass.getEnumConstants()) {
                    ksMethods.add((Object)enumConstant.toString());
                }
            } else {
                Method[] methods;
                for (Method method : methods = pluginClass.getMethods()) {
                    if (!method.isAnnotationPresent(KSMethod.class) || isStatic.booleanValue() && !Modifier.isStatic(method.getModifiers())) continue;
                    StringBuffer autoTip = ScriptUtil.getMethodTip(method);
                    ksMethods.add((Object)autoTip.toString());
                    if (!method.isAnnotationPresent(Deprecated.class)) continue;
                    deMethods.add((Object)autoTip.toString());
                }
            }
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            logger.error(e.getMessage());
        }
        methodInfo.put("ksmethods", (Object)ksMethods);
        methodInfo.put("demethods", (Object)deMethods);
        return methodInfo;
    }

    private static StringBuffer getMethodTip(Method method) {
        StringBuffer autoTip = new StringBuffer();
        autoTip.append(method.getName());
        autoTip.append('(');
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            String[] paths = parameters[i].getParameterizedType().getTypeName().split("\\.");
            String className = paths[paths.length - 1];
            autoTip.append(className);
            if (i >= parameters.length - 1) continue;
            autoTip.append(',');
        }
        autoTip.append(')');
        autoTip.append(" : ");
        autoTip.append(method.getReturnType().getSimpleName());
        return autoTip;
    }

    public static JSONArray getKSMethodInInterface(Class<?> returnTypeClass) {
        Method[] methods;
        JSONArray ksMethods = new JSONArray();
        for (Method method : methods = returnTypeClass.getMethods()) {
            boolean isKSMethod = ScriptUtil.isKSMethod(method);
            if (!isKSMethod) continue;
            StringBuffer autoTip = ScriptUtil.getMethodTip(method);
            ksMethods.add((Object)autoTip.toString());
        }
        return ksMethods;
    }
}

