/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.svn.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.common.hosting.SVNManagerUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SVNInfoPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String P = "passwd";
    private static final String USERNAME = "username";
    private static final String BIZAPPID = "bizappid";
    private static final String IPPOST = "ippost";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, P});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String userName = (String)param.getCustomParam(USERNAME);
        String bizAppId = (String)param.getCustomParam(BIZAPPID);
        String type = (String)param.getCustomParam("type");
        String ipPost = (String)param.getCustomParam(IPPOST);
        this.getPageCache().put(IPPOST, ipPost);
        if ("user".equals(type)) {
            JSONObject data = SVNManagerUtil.doGet((String)(ipPost + "rest/appuser.get?action=get.databyuser&userId=" + userName + "&appId=" + bizAppId));
            if (data != null && SUCCESS.equals(data.getString(MESSAGE))) {
                JSONObject result = (JSONObject)data.get((Object)"result");
                JSONObject app = (JSONObject)result.get((Object)"app");
                JSONArray managers = (JSONArray)result.get((Object)"managers");
                String rw = result.getString("rw");
                String passwd = result.getString(P);
                if (app != null) {
                    this.getModel().setValue("svnserver", (Object)app.getString("server"));
                    this.getModel().setValue("svnurl", (Object)app.getString("url"));
                }
                String managerNames = this.getManagerNames(managers);
                this.getModel().setValue("manager", (Object)managerNames);
                this.getModel().setValue("auth", (Object)rw);
                this.getModel().setValue(P, (Object)passwd);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u8be5\u5e94\u7528\u7684\u7528\u6237\uff0c\u8bf7\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"SVNInfoPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        } else if ("unuser".equals(type)) {
            JSONObject data = SVNManagerUtil.doGet((String)(ipPost + "rest/appuser.get?action=get.managerdatabyapp&appId=" + bizAppId));
            if (data != null && SUCCESS.equals(data.getString(MESSAGE))) {
                JSONObject result = (JSONObject)data.get((Object)"result");
                JSONObject app = (JSONObject)result.get((Object)"app");
                JSONArray managers = (JSONArray)result.get((Object)"managers");
                if (app != null) {
                    this.getModel().setValue("svnserver", (Object)app.getString("server"));
                    this.getModel().setValue("svnurl", (Object)app.getString("url"));
                }
                String managerNames = this.getManagerNames(managers);
                this.getModel().setValue("manager", (Object)managerNames);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"auth", P});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u8be5\u5e94\u7528\u7684\u7528\u6237\uff0c\u8bf7\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"SVNInfoPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private String getManagerNames(JSONArray managers) {
        String managerNames = "";
        HashSet<String> managerPhones = new HashSet<String>(managers.size());
        for (int i = 0; i < managers.size(); ++i) {
            managerPhones.add(managers.getJSONObject(i).getString("userId"));
        }
        QFilter[] qfilter = new QFilter[]{new QFilter("phone", "in", (Object)managerPhones.toArray())};
        Map userObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"name, phone", (QFilter[])qfilter);
        if (userObjects != null && userObjects.size() > 0) {
            StringBuilder mn = new StringBuilder();
            Iterator iterator = userObjects.keySet().iterator();
            while (iterator.hasNext()) {
                DynamicObject userObject = (DynamicObject)userObjects.get(iterator.next());
                mn.append(userObject.getString("name"));
                mn.append(';');
            }
            managerNames = mn.substring(0, mn.toString().length() - 1);
        }
        return managerNames;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        if (e.getReturnData() != null && "changepasswdCallBack".equals(actionId = e.getActionId())) {
            String newPasswd = (String)e.getReturnData();
            this.getModel().setValue(P, (Object)newPasswd);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\u3002", (String)"SVNInfoPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnok": {
                this.confirm();
                break;
            }
            case "passwd": {
                this.changePasswd();
                break;
            }
        }
    }

    private void changePasswd() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String userName = (String)param.getCustomParam(USERNAME);
        String bizAppId = (String)param.getCustomParam(BIZAPPID);
        String ipPost = (String)param.getCustomParam(IPPOST);
        String passwd = (String)this.getModel().getValue(P);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("svnchangepasswd");
        parameter.setCustomParam(P, (Object)passwd);
        parameter.setCustomParam(USERNAME, (Object)userName);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(IPPOST, (Object)ipPost);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u5bc6\u7801", (String)"SVNInfoPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changepasswdCallBack"));
        this.getView().showForm(parameter);
    }

    private void confirm() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String userName = (String)param.getCustomParam(USERNAME);
        String ipPost = (String)param.getCustomParam(IPPOST);
        String passwd = (String)this.getModel().getValue(P);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", userName);
        data.put(P, passwd);
        JSONObject result = SVNManagerUtil.doPost((String)(ipPost + "rest/user.post?action=mod.user"), data);
        if (SUCCESS.equals(result.getString(MESSAGE))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4fdd\u5b58\u6210\u529f\u3002", (String)"SVNInfoPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
            this.getView().close();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SVNInfoPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }
}

