/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.svn.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.common.util.HttpClientUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

public class SVNUploadFilePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String TEMPUPLOADURL = "tempuploadurl";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnconfirm"});
        IAttachmentPanel panel = (IAttachmentPanel)this.getView().getControl("attachmentpanelap");
        panel.addUploadListener((UploadListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        if (e.getReturnData() != null && "".equals(actionId = e.getActionId())) {
            e.getReturnData();
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnconfirm": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        JSONArray files = new JSONArray();
        String tempUploadUrl = this.getPageCache().get(TEMPUPLOADURL);
        JSONArray urlMsgs = JSONArray.parseArray((String)tempUploadUrl);
        if (urlMsgs != null && urlMsgs.size() > 0) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String bizAppId = (String)parameter.getCustomParam("bizappid");
            String fileFolder = (String)parameter.getCustomParam("filefolder");
            String bizAppNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"number").getString("number");
            String localPath = DevportalUtil.USER_HOME + File.separator + "metadata" + File.separator + bizAppNumber + File.separator + fileFolder;
            File localFile = new File(localPath = FileUtils.cleanString((String)localPath));
            if (!localFile.exists()) {
                localFile.mkdirs();
            }
            for (int i = 0; i < urlMsgs.size(); ++i) {
                JSONObject urlMsg = urlMsgs.getJSONObject(i);
                String url = urlMsg.getString("url");
                String fileName = urlMsg.getString("filename");
                files.add((Object)fileName);
                String filePath = localPath + File.separator + fileName;
                HttpGet httpUrl = HttpClientUtils.wrapperHttpGet((String)url);
                HttpClient httpClient = HttpClientUtils.wrapperHttpClient((HttpRequestBase)httpUrl);
                String checkCustomZipPath = FileUtils.cleanString((String)DevportalUtil.checkFilePath(filePath));
                Path customZipPath = Paths.get(checkCustomZipPath, new String[0]);
                try (TXHandle tx = TX.required((String)"mdl_SVNUploadFilePlugin_confirm");){
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(httpClient.execute((HttpUriRequest)httpUrl).getEntity().getContent()));
                         BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0])));){
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            bw.write(line);
                            bw.newLine();
                            bw.flush();
                        }
                    }
                    catch (Exception e) {
                        tx.markRollback();
                    }
                    continue;
                }
            }
        }
        this.getView().returnDataToParent((Object)files);
        this.getView().close();
    }

    public void upload(UploadEvent arg0) {
        Object[] urlMsgs;
        JSONArray urls = new JSONArray();
        String tempUploadUrl = this.getPageCache().get(TEMPUPLOADURL);
        if (StringUtils.isNotBlank((CharSequence)tempUploadUrl)) {
            urls = JSONArray.parseArray((String)tempUploadUrl);
        }
        if ((urlMsgs = arg0.getUrls()) != null && urlMsgs.length > 0) {
            for (int i = 0; i < urlMsgs.length; ++i) {
                Map urlMsg = (Map)urlMsgs[i];
                JSONObject map = new JSONObject();
                map.put("url", urlMsg.get("url"));
                map.put("filename", urlMsg.get("name"));
                urls.add((Object)map);
            }
        }
        this.getPageCache().put(TEMPUPLOADURL, urls.toJSONString());
    }
}

