/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SchemeTemplateTitleRepairUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(SchemeTemplateTitleRepairUpgradeServiceImpl.class);
    private static final String mainTableName = "T_BAS_PROGRAMTEMPLATE";
    private static final String mainTableId = "FID";
    private static final String mainTableColumn = "FTITLE";
    private static final String multiTableName = "T_BAS_PROGRAMTEMPLATE_L";
    private static final String multiTablePKID = "FPKID";
    private static final String multiTableColumn = "FTITLE";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder resultLog = new StringBuilder();
        try (TXHandle tx = TX.requiresNew();){
            try {
                resultLog.append("repair data begin\n");
                this.repairSchemeTemplateTitle(dbKey);
                resultLog.append("repair data success");
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("repair bos_schemetemplate title data error", (Throwable)e);
                throw e;
            }
        }
        result.setLog(resultLog.toString());
        return result;
    }

    private void repairSchemeTemplateTitle(String dbKey) {
        Map<String, String> idAndTitleMap = this.getIdAndTitleMap(dbKey);
        this.repair(idAndTitleMap, dbKey);
    }

    private Map<String, String> getIdAndTitleMap(String dbKey) {
        String idTitleSql = String.format("SELECT %s,%s FROM %s WHERE %s != '' OR %s != ' '", mainTableId, "FTITLE", mainTableName, "FTITLE", "FTITLE");
        return (Map)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)idTitleSql, rs -> {
            HashMap<String, String> temp = new HashMap<String, String>(8);
            while (rs.next()) {
                String id = rs.getString(mainTableId);
                String title = rs.getString("FTITLE");
                temp.put(id, title);
            }
            return temp;
        });
    }

    private void repair(Map<String, String> idAndTitleMap, String dbKey) {
        String queryPKIDSql = String.format("SELECT %s FROM %s WHERE %s = ? AND FLOCALEID = 'zh_CN'", multiTablePKID, multiTableName, mainTableId);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(8);
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(8);
        for (Map.Entry<String, String> entry : idAndTitleMap.entrySet()) {
            String id = entry.getKey();
            String title = entry.getValue();
            Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)id)};
            String pkId = (String)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)queryPKIDSql, (Object[])sqlParameters, rs -> {
                if (rs.next()) {
                    return rs.getString(multiTablePKID);
                }
                return "";
            });
            if (StringUtils.isNotBlank((CharSequence)pkId)) {
                SqlParameter[] updateParam = new SqlParameter[]{new SqlParameter(":FTITLE", -9, (Object)title), new SqlParameter(":FPKID", 12, (Object)pkId)};
                updateParamList.add(updateParam);
                if (updateParamList.size() != 1000) continue;
                this.update(dbKey, updateParamList);
                updateParamList.clear();
                continue;
            }
            SqlParameter[] insertParam = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)id), new SqlParameter(":FPKID", 12, (Object)ID.genStringId()), new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN"), new SqlParameter(":FTITLE", -9, (Object)title)};
            insertParamList.add(insertParam);
            if (insertParamList.size() != 1000) continue;
            this.insert(dbKey, insertParamList);
            insertParamList.clear();
        }
        if (!updateParamList.isEmpty()) {
            this.update(dbKey, updateParamList);
        }
        if (!insertParamList.isEmpty()) {
            this.insert(dbKey, insertParamList);
        }
    }

    private void update(String dbKey, List<Object[]> updateParamList) {
        String updateSql = String.format("UPDATE %s SET %s = ? WHERE %S = ?", multiTableName, "FTITLE", multiTablePKID);
        DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)updateSql, updateParamList);
    }

    private void insert(String dbKey, List<Object[]> insertParamList) {
        String insertSql = String.format("INSERT INTO %s(%s,%s,%s,%s) VALUES(?,?,?,?)", multiTableName, mainTableId, multiTablePKID, "FLOCALEID", "FTITLE");
        DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)insertSql, insertParamList);
    }
}

