/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.upgrade.service.impl;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.coderule.api.CoderuleFile;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.upgrade.service.BillTypeDataDeployService;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.billtype.entity.BillTypeFile;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.ExceptionUtils;

public class BillTypeDataDeployServiceImpl
extends BillTypeDataDeployService {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log logger = LogFactory.getLog(BillTypeDataDeployServiceImpl.class);

    @Override
    public Map<String, Object> createTreeNodes(@NotNull String appId, @NotNull String entityNum, @NotNull TreeNode parentNode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        String inheritPath = appMeta.getInheritPath();
        List<String> appIdList = DevportalUtil.getAllAppIds(inheritPath, appId);
        List billTypeList = null;
        try {
            billTypeList = BillTypeServiceHelper.getBillTypesByAppId(appIdList);
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s \u52a0\u8f7d\u3010\u5355\u636e\u7c7b\u578b\u3011\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u5355\u636e\u7c7b\u578b\u63a5\u53e3\u3010BillTypeServiceHelper.getBillTypesByAppId\u3011\u51fa\u9519\uff0c\u8be6\u60c5\u5982\u4e0b: %2$s", (String)"BillTypeDataDeployServiceImpl_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentNode.getText(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(errMsg);
            resultMap.put("success", false);
            resultMap.put("message", errMsg);
        }
        if (billTypeList != null && !billTypeList.isEmpty()) {
            TreeNode billTypeNode = AppPackageUtil.geneConfNode(parentNode.getId(), entityNum, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"BillTypeDataDeployServiceImpl_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parentNode.addChild(billTypeNode);
            this.createBillTypeDataNode(billTypeList, billTypeNode);
        }
        return resultMap;
    }

    private void createBillTypeDataNode(List<Map<String, Object>> billTypeList, TreeNode parentNode) {
        for (Map<String, Object> billType : billTypeList) {
            TreeNode dataNode = AppPackageUtil.geneConfNode(parentNode.getId(), billType.get("id").toString(), billType.get("name").toString());
            parentNode.addChild(dataNode);
        }
    }

    @Override
    public Map<String, Object> exportDeployDatas(String entityNum, @NotNull List<String> dataIdList, String expFileName, @NotNull String exportPath, Object ... params) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        List billtypeExportFileList = BillTypeServiceHelper.exportBillTypeByIds(dataIdList);
        ArrayList<String> billtypeSqlList = new ArrayList<String>();
        if (!billtypeExportFileList.isEmpty()) {
            for (BillTypeFile billtypeFile : billtypeExportFileList) {
                billtypeSqlList.add(String.format("%s.sql", billtypeFile.getFileName()));
                this.exportSource(billtypeFile, exportPath);
            }
            resultMap.put("sqlfilename", SerializationUtils.toJsonString(billtypeSqlList));
        }
        return resultMap;
    }

    public void exportSource(Object objectFile, String appPath) {
        block32: {
            String fileName = "";
            List dataList = Collections.emptyList();
            if (objectFile instanceof CoderuleFile) {
                fileName = ((CoderuleFile)objectFile).getFileName();
                dataList = ((CoderuleFile)objectFile).getFileContent();
            } else if (objectFile instanceof BillTypeFile) {
                fileName = ((BillTypeFile)objectFile).getFileName();
                dataList = ((BillTypeFile)objectFile).getFileContent();
            }
            String filePath = appPath + File.separator + "preinsdata" + File.separator + fileName + ".sql";
            File file = new File(filePath);
            File coderuleAboveFile = file.getParentFile();
            if (!coderuleAboveFile.exists()) {
                coderuleAboveFile.mkdirs();
            }
            if (!file.exists()) {
                try {
                    boolean fileCreate = file.createNewFile();
                    if (!fileCreate) break block32;
                    Path customZipPath = Paths.get(DevportalUtil.checkFilePath(filePath), new String[0]);
                    try (OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                         OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                        for (String data : dataList) {
                            writer.write(data + System.lineSeparator());
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
        }
    }
}

