/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.upgrade.service.impl;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.CoderuleFile;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.upgrade.service.CodeRuleDataDeployService;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.billtype.entity.BillTypeFile;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.ExceptionUtils;

public class CodeRuleDataDeployServiceImpl
extends CodeRuleDataDeployService {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log logger = LogFactory.getLog(CodeRuleDataDeployServiceImpl.class);

    @Override
    public Map<String, Object> createTreeNodes(@NotNull String appId, @NotNull String entityNum, @NotNull TreeNode parentNode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        String inheritPath = appMeta.getInheritPath();
        List<String> appIdList = DevportalUtil.getAllAppIds(inheritPath, appId);
        List codeRuleList = null;
        try {
            codeRuleList = CodeRuleServiceHelper.getAllCodeRuleByAppId(appIdList);
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s \u52a0\u8f7d\u3010\u7f16\u7801\u89c4\u5219\u3011\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u4fe1\u606f\u63a5\u53e3\u3010CodeRuleServiceHelper.getAllCodeRuleByAppId\u3011\u51fa\u9519\uff0c\u8be6\u60c5\u5982\u4e0b: %2$s", (String)"CodeRuleDataDeployServiceImpl_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentNode.getText(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(errMsg);
            resultMap.put("success", false);
            resultMap.put("message", errMsg);
        }
        if (codeRuleList != null && !codeRuleList.isEmpty()) {
            logger.debug(String.format("\u5171\u67e5\u8be2\u5230 %s \u6761\u7f16\u7801\u89c4\u5219", codeRuleList.size()));
            TreeNode codeRuleNode = AppPackageUtil.geneConfNode(parentNode.getId(), entityNum, ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219", (String)"CodeRuleDataDeployServiceImpl_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parentNode.addChild(codeRuleNode);
            this.createCodeRuleDataNode(codeRuleList, codeRuleNode);
        }
        return resultMap;
    }

    private void createCodeRuleDataNode(List<CodeRuleInfo> codeRuleList, TreeNode parentNode) {
        for (CodeRuleInfo codeRule : codeRuleList) {
            TreeNode dataNode = AppPackageUtil.geneConfNode(parentNode.getId(), codeRule.getId(), codeRule.getName());
            parentNode.addChild(dataNode);
        }
    }

    @Override
    public Map<String, Object> exportDeployDatas(String entityNum, @NotNull List<String> dataIdList, String expFileName, @NotNull String exportPath, Object ... params) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        List coderuleFileList = CodeRuleServiceHelper.exportCodeRuleByCoderuleID(dataIdList);
        ArrayList<String> coderuleSqlList = new ArrayList<String>();
        if (coderuleFileList != null && !coderuleFileList.isEmpty()) {
            for (CoderuleFile coderuleFile : coderuleFileList) {
                coderuleSqlList.add(String.format("%s.sql", coderuleFile.getFileName()));
                this.exportSource(coderuleFile, exportPath);
            }
            resultMap.put("sqlfilename", SerializationUtils.toJsonString(coderuleSqlList));
        }
        return resultMap;
    }

    public void exportSource(Object objectFile, String appPath) {
        block32: {
            String fileName = "";
            List dataList = Collections.emptyList();
            if (objectFile instanceof CoderuleFile) {
                fileName = ((CoderuleFile)objectFile).getFileName();
                dataList = ((CoderuleFile)objectFile).getFileContent();
            } else if (objectFile instanceof BillTypeFile) {
                fileName = ((BillTypeFile)objectFile).getFileName();
                dataList = ((BillTypeFile)objectFile).getFileContent();
            }
            String filePath = appPath + File.separator + "preinsdata" + File.separator + fileName + ".sql";
            File file = new File(filePath);
            File coderuleAboveFile = file.getParentFile();
            if (!coderuleAboveFile.exists()) {
                coderuleAboveFile.mkdirs();
            }
            if (!file.exists()) {
                try {
                    boolean fileCreate = file.createNewFile();
                    if (!fileCreate) break block32;
                    Path customZipPath = Paths.get(DevportalUtil.checkFilePath(filePath), new String[0]);
                    try (OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                         OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                        for (String data : dataList) {
                            writer.write(data + System.lineSeparator());
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
        }
    }
}

