/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.upgrade.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.upgrade.service.PermItemDataDeployService;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.ExceptionUtils;

public class PermItemDataDeployServiceImpl
extends PermItemDataDeployService {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log logger = LogFactory.getLog(PermItemDataDeployServiceImpl.class);

    @Override
    public Map<String, Object> createTreeNodes(@NotNull String appId, @NotNull String entityNum, @NotNull TreeNode parentNode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        DynamicObjectCollection permItemColl = null;
        try {
            permItemColl = this.queryPermItemDatas(appId);
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s \u52a0\u8f7d\u3010\u6743\u9650\u9879\u3011\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8be6\u60c5\u5982\u4e0b: %2$s", (String)"PermItemDataDeployServiceImpl_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentNode.getText(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(errMsg);
            resultMap.put("success", false);
            resultMap.put("message", errMsg);
        }
        if (permItemColl != null && !permItemColl.isEmpty()) {
            logger.debug(String.format("\u5e94\u7528(%1$s)\u4e0b\u67e5\u8be2\u5230 %2$s \u6761\u6743\u9650\u9879", appId, permItemColl.size()));
            TreeNode permItemNode = AppPackageUtil.geneConfNode(parentNode.getId(), entityNum, ResManager.loadKDString((String)"\u6743\u9650\u9879", (String)"PermItemDataDeployServiceImpl_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parentNode.addChild(permItemNode);
            AppPackageUtil.createDataNode(permItemColl, permItemNode);
        }
        return resultMap;
    }

    private DynamicObjectCollection queryPermItemDatas(Object appId) {
        QFilter permItemFilter = new QFilter("id", "in", this.getAllPermItems(appId));
        QFilter excludedFilter = new QFilter("number", "not like", (Object)"QXX%");
        return ORM.create().query("perm_permitem", new QFilter[]{permItemFilter, excludedFilter});
    }

    private Set<String> getAllPermItems(Object appId) {
        HashSet<String> permItemIdSet = new HashSet<String>();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId.toString(), (boolean)false);
        String inheritPath = appMeta.getInheritPath();
        List<String> appIdList = DevportalUtil.getAllAppIds(inheritPath, appId.toString());
        QFilter filter = new QFilter("bizapp", "in", appIdList);
        DynamicObjectCollection formColl = QueryServiceHelper.query((String)"bos_entitymeta", (String)"id, number", (QFilter[])filter.toArray());
        for (DynamicObject formObj : formColl) {
            permItemIdSet.addAll(EntityMetadataCache.getPermissionItems((String)formObj.getString("number")));
        }
        return permItemIdSet;
    }

    @Override
    public Map<String, Object> exportDeployDatas(String entityNum, @NotNull List<String> dataIdList, String expFileName, @NotNull String exportPath, Object ... params) {
        ArrayList<String> permItemSqlList = new ArrayList<String>();
        Map<String, Object> retMap = AppPackageUtil.expPreInsDataSql(entityNum, dataIdList, expFileName, exportPath);
        Object sqlFileName = retMap.get("sqlfilename");
        if (sqlFileName != null) {
            permItemSqlList.add(sqlFileName.toString());
        }
        retMap.put("sqlfilename", SerializationUtils.toJsonString(permItemSqlList));
        return retMap;
    }
}

