/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.upgrade.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.devportal.upgrade.service.PortalSchemaDataDeployService;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.ExceptionUtils;

public class PortalSchemaDataDeployServiceImpl
extends PortalSchemaDataDeployService {
    private static final Log logger = LogFactory.getLog(PortalSchemaDataDeployServiceImpl.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    @Override
    public Map<String, Object> createTreeNodes(@NotNull String appId, @NotNull String entityNum, @NotNull TreeNode parentNode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        DynamicObjectCollection protalSchemaColl = null;
        try {
            protalSchemaColl = this.queryProtalSchemaDatas(appMeta);
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u52a0\u8f7d\u201c\u5e94\u7528\u5de5\u4f5c\u53f0\u201d\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8be6\u60c5\u5982\u4e0b: %2$s\u3002", (String)"PortalSchemaDataDeployServiceImpl_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentNode.getText(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(errMsg);
            resultMap.put("success", false);
            resultMap.put("message", errMsg);
        }
        if (protalSchemaColl != null && !protalSchemaColl.isEmpty()) {
            logger.debug(String.format("\u5e94\u7528(%1$s)\u4e0b\u67e5\u8be2\u5230 %2$s \u6761\u5e94\u7528\u5de5\u4f5c\u53f0/\u9996\u9875\u65b9\u6848\u6570\u636e", appMeta.getAppElement().getNumber(), protalSchemaColl.size()));
            TreeNode protalSchemaNode = AppPackageUtil.geneConfNode(parentNode.getId(), entityNum, ResManager.loadKDString((String)"\u5e94\u7528\u5de5\u4f5c\u53f0", (String)"PortalSchemaDataDeployServiceImpl_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parentNode.addChild(protalSchemaNode);
            boolean sysSchema = true;
            boolean personalSchema = true;
            TreeNode protalSchemaSubNode = new TreeNode();
            for (DynamicObject protalSchemaObj : protalSchemaColl) {
                TreeNode protalSchemaDataNode;
                String protalSchemeId = protalSchemaObj.getString("id");
                String protalSchemeName = protalSchemaObj.getLocaleString("name").getLocaleValue();
                String protalSchemeType = protalSchemaObj.getString("schemetype");
                if ("1".equals(protalSchemeType)) {
                    if (sysSchema) {
                        protalSchemaSubNode = AppPackageUtil.geneConfNode(protalSchemaNode.getId(), protalSchemeType, ResManager.loadKDString((String)"\u5168\u5c40\u65b9\u6848", (String)"PortalSchemaDataDeployServiceImpl_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                        protalSchemaNode.addChild(protalSchemaSubNode);
                        sysSchema = false;
                    }
                    protalSchemaDataNode = AppPackageUtil.geneConfNode(protalSchemaSubNode.getId(), protalSchemeId, protalSchemeName);
                    protalSchemaSubNode.addChild(protalSchemaDataNode);
                    continue;
                }
                if (!"3".equals(protalSchemeType)) continue;
                if (personalSchema) {
                    protalSchemaSubNode = AppPackageUtil.geneConfNode(protalSchemaNode.getId(), protalSchemeType, ResManager.loadKDString((String)"\u4e2a\u6027\u65b9\u6848", (String)"PortalSchemaDataDeployServiceImpl_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    protalSchemaNode.addChild(protalSchemaSubNode);
                    personalSchema = false;
                }
                protalSchemaDataNode = AppPackageUtil.geneConfNode(protalSchemaSubNode.getId(), protalSchemeId, protalSchemeName);
                protalSchemaSubNode.addChild(protalSchemaDataNode);
            }
        }
        return resultMap;
    }

    private DynamicObjectCollection queryProtalSchemaDatas(AppMetadata appMeta) {
        String masterAppId = appMeta.getMasterId();
        String appId = appMeta.getId();
        String appType = appMeta.getDevType();
        QFilter filter = "2".equals(appType) ? new QFilter("bizapp", "=", (Object)masterAppId) : new QFilter("bizapp", "=", (Object)appId);
        String selectFields = "id, number, name, schemetype";
        return ORM.create().query("portal_scheme", selectFields, filter.toArray(), "schemetype");
    }

    @Override
    public Map<String, Object> exportDeployDatas(String entityNum, @NotNull List<String> dataIdList, String expFileName, @NotNull String exportPath, Object ... params) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        List<Long> portalSchemaIds = dataIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        ArrayList<String> portalSchemaSqlNameList = new ArrayList<String>();
        boolean hasXmlFlag = AppPackageUtil.exportPageScheme(portalSchemaIds, exportPath, portalSchemaSqlNameList);
        resultMap.put("sqlfilename", SerializationUtils.toJsonString(portalSchemaSqlNameList));
        resultMap.put("hasxmlflag", hasXmlFlag);
        return resultMap;
    }
}

