/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.upgrade.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.upgrade.service.ScheduleDataDeployService;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.schedule.deploy.IScheduleDeployService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.ExceptionUtils;

public class ScheduleDataDeployServiceImpl
extends ScheduleDataDeployService {
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final Log logger = LogFactory.getLog(ScheduleDataDeployServiceImpl.class);

    @Override
    public Map<String, Object> createTreeNodes(@NotNull String appId, @NotNull String entityNum, @NotNull TreeNode parentNode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        String inheritPath = appMeta.getInheritPath();
        List<String> appIdList = DevportalUtil.getAllAppIds(inheritPath, appId);
        DynamicObjectCollection scheduleColl = new DynamicObjectCollection();
        try {
            for (String tmpAppId : appIdList) {
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)tmpAppId, (boolean)false);
                IScheduleDeployService service = (IScheduleDeployService)ServiceFactory.getService(IScheduleDeployService.class);
                scheduleColl.addAll((Collection)service.querySchedules(appMetadata.getNumber()));
            }
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u52a0\u8f7d\u201c\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u201d\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%2$s\u3002", (String)"ScheduleDataDeployServiceImpl_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), parentNode.getText(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(errMsg);
            resultMap.put("success", false);
            resultMap.put("message", errMsg);
        }
        if (!scheduleColl.isEmpty()) {
            logger.debug(String.format("\u5fae\u670d\u52a1\u63a5\u53e3\u5171\u83b7\u53d6\u5230 %s \u6761\u8c03\u5ea6\u7ba1\u7406\u6570\u636e\u3002", scheduleColl.size()));
            TreeNode scheduleNode = AppPackageUtil.geneConfNode(parentNode.getId(), entityNum, ResManager.loadKDString((String)"\u8c03\u5ea6\u7ba1\u7406", (String)"ScheduleDataDeployServiceImpl_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parentNode.addChild(scheduleNode);
            AppPackageUtil.createDataNode(scheduleColl, scheduleNode);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> exportDeployDatas(String entityNum, @NotNull List<String> dataIdList, String expFileName, @NotNull String exportPath, Object ... params) {
        Boolean isOverride = (Boolean)params[0];
        IScheduleDeployService service = (IScheduleDeployService)ServiceFactory.getService(IScheduleDeployService.class);
        return service.expScheduleDeployDatas(dataIdList, exportPath, isOverride.booleanValue());
    }
}

