/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class KDEMulLangUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(KDEMulLangUpgradeServiceImpl.class);
    private StringBuilder resultLog = new StringBuilder();

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.repairData(dbKey);
        result.setLog(this.resultLog.toString());
        return result;
    }

    private void repairData(String dbKey) {
        this.innerRepairData(DBRoute.of((String)dbKey), "t_meta_scenecode", "t_meta_scenecode_l", "fid", new String[]{"fname", "fdescription"});
    }

    private void innerRepairData(DBRoute dbRoute, String table, String lTable, String tablePk, String[] columns) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.resultLog.append("repair data begin ").append(table).append("\n");
                Migrator migrator = new Migrator(dbRoute, table, lTable, tablePk, columns);
                migrator.execute();
                this.resultLog.append("repair data success ").append(table).append("\n");
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("repair data error table:{} ", (Object)table, (Object)e);
                throw e;
            }
        }
    }

    static class Migrator {
        private final String table;
        private final String lTable;
        private final String tablePk;
        private final String[] columns;
        private final DBRoute dbRoute;
        private static int batchSize = 1000;

        Migrator(DBRoute dbRoute, String table, String lTable, String tablePk, String[] columns) {
            this.table = table;
            this.lTable = lTable;
            this.tablePk = tablePk;
            this.columns = columns;
            this.dbRoute = dbRoute;
        }

        public void setBatchSize(int batchSize) {
            Migrator.batchSize = batchSize;
        }

        void execute() {
            Map<Object, String[]> tableData = this.getTableData();
            Map<Object, String> pkIds = this.getFpkidFromLtable();
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(tableData.size());
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(8);
            for (Map.Entry<Object, String[]> entry : tableData.entrySet()) {
                Object[] param;
                Object id = entry.getKey();
                String[] columnDatas = entry.getValue();
                String fpkid = pkIds.get(id);
                if (StringUtils.isNotEmpty((CharSequence)fpkid)) {
                    param = new Object[this.columns.length + 1];
                    System.arraycopy(columnDatas, 0, param, 0, columnDatas.length);
                    param[this.columns.length] = fpkid;
                    updateParamList.add(param);
                    if (updateParamList.size() != batchSize) continue;
                    this.update(updateParamList);
                    updateParamList.clear();
                    continue;
                }
                param = new Object[this.columns.length + 3];
                param[0] = DB.genStringId((String)this.lTable);
                param[1] = Lang.zh_CN.toString();
                param[2] = id;
                for (int i = 0; i < columnDatas.length; ++i) {
                    param[i + 3] = columnDatas[i];
                }
                insertParamList.add(param);
                if (insertParamList.size() != batchSize) continue;
                this.insert(insertParamList);
                insertParamList.clear();
            }
            if (!insertParamList.isEmpty()) {
                this.insert(insertParamList);
            }
            if (!updateParamList.isEmpty()) {
                this.update(updateParamList);
            }
        }

        private Map<Object, String> getFpkidFromLtable() {
            String sql = String.format("SELECT fpkid,%s FROM %s WHERE FLOCALEID = '%s'", this.tablePk, this.lTable, Lang.zh_CN);
            Map pkIds = (Map)DB.query((DBRoute)this.dbRoute, (String)sql, rs -> {
                HashMap<Object, String> set = new HashMap<Object, String>(6);
                while (rs.next()) {
                    set.put(rs.getObject(this.tablePk), rs.getString("fpkid"));
                }
                return set;
            });
            return pkIds;
        }

        private Map<Object, String[]> getTableData() {
            String columnsStr = StringUtils.join((Object[])this.columns, (char)',');
            String sql = String.format("SELECT %s,%s FROM %s ", this.tablePk, columnsStr, this.table);
            return (Map)DB.query((DBRoute)this.dbRoute, (String)sql, rs -> {
                LinkedHashMap<Object, String[]> temp = new LinkedHashMap<Object, String[]>(8);
                while (rs.next()) {
                    Object id = rs.getObject(this.tablePk);
                    String[] columnsData = new String[this.columns.length];
                    for (int i = 0; i < this.columns.length; ++i) {
                        String str = rs.getString(this.columns[i]);
                        if (StringUtils.isEmpty((CharSequence)str)) {
                            str = " ";
                        }
                        columnsData[i] = str;
                    }
                    temp.put(id, columnsData);
                }
                return temp;
            });
        }

        private void insert(List<Object[]> insertParamList) {
            String columnsStr = StringUtils.join((Object[])this.columns, (char)',');
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.columns.length; ++i) {
                sb.append("?,");
            }
            sb.setLength(sb.length() - 1);
            String insertSql = String.format("INSERT INTO %s(fpkid,flocaleid,%s,%s) VALUES(?,?,?,%s)", this.lTable, this.tablePk, columnsStr, sb);
            DB.executeBatch((DBRoute)this.dbRoute, (String)insertSql, insertParamList);
        }

        private void update(List<Object[]> updateParamList) {
            String separator = "= ?,";
            String columnsStr = StringUtils.join((Object[])this.columns, (String)separator);
            columnsStr = columnsStr + "= ? ";
            String updateSql = String.format("UPDATE %s SET %s WHERE fpkid = ?", this.lTable, columnsStr);
            DB.executeBatch((DBRoute)this.dbRoute, (String)updateSql, updateParamList);
        }
    }
}

