/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.util;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.business.hosting.SVNCodeHostingServiceImpl;
import kd.bos.devportal.common.hosting.SVNManagerUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.FileUtils;

public class SVNManageUtil {
    public static final Log logger = LogFactory.getLog(SVNManageUtil.class);
    public static final String NOPATH = "NOPATH";
    private static final String APP_TYPE = "APP_TYPE";
    private static final String MESSAGE = "message";
    private static final String RESULT = "result";
    private static final String COMMITINFO = "commitInfo";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZAPPID = "bizappid";
    private static final String KEY_SVNMANAGE = "svnmanage";
    private static final String MANAGER = "manager";
    private static final String SVNMANAGEUTIL_1 = "SVNManageUtil_1";
    private static final String USERNAME = "username";
    private static final String BIZAPPNUMBER = "bizappnumber";
    private static final String SVNMSG = "svnmsg";
    private static final String SVN_URL = "svnurl";
    private static final String IP_POST = "ippost";
    private static final String SVNMANAGECALLBACK = "svnmanagecallback";
    private static final String SVNINFO = "svninfo";
    private static final String SVNMANAGEUTIL_2 = "SVNManageUtil_2";
    private static final String SAVE_JSESSION_ID = "SAVE_JSESSION_ID";
    private static final String BOS_DEVP_SVNLOGIN = "bos_devp_svnlogin";
    private static final String SVNMANAGEUTIL_12 = "SVNManageUtil_12";
    private static final String CLOUD = "cloud";
    private static final String SVNLOGINCLOUDCALLBACK = "svnlogincloudcallback";
    private static final String P = "password";
    private static final String SVNLOGINCALLBACK = "svnlogincallback";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized JSONObject checkIn(String bizAppId, String checkinType, String svnPath, String localPath, String userName, String passWord, String annotation, boolean checkinappFlag, List<String> bizIds, List<String> scriptIds) {
        boolean appFlag;
        File traceIdFile;
        File appNumberFile;
        String filePath;
        String traceIdPath;
        JSONObject checkInMsg;
        block22: {
            String appNumber;
            SVNCodeHostingServiceImpl service;
            block21: {
                boolean appFlag2;
                File traceIdFile2;
                checkInMsg = new JSONObject();
                service = new SVNCodeHostingServiceImpl();
                traceIdPath = null;
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                appNumber = appMeta.getNumber();
                Map checkPath = service.checkSvnPath(svnPath + "/metadata", userName, passWord);
                String checkPathMsg = (String)checkPath.get(MESSAGE);
                if (!"failed".equals(checkPathMsg)) break block21;
                checkInMsg.put(NOPATH, (Object)NOPATH);
                JSONObject jSONObject = checkInMsg;
                if (traceIdPath == null || !(traceIdFile2 = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return jSONObject;
                AppUtils.deleteKd((File)traceIdFile2);
                String filePath2 = FileUtils.cleanString((String)localPath);
                File appNumberFile2 = new File(filePath2);
                if (appNumberFile2.listFiles().length != 0 || !(appFlag2 = appNumberFile2.delete())) return jSONObject;
                logger.debug(appNumberFile2 + "delete:" + appFlag2);
                return jSONObject;
            }
            try {
                File[] files;
                Map checkoutMap;
                String checkoutMsg;
                Map checkAppPath;
                String checkAppMsg;
                int i;
                traceIdPath = localPath + File.separator + RequestContext.get().getTraceId();
                String metadataPath = traceIdPath + File.separator + "metadata";
                String filePath3 = FileUtils.cleanString((String)metadataPath);
                File metadataFile = new File(filePath3);
                metadataFile.mkdirs();
                String expPath = localPath + File.separator + RequestContext.get().getTraceId();
                if (APP_TYPE.equals(checkinType)) {
                    if (bizIds != null && bizIds.size() > 0) {
                        for (i = 0; i < bizIds.size(); ++i) {
                            String pageId = bizIds.get(i);
                            DevportalUtil.expFormMetadata(pageId, expPath, "CHECKIN_PAGE");
                        }
                    }
                    if (scriptIds != null && scriptIds.size() > 0) {
                        for (i = 0; i < scriptIds.size(); ++i) {
                            String scriptId = scriptIds.get(i);
                            DevportalUtil.expScriptMeta(scriptId, expPath);
                        }
                    }
                } else {
                    for (i = 0; i < bizIds.size(); ++i) {
                        String bizId = bizIds.get(i);
                        if ("PAGE_TYPE".equals(checkinType)) {
                            DevportalUtil.expFormMetadata(bizId, expPath, "CHECKIN_PAGE");
                            continue;
                        }
                        if (!"SCRIPT_TYPE".equals(checkinType)) continue;
                        DevportalUtil.expScriptMeta(bizId, expPath);
                    }
                }
                if ("failed".equals(checkAppMsg = (String)(checkAppPath = service.checkSvnPath(svnPath + "/metadata/" + appNumber.toLowerCase() + ".app", userName, passWord)).get(MESSAGE)) || checkinappFlag) {
                    DevportalUtil.expAppMetadata(bizAppId, expPath, "CHECKIN_PAGE");
                }
                if ("success".equals(checkoutMsg = (String)(checkoutMap = service.checkoutAppMetadata(metadataFile, svnPath = svnPath + "/metadata", files = metadataFile.listFiles(), userName, passWord)).get(MESSAGE))) {
                    Map commitMap = service.commitAppMetadata(metadataFile, svnPath, userName, passWord, annotation);
                    String commitMsg = (String)commitMap.get(MESSAGE);
                    if ("success".equals(commitMsg)) {
                        String commitResult;
                        Object commitInfo;
                        checkInMsg.put("SUCCESS", (Object)"SUCCESS");
                        Map commitResultMap = (Map)commitMap.get(RESULT);
                        if (commitResultMap != null && (commitInfo = commitResultMap.get(COMMITINFO)) != null && "EMPTY COMMIT".equals(commitResult = commitResultMap.get(COMMITINFO).toString())) {
                            checkInMsg.put("EMPTY COMMIT", (Object)"EMPTY COMMIT");
                        }
                    } else {
                        Map resultMap = (Map)commitMap.get(RESULT);
                        if (resultMap != null) {
                            String result = (String)resultMap.get(COMMITINFO);
                            checkInMsg.put("ERROR", (Object)result);
                        }
                    }
                    break block22;
                }
                Map resultMap = (Map)checkoutMap.get(RESULT);
                if (resultMap == null) break block22;
                String result = (String)resultMap.get("checkVal");
                checkInMsg.put("ERROR", (Object)result);
            }
            catch (NullPointerException exception) {
                boolean appFlag3;
                File traceIdFile3;
                logger.error((Throwable)exception);
                checkInMsg.put("ERROR", (Object)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7528\u6237\u540d\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"SVNManageUtil_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                if (traceIdPath == null || !(traceIdFile3 = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return checkInMsg;
                AppUtils.deleteKd((File)traceIdFile3);
                filePath = FileUtils.cleanString((String)localPath);
                appNumberFile = new File(filePath);
                if (appNumberFile.listFiles().length != 0 || !(appFlag3 = appNumberFile.delete())) return checkInMsg;
                logger.debug(appNumberFile + "delete:" + appFlag3);
                return checkInMsg;
            }
            catch (Exception exception2) {
                boolean appFlag4;
                File traceIdFile4;
                logger.error((Throwable)exception2);
                checkInMsg.put("ERROR", (Object)exception2.getMessage());
                {
                    catch (Throwable throwable) {
                        boolean appFlag5;
                        File traceIdFile5;
                        if (traceIdPath == null || !(traceIdFile5 = new File(traceIdPath = FileUtils.cleanString(traceIdPath))).exists()) throw throwable;
                        AppUtils.deleteKd((File)traceIdFile5);
                        String filePath4 = FileUtils.cleanString((String)localPath);
                        File appNumberFile3 = new File(filePath4);
                        if (appNumberFile3.listFiles().length != 0 || !(appFlag5 = appNumberFile3.delete())) throw throwable;
                        logger.debug(appNumberFile3 + "delete:" + appFlag5);
                        throw throwable;
                    }
                }
                if (traceIdPath == null || !(traceIdFile4 = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return checkInMsg;
                AppUtils.deleteKd((File)traceIdFile4);
                filePath = FileUtils.cleanString((String)localPath);
                appNumberFile = new File(filePath);
                if (appNumberFile.listFiles().length != 0 || !(appFlag4 = appNumberFile.delete())) return checkInMsg;
                logger.debug(appNumberFile + "delete:" + appFlag4);
                return checkInMsg;
            }
        }
        if (traceIdPath == null || !(traceIdFile = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return checkInMsg;
        AppUtils.deleteKd((File)traceIdFile);
        filePath = FileUtils.cleanString((String)localPath);
        appNumberFile = new File(filePath);
        if (appNumberFile.listFiles().length != 0 || !(appFlag = appNumberFile.delete())) return checkInMsg;
        logger.debug(appNumberFile + "delete:" + appFlag);
        return checkInMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized JSONObject checkIn(String bizAppId, String checkinType, String svnPath, String localPath, String userName, String passWord, String annotation, boolean checkinappFlag, List<String> bizIds, List<String> scriptIds, Map<String, String> pageUnits) {
        boolean appFlag;
        File traceIdFile;
        File appNumberFile;
        String filePath;
        String traceIdPath;
        JSONObject checkInMsg;
        block22: {
            String appNumber;
            SVNCodeHostingServiceImpl service;
            block21: {
                boolean appFlag2;
                File traceIdFile2;
                checkInMsg = new JSONObject();
                service = new SVNCodeHostingServiceImpl();
                traceIdPath = null;
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                appNumber = appMeta.getNumber();
                Map checkPath = service.checkSvnPath(svnPath + "/metadata", userName, passWord);
                String checkPathMsg = (String)checkPath.get(MESSAGE);
                if (!"failed".equals(checkPathMsg)) break block21;
                checkInMsg.put(NOPATH, (Object)NOPATH);
                JSONObject jSONObject = checkInMsg;
                if (traceIdPath == null || !(traceIdFile2 = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return jSONObject;
                AppUtils.deleteKd((File)traceIdFile2);
                String filePath2 = FileUtils.cleanString((String)localPath);
                File appNumberFile2 = new File(filePath2);
                if (appNumberFile2.listFiles().length != 0 || !(appFlag2 = appNumberFile2.delete())) return jSONObject;
                logger.debug(appNumberFile2 + "delete:" + appFlag2);
                return jSONObject;
            }
            try {
                File[] files;
                Map checkoutMap;
                String checkoutMsg;
                Map checkAppPath;
                String checkAppMsg;
                int i;
                traceIdPath = localPath + File.separator + RequestContext.get().getTraceId();
                String metadataPath = traceIdPath + File.separator + "metadata";
                String filePath3 = FileUtils.cleanString((String)metadataPath);
                File metadataFile = new File(filePath3);
                metadataFile.mkdirs();
                String expPath = localPath + File.separator + RequestContext.get().getTraceId();
                if (APP_TYPE.equals(checkinType)) {
                    if (bizIds != null && bizIds.size() > 0) {
                        for (i = 0; i < bizIds.size(); ++i) {
                            String pageId = bizIds.get(i);
                            String unitId = pageUnits.get(pageId);
                            DevportalUtil.expFormMetadata(pageId, bizAppId, unitId, expPath, "CHECKIN_PAGE");
                        }
                    }
                    if (scriptIds != null && scriptIds.size() > 0) {
                        for (i = 0; i < scriptIds.size(); ++i) {
                            String scriptId = scriptIds.get(i);
                            DevportalUtil.expScriptMeta(scriptId, expPath);
                        }
                    }
                } else {
                    for (i = 0; i < bizIds.size(); ++i) {
                        String bizId = bizIds.get(i);
                        if ("PAGE_TYPE".equals(checkinType)) {
                            DevportalUtil.expFormMetadata(bizId, expPath, "CHECKIN_PAGE");
                            continue;
                        }
                        if (!"SCRIPT_TYPE".equals(checkinType)) continue;
                        DevportalUtil.expScriptMeta(bizId, expPath);
                    }
                }
                if ("failed".equals(checkAppMsg = (String)(checkAppPath = service.checkSvnPath(svnPath + "/metadata/" + appNumber.toLowerCase() + ".app", userName, passWord)).get(MESSAGE)) || checkinappFlag) {
                    DevportalUtil.expAppMetadata(bizAppId, expPath, "CHECKIN_PAGE");
                }
                if ("success".equals(checkoutMsg = (String)(checkoutMap = service.checkoutAppMetadata(metadataFile, svnPath = svnPath + "/metadata", files = metadataFile.listFiles(), userName, passWord)).get(MESSAGE))) {
                    Map commitMap = service.commitAppMetadata(metadataFile, svnPath, userName, passWord, annotation);
                    String commitMsg = (String)commitMap.get(MESSAGE);
                    if ("success".equals(commitMsg)) {
                        String commitResult;
                        Object commitInfo;
                        checkInMsg.put("SUCCESS", (Object)"SUCCESS");
                        Map commitResultMap = (Map)commitMap.get(RESULT);
                        if (commitResultMap != null && (commitInfo = commitResultMap.get(COMMITINFO)) != null && "EMPTY COMMIT".equals(commitResult = commitResultMap.get(COMMITINFO).toString())) {
                            checkInMsg.put("EMPTY COMMIT", (Object)"EMPTY COMMIT");
                        }
                    } else {
                        Map resultMap = (Map)commitMap.get(RESULT);
                        if (resultMap != null) {
                            String result = (String)resultMap.get(COMMITINFO);
                            checkInMsg.put("ERROR", (Object)result);
                        }
                    }
                    break block22;
                }
                Map resultMap = (Map)checkoutMap.get(RESULT);
                if (resultMap == null) break block22;
                String result = (String)resultMap.get("checkVal");
                checkInMsg.put("ERROR", (Object)result);
            }
            catch (NullPointerException exception) {
                boolean appFlag3;
                File traceIdFile3;
                logger.error((Throwable)exception);
                checkInMsg.put("ERROR", (Object)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7528\u6237\u540d\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"SVNManageUtil_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                if (traceIdPath == null || !(traceIdFile3 = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return checkInMsg;
                AppUtils.deleteKd((File)traceIdFile3);
                filePath = FileUtils.cleanString((String)localPath);
                appNumberFile = new File(filePath);
                if (appNumberFile.listFiles().length != 0 || !(appFlag3 = appNumberFile.delete())) return checkInMsg;
                logger.debug(appNumberFile + "delete:" + appFlag3);
                return checkInMsg;
            }
            catch (Exception exception2) {
                boolean appFlag4;
                File traceIdFile4;
                logger.error((Throwable)exception2);
                checkInMsg.put("ERROR", (Object)exception2.getMessage());
                {
                    catch (Throwable throwable) {
                        boolean appFlag5;
                        File traceIdFile5;
                        if (traceIdPath == null || !(traceIdFile5 = new File(traceIdPath = FileUtils.cleanString(traceIdPath))).exists()) throw throwable;
                        AppUtils.deleteKd((File)traceIdFile5);
                        String filePath4 = FileUtils.cleanString((String)localPath);
                        File appNumberFile3 = new File(filePath4);
                        if (appNumberFile3.listFiles().length != 0 || !(appFlag5 = appNumberFile3.delete())) throw throwable;
                        logger.debug(appNumberFile3 + "delete:" + appFlag5);
                        throw throwable;
                    }
                }
                if (traceIdPath == null || !(traceIdFile4 = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return checkInMsg;
                AppUtils.deleteKd((File)traceIdFile4);
                filePath = FileUtils.cleanString((String)localPath);
                appNumberFile = new File(filePath);
                if (appNumberFile.listFiles().length != 0 || !(appFlag4 = appNumberFile.delete())) return checkInMsg;
                logger.debug(appNumberFile + "delete:" + appFlag4);
                return checkInMsg;
            }
        }
        if (traceIdPath == null || !(traceIdFile = new File(traceIdPath = FileUtils.cleanString((String)traceIdPath))).exists()) return checkInMsg;
        AppUtils.deleteKd((File)traceIdFile);
        filePath = FileUtils.cleanString((String)localPath);
        appNumberFile = new File(filePath);
        if (appNumberFile.listFiles().length != 0 || !(appFlag = appNumberFile.delete())) return checkInMsg;
        logger.debug(appNumberFile + "delete:" + appFlag);
        return checkInMsg;
    }

    public static void svnManage(String bizAppId, String bizAppNumber, String svnmsg, AbstractFormPlugin plugin) {
        block21: {
            String userId = RequestContext.get().getUserId();
            String userName = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(userId), (String)"bos_user", (String)"phone").getString("phone");
            String svnUrl = AppUtils.getSvnUrl();
            if (StringUtils.isNotBlank((CharSequence)svnUrl)) {
                QFilter[] filters = new QFilter[]{new QFilter(BIZAPPID, "=", (Object)bizAppId)};
                DynamicObject svnManage = BusinessDataServiceHelper.loadSingle((String)KEY_SVNMANAGE, (String)"id,svnserver,svnurl", (QFilter[])filters);
                String IPPOST = svnUrl.split("/svn")[0] + ":8080/";
                if (svnManage == null) {
                    String devInfo = AppUtils.getDeveloperInfo();
                    String SVNURL2 = svnUrl + devInfo + "/" + bizAppNumber;
                    try {
                        JSONObject app = SVNManagerUtil.doGet((String)(IPPOST + "rest/app.get?action=get.app&appId=" + bizAppId));
                        if (app != null && app.get((Object)RESULT) != null) {
                            boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)Long.parseLong(userId));
                            JSONObject data = SVNManagerUtil.doGet((String)(IPPOST + "rest/user.get?action=get.userbyappuser&userId=" + userName + "&appId=" + bizAppId));
                            if (data != null && data.get((Object)RESULT) != null && MANAGER.equals(data.getJSONObject(RESULT).getString("role"))) {
                                BillShowParameter parameter = new BillShowParameter();
                                parameter.getOpenStyle().setShowType(ShowType.Modal);
                                parameter.setCustomParam("type", (Object)MANAGER);
                                parameter.setStatus(OperationStatus.ADDNEW);
                                parameter.setFormId(KEY_SVNMANAGE);
                                parameter.setCaption(ResManager.loadKDString((String)"svn\u7ba1\u7406", (String)SVNMANAGEUTIL_1, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                parameter.setCustomParam(USERNAME, (Object)userName);
                                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                                parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                                parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                                parameter.setCustomParam(SVN_URL, (Object)SVNURL2);
                                parameter.setCustomParam(IP_POST, (Object)IPPOST);
                                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                                plugin.getView().showForm((FormShowParameter)parameter);
                            } else if (isAdminUser) {
                                BillShowParameter parameter = new BillShowParameter();
                                parameter.getOpenStyle().setShowType(ShowType.Modal);
                                parameter.setCustomParam("type", (Object)"supermanager");
                                parameter.setStatus(OperationStatus.ADDNEW);
                                parameter.setFormId(KEY_SVNMANAGE);
                                parameter.setCaption(ResManager.loadKDString((String)"svn\u7ba1\u7406", (String)SVNMANAGEUTIL_1, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                parameter.setCustomParam(USERNAME, (Object)userName);
                                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                                parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                                parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                                parameter.setCustomParam(SVN_URL, (Object)SVNURL2);
                                parameter.setCustomParam(IP_POST, (Object)IPPOST);
                                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                                plugin.getView().showForm((FormShowParameter)parameter);
                            } else if (data != null && data.get((Object)RESULT) != null && "rember".equals(data.getJSONObject(RESULT).getString("role"))) {
                                FormShowParameter parameter = new FormShowParameter();
                                parameter.getOpenStyle().setShowType(ShowType.Modal);
                                parameter.setCustomParam("type", (Object)"user");
                                parameter.setFormId(SVNINFO);
                                parameter.setCaption(ResManager.loadKDString((String)"svn\u4fe1\u606f", (String)SVNMANAGEUTIL_2, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                parameter.setCustomParam(USERNAME, (Object)userName);
                                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                                parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                                parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                                parameter.setCustomParam(SVN_URL, (Object)SVNURL2);
                                parameter.setCustomParam(IP_POST, (Object)IPPOST);
                                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                                plugin.getView().showForm(parameter);
                            } else {
                                FormShowParameter parameter = new FormShowParameter();
                                parameter.getOpenStyle().setShowType(ShowType.Modal);
                                parameter.setCustomParam("type", (Object)"unuser");
                                parameter.setFormId(SVNINFO);
                                parameter.setCaption(ResManager.loadKDString((String)"svn\u4fe1\u606f", (String)SVNMANAGEUTIL_2, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                parameter.setCustomParam(USERNAME, (Object)userName);
                                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                                parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                                parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                                parameter.setCustomParam(SVN_URL, (Object)SVNURL2);
                                parameter.setCustomParam(IP_POST, (Object)IPPOST);
                                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                                plugin.getView().showForm(parameter);
                            }
                            break block21;
                        }
                        BillShowParameter parameter = new BillShowParameter();
                        parameter.getOpenStyle().setShowType(ShowType.Modal);
                        parameter.setCustomParam("type", (Object)"addnew");
                        parameter.setStatus(OperationStatus.ADDNEW);
                        parameter.setFormId(KEY_SVNMANAGE);
                        parameter.setCaption(ResManager.loadKDString((String)"svn\u7ba1\u7406", (String)SVNMANAGEUTIL_1, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                        parameter.setCustomParam(USERNAME, (Object)userName);
                        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                        parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                        parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                        parameter.setCustomParam(SVN_URL, (Object)SVNURL2);
                        parameter.setCustomParam(IP_POST, (Object)IPPOST);
                        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                        plugin.getView().showForm((FormShowParameter)parameter);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        SVNManageUtil.openCustomSvnManage(userName, bizAppId, bizAppNumber, svnmsg, plugin);
                    }
                } else {
                    String svnServer = svnManage.getString("svnserver");
                    if ("nextserver".equals(svnServer)) {
                        String path = svnManage.getString(SVN_URL);
                        String SVNURL3 = svnUrl + path;
                        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)Long.parseLong(userId));
                        try {
                            JSONObject data = SVNManagerUtil.doGet((String)(IPPOST + "rest/user.get?action=get.userbyappuser&userId=" + userName + "&appId=" + bizAppId));
                            if (data != null && data.get((Object)RESULT) != null && MANAGER.equals(data.getJSONObject(RESULT).getString("role"))) {
                                BillShowParameter parameter = new BillShowParameter();
                                parameter.getOpenStyle().setShowType(ShowType.Modal);
                                parameter.setCustomParam("type", (Object)MANAGER);
                                parameter.setStatus(OperationStatus.EDIT);
                                parameter.setPkId((Object)svnManage.getString("id"));
                                parameter.setFormId(KEY_SVNMANAGE);
                                parameter.setCaption(ResManager.loadKDString((String)"svn\u7ba1\u7406", (String)SVNMANAGEUTIL_1, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                parameter.setCustomParam(USERNAME, (Object)userName);
                                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                                parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                                parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                                parameter.setCustomParam(SVN_URL, (Object)SVNURL3);
                                parameter.setCustomParam(IP_POST, (Object)IPPOST);
                                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                                plugin.getView().showForm((FormShowParameter)parameter);
                                break block21;
                            }
                            if (isAdminUser) {
                                BillShowParameter parameter = new BillShowParameter();
                                parameter.getOpenStyle().setShowType(ShowType.Modal);
                                parameter.setCustomParam("type", (Object)"supermanager");
                                parameter.setStatus(OperationStatus.EDIT);
                                parameter.setPkId((Object)svnManage.getString("id"));
                                parameter.setFormId(KEY_SVNMANAGE);
                                parameter.setCaption(ResManager.loadKDString((String)"svn\u7ba1\u7406", (String)SVNMANAGEUTIL_1, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                parameter.setCustomParam(USERNAME, (Object)userName);
                                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                                parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                                parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                                parameter.setCustomParam(SVN_URL, (Object)SVNURL3);
                                parameter.setCustomParam(IP_POST, (Object)IPPOST);
                                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                                plugin.getView().showForm((FormShowParameter)parameter);
                                break block21;
                            }
                            if (data != null && data.get((Object)RESULT) != null && "rember".equals(data.getJSONObject(RESULT).getString("role"))) {
                                FormShowParameter parameter = new FormShowParameter();
                                parameter.getOpenStyle().setShowType(ShowType.Modal);
                                parameter.setCustomParam("type", (Object)"user");
                                parameter.setFormId(SVNINFO);
                                parameter.setCaption(ResManager.loadKDString((String)"svn\u4fe1\u606f", (String)SVNMANAGEUTIL_2, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                parameter.setCustomParam(USERNAME, (Object)userName);
                                parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                                parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                                parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                                parameter.setCustomParam(SVN_URL, (Object)SVNURL3);
                                parameter.setCustomParam(IP_POST, (Object)IPPOST);
                                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                                plugin.getView().showForm(parameter);
                                break block21;
                            }
                            FormShowParameter parameter = new FormShowParameter();
                            parameter.getOpenStyle().setShowType(ShowType.Modal);
                            parameter.setCustomParam("type", (Object)"unuser");
                            parameter.setFormId(SVNINFO);
                            parameter.setCaption(ResManager.loadKDString((String)"svn\u4fe1\u606f", (String)SVNMANAGEUTIL_2, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                            parameter.setCustomParam(USERNAME, (Object)userName);
                            parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                            parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                            parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                            parameter.setCustomParam(SVN_URL, (Object)SVNURL3);
                            parameter.setCustomParam(IP_POST, (Object)IPPOST);
                            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                            plugin.getView().showForm(parameter);
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                            SVNManageUtil.openCustomSvnManage(userName, bizAppId, bizAppNumber, svnmsg, plugin);
                        }
                    } else if ("customserver".equals(svnServer) || svnServer.trim().length() == 0) {
                        String SVNURL4 = svnUrl + AppUtils.getDeveloperInfo() + "/" + bizAppNumber;
                        BillShowParameter parameter = new BillShowParameter();
                        parameter.getOpenStyle().setShowType(ShowType.Modal);
                        parameter.setCustomParam("type", (Object)"custom");
                        parameter.setStatus(OperationStatus.EDIT);
                        parameter.setPkId((Object)svnManage.getString("id"));
                        parameter.setFormId(KEY_SVNMANAGE);
                        parameter.setCaption(ResManager.loadKDString((String)"svn\u7ba1\u7406", (String)SVNMANAGEUTIL_1, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                        parameter.setCustomParam(USERNAME, (Object)userName);
                        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
                        parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
                        parameter.setCustomParam(SVNMSG, (Object)svnmsg);
                        parameter.setCustomParam(SVN_URL, (Object)SVNURL4);
                        parameter.setCustomParam(IP_POST, (Object)IPPOST);
                        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
                        plugin.getView().showForm((FormShowParameter)parameter);
                    }
                }
            } else {
                SVNManageUtil.openCustomSvnManage(userName, bizAppId, bizAppNumber, svnmsg, plugin);
            }
        }
    }

    private static void openCustomSvnManage(String userName, String bizAppId, String bizAppNumber, String svnmsg, AbstractFormPlugin plugin) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("type", (Object)"onlycustom");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId(KEY_SVNMANAGE);
        parameter.setCaption(ResManager.loadKDString((String)"svn\u7ba1\u7406", (String)SVNMANAGEUTIL_1, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam(USERNAME, (Object)userName);
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(BIZAPPNUMBER, (Object)bizAppNumber);
        parameter.setCustomParam(SVNMSG, (Object)svnmsg);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, SVNMANAGECALLBACK));
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void checkinMsg(JSONObject checkInReturnMsg, String jsessionId, IFormView formView, boolean isChecked) {
        checkInReturnMsg.put(SVNMSG, (Object)jsessionId);
        if (StringUtils.isNotBlank((Object)checkInReturnMsg.get((Object)"CONFLICT"))) {
            formView.showTipNotification((String)checkInReturnMsg.get((Object)"CONFLICT"));
            if (isChecked) {
                ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction(SAVE_JSESSION_ID, (Object)checkInReturnMsg);
            }
        } else if (StringUtils.isNotBlank((Object)checkInReturnMsg.get((Object)"ERROR"))) {
            String authenticationError = (String)checkInReturnMsg.get((Object)"ERROR");
            if (authenticationError.contains("Authentication required")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u8d26\u53f7\u6743\u9650\u3002", (String)"SVNManageUtil_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                formView.showErrorNotification((String)checkInReturnMsg.get((Object)"ERROR"));
            }
            checkInReturnMsg.clear();
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction(SAVE_JSESSION_ID, (Object)checkInReturnMsg);
        } else if (StringUtils.isNotBlank((Object)checkInReturnMsg.get((Object)"EMPTY COMMIT"))) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5143\u6570\u636e\u65e0\u53d8\u5316\uff0c\u65e0\u9700\u8fc1\u5165\u3002", (String)"SVNManageUtil_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            if (isChecked) {
                ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction(SAVE_JSESSION_ID, (Object)checkInReturnMsg);
            }
        } else if (StringUtils.isNotBlank((Object)checkInReturnMsg.get((Object)"SUCCESS"))) {
            formView.showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u5165\u6210\u529f\u3002", (String)"SVNManageUtil_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
            if (isChecked) {
                ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction(SAVE_JSESSION_ID, (Object)checkInReturnMsg);
            }
        }
    }

    public static void svnLoginCallBackView(String bizAppId, String bizId, String checkinType, IFormView formView, AbstractFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_svnchoose");
        parameter.setCaption(ResManager.loadKDString((String)"\u7b7e\u5165SVN", (String)"SVNManageUtil_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        if (StringUtils.isNotBlank((CharSequence)bizId)) {
            parameter.setCustomParam("bizid", (Object)bizId);
        }
        parameter.setCustomParam("type", (Object)checkinType);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)plugin, "svncheckincallback");
        parameter.setCloseCallBack(callBack);
        formView.showForm(parameter);
    }

    public static void checkinCloud(JSONObject arg, AbstractFormPlugin plugin, String bizAppId) {
        String bizCloudId = arg.getString("bizcloudid");
        String bizCloudNumber = arg.getString("bizcloudnumber");
        String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728SVN\u7ba1\u7406\u4e2d\u914d\u7f6e\u57fa\u7840\u5e94\u7528\u7684SVN\u8def\u5f84\u3002", (String)"SVNManageUtil_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String svnSessionId = arg.getString("svnsessionid");
        HashMap<String, String> svnInfo = new HashMap<String, String>(16);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        CloseCallBack callBack = null;
        if (StringUtils.isBlank((CharSequence)svnSessionId) || "undefined".equals(svnSessionId) || "null".equals(svnSessionId)) {
            svnSessionId = UUID.randomUUID().toString();
            parameter.setFormId(BOS_DEVP_SVNLOGIN);
            parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)SVNMANAGEUTIL_12, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("type", (Object)CLOUD);
            callBack = new CloseCallBack((IFormPlugin)plugin, SVNLOGINCLOUDCALLBACK);
        } else {
            String sessionKey;
            SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)svnSessionId);
            String loginInfo = sessionDao.getAttribute(sessionKey = AppUtils.getSessionKey((String)svnPath, (String)svnSessionId));
            if (StringUtils.isBlank((CharSequence)loginInfo)) {
                parameter.setFormId(BOS_DEVP_SVNLOGIN);
                parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)SVNMANAGEUTIL_12, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("type", (Object)CLOUD);
                callBack = new CloseCallBack((IFormPlugin)plugin, SVNLOGINCLOUDCALLBACK);
            } else {
                JSONObject userLogin = JSONObject.parseObject((String)loginInfo);
                String userName = userLogin.getString(USERNAME);
                String passWord = userLogin.getString(P);
                if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
                    parameter.setFormId(BOS_DEVP_SVNLOGIN);
                    parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)SVNMANAGEUTIL_12, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setCustomParam("type", (Object)CLOUD);
                    callBack = new CloseCallBack((IFormPlugin)plugin, SVNLOGINCLOUDCALLBACK);
                } else {
                    svnInfo.put(USERNAME, userName);
                    svnInfo.put(P, passWord);
                    parameter.setCaption(String.format(ResManager.loadKDString((String)"\u7b7e\u5165\u4e1a\u52a1\u4e91\"%s\"", (String)"SVNManageUtil_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizCloudNumber));
                    parameter.setFormId("bos_devp_svndiff");
                    parameter.setPageId(UUID.randomUUID().toString());
                    HashMap<String, String> customMap = new HashMap<String, String>(16);
                    customMap.put(BIZAPPID, bizAppId);
                    customMap.put("id", bizCloudId);
                    customMap.put("type", CLOUD);
                    customMap.put("svnpath", svnPath);
                    customMap.put("oldversion", "locale");
                    customMap.put("newversion", "head");
                    customMap.put("scene", CLOUD);
                    parameter.setCustomParams(customMap);
                    OpenStyle style = new OpenStyle();
                    StyleCss cssStyle = new StyleCss();
                    cssStyle.setHeight("760");
                    cssStyle.setWidth("1200");
                    style.setInlineStyleCss(cssStyle);
                    style.setShowType(ShowType.Modal);
                    parameter.setOpenStyle(style);
                }
            }
        }
        svnInfo.put("svnsessionid", svnSessionId);
        svnInfo.put(BIZAPPID, bizAppId);
        svnInfo.put("cloudnumber", bizCloudNumber);
        svnInfo.put("cloudid", bizCloudId);
        plugin.getPageCache().put(svnInfo);
        if (callBack != null) {
            parameter.setCloseCallBack(callBack);
        }
        plugin.getView().showForm(parameter);
    }

    public static void checkInApp(JSONObject arg, AbstractFormPlugin plugin) {
        String bizAppId = arg.getString(BIZAPPID);
        if (!AppUtils.checkResourceBelongsToCurDeveloper((String)bizAppId)) {
            plugin.getView().showTipNotification(DevportalUtil.getNoPermissionTip());
            return;
        }
        String svnPath = AppUtils.getSVNPathByAppId((String)bizAppId);
        if (StringUtils.isBlank((CharSequence)svnPath)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728svn\u7ba1\u7406\u4e2d\u914d\u7f6esvn\u8def\u5f84\u3002", (String)"SVNManageUtil_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String jsessionId = arg.getString(SVNMSG);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = null;
        if (StringUtils.isBlank((CharSequence)jsessionId) || "undefined".equals(jsessionId) || "null".equals(jsessionId)) {
            jsessionId = UUID.randomUUID().toString();
            parameter.setFormId(BOS_DEVP_SVNLOGIN);
            parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)SVNMANAGEUTIL_12, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            callBack = new CloseCallBack((IFormPlugin)plugin, SVNLOGINCALLBACK);
        } else {
            String sessionKey;
            SessionDAO sessionDao = SessionDAOFactory.getSessionDAO((String)jsessionId);
            String loginInfo = sessionDao.getAttribute(sessionKey = AppUtils.getSessionKey((String)svnPath, (String)jsessionId));
            if (StringUtils.isBlank((CharSequence)loginInfo)) {
                parameter.setFormId(BOS_DEVP_SVNLOGIN);
                parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)SVNMANAGEUTIL_12, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                callBack = new CloseCallBack((IFormPlugin)plugin, SVNLOGINCALLBACK);
            } else {
                JSONObject userLogin = JSONObject.parseObject((String)loginInfo);
                String userName = userLogin.getString(USERNAME);
                String passWord = userLogin.getString(P);
                if (StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)passWord)) {
                    parameter.setFormId(BOS_DEVP_SVNLOGIN);
                    parameter.setCaption(ResManager.loadKDString((String)"\u767b\u5f55SVN", (String)SVNMANAGEUTIL_12, (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    callBack = new CloseCallBack((IFormPlugin)plugin, SVNLOGINCALLBACK);
                } else {
                    plugin.getPageCache().put(USERNAME, userName);
                    plugin.getPageCache().put(P, passWord);
                    parameter.setFormId("bos_devp_svnchoose");
                    parameter.setCaption(ResManager.loadKDString((String)"\u7b7e\u5165SVN", (String)"SVNManageUtil_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    parameter.setCustomParam("type", (Object)APP_TYPE);
                    callBack = new CloseCallBack((IFormPlugin)plugin, "svncheckincallback");
                }
            }
        }
        plugin.getPageCache().put("jsessionid", jsessionId);
        plugin.getPageCache().put(BIZAPPID, bizAppId);
        plugin.getPageCache().put("checkintype", APP_TYPE);
        parameter.setCloseCallBack(callBack);
        plugin.getView().showForm(parameter);
    }
}

