/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.lang.LangWriter;

public class GetAppMultiLangFileApiService
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(GetAppMultiLangFileApiService.class);
    private List<String> tlangs;
    private String slang = "zh_CN";
    private MetadataSerializer serializer;

    public ApiResult doCustomService(Map<String, Object> params) {
        String id = (String)params.get("appid");
        this.tlangs = (List)params.get("langs");
        if (this.tlangs == null) {
            this.tlangs = new ArrayList<String>();
        }
        HashSet<String> tlangSet = new HashSet<String>(this.tlangs);
        this.slang = params.get("sourceLang") == null ? "zh_CN" : params.get("sourceLang").toString();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("id", id);
            map.put("ver", Long.valueOf(System.currentTimeMillis()).toString());
            List<DeployFile> list = this.getAppDeployFile(id);
            for (DeployFile file : list) {
                String localeId;
                String[] name = file.getFileName().split("\\.");
                if (name.length == 2) {
                    localeId = "main";
                    map.put(localeId, file.getFileContent());
                    continue;
                }
                localeId = name[1];
                if (tlangSet.size() <= 0 || !tlangSet.contains(localeId)) continue;
                map.put(localeId, file.getFileContent());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"GetAppMultiLangFileApiService_0", (String)"bos-devportal-webapi", (Object[])new Object[0]), e.getMessage()));
        }
        return ApiResult.success((Object)SerializationUtils.toJsonString(map));
    }

    private List<DeployFile> getAppDeployFile(String id) {
        AppMetadata appMeta = AppReader.loadMeta((String)id, (boolean)true);
        if (appMeta == null) {
            return Collections.emptyList();
        }
        this.serializer = new MetadataSerializer(appMeta.getModelType());
        LangWriter writer = new LangWriter(this.serializer.getBinder(), (Object)appMeta, new ArrayList());
        writer.setLoaceValue(this.tlangs);
        for (String tlang : this.tlangs) {
            writer.setNullLoaceValue(tlang, this.slang);
        }
        return this.getAppDeployFile(appMeta);
    }

    public List<DeployFile> getAppDeployFile(AppMetadata appMeta) {
        ArrayList<Object> designAppMetaLs = new ArrayList<Object>();
        DesignAppMeta designAppMeta = null;
        MetadataWriter writer = new MetadataWriter(appMeta.getModelType());
        List appDesigners = writer.convertToDesignMeta(new AbstractMetadata[]{appMeta});
        for (AbstractDesignMeta abstractDesignMeta : appDesigners) {
            if (abstractDesignMeta instanceof DesignAppMetaL) {
                designAppMetaLs.add(abstractDesignMeta);
                continue;
            }
            if (!(abstractDesignMeta instanceof DesignAppMeta)) continue;
            designAppMeta = (DesignAppMeta)abstractDesignMeta;
        }
        List<DeployFile> deployFileList = this.getAppDeployFile(designAppMeta, designAppMetaLs);
        if (deployFileList != null && deployFileList.size() > 0) {
            return deployFileList;
        }
        return Collections.emptyList();
    }

    private List<DeployFile> getAppDeployFile(DesignAppMeta designMeta, List<Object> designAppMetaLs) {
        if (designMeta == null) {
            return null;
        }
        String id = designMeta.getId();
        DeployAppMetadata deploy = new DeployAppMetadata();
        String masterId = "2".equals(designMeta.getDevType()) ? designMeta.getMasterId() : id;
        ArrayList<DeployFile> files = new ArrayList<DeployFile>(designAppMetaLs.size());
        HashMap designEntityMetaLMap = new HashMap();
        for (Object fm : designAppMetaLs) {
            DesignMetaL fmL = (DesignMetaL)fm;
            deploy = new DeployAppMetadata();
            deploy.setMasterId(masterId);
            deploy.setId(id);
            deploy.setVersion(designMeta.getVersion());
            deploy.getDesignMetas().add(fmL);
            AbstractDesignMeta emL = (AbstractDesignMeta)designEntityMetaLMap.get(fmL.getId() + "." + fmL.getLocaleId());
            if (emL != null) {
                deploy.getDesignMetas().add(emL);
            }
            files.add(deploy.toDeployFile(designMeta.getNumber().toLowerCase() + "." + fmL.getLocaleId() + ".appx"));
        }
        return files;
    }
}

