/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.common.GetFormInfosApiResult;
import kd.bos.devportal.util.DevportalDispatchServiceHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class GetDesigntimeAllFormIdsByAppIdApiService
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(GetDesigntimeAllFormIdsByAppIdApiService.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            Map checkResult;
            Object orgAuthorFilter;
            String urlFormat = "/app/devportal/getDesigntimeAllFormIdsByAppId";
            Object objResult = DispatchServiceHelper.invokeService((String)"kd.bos.openapi.servicehelper", (String)"bos", (String)"OpenApiEntityService", (String)"getUserConfig", (Object[])new Object[]{urlFormat});
            if (objResult instanceof Map && (orgAuthorFilter = (checkResult = (Map)objResult).get("org_author_filter")) instanceof Boolean && ((Boolean)orgAuthorFilter).booleanValue() && !this.isAdminUser() && !this.isHasRight()) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"GetDesigntimeAllFormIdsByAppIdApiService_0", (String)"bos-devportal-webapi", (Object[])new Object[0]));
            }
            if (Boolean.parseBoolean(String.valueOf(params.get("loadDetails")))) {
                List appids = (List)params.get("appIds");
                return GetFormInfosApiResult.success(this.getDetailData(appids.toArray()));
            }
            Object retData = DevportalDispatchServiceHelper.invokeBOSService("BizAppService", "getDesigntimeAllFormIdsByAppId", params.values().toArray());
            return ApiResult.success((Object)retData);
        }
        catch (Exception exp) {
            return ApiResult.ex((Throwable)exp);
        }
    }

    private Object getDetailData(Object[] appId) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])appId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_devportal_bizapp"));
        ArrayList<String> appIds = new ArrayList<String>(10);
        for (DynamicObject obj : objs) {
            String inheritpath = obj.getString("inheritpath");
            if (StringUtils.isNotBlank((CharSequence)inheritpath)) {
                String[] stringArray = inheritpath.split(",");
                appIds.addAll(Arrays.asList(stringArray));
            }
            appIds.add(obj.getPkValue().toString());
        }
        QFilter[] filters = new QFilter[]{new QFilter("bizappid", "in", (Object)appIds.toArray(new String[appIds.size()]))};
        Map formMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"number,bizappid,modeltype,version,inheritpath", (QFilter[])filters);
        HashSet<String> fromIds = new HashSet<String>(10);
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>(formMap.size());
        for (Map.Entry entry : formMap.entrySet()) {
            Map<String, String> info = new HashMap<String, String>(1);
            DynamicObject dyObj = (DynamicObject)entry.getValue();
            info.put("number", dyObj.getString("number"));
            info.put("appid", dyObj.getString("bizappid"));
            info.put("modelType", dyObj.getString("modeltype"));
            info.put("version", dyObj.getString("version"));
            String formInheritPath = dyObj.getString("inheritpath");
            info.put("inheritpath", formInheritPath);
            if (StringUtils.isNotBlank((CharSequence)formInheritPath)) {
                fromIds.addAll(Arrays.asList(formInheritPath.split(",")));
            }
            datas.add(info);
        }
        try {
            Map formNumberMap = BusinessDataServiceHelper.loadFromCache((Object[])fromIds.toArray(), (String)"bos_formmeta");
            for (Map<String, String> info : datas) {
                String formInheritPath = (String)info.get("inheritpath");
                if (!StringUtils.isNotBlank((CharSequence)formInheritPath)) continue;
                formInheritPath = Arrays.stream(formInheritPath.split(",")).filter(StringUtils::isNotBlank).map(form -> ((DynamicObject)formNumberMap.get(form)).getString("number")).collect(Collectors.joining(","));
                info.put("inheritpath", formInheritPath);
            }
        }
        catch (Exception e) {
            log.error("bos_formmeta\u5b9e\u4f53ID\u6620\u5c04bos_formmeta\u5b9e\u4f53number\u5931\u8d25: " + e.getMessage());
        }
        return datas;
    }

    private boolean isHasRight() {
        long userId = RequestContext.get().getCurrUserId();
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, null, (String)"pc_devportal_main", (String)"47150e89000000ac");
        return flag == 1;
    }

    private boolean isAdminUser() {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.isAdminUser((long)userId);
    }
}

