/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.util.PersonalSchemaTemplateUtil;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class GetPersonalizedAppInfoListApiService
implements IBillWebApiPlugin {
    private static final String USERCONFIGKEY = "appPersonalList";
    private static final String TENANTCONFIGKEY = "tenantPersonalList";

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            Map checkResult;
            Object orgAuthorFilter;
            String urlFormat = "/app/devportal/getPersonalizedAppInfoList";
            Object objResult = DispatchServiceHelper.invokeService((String)"kd.bos.openapi.servicehelper", (String)"bos", (String)"OpenApiEntityService", (String)"getUserConfig", (Object[])new Object[]{urlFormat});
            if (objResult instanceof Map && (orgAuthorFilter = (checkResult = (Map)objResult).get("org_author_filter")) instanceof Boolean && ((Boolean)orgAuthorFilter).booleanValue() && !this.isAdminUser() && !this.isHasRight()) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"GetPersonalizedAppInfoListApiService_0", (String)"bos-devportal-webapi", (Object[])new Object[0]));
            }
            JSONArray allAppsInSystem = BizAppServiceHelp.getAllAppInfo();
            JSONArray resultApps = this.getAppsAfterFilters(allAppsInSystem, true);
            ArrayList apps = new ArrayList();
            if (resultApps != null) {
                for (int i = 0; i < resultApps.size(); ++i) {
                    JSONArray cloudApps = resultApps.getJSONArray(i);
                    if (cloudApps == null || cloudApps.size() <= 0) continue;
                    JSONObject cloudObj = cloudApps.getJSONObject(0);
                    LocaleString categoryName = (LocaleString)SerializationUtils.fromJsonString((String)cloudObj.getString("name"), LocaleString.class);
                    String categoryId = cloudObj.getString("id");
                    for (int j = 1; j < cloudApps.size(); ++j) {
                        JSONObject appObj = cloudApps.getJSONObject(j);
                        String formId = appObj.getString("number");
                        String logoUrl = appObj.getString("image");
                        LocaleString formName = (LocaleString)SerializationUtils.fromJsonString((String)appObj.getString("name"), LocaleString.class);
                        HashMap<String, Object> app = new HashMap<String, Object>();
                        app.put("categoryName", categoryName);
                        app.put("categoryId", categoryId);
                        app.put("formId", formId);
                        app.put("formName", formName);
                        app.put("logoUrl", logoUrl);
                        apps.add(app);
                    }
                }
            }
            return ApiResult.success(apps);
        }
        catch (Exception exp) {
            return ApiResult.ex((Throwable)exp);
        }
    }

    private JSONArray getAppsAfterFilters(JSONArray allApps, boolean runtime) {
        List userBizApps;
        PersonalSchemaTemplateUtil personalSchemaTemplateUtil = new PersonalSchemaTemplateUtil();
        boolean hasPersonalApps = false;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (runtime) {
            JSONArray allPersonInfo;
            String personalApps = UserConfigServiceHelper.getSetting((long)userId, (String)USERCONFIGKEY);
            String tenantApps = UserConfigServiceHelper.getSetting((long)0L, (String)TENANTCONFIGKEY);
            if (StringUtils.isNotBlank((CharSequence)personalApps)) {
                if (personalApps != null) {
                    allApps = !personalApps.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") ? JSONArray.parseArray((String)personalApps) : (allPersonInfo = personalSchemaTemplateUtil.changePersonalSchemaInfoToJsonArray(allApps, personalApps));
                }
            } else if (StringUtils.isNotBlank((CharSequence)tenantApps)) {
                allApps = allPersonInfo = personalSchemaTemplateUtil.changePersonalSchemaInfoToJsonArray(allApps, tenantApps);
            }
        }
        if ((userBizApps = PermissionServiceHelper.getUserBizApps((Long)userId)) == null) {
            return allApps;
        }
        String userTypeInContext = RequestContext.get().getUserType();
        if (userTypeInContext == null) {
            return allApps;
        }
        String[] userType = userTypeInContext.split(",");
        ArrayList<String> userTypeList = new ArrayList<String>(Arrays.asList(userType));
        if (PermissionServiceHelper.isAdminUser((long)userId) || userId.equals(10L)) {
            userTypeList.add("1");
        }
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (userId.equals(10L)) {
            isSuperAdmin = true;
        }
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null || !this.filterApp(cloudOrApp, hasPersonalApps, userBizApps, userTypeList, isSuperAdmin)) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        return allApps;
    }

    private boolean filterApp(JSONObject appObject, boolean hasPersonalApps, List<String> userBizApps, List<String> userTypeList, boolean isSuperAdmin) {
        boolean isRemoveApp = false;
        String appId = appObject.getString("id");
        String allUserApp = appObject.getString("alluserapp");
        String[] appUserType = appObject.getString("usertype").split(",");
        ArrayList<String> appUserTypeList = new ArrayList<String>(Arrays.asList(appUserType));
        if (isSuperAdmin && allUserApp.equals("true")) {
            isRemoveApp = true;
        }
        if (!(isRemoveApp || userBizApps == null || userBizApps.contains(appId) || allUserApp.equals("true"))) {
            isRemoveApp = true;
        }
        Iterator<Object> iterator = appUserTypeList.iterator();
        while (iterator.hasNext()) {
            String appUserTypeId = (String)iterator.next();
            if (!StringUtils.isEmpty((CharSequence)appUserTypeId)) continue;
            iterator.remove();
        }
        iterator = userTypeList.iterator();
        while (iterator.hasNext()) {
            String userTypeId = (String)iterator.next();
            if (!StringUtils.isEmpty((CharSequence)userTypeId)) continue;
            iterator.remove();
        }
        if (!isRemoveApp && Collections.disjoint(appUserTypeList, userTypeList)) {
            isRemoveApp = true;
        }
        return isRemoveApp;
    }

    private boolean isHasRight() {
        long userId = RequestContext.get().getCurrUserId();
        int flag = PermissionServiceHelper.checkPermission((Long)userId, (Long)0L, null, (String)"pc_devportal_main", (String)"47150e89000000ac");
        return flag == 1;
    }

    private boolean isAdminUser() {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.isAdminUser((long)userId);
    }
}

