/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.designer.property.alias.PropertyConverterFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;

public class AbstractFormDesignerPlugin
extends AbstractFormPlugin
implements PropertyListener {
    public static final String BOS_MOBILEPREVIEW = "bos_mobilepreview";
    public static final String FORM_ID = "formId";
    public static final String PARAM_FORM = "form";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_CONTEXT = "context";
    public static final String PARAM_ITEM = "item";
    public static final String PARAM_ITEM_ID = "itemId";
    public static final String PARAM_MODEL_TYPE = "modelType";
    public static final String PARAM_META_TYPE = "metaType";
    public static final String PARAM_PROPERTY_NAME = "propertyName";
    public static final String PARAM_DESIGNER_MODEL_TYPE = "designermodeltype";
    public static final String PARAM_PROPERTY_EDIT = "propertyEdit";
    public static final String PREFIX_MOB = "Mob";
    public static final String PARAM_DESIGNER_PAGEID = "designerPageId";
    public static final String PARAM_MODEL_TYPE_1 = "modeltype";
    private static final String designerKey = "formdesigner";
    private static final String PREVIEWLANG = "preview_lang";
    private static final String JS_PLUGIN_TYPE = "14";

    protected String getDesignerKey() {
        return designerKey;
    }

    public void registerListener(EventObject e) {
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        designer.addPropertyButtonClickListener((PropertyListener)this);
    }

    private FormShowParameter createListShowParameter(Map<String, Object> openParameter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(openParameter.get(FORM_ID).toString());
        showParameter.setCustomParam("selectaction", (Object)"FieldEdit");
        StyleCss css = new StyleCss();
        if (openParameter.containsKey("width")) {
            css.setWidth(openParameter.get("width").toString());
        } else {
            css.setWidth("960px");
        }
        if (openParameter.containsKey("height")) {
            css.setWidth(openParameter.get("height").toString());
        } else {
            css.setHeight("580px");
        }
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)openParameter.get(FORM_ID).toString());
        showParameter.setFormId(formConfig.getF7ListFormId());
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setLookUp(true);
        boolean isMultiSelect = false;
        if (openParameter.containsKey("multiSelect") && openParameter.get("multiSelect").equals("true")) {
            isMultiSelect = true;
        }
        showParameter.setMultiSelect(isMultiSelect);
        showParameter.setShowTitle(false);
        if (openParameter.containsKey(PARAM_MODEL_TYPE_1)) {
            String formPara = openParameter.get(PARAM_MODEL_TYPE_1).toString();
            showParameter.setCustomParam(PARAM_MODEL_TYPE_1, (Object)formPara);
        } else if (openParameter.containsKey("listStyle")) {
            showParameter.setLookUp(false);
            showParameter.setFormId(formConfig.getListFormId());
        }
        return showParameter;
    }

    public void click(PropertyEvent e) {
        PropertyEditHelper.cachePropEventParam(this.getView(), e);
        Map clickParam = e.getParam();
        if (clickParam.containsKey("type") && "del".equalsIgnoreCase((String)clickParam.get("type"))) {
            this.deleteRefField(e);
        } else {
            FormShowParameter showParameter;
            Map openParameter = (Map)clickParam.get(PARAM_FORM);
            if (openParameter.containsKey("showType") && openParameter.get("showType").equals("ListType")) {
                showParameter = this.createListShowParameter(openParameter);
                if ("bos_devpn_stanardfield".equals(((ListShowParameter)showParameter).getBillFormId())) {
                    String itemId = e.getItemId();
                    Map param = e.getParam();
                    List fieldItems = (List)((List)param.get(PARAM_CONTEXT)).get(0);
                    for (Map fieldItem : fieldItems) {
                        Object refFieldObj;
                        if (!itemId.equals(fieldItem.get("Id")) || !((refFieldObj = fieldItem.get("RefField")) instanceof String) || !StringUtils.isNotBlank((CharSequence)((String)refFieldObj))) continue;
                        HashMap<String, String> paramMap = new HashMap<String, String>(5);
                        paramMap.put("RefField", (String)refFieldObj);
                        paramMap.put("ItemId", itemId);
                        paramMap.put("MetaType", "entitymeta");
                        this.getPageCache().put("delref", SerializationUtils.toJsonString(paramMap));
                    }
                }
            } else {
                showParameter = FormShowParameter.createFormShowParameter((Map)openParameter);
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(PARAM_ITEM_ID, (Object)e.getItemId());
            showParameter.setCustomParam(PARAM_DESIGNER_PAGEID, (Object)this.getView().getPageId());
            showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)this.getPageCache().get(PARAM_MODEL_TYPE));
            showParameter.setCustomParam(PARAM_META_TYPE, (Object)e.getMetaType());
            String propName = e.getPropertName();
            showParameter.setCustomParam(PARAM_PROPERTY_NAME, (Object)propName);
            if ("MustInputCondition".equals(propName)) {
                showParameter.setCaption(ResManager.loadKDString((String)"\u5fc5\u5f55\u6761\u4ef6\u8bbe\u7f6e", (String)"AbstractFormDesignerPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            }
            showParameter.setCustomParam(PARAM_VALUE, e.getParam().get(PARAM_VALUE));
            showParameter.setCustomParam(PARAM_CONTEXT, e.getParam().get(PARAM_CONTEXT));
            showParameter.setParentFormId(this.getPageCache().get("openformid"));
            if (openParameter.containsKey(PARAM_DESIGNER_MODEL_TYPE)) {
                showParameter.setClientParam(PARAM_MODEL_TYPE, openParameter.get(PARAM_DESIGNER_MODEL_TYPE));
                showParameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
            }
            if ("BasdataNumber".equals(e.getPropertName())) {
                showParameter.setHasRight(true);
            }
            String bizappid = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
            showParameter.setCustomParam("bizappid", (Object)bizappid);
            Object param = this.getView().getFormShowParameter().getCustomParam("bizext");
            if (StringUtils.isNotBlank((Object)param)) {
                showParameter.setCustomParam("bizext", param);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PARAM_PROPERTY_EDIT);
            closeCallBack.setControlKey(((Control)e.getSource()).getKey());
            showParameter.setCloseCallBack(closeCallBack);
            this.beforeShowPropertyEdit(e, showParameter);
            this.getView().showForm(showParameter);
        }
    }

    protected void beforeShowPropertyEdit(PropertyEvent e, FormShowParameter showParameter) {
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (PARAM_PROPERTY_EDIT.equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
            Object returnData = e.getReturnData();
            if (returnData instanceof List) {
                designer.setProperty((List)returnData);
            } else {
                designer.setProperty((Map)returnData);
            }
            PropertyEditHelper.clearPropEventParamCache(this.getView());
        }
    }

    public void getPropertyAlias(PropertyEvent e) {
        Map openParameter = (Map)e.getParam().get(PARAM_FORM);
        String formId = (String)openParameter.get(FORM_ID);
        IPropertyConverter cv = PropertyConverterFactory.create(formId);
        if (cv != null) {
            cv.setContext(e.getParam().get(PARAM_CONTEXT), e.getItemId());
            cv.setModelType(this.getPageCache().get(PARAM_MODEL_TYPE));
            Object value = e.getParam().get(PARAM_VALUE);
            Object alias = cv.convert(value);
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(PARAM_ITEM_ID, e.getItemId());
            para.put(PARAM_META_TYPE, e.getMetaType());
            para.put(PARAM_PROPERTY_NAME, e.getPropertName());
            para.put(PARAM_VALUE, value);
            para.put("alias", alias);
            FormDesigner designer = (FormDesigner)e.getSource();
            designer.setProperty(para);
        }
    }

    protected void preview(String formId, String modelType) {
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            HashMap<String, String> para = new HashMap<String, String>();
            String tempNumber = formId;
            if (modelType.startsWith(PREFIX_MOB)) {
                tempNumber = BOS_MOBILEPREVIEW;
            }
            para.put(FORM_ID, tempNumber);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            if (modelType.startsWith(PREFIX_MOB)) {
                showParameter.setCustomParam("number", (Object)formId);
                showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)modelType);
                showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
                showParameter.setClientParam("preview", (Object)"true");
            } else {
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
            }
            showParameter.setCustomParam("formConfigShowLang", (Object)this.getPreviewLang());
            this.getView().showForm(showParameter);
        }
    }

    protected Map<String, Object> fillBackInheritProperty(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        if (null == originMeta || originMeta.isEmpty() || null == needFillMeta || needFillMeta.isEmpty()) {
            return needFillMeta;
        }
        List items = (List)needFillMeta.get("Items");
        if (null == items) {
            return needFillMeta;
        }
        Map<String, Boolean> inheritMap = this.getInheritMap(originMeta);
        for (Map item : items) {
            String id = (String)item.get("Id");
            if (!StringUtils.isNotBlank((CharSequence)id) || !inheritMap.containsKey(id)) continue;
            item.put("Inherit", inheritMap.get(id));
        }
        return needFillMeta;
    }

    protected void switchPreviewLang(String lang) {
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            this.getPageCache().put(PREVIEWLANG, lang);
        }
    }

    protected String getPreviewLang() {
        String lang = this.getPageCache().get(PREVIEWLANG);
        return lang == null ? RequestContext.get().getLang().toString() : lang.toString();
    }

    private Map<String, Boolean> getInheritMap(Map<String, Object> meta) {
        HashMap<String, Boolean> inheritMap = new HashMap<String, Boolean>();
        if (null == meta || meta.isEmpty()) {
            return inheritMap;
        }
        List items = (List)meta.get("Items");
        if (null == items || items.isEmpty()) {
            return inheritMap;
        }
        items.stream().forEach(item -> {
            String id = (String)item.get("Id");
            Boolean inherit = (Boolean)item.get("Inherit");
            if (StringUtils.isNotBlank((CharSequence)id) && null != inherit) {
                inheritMap.put(id, inherit);
            }
        });
        return inheritMap;
    }

    protected void deleteRefField(PropertyEvent e) {
    }

    protected void restoreLang(AbstractMetadata metadata, List<Map<String, Map<String, Object>>> localeItems, String excludeLang) {
        if (localeItems == null || localeItems.isEmpty()) {
            return;
        }
        MetadataSerializer serializer = new MetadataSerializer(metadata.getModelType());
        LangWriter writer = new LangWriter(serializer.getBinder(), (Object)metadata, localeItems);
        ArrayList<String> langs = new ArrayList<String>();
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List<String> designerLangs = new ArrayList<String>();
        List languages = inteService.getEnabledLang();
        if (null != languages && !languages.isEmpty()) {
            for (EnabledLang lang : languages) {
                if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                designerLangs.add(lang.getNumber());
            }
        }
        if (null == designerLangs || designerLangs.isEmpty()) {
            designerLangs = Arrays.asList("zh_CN", "zh_TW", "en_US");
        }
        for (String dlang : designerLangs) {
            if (dlang.equals(excludeLang)) continue;
            langs.add(dlang);
        }
        writer.setLoaceValue(langs);
    }

    protected Map<String, Map<String, Object>> extractControlAttribute(Class<? extends ControlAp> type, List<? extends ControlAp> elements, List<String> propNames) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(elements.size());
        IDataEntityType dt = OrmUtils.getDataEntityType(type);
        ISimpleProperty pkProp = dt.getPrimaryKey();
        ArrayList<IDataEntityProperty> propertyList = new ArrayList<IDataEntityProperty>(propNames.size());
        for (String string : propNames) {
            IDataEntityProperty prop = (IDataEntityProperty)dt.getProperties().get((Object)string);
            if (prop == null) continue;
            propertyList.add(prop);
        }
        if (pkProp != null && !propertyList.isEmpty()) {
            for (String string : elements) {
                if (string == null || !type.isAssignableFrom(string.getClass())) continue;
                String pkValue = String.valueOf(pkProp.getValue((Object)string));
                HashMap<String, Object> propDataMap = new HashMap<String, Object>(propertyList.size());
                for (IDataEntityProperty prop : propertyList) {
                    Object propData = prop.getValue((Object)string);
                    if (propData == null) continue;
                    propDataMap.put(prop.getName(), propData);
                }
                if (propDataMap.size() <= 0) continue;
                result.put(pkValue, propDataMap);
            }
        }
        return result;
    }

    protected void initializeJsPluginForOldMeta(Map<String, Object> designerMetadata) {
        Map formMeta = (Map)designerMetadata.get("formmeta");
        String formId = (String)formMeta.get("Id");
        String formNumber = (String)formMeta.get("Key");
        String formName = (String)formMeta.get("Name");
        String modelType = (String)designerMetadata.get(PARAM_MODEL_TYPE);
        List items = (List)formMeta.get("Items");
        if (items != null) {
            List mobItems;
            Map rootApMap = (Map)items.get(0);
            this.innerAddJsPlugin(rootApMap, formId, formNumber, formName, modelType, modelType.startsWith(PREFIX_MOB));
            Map mobMeta = (Map)rootApMap.get("MobMeta");
            if (mobMeta != null && (mobItems = (List)mobMeta.get("Items")) != null) {
                Map mobRootApMap = (Map)mobItems.get(0);
                this.innerAddJsPlugin(mobRootApMap, formId, formNumber + "_mob", formName, modelType, true);
            }
        }
    }

    private void innerAddJsPlugin(Map<String, Object> rootApMap, String formId, String formNumber, String formName, String modelType, boolean isMob) {
        boolean hasSelfPageJsPlugin = false;
        if (rootApMap.get("JsPlugins") != null) {
            List jsPlugins = (List)rootApMap.get("JsPlugins");
            for (Map jsPlugin : jsPlugins) {
                if (jsPlugin.get("Inherit") != null && ((Boolean)jsPlugin.get("Inherit")).booleanValue()) continue;
                hasSelfPageJsPlugin = true;
                break;
            }
            if (!hasSelfPageJsPlugin) {
                Plugin selfPlugin = this.createJsPlugin(formId, formNumber, formName, jsPlugins.size(), isMob);
                jsPlugins.add(new MetadataSerializer(modelType).serializeToMap((Object)selfPlugin));
            }
        } else {
            Plugin selfPlugin = this.createJsPlugin(formId, formNumber, formName, 0, isMob);
            ArrayList<Map> jsPlugins = new ArrayList<Map>(1);
            jsPlugins.add(new MetadataSerializer(modelType).serializeToMap((Object)selfPlugin));
            rootApMap.put("JsPlugins", jsPlugins);
        }
    }

    private Plugin createJsPlugin(String formId, String formNumber, String formName, int rowKey, boolean isMob) {
        String likeValue = formId + "%";
        if (isMob) {
            likeValue = formId + "_mob%";
        }
        QFilter[] qFilter = new QFilter[]{new QFilter("classname", "like", (Object)likeValue), new QFilter("cbox_script_type", "=", (Object)JS_PLUGIN_TYPE)};
        Map queryMap = BusinessDataReader.loadFromCache((String)"ide_pluginscript", (String)"id, classname", (QFilter[])qFilter);
        String scriptId = "";
        if (!CollectionUtils.isEmpty((Map)queryMap)) {
            for (Map.Entry pluginItem : queryMap.entrySet()) {
                String dbFpk = (String)pluginItem.getKey();
                DynamicObject plugin = (DynamicObject)pluginItem.getValue();
                String dbClassName = plugin.getString("classname");
                String className = formId + "_" + dbFpk;
                if (isMob) {
                    className = formId + "_mob_" + dbFpk;
                }
                if (!className.equals(dbClassName)) continue;
                scriptId = dbFpk;
                break;
            }
        }
        Plugin selfPlugin = new Plugin();
        if (StringUtils.isBlank((CharSequence)scriptId)) {
            scriptId = Uuid8.generateShortUuid();
        }
        selfPlugin.setFpk(scriptId);
        String className = formId + "_" + selfPlugin.getFpk();
        if (isMob) {
            className = formId + "_mob_" + selfPlugin.getFpk();
        }
        selfPlugin.setClassName(className);
        selfPlugin.setEnabled(true);
        selfPlugin.setSourceNumber(formNumber);
        selfPlugin.setSourceName(new LocaleString(formName));
        selfPlugin.setRowKey(rowKey);
        return selfPlugin;
    }
}

