/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import org.apache.commons.io.FilenameUtils;

public class DomainModelTypePlugin
extends AbstractFormPlugin {
    private static final String ENTRY_KEY = "EntryEntity";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        this.addClickListeners(new String[]{"btnexcel"});
        this.getModel().addDataModelChangeListener((IDataModelChangeListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnexcel")) {
            try {
                this.closeAndExep();
            }
            catch (IOException e) {
                this.getView().showErrorNotification(e.toString());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        if (event.getProperty().getName().equalsIgnoreCase("model")) {
            String value = event.getChangeSet()[0].getNewValue().toString();
            DomainModelType dmt = DomainModelType.getDomainModelType((String)value);
            ArrayList<ComboItem> categoryItems = new ArrayList<ComboItem>(10);
            for (Category c : dmt.getCategories()) {
                categoryItems.add(new ComboItem(c.getName(), dmt.getId() + "_" + c.getId()));
            }
            ComboEdit combo = (ComboEdit)this.getView().getControl("category");
            combo.setComboItems(categoryItems);
        }
        if (event.getProperty().getName().equalsIgnoreCase("category")) {
            String id = event.getChangeSet()[0].getNewValue().toString();
            String[] str = id.split("_");
            String dmtId = str[0];
            String categoryId = str[1];
            this.resetElementInfo(dmtId, categoryId);
            this.getView().updateView();
        }
    }

    private List<ElementType> getElements(String dmtId, String categoryId) {
        DomainModelType dmt = DomainModelType.getDomainModelType((String)dmtId);
        for (Category c : dmt.getCategories()) {
            if (!c.getId().equals(categoryId)) continue;
            return c.getElementTypes();
        }
        return Collections.emptyList();
    }

    private void resetElementInfo(String dmtId, String categoryId) {
        List<ElementType> elements;
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(ENTRY_KEY);
        if (count > 0) {
            model.deleteEntryData(ENTRY_KEY);
            this.getView().updateView();
        }
        if ((elements = this.getElements(dmtId, categoryId)).isEmpty()) {
            return;
        }
        int[] index = this.getModel().batchCreateNewEntryRow(ENTRY_KEY, elements.size());
        int i = 0;
        for (ElementType element : elements) {
            for (Property pro : element.getProperties()) {
                model.setValue("element", (Object)(element.getName() + ""), index[i]);
                model.setValue("propertyname", (Object)(pro.getName() + ""), index[i]);
                model.setValue("property", (Object)pro.getPropertyName(), index[i]);
                model.setValue("description", (Object)(pro.getDescription() + ""), index[i]);
                ++i;
            }
        }
    }

    private void closeAndExep() throws IOException {
        Map<String, DomainModelType> dmtMap = this.getDMTMap();
        String path = "c:/export/";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (Map.Entry<String, DomainModelType> dmt : dmtMap.entrySet()) {
            DomainModelType dmtValue = dmt.getValue();
            String fileModelName = String.format(ResManager.loadKDString((String)"%1$s_\u5206\u7c7b%2$s", (String)"DomainModelTypePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), dmt.getValue().getName(), ".csv");
            String fileElementName = String.format(ResManager.loadKDString((String)"%1$s_\u5143\u7d20%2$s", (String)"DomainModelTypePlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), dmt.getValue().getName(), ".csv");
            FileOutputStream outModel = new FileOutputStream(FilenameUtils.getName((String)String.format("%1$s%2$s", path, fileModelName)));
            Throwable throwable = null;
            try {
                FileOutputStream outElement = new FileOutputStream(FilenameUtils.getName((String)String.format("%1$s%2$s", path, fileElementName)));
                Throwable throwable2 = null;
                try {
                    BufferedWriter csvFileModelOutputStream = new BufferedWriter(new OutputStreamWriter((OutputStream)outModel, "UTF-8"), 1024);
                    BufferedWriter csvFileElementOutputStream = new BufferedWriter(new OutputStreamWriter((OutputStream)outElement, "UTF-8"), 1024);
                    List category = dmtValue.getCategories();
                    csvFileModelOutputStream.write(String.format(ResManager.loadKDString((String)"%s\u7c7b\u522b,\u5143\u7d20\u540d\u79f0,Id", (String)"DomainModelTypePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\ufeff"));
                    csvFileModelOutputStream.newLine();
                    for (Category category2 : category) {
                        for (ElementType event : category2.getElementTypes()) {
                            csvFileModelOutputStream.write(category2.getName().toString() + ",");
                            csvFileModelOutputStream.write(event.getName() + "," + event.getId());
                            csvFileModelOutputStream.newLine();
                        }
                    }
                    csvFileModelOutputStream.flush();
                    csvFileElementOutputStream.write(String.format(ResManager.loadKDString((String)"%s\u5143\u7d20,\u5c5e\u6027Name,\u5c5e\u6027,\u5c5e\u6027\u63cf\u8ff0", (String)"DomainModelTypePlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\ufeff"));
                    csvFileElementOutputStream.newLine();
                    for (Map.Entry entry : dmtValue.getElementTypes().entrySet()) {
                        ElementType elementValue = (ElementType)entry.getValue();
                        List proList = elementValue.getProperties();
                        for (int i = 0; i < proList.size(); ++i) {
                            csvFileElementOutputStream.write(elementValue.getName() + ",");
                            String name = ((Property)proList.get(i)).getName().toString();
                            String propertyName = ((Property)proList.get(i)).getPropertyName();
                            csvFileElementOutputStream.write(propertyName + "," + name + "," + ((Property)proList.get(i)).getDescription());
                            csvFileElementOutputStream.newLine();
                        }
                    }
                    csvFileElementOutputStream.flush();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (outElement == null) continue;
                    if (throwable2 != null) {
                        try {
                            outElement.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    outElement.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (outModel == null) continue;
                if (throwable != null) {
                    try {
                        outModel.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                outModel.close();
            }
        }
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u51fa\u5230 %s", (String)"DomainModelTypePlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), path));
    }

    public void afterCreateNewData(EventObject event) {
        Map<String, DomainModelType> dmtMap = this.getDMTMap();
        ArrayList<ComboItem> modleItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, DomainModelType> dmt : dmtMap.entrySet()) {
            String key = dmt.getKey();
            LocaleString name = dmt.getValue().getName();
            modleItems.add(new ComboItem(name, key));
        }
        ComboEdit combo = (ComboEdit)this.getView().getControl("model");
        combo.setComboItems(modleItems);
    }

    private Map<String, DomainModelType> getDMTMap() {
        DomainModelType baseFormModel = DomainModelType.getDomainModelType((String)"BaseFormModel");
        DomainModelType billFormModel = DomainModelType.getDomainModelType((String)"BillFormModel");
        DomainModelType dynamicFormModel = DomainModelType.getDomainModelType((String)"DynamicFormModel");
        DomainModelType mobileFormModel = DomainModelType.getDomainModelType((String)"MobileFormModel");
        DomainModelType mobileBillFormModel = DomainModelType.getDomainModelType((String)"MobileBillFormModel");
        DomainModelType designMobileBillFormModel = DomainModelType.getDomainModelType((String)"DesignMobileBillFormModel");
        DomainModelType mobListModel = DomainModelType.getDomainModelType((String)"MobileListModel");
        DomainModelType widgetFormModel = DomainModelType.getDomainModelType((String)"WidgetFormModel");
        DomainModelType billListCardViewModel = DomainModelType.getDomainModelType((String)"BillListCardViewModel");
        DomainModelType carEntryMenuModel = DomainModelType.getDomainModelType((String)"CarEntryMenuModel");
        DomainModelType userGuideModel = DomainModelType.getDomainModelType((String)"UserGuideFormModel");
        DomainModelType mobUserGuideModel = DomainModelType.getDomainModelType((String)"MobUserGuideFormModel");
        HashMap<String, DomainModelType> dmtMap = new HashMap<String, DomainModelType>();
        dmtMap.put(baseFormModel.getId(), baseFormModel);
        dmtMap.put(billFormModel.getId(), billFormModel);
        dmtMap.put(dynamicFormModel.getId(), dynamicFormModel);
        dmtMap.put(mobileFormModel.getId(), mobileFormModel);
        dmtMap.put(mobileBillFormModel.getId(), mobileBillFormModel);
        dmtMap.put(designMobileBillFormModel.getId(), designMobileBillFormModel);
        dmtMap.put(mobListModel.getId(), mobListModel);
        dmtMap.put(widgetFormModel.getId(), widgetFormModel);
        dmtMap.put(billListCardViewModel.getId(), billListCardViewModel);
        dmtMap.put(carEntryMenuModel.getId(), carEntryMenuModel);
        dmtMap.put(userGuideModel.getId(), userGuideModel);
        dmtMap.put(mobUserGuideModel.getId(), mobUserGuideModel);
        return dmtMap;
    }
}

