/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.designer.AbstractFormDesignerPlugin;
import kd.bos.designer.ExchangeRateGroupCreateUIElemntListener;
import kd.bos.designer.ISubDesginer;
import kd.bos.designer.ListCreateUIElemntListener;
import kd.bos.designer.MetaIsvCheck;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.QueryListDesigner;
import kd.bos.designer.bizobjext.BizObjectExtDesignerPlugin;
import kd.bos.designer.bizobjext.DesignerDataUtil;
import kd.bos.designer.bizobjext.ExtDeployDesignerData;
import kd.bos.designer.bizobjext.TempSaveDesignerData;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.GitSaveMetadata;
import kd.bos.designer.dao.LibAddress;
import kd.bos.designer.dao.MetadataUtil;
import kd.bos.designer.dao.OperationInfo;
import kd.bos.designer.property.BillListCDWDesignerPlugin;
import kd.bos.designer.property.ListDesignerValidator;
import kd.bos.designer.property.MobBillDesignerPlugin;
import kd.bos.devportal.common.FieldsType;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.property.PictureProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.events.NameCombineCreateUIElemntListener;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.AfterAddControlEvent;
import kd.bos.form.control.events.AfterAddControlListener;
import kd.bos.form.control.events.CreateUIElemntListener;
import kd.bos.form.control.events.KeyPressArgs;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.control.events.ShortCutKeyListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.CreateOperationUtils;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.isv.IsvParamCache;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignerMetas;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.dao.converter.PrintMetadataConverter;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.form.Style;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.IFormController;
import kd.bos.param.ParameterReader;
import kd.bos.service.IFormDesignService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.servicehelper.util.GitPermissionUtil;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;

public class FormDesignerPlugin
extends AbstractFormDesignerPlugin
implements TabSelectListener,
ShortCutKeyListener,
AfterAddControlListener {
    private static final Log log = LogFactory.getLog(FormDesignerPlugin.class);
    public static final String CALLBACK_DOPUBLISH = "dopublish";
    private static IFormDesignService formDesignService;
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String MODE_TYPE = "modelType";
    private static final String CONTEXT = "context";
    private static final String VALUE = "value";
    private static final String LANGUAGE = "language";
    private static final String DESIGNER_PARAMS = "designerparams";
    private static final String FORM_ID = "formId";
    private static final String FORM_META = "formmeta";
    private static final String BIZ_APPID = "bizappid";
    private static final String OPEN_FORM_ID = "openformid";
    private static final String LOCALE_ITEMS = "localeItems";
    private static final String ENTITY_TREE = "entitytree";
    private static final String OUTLINE = "outline";
    private static final String OLD_METADATA = "oldmetadata";
    private static final String REALTIME_METADATA = "realtimemetadata";
    private static final String MODIFY_DATE = "modifyDate";
    private static final String IS_OLD_VIEW = "isOldView";
    private static final String ITEMS = "Items";
    private static final String ENTITY_META = "entitymeta";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String ZH_CN = "zh_CN";
    private static final String PARAM_TYPE = "paramType";
    private static final String GET_USER_THEME = "getUserTheme";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZ_UNIT = "bizunit";
    public static final String NUMBER = "number";
    public static final String PREVIEW = "preview";
    public static final String EXPORT = "export";
    public static final String LIST_PREVIEW = "listpreview";
    public static final String PUBLISH = "publish";
    public static final String SAVE = "save";
    public static final String TEST_SAVE = "testsave";
    public static final String TEST_DEPLOY = "testdeploy";
    public static final String BTN_PC = "btnpc";
    public static final String BTN_MOBILE = "btnmobile";
    public static final String BTN_PC_LIST = "btnpclist";
    public static final String BTN_MOBILE_LIST = "btnmobilelist";
    private static final String BTN_JS = "btnjs";
    private static final String BTN_JS_MOB = "btnjsmob";
    public static final String BTN_XML = "btnxml";
    public static final String BTN_LOG = "btnlog";
    public static final String BTN_USER = "btnuser";
    public static final String LIST_META = "ListMeta";
    public static final String MOB_META = "MobMeta";
    public static final String MOB_LIST_META = "MobListMeta";
    public static final String FORM_DESIGNER = "formdesigner";
    public static final String SUB_FORM_DESIGNER = "subformdesigner";
    public static final String TAB_DESIGNERS = "tabdesigners";
    public static final String DESIGNER = "designer";
    public static final String DESIGNER_KEY = "designer_key";
    public static final String SUPERADMIN_DEFAULT_ICON = "/icons/pc/other/superAdministrators_38_38.png";
    public static final String ISV_KINGDEE = "kingdee";
    public static final String FORM_EXT = "_ext";
    private static final String MERGE_VERSION = "mergeVersion";
    private static final String SHOW_FORM_LANG_PARAM = "formConfigShowLang";
    private static final String GITMSG = "gitmsg";
    protected static final String DO_DELETE = "doDelete";
    protected static final String DELETE_FILED_REFERENCED_LIST = "deleteReferencedList";
    protected static final String DELETE_FILED_REFERENCED_LIST_LIST_META = "deleteReferencedList_ListMeta";
    protected static final String DELETE_FILED_REFERENCED_LIST_MOB_META = "deleteReferencedList_MobMeta";
    protected static final String DELETE_FILED_REFERENCED_LIST_MOB_LIST_META = "deleteReferencedList_MobListMeta";
    private static final String METADATA_MERGE_CALL_BACK = "metadataMergeCallBack";
    private static final boolean BOOLEAN_TRUE = true;
    private static final boolean BOOLEAN_FALSE = false;
    private static final String BIZ_OPERATE_KEY = "bizOperateKey";
    private BizObjectExtDesignerPlugin bizObjectExtDesignerPlugin = new BizObjectExtDesignerPlugin();

    public void initialize() {
        super.initialize();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String id = (String)showParameter.getCustomParam("id");
        if (id != null) {
            this.getPageCache().put("id", id);
        }
        String bizAppId = (String)showParameter.getCustomParam(BIZ_APPID);
        this.getPageCache().put(BIZ_APPID, bizAppId);
        String number = (String)showParameter.getCustomParam(NUMBER);
        if (number != null) {
            this.getPageCache().put(NUMBER, number);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        String modeltype = this.getPageCache().get(MODE_TYPE);
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        designer.addCreateUIElemntListener((CreateUIElemntListener)new NameCombineCreateUIElemntListener(this.getView()));
        if ("QueryListModel".equals(modeltype)) {
            designer.addCreateUIElemntListener((CreateUIElemntListener)new ListCreateUIElemntListener(this.getView()));
            QueryListDesigner plugin = new QueryListDesigner();
            plugin.setView(this.getView());
            designer.addPropertyButtonClickListener((PropertyListener)plugin);
        } else {
            super.registerListener(e);
        }
        this.addClickListeners(new String[]{SAVE, PREVIEW, EXPORT, PUBLISH, BTN_PC, BTN_MOBILE, BTN_PC_LIST, BTN_MOBILE_LIST, BTN_XML, BTN_USER, BTN_LOG, TEST_SAVE, TEST_DEPLOY, BTN_JS, BTN_JS_MOB});
        Tab tab = (Tab)this.getControl(TAB_DESIGNERS);
        tab.addTabSelectListener((TabSelectListener)this);
        this.attachSubDesigner();
        designer.addShortCutKeyListener((ShortCutKeyListener)this);
        designer.addAfterAddControlListener((AfterAddControlListener)this);
        designer.addCreateUIElemntListener((CreateUIElemntListener)new ExchangeRateGroupCreateUIElemntListener());
        this.bizObjectExtDesignerPlugin.registerListener(e);
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        this.bizObjectExtDesignerPlugin.setView(formView);
    }

    private void attachSubDesigner() {
        String designerName = this.getPageCache().get(DESIGNER);
        AbstractFormDesignerPlugin plugin = null;
        FormDesigner designer = (FormDesigner)this.getView().getControl(SUB_FORM_DESIGNER);
        if (LIST_META.equals(designerName) || MOB_LIST_META.equals(designerName)) {
            plugin = new BillListCDWDesignerPlugin();
            ListCreateUIElemntListener listCreateUIElemntListener = new ListCreateUIElemntListener(this.getView());
            listCreateUIElemntListener.setMobList(MOB_LIST_META.equals(designerName));
            designer.addCreateUIElemntListener((CreateUIElemntListener)listCreateUIElemntListener);
        } else if (MOB_META.equals(designerName)) {
            plugin = new MobBillDesignerPlugin();
        }
        if (designer != null && plugin != null) {
            plugin.setView(this.getView());
            designer.addPropertyButtonClickListener((PropertyListener)plugin);
            designer.addAfterAddControlListener((AfterAddControlListener)this);
        }
    }

    public void openSubDesigner(PropertyEvent e) {
        Map<String, Object> tMap;
        AbstractFormDesignerPlugin plugin;
        FormDesigner designer = (FormDesigner)this.getView().getControl(SUB_FORM_DESIGNER);
        if (MOB_META.equals(e.getPropertName())) {
            plugin = new MobBillDesignerPlugin();
            plugin.setView(this.getView());
            tMap = ((MobBillDesignerPlugin)plugin).loadData(designer, e.getParam().get(CONTEXT), e.getPropertName(), e.getParam().get(VALUE), (String)e.getParam().get(LANGUAGE));
        } else {
            plugin = new BillListCDWDesignerPlugin();
            plugin.setView(this.getView());
            tMap = ((BillListCDWDesignerPlugin)plugin).loadData(designer, e.getParam().get(CONTEXT), e.getPropertName(), e.getParam().get(VALUE), (String)e.getParam().get(LANGUAGE));
        }
        Tab tab = (Tab)this.getControl(TAB_DESIGNERS);
        tab.activeTab("tabpagesubdesigner");
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("itemId", e.getItemId());
        params.put("metaType", e.getMetaType());
        tMap.put(DESIGNER_PARAMS, params);
        tMap.put(DESIGNER, e.getPropertName());
        this.getPageCache().put(DESIGNER, e.getPropertName());
    }

    private boolean isBizObjExt() {
        return "true".equals(this.getView().getFormShowParameter().getCustomParam("bizext"));
    }

    private boolean isInValidIsv() {
        try {
            IsvParamCache.setIsvParam((boolean)true);
            ISVService.getISVInfo().getId();
        }
        catch (KDException kde) {
            log.error((Throwable)kde);
            IsvParamCache.remove();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SAVE});
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u5f00\u53d1\u5546\u8d44\u8d28\u6587\u4ef6\u3002", (String)"MainPlugin_13", (String)"bos-devportal-plugin", (Object[])new Object[0]), kde.getMessage()));
            return true;
        }
        return false;
    }

    private boolean isProductEnv() {
        return EnvTypeHelper.isProductEnv() && this.getView().getFormShowParameter().getCustomParam("plmstart") == null && !this.isBizObjExt();
    }

    public void afterCreateNewData(EventObject evt) {
        if (this.isProductEnv() && !this.isPrintModel() || this.isInValidIsv()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE});
        }
        if (this.isProductEnv() && this.isExtendForm()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_secdev_patch_guide");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
        if (!this.isExtendForm() && EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FormDesignerPlugin_31", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
        if (this.isPrintModel()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String tplId = (String)showParameter.getCustomParam("id");
            if (!this.getOrCreateDesignService().isCanEditTpl(tplId)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{SAVE});
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5957\u6253\u6a21\u677f\u7684\u521b\u5efa\u7ec4\u7ec7\u548c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"FormDesignerPlugin_33", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private String getAppIdByFormId(String id) {
        String sql = String.format("select fbizappid from t_meta_formdesign where fid = '%s'", id);
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            String id1 = "";
            if (rs.next()) {
                id1 = rs.getString(1);
            }
            return id1;
        });
    }

    private boolean isExtendForm() {
        String sql = String.format("select ftype from t_meta_formdesign where fid = '%s'", this.getPageCache().get("id"));
        String type = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            String ftype = "";
            if (rs.next()) {
                ftype = rs.getString(1);
            }
            return ftype;
        });
        return "2".equals(type);
    }

    public void afterBindData(EventObject e) {
        if (RequestContext.get().getLang() != Lang.zh_CN && RequestContext.get().getLang() != Lang.zh_TW) {
            Image image = (Image)this.getControl("imageap");
            image.setUrl("/images/pc/other/Dev_platform_logo_en.png");
        }
        String hideFormListButton = (String)this.getView().getFormShowParameter().getCustomParam("hideFormListButton");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{EXPORT});
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("ext"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_XML});
        }
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        String id = this.getPageCache().get("id");
        String openFormId = "";
        String modelType = "";
        Map<String, Object> designerMetadata = null;
        if (id != null) {
            designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
            if (designerMetadata != null) {
                openFormId = (String)((Map)designerMetadata.get(FORM_META)).get("Key");
                this.initializeJsPluginForOldMeta(designerMetadata);
                this.recordTimeAndAquireMutex(openFormId, designerMetadata);
                this.getPageCache().put(MERGE_VERSION, (String)designerMetadata.get(MERGE_VERSION));
                modelType = (String)designerMetadata.get(MODE_TYPE);
                designerMetadata.put("subSystem", 1);
                Map formmeta = (Map)designerMetadata.get(FORM_META);
                if (formmeta != null && "kdprod".equals((String)formmeta.get("Isv"))) {
                    designerMetadata.put("isv", formmeta.get("Isv"));
                } else {
                    designerMetadata.put("isv", ISVService.getISVInfo().getId());
                }
                String bizappId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APPID);
                if (StringUtils.isBlank((CharSequence)bizappId)) {
                    bizappId = this.getAppIdByFormId(id);
                }
                if ("PrintModel".equals(modelType)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{LIST_PREVIEW, PUBLISH, EXPORT});
                }
                this.getView().setVisible(Boolean.valueOf(modelType.startsWith("ParameterFormModel")), new String[]{PUBLISH});
                designerMetadata.put("appNum", AppReader.getAppNumberById((String)bizappId));
                designerMetadata.put(BIZ_APPID, bizappId);
                HashMap<String, Boolean> options = new HashMap<String, Boolean>(3);
                if (formmeta != null && !StringUtils.equals((CharSequence)String.valueOf(formmeta.get("EntityId")), (CharSequence)id) && ("BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType))) {
                    options.put("isNotAllowPasteEntity", true);
                }
                designerMetadata.put("options", options);
                designer.open(modelType, designerMetadata);
                designer.sendFieldProsLock(DesignerUtils.getSpecialPropsExtensible((String)id));
                Map clientLocaleItems = (Map)designerMetadata.remove("clientLocaleItems");
                designer.sendMulLangProperty(clientLocaleItems);
            }
        } else {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Map newParam = (Map)showParameter.getCustomParam("newParam");
            if (newParam != null) {
                modelType = (String)newParam.get(MODE_TYPE);
                designerMetadata = this.createBlackTemplate(newParam);
                if (designerMetadata != null) {
                    id = (String)designerMetadata.get("id");
                }
                designer.open(modelType, designerMetadata);
                designer.sendFieldProsLock(DesignerUtils.getSpecialPropsExtensible((String)id));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.getPageCache().put(OPEN_FORM_ID, openFormId);
        }
        this.getPageCache().put(MODE_TYPE, modelType);
        if (designerMetadata != null) {
            this.getPageCache().put(LOCALE_ITEMS, SerializationUtils.toJsonString((Object)designerMetadata.remove(LOCALE_ITEMS)));
        }
        this.initDesignerView(openFormId, modelType, designerMetadata);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"back"});
        this.getPageCache().remove(REALTIME_METADATA);
        this.getPageCache().remove(DESIGNER);
        this.setTabColor(BTN_PC);
        if ("QueryListModel".equals(modelType)) {
            designer.resetSideBar(new String[]{ENTITY_TREE, OUTLINE});
        }
        this.getPageCache().put(OLD_METADATA, SerializationUtils.toJsonString(designerMetadata));
        this.getPageCache().put("originMetadata", SerializationUtils.toJsonString(designerMetadata));
        if (null != designerMetadata && !designerMetadata.isEmpty()) {
            Map fullCaption;
            LocaleString localeCaption;
            this.resourceCheck(designerMetadata);
            String browerTitle = (String)designerMetadata.get("caption");
            if (StringUtils.isBlank((CharSequence)browerTitle) && StringUtils.isBlank((CharSequence)(browerTitle = (localeCaption = (fullCaption = (Map)designerMetadata.get("fullLocaleCaption")) == null ? new LocaleString("") : LocaleString.fromMap((Map)fullCaption)).toString())) && localeCaption.size() > 0) {
                browerTitle = localeCaption.values().stream().filter(t -> StringUtils.isNotBlank((CharSequence)t)).findFirst().orElseGet(() -> "");
            }
            this.getView().executeClientCommand("setCaption", new Object[]{browerTitle});
        }
        this.switchPreviewLang(RequestContext.get().getLang().toString());
        if ("yes".equals(hideFormListButton) && this.commitSubDesignerData()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_PC, BTN_PC_LIST});
            this.changeView(MOB_META, designerMetadata);
            this.setTabColor(BTN_MOBILE);
        }
        if (this.commitSubDesignerData()) {
            String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tabKey");
            if ("listmeta".equals(tabKey)) {
                this.changeView(LIST_META, designerMetadata);
                this.setTabColor(BTN_PC_LIST);
            } else if ("mobmeta".equals(tabKey)) {
                this.changeView(MOB_META, designerMetadata);
                this.setTabColor(BTN_MOBILE);
            } else if ("moblistmeta".equals(tabKey)) {
                this.changeView(MOB_LIST_META, designerMetadata);
                this.setTabColor(BTN_MOBILE_LIST);
            }
        }
        this.getGitSessionId();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DecodeHandlerFactory.sendDesignerEncodingElements((String)FORM_DESIGNER, (IClientViewProxy)clientViewProxy);
        this.bizObjectExtDesignerPlugin.afterBindData(e);
        this.getView().addClientCallBack("gptInfo", Integer.valueOf(1000));
        Lang lang = RequestContext.getOrCreate().getLang();
        if (Lang.zh_CN != lang) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_XML});
        }
    }

    private void getGitSessionId() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        boolean type = DevportalCommonUtil.isGitManageType();
        if (type) {
            clientViewProxy.getClientLocalStorage(GITMSG);
        }
    }

    private Map<String, Object> createBlackTemplate(Map<String, Object> newParam) {
        Map<String, Object> designerMetadata = null;
        if (newParam != null) {
            DesignerData designerData = new DesignerData();
            boolean isPrint = false;
            Object printObj = newParam.get("isprint");
            if (printObj != null) {
                isPrint = (Boolean)printObj;
            }
            if (isPrint) {
                designerMetadata = designerData.createPrintModel(newParam);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{LIST_PREVIEW, PUBLISH, EXPORT});
            } else {
                designerMetadata = designerData.createBlankModel(newParam);
            }
        }
        return designerMetadata;
    }

    private void recordTimeAndAquireMutex(String formId, Map<String, Object> designerMetadata) {
        Date date = (Date)designerMetadata.get(MODIFY_DATE);
        long modifyDate = date == null ? 0L : date.getTime();
        this.getPageCache().put(MODIFY_DATE, String.valueOf(modifyDate));
    }

    private void initDesignerView(String formId, String modelType, Map<String, Object> metaData) {
        if (modelType.equals("BillFormModel") || modelType.equals("BaseFormModel") || modelType.equals("KMModel")) {
            if (!this.isOldView(metaData)) {
                FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
                if (!StringUtils.equals((CharSequence)formMetadata.getEntityId(), (CharSequence)formMetadata.getId())) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PC, BTN_PC_LIST});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_MOBILE, BTN_MOBILE_LIST});
                    this.showJSBtn(BTN_JS);
                } else {
                    if (modelType.equals("KMModel")) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PC, BTN_PC_LIST});
                    } else {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PC, BTN_MOBILE, BTN_PC_LIST, BTN_MOBILE_LIST});
                    }
                    this.showJSBtn(BTN_JS);
                }
            } else {
                String hideFormListButton = (String)this.getView().getFormShowParameter().getCustomParam("hideFormListButton");
                if ("yes".equals(hideFormListButton)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_MOBILE, BTN_MOBILE_LIST});
                    this.showJSBtn(BTN_JS_MOB);
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PC, BTN_MOBILE, BTN_PC_LIST, BTN_MOBILE_LIST});
                    this.showJSBtn(BTN_JS);
                }
            }
        } else if (modelType.equals("BalanceModel")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PC, BTN_PC_LIST});
            this.showJSBtn(BTN_JS);
        } else if (modelType.equals("LogBillFormModel")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PC, BTN_PC_LIST});
            this.showJSBtn(BTN_JS);
        } else {
            this.getView().setVisible(Boolean.valueOf(modelType.equals("MobileBillFormModel")), new String[]{BTN_PC, BTN_MOBILE_LIST});
            boolean isMobile = modelType.equals("MobileBillFormModel") || modelType.equals("MobileFormModel");
            boolean isDynamicForm = modelType.equals("DynamicFormModel");
            if (isMobile) {
                this.showJSBtn(BTN_JS_MOB);
            } else if (isDynamicForm) {
                this.showJSBtn(BTN_JS);
            }
        }
    }

    protected boolean isOldView(Map<String, Object> metaData) {
        boolean isOldView = false;
        if (metaData == null) {
            isOldView = this.getPageCache().get(IS_OLD_VIEW) != null && Boolean.parseBoolean(this.getPageCache().get(IS_OLD_VIEW));
        } else {
            Map designerItems = (Map)((List)((Map)metaData.get(FORM_META)).get(ITEMS)).get(0);
            isOldView = designerItems.containsKey(MOB_META) || designerItems.containsKey(MOB_LIST_META);
            this.getPageCache().put(IS_OLD_VIEW, Boolean.toString(isOldView));
        }
        return isOldView;
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey()) {
            case "save": {
                this.saveData();
                break;
            }
            case "testsave": {
                this.getPageCache().put(BIZ_OPERATE_KEY, TEST_SAVE);
                this.saveData((content, oldContent) -> {
                    TempSaveDesignerData designerData = new TempSaveDesignerData();
                    return ((DesignerData)designerData).save((Map<String, Object>)content, (Map<String, Object>)oldContent);
                });
                break;
            }
            case "testdeploy": {
                boolean permission = DesignerDataUtil.isLightExtOperationPermission(this.getView().getFormShowParameter().getCheckRightAppId(), "1CAAHEJOTG0U");
                if (!permission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8f7b\u6269\u5c55\u201d\u7684\u201c\u53d1\u5e03\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyBizObjExtListOperatePlugin_16", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(BIZ_OPERATE_KEY, TEST_DEPLOY);
                FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
                Map content2 = designer.getContent();
                boolean isCommit = this.commitSubDesignerData(content2);
                if (!isCommit || content2.isEmpty()) {
                    return;
                }
                this.getPageCache().put("deploydata", SerializationUtils.toJsonString((Object)content2));
                DesignerDataUtil.createDeployShowParameter(this, (String)content2.get("id"), CALLBACK_DOPUBLISH);
                break;
            }
            case "preview": {
                this.doPreview();
                break;
            }
            case "export": {
                this.exportFile(true);
                break;
            }
            case "publish": {
                this.doPublish();
                break;
            }
            case "back": {
                this.back();
                break;
            }
            case "btnpc": {
                this.back();
                break;
            }
            case "btnmobile": {
                if (!this.commitSubDesignerData()) break;
                this.changeView(MOB_META);
                this.setTabColor(btn.getKey());
                this.showJSBtn(BTN_JS_MOB);
                break;
            }
            case "btnpclist": {
                if (!this.commitSubDesignerData()) break;
                this.changeView(LIST_META);
                this.setTabColor(btn.getKey());
                this.showJSBtn("");
                break;
            }
            case "btnmobilelist": {
                if (!this.commitSubDesignerData()) break;
                this.changeView(MOB_LIST_META);
                this.setTabColor(btn.getKey());
                this.showJSBtn("");
                break;
            }
            case "btnxml": {
                this.editMetadata();
                break;
            }
            case "btnlog": {
                this.showMetadataLog();
                break;
            }
            case "btnjs": 
            case "btnjsmob": {
                this.showJSScriptEditor();
                break;
            }
        }
    }

    private void editMetadata() {
        JSONObject arg = this.devPermission();
        boolean verifyPermissionAndLock = this.verifyPermissionAndLock(arg);
        if (!verifyPermissionAndLock) {
            return;
        }
        FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
        Map content = designer.getContent();
        DesignerMetas metas = new DesignerMetas();
        if (content != null) {
            String localItem = this.getPageCache().get(LOCALE_ITEMS);
            if (localItem != null) {
                content.put(LOCALE_ITEMS, SerializationUtils.fromJsonString((String)localItem, Map.class));
            }
            DesignerData designerData = new DesignerData();
            metas.setItems(designerData.getDesignerMeatadata(content));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_metadataxml");
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey(TAB_DESIGNERS);
        parameter.setCustomParam("metas", (Object)metas.toJsonString());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "xmledit");
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
        this.getView().showForm(parameter);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_PC, BTN_MOBILE, BTN_PC_LIST, BTN_MOBILE_LIST, SAVE, PREVIEW, EXPORT, BTN_XML, PUBLISH, BTN_LOG});
    }

    private void showMetadataLog() {
        FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
        Map content = designer.getContent();
        boolean currentIsv = this.checkCurrentIsv();
        boolean isvIsSame = this.checkIsvIsSame(content);
        JSONObject arg = this.devPermission();
        boolean verifyPermissionAndLock = this.verifyPermissionAndLock(arg);
        if (!verifyPermissionAndLock) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_metalog_new");
        String id = this.getPageCache().get("id");
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("gray", (Object)AppGroupUtils.isGrayGroup());
        parameter.setCustomParam("prod", (Object)(EnvTypeHelper.isProductEnv() && !this.isPrintModel() ? 1 : 0));
        parameter.setCustomParam("deploy", (Object)EnvTypeHelper.isDeploying());
        parameter.setCustomParam("currentIsvIsBank", (Object)currentIsv);
        parameter.setCustomParam("isvIsSame", (Object)isvIsSame);
        parameter.setCustomParam("bizext", this.getView().getFormShowParameter().getCustomParam("bizext"));
        parameter.setCustomParam("designerMetaLog", (Object)"true");
        parameter.setCustomParam("isPrintModel", (Object)String.valueOf(this.isPrintModel()));
        parameter.setCustomParam(BIZ_OPERATE_KEY, (Object)this.getPageCache().get(BIZ_OPERATE_KEY));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, METADATA_MERGE_CALL_BACK));
        this.getView().showForm(parameter);
    }

    private boolean checkCurrentIsv() {
        String currentIsv = ISVService.getISVInfo().getId();
        return StringUtils.isBlank((CharSequence)currentIsv);
    }

    private boolean checkIsvIsSame(Map<String, Object> content) {
        Boolean isDeveloper;
        String currentIsv = ISVService.getISVInfo().getId();
        Map formMeta = (Map)content.get(FORM_META);
        String modelType = (String)formMeta.get("ModelType");
        PrintMetadataConverter converter = "PrintModel".equals(modelType) ? new PrintMetadataConverter() : new FormMetadataConverter();
        AbstractMetadata meta = converter.convertTo(content);
        String metadataIsv = meta.getIsv();
        if (ISV_KINGDEE.equalsIgnoreCase(currentIsv) && StringUtils.isBlank((CharSequence)metadataIsv)) {
            metadataIsv = currentIsv;
        }
        if (null != (isDeveloper = (Boolean)content.get("isDeveloper")) && !isDeveloper.booleanValue()) {
            return true;
        }
        return StringUtils.equals((CharSequence)currentIsv, (CharSequence)metadataIsv);
    }

    private void changeView(String subDesignerName) {
        this.changeView(subDesignerName, null);
    }

    private void changeView(String subDesignerName, Map<String, Object> designerMetadata) {
        this.getView().getPageCache().put(DESIGNER_KEY, SUB_FORM_DESIGNER);
        FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
        Map content = designerMetadata;
        if (content == null) {
            content = designer.getContent();
        }
        Map formMeta = (Map)content.get(FORM_META);
        Map entityMeta = (Map)content.get(ENTITY_META);
        List items = (List)formMeta.get(ITEMS);
        Map formAp = (Map)items.get(0);
        String itemId = (String)formAp.get("Id");
        HashMap param = new HashMap(2);
        param.put(VALUE, formAp.get(subDesignerName));
        param.put(LANGUAGE, content.get(LANGUAGE));
        if (MOB_META.equals(subDesignerName)) {
            ArrayList<List<Object>> context = new ArrayList<List<Object>>(2);
            items = (List)formMeta.get(ITEMS);
            context.add(items);
            context.add((List<Object>)entityMeta.get(ITEMS));
            param.put(CONTEXT, context);
        } else {
            param.put(CONTEXT, entityMeta.get(ITEMS));
        }
        PropertyEvent e = new PropertyEvent((Object)designer, itemId, FORM_META, subDesignerName, param);
        this.openSubDesigner(e);
    }

    public void tabSelected(TabSelectEvent e) {
        String designerName = this.getPageCache().get(DESIGNER);
        if (LIST_META.equals(designerName) || MOB_LIST_META.equals(designerName)) {
            FormDesigner designer = (FormDesigner)this.getView().getControl(SUB_FORM_DESIGNER);
            designer.resetSideBar(new String[]{ENTITY_TREE, OUTLINE});
        } else if (MOB_META.equals(designerName)) {
            FormDesigner designer = (FormDesigner)this.getView().getControl(SUB_FORM_DESIGNER);
            designer.resetSideBar(new String[]{ENTITY_TREE, OUTLINE, "toolbox"});
        }
    }

    private void back() {
        if (this.commitSubDesignerData()) {
            this.switchToMainDesigner();
            String modelType = this.getPageCache().get(MODE_TYPE);
            if ("MobileBillFormModel".equals(modelType) || "MobileFormModel".equals(modelType)) {
                this.showJSBtn(BTN_JS_MOB);
            } else {
                this.showJSBtn(BTN_JS);
            }
        }
    }

    public void switchToMainDesigner() {
        Tab tab = (Tab)this.getControl(TAB_DESIGNERS);
        this.setRealtimeMetadataPageCache();
        tab.activeTab("tabpagedesigner");
        this.getPageCache().put(DESIGNER, "");
        this.getPageCache().put(DESIGNER_KEY, "");
        this.setTabColor(BTN_PC);
    }

    private void setRealtimeMetadataPageCache() {
        FormDesigner subDesigner = (FormDesigner)this.getView().getControl(SUB_FORM_DESIGNER);
        FormDesigner formDesigner = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
        Map content = formDesigner.getContent();
        if (subDesigner.getContent() != null) {
            String designerKey = (String)subDesigner.getContent().get(DESIGNER);
            Map formMeta = (Map)content.get(FORM_META);
            List items = (List)formMeta.get(ITEMS);
            Map formAp = (Map)items.get(0);
            formAp.put(designerKey, subDesigner.getContent().get(FORM_META));
        }
        this.getPageCache().put(REALTIME_METADATA, SerializationUtils.toJsonString((Object)content));
    }

    private ISubDesginer getISubDesigner(String metaType) {
        AbstractFormDesignerPlugin plugin = null;
        if (LIST_META.equals(metaType) || MOB_LIST_META.equals(metaType)) {
            plugin = new BillListCDWDesignerPlugin();
        } else if (MOB_META.equals(metaType)) {
            plugin = new MobBillDesignerPlugin();
        }
        return plugin;
    }

    protected boolean commitSubDesignerData() {
        FormDesigner subdesigner = (FormDesigner)this.getView().getControl(SUB_FORM_DESIGNER);
        Map tmap = subdesigner.getContent();
        if (tmap == null) {
            return true;
        }
        String designerName = (String)tmap.get(DESIGNER);
        if (StringUtils.isBlank((CharSequence)designerName)) {
            return true;
        }
        ISubDesginer plugin = this.getISubDesigner(designerName);
        if (plugin == null) {
            return true;
        }
        if (plugin instanceof IFormPlugin) {
            ((IFormPlugin)plugin).setView(this.getView());
        }
        Map params = (Map)tmap.get(DESIGNER_PARAMS);
        params.put(PROPERTY_NAME, designerName);
        Object v = plugin.getReturnData(subdesigner, (Map<String, Object>)params);
        if (v instanceof Boolean && !((Boolean)v).booleanValue()) {
            return false;
        }
        if (v instanceof String) {
            if (StringUtils.isNotBlank((Object)v)) {
                this.getView().showTipNotification((String)v);
            }
            return false;
        }
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        Map propValue = (Map)v;
        designer.setProperty(propValue);
        return true;
    }

    private void setTabColor(String btn) {
        String btnStr = "btnpc_btnmobile_btnpclist_btnmobilelist_btnxml";
        if (!btnStr.contains(btn)) {
            return;
        }
        String[] keys = btnStr.split("_");
        HashMap<String, String> activeItem = new HashMap<String, String>();
        HashMap<String, Object> unActiveItem = new HashMap<String, Object>();
        activeItem.put("bc", "#56aaff");
        unActiveItem.put("bc", null);
        for (String key : keys) {
            if (key.equals(btn)) {
                this.getView().updateControlMetadata(key, activeItem);
                continue;
            }
            this.getView().updateControlMetadata(key, unActiveItem);
        }
    }

    private void showJSBtn(String btnKey) {
        if (this.isBizObjExt()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_JS, BTN_JS_MOB});
        } else {
            String[] keys;
            String jsBtnStr = "btnjs_btnjsmob";
            for (String key : keys = jsBtnStr.split("_")) {
                if (key.equals(btnKey)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{key});
                    continue;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{key});
            }
        }
    }

    private void showJSScriptEditor() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String designerKey = this.getView().getPageCache().get(DESIGNER_KEY);
        if (StringUtils.isBlank((CharSequence)designerKey)) {
            designerKey = FORM_DESIGNER;
        }
        clientViewProxy.invokeControlMethod(designerKey, "showJSScriptEditor", new Object[]{new ArrayList()});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Map map;
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("setaddresscallback".equals(actionId)) {
            if (returnData != null) {
                String libAddress = (String)returnData;
                SessionManager.getCurrent().put("libaddress", libAddress);
            }
        } else if ("xmledit".equals(actionId)) {
            if (returnData != null) {
                this.updateXmlToDesigner((DesignerMetas)returnData);
            }
            String modelType = this.getPageCache().get(MODE_TYPE);
            String formId = this.getPageCache().get(OPEN_FORM_ID);
            this.initDesignerView(formId, modelType, null);
            this.getView().setVisible(Boolean.valueOf(modelType.startsWith("ParameterFormModel")), new String[]{PUBLISH});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_XML, PREVIEW, SAVE, BTN_LOG});
        } else if (METADATA_MERGE_CALL_BACK.equals(actionId) && returnData != null) {
            Map res = (Map)returnData;
            String action = (String)res.get("action");
            if (StringUtils.equals((CharSequence)"restore", (CharSequence)action)) {
                String status = (String)res.get("status");
                if (StringUtils.equals((CharSequence)"success", (CharSequence)status)) {
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy.addAction("f5Refresh", null);
                } else {
                    String message = (String)res.get("message");
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fd8\u539f\u5931\u8d25\uff1a%s\u3002", (String)"FormDesignerPlugin_42", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), message));
                }
            }
        } else if ("propertyEdit".equalsIgnoreCase(actionId) && returnData != null) {
            FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
            if (returnData instanceof List) {
                List returnList = (List)returnData;
                for (Object ele : returnList) {
                    if (!(ele instanceof Map) || !"RefField".equals(((Map)ele).get(PROPERTY_NAME))) continue;
                    String delRefStr = this.getPageCache().get("delref");
                    if (StringUtils.isNotBlank((CharSequence)delRefStr)) {
                        Map paramMap;
                        String itemId = (String)((Map)ele).get("itemId");
                        if (itemId.equals((paramMap = (Map)SerializationUtils.fromJsonString((String)delRefStr, Map.class)).get("ItemId"))) {
                            PropertyEvent propertyEvent = new PropertyEvent((Object)this, itemId, (String)paramMap.get("MetaType"), null, paramMap);
                            this.deleteRefField(propertyEvent);
                        }
                        this.getPageCache().remove("delref");
                    }
                    this.cacheRefField(returnList);
                }
                designer.setProperty(returnList);
            } else {
                designer.setProperty((Map)returnData);
            }
            PropertyEditHelper.clearPropEventParamCache(this.getView());
        } else if (CALLBACK_DOPUBLISH.equalsIgnoreCase(actionId) && returnData instanceof Map && (map = (Map)returnData).containsKey("success")) {
            FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
            Map deplydata = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("deploydata"), Map.class);
            designer.setContent(deplydata);
            this.getPageCache().remove("deploydata");
            this.saveData((content, oldContent) -> {
                ExtDeployDesignerData designerData = new ExtDeployDesignerData();
                return ((DesignerData)designerData).save((Map<String, Object>)content, (Map<String, Object>)oldContent);
            });
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map param = e.getParam();
        if (GITMSG.equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String gitSessionId = (String)param.get("actonResult");
                this.getPageCache().put("gitSessionId", gitSessionId);
            } else {
                this.getPageCache().put("gitSessionId", "");
            }
        }
        if (Objects.equals("gptInfo", e.getName())) {
            this.showGPTPage();
        }
    }

    private void showGPTPage() {
        try {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_chat_ai_customcontrol");
            fsp.getOpenStyle().setTargetKey("gpt_gai_panel");
            fsp.setCustomParam("slideEnv", (Object)"BOS_DESIGNER");
            fsp.getOpenStyle().setShowType(ShowType.InContainer);
            this.getView().showForm(fsp);
        }
        catch (Exception e) {
            log.warn(" showGPTPage error" + e.getMessage(), (Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("createextendappandpage".equals(messageBoxClosedEvent.getCallBackId())) {
            String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u8fdb\u5165\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\uff0c\u5c06\u8d44\u6e90\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"FormDesignerPlugin_27", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
        } else if ("openeextendappandpage".equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                FormController srv = (FormController)this.getView().getService(IFormController.class);
                String extFormId = this.getPageCache().get("extNum");
                srv.showDesigner(extFormId);
            }
        } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"designerheader"});
        }
    }

    private void updateXmlToDesigner(DesignerMetas designerMetas) {
        Map tMap;
        DesignFormMeta designFormMeta = designerMetas.getDesignFormMeta();
        MetadataReader reader = new MetadataReader(false);
        reader.setModelType(designFormMeta.getModelType());
        AbstractMetadata metadata = null;
        if (!StringUtils.isBlank((CharSequence)designFormMeta.getParentId())) {
            boolean runtime = true;
            if (designFormMeta.getParentId().equals(designFormMeta.getMasterId())) {
                runtime = false;
            }
            if ((metadata = reader.readMeta(designFormMeta.getParentId(), OrmUtils.getDataEntityType(DesignFormMeta.class), runtime, true)) instanceof FormMetadata) {
                this.setInherit(((FormMetadata)metadata).getItems());
            }
        }
        DcxmlSerializer xmlSerializer = reader.getDcxmlSerializer(null);
        xmlSerializer.getBinder().setLCId(ZH_CN);
        xmlSerializer.setOnlyLocaleVale(false);
        xmlSerializer.setResetLoacaleValueBy2052(true);
        metadata = (AbstractMetadata)xmlSerializer.deserializeFromString(designFormMeta.getDataXml(), (Object)metadata);
        List designFormMetaLs = designerMetas.getDesignFormMetaL();
        for (DesignFormMetaL designFormMetaL : designFormMetaLs) {
            xmlSerializer.getBinder().setLCId(designFormMetaL.getLocaleId());
            metadata = (AbstractMetadata)xmlSerializer.deserializeFromString(designFormMetaL.getDataXml(), (Object)metadata);
        }
        metadata.convertFromDesignMeta((DesignMeta)designFormMeta);
        if (metadata instanceof FormMetadata) {
            this.bindEntityMetadata(designerMetas, reader, (FormMetadata)metadata, xmlSerializer);
        }
        if ((tMap = metadata.buildDesignMeta(ZH_CN)) != null) {
            this.getPageCache().put(LOCALE_ITEMS, SerializationUtils.toJsonString(tMap.remove(LOCALE_ITEMS)));
        }
        FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
        designer.open(metadata.getModelType(), tMap);
        if (tMap != null) {
            designer.sendFieldProsLock(DesignerUtils.getSpecialPropsExtensible((String)((String)tMap.get("id"))));
        }
        this.switchToMainDesigner();
    }

    public void bindEntityMetadata(DesignerMetas designerMetas, MetadataReader reader, FormMetadata formMetadata, DcxmlSerializer xmlSerializer) {
        formMetadata.createIndex(true);
        DesignEntityMeta designEntityMeta = designerMetas.getDesignEntityMeta();
        if (designEntityMeta == null) {
            return;
        }
        EntityMetadata entityMetadata = null;
        if (StringUtils.isNotBlank((CharSequence)designEntityMeta.getParentId())) {
            boolean runtime = true;
            if (designEntityMeta.getParentId().equals(designEntityMeta.getMasterId())) {
                runtime = false;
            }
            entityMetadata = (EntityMetadata)reader.readMeta(designEntityMeta.getParentId(), OrmUtils.getDataEntityType(DesignEntityMeta.class), runtime, true);
            this.setInherit(entityMetadata.getItems());
        }
        xmlSerializer.getBinder().setLCId(ZH_CN);
        xmlSerializer.setOnlyLocaleVale(false);
        entityMetadata = (EntityMetadata)xmlSerializer.deserializeFromString(designEntityMeta.getDataXml(), entityMetadata);
        List designEntityMetaLs = designerMetas.getDesignEntityMetaL();
        xmlSerializer.setOnlyLocaleVale(true);
        for (DesignEntityMetaL designEntityMetaL : designEntityMetaLs) {
            xmlSerializer.getBinder().setLCId(designEntityMetaL.getDataXml());
            entityMetadata = (EntityMetadata)xmlSerializer.deserializeFromString(designEntityMetaL.getDataXml(), (Object)entityMetadata);
        }
        entityMetadata.convertFromDesignMeta((DesignMeta)designEntityMeta);
        entityMetadata.createIndex(true);
        formMetadata.bindEntityMetadata(entityMetadata);
    }

    private void setInherit(List<?> items) {
        for (Object item : items) {
            ((AbstractElement)item).setInherit(true);
            if (!(item instanceof FormAp)) continue;
            List plugins = ((FormAp)item).getPlugins();
            for (Plugin p : plugins) {
                p.setInherit(true);
            }
        }
    }

    private LibAddress checkAddress(String subFNumber) {
        LibAddress libAddress = MetadataUtil.getLibAddress(subFNumber);
        if (libAddress != null && StringUtils.isEmpty((CharSequence)libAddress.getLibAddress())) {
            boolean ide_svn_choselibIsDeprecated = true;
            if (ide_svn_choselibIsDeprecated) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201ccheckAddress\u201d%s\u5931\u8d25\uff0c\u201cgetLibAddress\u201d\u4e3a\u7a7a\u3002", (String)"FormDesignerPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), subFNumber));
                return null;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_svn_choselib");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("subFnumber", (Object)subFNumber);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setaddresscallback"));
            parameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
            this.getView().showForm(parameter);
            return null;
        }
        return libAddress;
    }

    private String getSubSystemNumber() {
        String subFNumber = (String)this.getView().getFormShowParameter().getCustomParam("subFnumber");
        if (StringUtils.isEmpty((CharSequence)subFNumber)) {
            subFNumber = "Bos";
        }
        return subFNumber;
    }

    private void exportFile(boolean isShowMessage) {
        String id = this.getPageCache().get("id");
        if (id == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"FormDesignerPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String subFNumber = this.getSubSystemNumber();
        LibAddress libAddress = this.checkAddress(subFNumber);
        if (libAddress == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormDesignerPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        try {
            MetadataUtil metadataUtil = new MetadataUtil();
            OperationInfo operationInfo = metadataUtil.expMetadata(id, libAddress);
            this.getPageCache().put("fileList", SerializationUtils.toJsonString(operationInfo.getFilePath()));
            if (isShowMessage) {
                if (operationInfo.getErrorMessage().isEmpty()) {
                    this.getView().showSuccessNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff0c\u5bfc\u51fa\u6587\u4ef6\u5217\u8868\uff1a\r\n%s\u3002", (String)"FormDesignerPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), operationInfo.getFilePathString()), Integer.valueOf(3000));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u5bfc\u51fa\u6210\u529f\u7684\u6587\u4ef6\u6709\uff1a%1$s\uff0c\r\n\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a%2$s\u3002", (String)"FormDesignerPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), operationInfo.getFilePathString(), operationInfo.getErrorMessageString()));
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s\u3002", (String)"FormDesignerPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void pcListPreview() {
        String id = this.getPageCache().get("id");
        String masterId = DesignerData.getMasterId(id);
        String key = DesignerData.getNumberById(masterId);
        String modelType = this.getPageCache().get(MODE_TYPE);
        if (modelType == null || modelType.equalsIgnoreCase("WidgetFormModel") || modelType.equalsIgnoreCase("DynamicFormModel")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u4e0d\u5b58\u5728\u5217\u8868\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"FormDesignerPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(key);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
        Object newpagevalue = this.getView().getFormShowParameter().getCustomParam("newpage");
        if (newpagevalue != null) {
            parameter.setCustomParam("newpage", newpagevalue);
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void mobListPreview() {
        String id = this.getPageCache().get("id");
        String masterId = DesignerData.getMasterId(id);
        String key = DesignerData.getNumberById(masterId);
        this.preview(key, "MobileListModel");
    }

    private void cardModelPreview(String formId, FormMetadata meta) {
        HashMap<String, Object> config = new HashMap<String, Object>(16);
        config.put("type", "cardform");
        config.put(FORM_ID, formId);
        config.put("appId", BizAppServiceHelp.getAppIdByFormNum((String)formId));
        config.put("pageId", this.getView().getPageId());
        config.put(LANGUAGE, meta.getRootAp().getLanguage());
        if (meta.getRootAp().getWidth() != null) {
            config.put("width", meta.getRootAp().getWidth().toString());
        }
        if (meta.getRootAp().getHeight() != null) {
            config.put("height", meta.getRootAp().getHeight().toString());
        }
        config.put("backgroundColor", meta.getRootAp().getBackColor());
        Style style = meta.getRootAp().getStyle();
        if (style != null) {
            config.put("style", style.getStyle());
        }
        String mobDomainUrl = UrlService.getMobileDomainContextUrl();
        config.put("ajaxUrl", mobDomainUrl);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("showForm", config);
    }

    private void printModelPreview(String id) {
        PrintMetadata printMeta = (PrintMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        if (printMeta != null) {
            String formId = DesignerData.getEntityNumberById(printMeta.getEntityId());
            String downloadUrl = this.getOrCreateDesignService().preview(this.getView().getPageId(), formId, printMeta.getKey());
            if (StringUtils.isNotBlank((CharSequence)downloadUrl)) {
                this.getView().openUrl(downloadUrl);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6253\u5370\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u53ef\u80fd\u662f\u6a21\u677f\u7ed1\u5b9a\u5b57\u6bb5\u5df2\u5728\u5355\u636e\u4e2d\u5220\u9664", (String)"FormDesignerPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OK);
            }
        }
    }

    private void doPreview() {
        String id = this.getPageCache().get("id");
        String masterId = DesignerData.getMasterId(id);
        String designerName = this.getPageCache().get(DESIGNER) == null ? "" : this.getPageCache().get(DESIGNER);
        String modelType = this.getPageCache().get(MODE_TYPE);
        if (modelType.startsWith("Mobile") || "MobUserGuideFormModel".equals(modelType)) {
            if ("MobileBillFormModel".equals(modelType) && MOB_LIST_META.equals(designerName)) {
                this.mobListPreview();
            } else {
                this.preview(DesignerData.getNumberById(masterId), "MobileBillFormModel");
            }
            return;
        }
        if ("CardModel".equals(modelType)) {
            String formId = DesignerData.getNumberById(masterId);
            if (StringUtils.isBlank((CharSequence)formId)) {
                return;
            }
            FormMetadata meta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
            this.cardModelPreview(formId, meta);
            return;
        }
        switch (designerName) {
            case "ListMeta": {
                this.pcListPreview();
                break;
            }
            case "MobListMeta": {
                this.mobListPreview();
                break;
            }
            case "MobMeta": {
                String key = DesignerData.getNumberById(masterId) + "_mob";
                this.preview(key, "MobileBillFormModel");
                break;
            }
            default: {
                String number = DesignerData.getNumberById(masterId);
                if (StringUtils.isBlank((CharSequence)number)) {
                    return;
                }
                this.previewForm(modelType, id, number);
            }
        }
    }

    private void previewForm(String modelType, String id, String number) {
        if (modelType.equals("PrintModel")) {
            this.printModelPreview(id);
        } else if ("QueryListModel".equals(modelType)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(number);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            HashMap<String, String> para = new HashMap<String, String>();
            para.put(FORM_ID, number);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
            showParameter.setAppId(this.getAppNumber(id));
            this.getView().showForm(showParameter);
        }
    }

    private String getAppNumber(String id) {
        String appNumber = "";
        String bizAppId = this.getPageCache().get(BIZ_APPID);
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            AppInfo appInfo = MetadataDao.getMasterAppInfo((String)bizAppId);
            appNumber = appInfo != null && StringUtils.isNotBlank((CharSequence)appInfo.getNumber()) ? appInfo.getNumber() : BizAppServiceHelp.getAppNumByAppId((String)this.getPageCache().get(BIZ_APPID));
        } else {
            AppInfo appInfo;
            DynamicObject dynamicObject = BizAppServiceHelp.getBizAppByFormID((String)id);
            appNumber = dynamicObject.getString(NUMBER);
            String appId = dynamicObject.getString("id");
            this.getPageCache().put(BIZ_APPID, appId);
            if (StringUtils.isNotBlank((CharSequence)appId) && (appInfo = MetadataDao.getMasterAppInfo((String)appId)) != null && StringUtils.isNotBlank((CharSequence)appInfo.getNumber())) {
                appNumber = appInfo.getNumber();
            }
        }
        return appNumber;
    }

    private boolean checkMetaModifier(Map<String, Object> lastestMetadata, String modifyTimeStamp, StringBuilder errMsgBuilder) {
        if (modifyTimeStamp == null || lastestMetadata == null) {
            return true;
        }
        Date lastestModifyDate = (Date)lastestMetadata.get(MODIFY_DATE);
        String modifyId = (String)lastestMetadata.get("modifierId");
        if (!StringUtils.equals((CharSequence)RequestContext.get().getUserId(), (CharSequence)modifyId) && lastestModifyDate != null && lastestModifyDate.getTime() >= Long.parseLong(modifyTimeStamp) + 5000L) {
            if (StringUtils.isNotBlank((CharSequence)modifyId)) {
                Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(modifyId));
                if (userInfo != null) {
                    errMsgBuilder.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c", (String)"FormDesignerPlugin_46", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).append(userInfo.get("name")).append(ResManager.loadKDString((String)"\u5728", (String)"FormDesignerPlugin_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).append(DateFormat.getDateTimeInstance().format(lastestModifyDate)).append(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e86\u5f53\u524d\u5143\u6570\u636e\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539\u3002", (String)"FormDesignerPlugin_47", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                }
            } else {
                errMsgBuilder.append(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5143\u6570\u636e\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539\u3002", (String)"FormDesignerPlugin_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private boolean checkMetadataVersion() {
        String newMergeVer;
        String id = this.getPageCache().get("id");
        if (StringUtils.isBlank((CharSequence)id)) {
            return true;
        }
        String modifyDate = this.getPageCache().get(MODIFY_DATE);
        Map lastestMetadata = MetadataDao.loadDesignerMetadata((String)id);
        if (lastestMetadata == null) {
            return true;
        }
        StringBuilder errMsgBuilder = new StringBuilder();
        if (!this.checkMetaModifier(lastestMetadata, modifyDate, errMsgBuilder)) {
            this.getView().showErrorNotification(errMsgBuilder.toString());
            return false;
        }
        String oldMergeVer = this.getPageCache().get(MERGE_VERSION);
        if (!StringUtils.isBlank((CharSequence)oldMergeVer) && !oldMergeVer.equals(newMergeVer = (String)lastestMetadata.get(MERGE_VERSION))) {
            log.info(String.format("\u8be5\u8868\u5355\u5143\u6570\u636e\u6216\u6e90\u9875\u9762\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539,\u8bbe\u8ba1\u5668\u7f13\u5b58\u7248\u672c\uff1a%s,\u65b0\u7248\u672c\uff1a%s", oldMergeVer, newMergeVer));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u5143\u6570\u636e\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u4fdd\u5b58\uff0c\u53ef\u80fd\u5b58\u5728\u7248\u672c\u51b2\u7a81\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u4fee\u6539\u3002", (String)"FormDesignerPlugin_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean resourceCheck(Map<String, Object> content) {
        Boolean isDeveloper;
        if (this.isBizObjExt()) {
            return true;
        }
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"DesignerData_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        Map formMeta = (Map)content.get(FORM_META);
        String modelType = (String)formMeta.get("ModelType");
        PrintMetadataConverter converter = "PrintModel".equals(modelType) ? new PrintMetadataConverter() : new FormMetadataConverter();
        AbstractMetadata meta = converter.convertTo(content);
        String metadataIsv = meta.getIsv();
        if (ISV_KINGDEE.equalsIgnoreCase(currentIsv) && StringUtils.isBlank((CharSequence)metadataIsv)) {
            metadataIsv = currentIsv;
        }
        if (null != (isDeveloper = (Boolean)content.get("isDeveloper")) && !isDeveloper.booleanValue()) {
            return true;
        }
        if (StringUtils.equals((CharSequence)currentIsv, (CharSequence)metadataIsv)) {
            return true;
        }
        String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u8fdb\u5165\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\uff0c\u5c06\u8d44\u6e90\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"FormDesignerPlugin_27", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        this.getView().showErrorNotification(errorMsg);
        return false;
    }

    private boolean existDraftOp(Map<String, Object> content) {
        List formItems = (List)((Map)content.get(FORM_META)).get(ITEMS);
        for (Object object : formItems) {
            Map map = (Map)object;
            Object operationKey = map.get("OperationKey");
            if (!"draft".equals(operationKey)) continue;
            return true;
        }
        return false;
    }

    private void saveData() {
        this.saveData((content, oldContent) -> {
            DesignerData designerData = new DesignerData();
            return designerData.save((Map<String, Object>)content, (Map<String, Object>)oldContent);
        });
    }

    private void saveData(BiFunction<Map<String, Object>, Map<String, Object>, Map<String, Object>> saveFunc) {
        FormDesigner designer;
        Map content;
        if (AppGroupUtils.isGrayGroup()) {
            String errorMsg = ResManager.loadKDString((String)"\u7070\u5ea6\u529f\u80fd\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_32", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        if (this.isProductEnv() && !this.isPrintModel()) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_28", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        if (EnvTypeHelper.isDeploying()) {
            String errorMsg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FormDesignerPlugin_31", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        JSONObject arg = this.devPermission();
        boolean verifyPermissionAndLock = this.verifyPermissionAndLock(arg);
        if (!verifyPermissionAndLock) {
            return;
        }
        if (this.isPrintModel()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String tplId = (String)showParameter.getCustomParam("id");
            if (!this.getOrCreateDesignService().isCanEditTpl(tplId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5957\u6253\u6a21\u677f\u7684\u521b\u5efa\u7ec4\u7ec7\u548c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4\u3002", (String)"FormDesignerPlugin_33", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if ((content = (designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER)).getContent()) == null || !"PrintModel".equalsIgnoreCase(content.get(MODE_TYPE).toString()) && !this.checkMetadataVersion()) {
            return;
        }
        content.put(LOCALE_ITEMS, SerializationUtils.fromJsonString((String)this.getPageCache().get(LOCALE_ITEMS), Map.class));
        String talentCode = RequestContext.get().getTenantCode();
        if ("true".equals(System.getProperty(talentCode + "_validateEntryPrimary", "true")) && !this.validateEntryPrimaryKey(content)) {
            return;
        }
        boolean isCommit = this.commitSubDesignerData(content);
        if (!isCommit || content.isEmpty()) {
            return;
        }
        boolean flag = this.existDraftOp(content);
        if (!flag) {
            if (!this.resourceCheck(content)) {
                return;
            }
            if (!this.mobTableFieldValidate(content, "text") || !this.mobTableFieldValidate(content, "picture")) {
                return;
            }
            if (this.isPrintModel()) {
                this.getOrCreateDesignService().beforeSave(content);
            }
            String oldContent = this.getPageCache().get(OLD_METADATA);
            Map<Object, Object> result = new HashMap(16);
            try {
                result = saveFunc.apply(content, (Map<String, Object>)SerializationUtils.fromJsonString((String)oldContent, Map.class));
            }
            catch (Throwable e) {
                if (FormDesignerPlugin.isShowStackTrace()) {
                    throw e;
                }
                log.error("\u8bbe\u8ba1\u5668\u4fdd\u5b58\u5931\u8d25.", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FormDesignerPlugin_43", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            if (this.isPrintModel()) {
                this.getOrCreateDesignService().afterSave(content);
            }
            Date date = (Date)result.get(MODIFY_DATE);
            this.getPageCache().put(MODIFY_DATE, String.valueOf(date == null ? System.currentTimeMillis() : date.getTime()));
            this.analyseSaveResult(content, result);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u73b0\u5728draft\u5168\u90e8\u4fee\u6539\u4e3asave,\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58", (String)"FormDesignerPlugin_19", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private static boolean isShowStackTrace() {
        try {
            Object isShowStackTrace;
            Map cache = ParameterReader.loadPublicParameterFromCache();
            if (cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
                return (Boolean)isShowStackTrace;
            }
        }
        catch (Throwable ex) {
            log.error("\u83b7\u53d6\u516c\u5171\u53c2\u6570\u5931\u8d25.", ex);
            return false;
        }
        return false;
    }

    private boolean mobTableFieldValidate(Map<String, Object> content, String fieldType) {
        Object items;
        if (content == null || StringUtils.isBlank((CharSequence)fieldType)) {
            return true;
        }
        String TEXT = "text";
        String PICTURE = "picture";
        String mapFieldKey = "";
        String mobTableColKey = "";
        String mobTableColName = "";
        String _Type_ = "TextMobTableColumnAp";
        String recommendType = ResManager.loadKDString((String)"\u56fe\u7247", (String)"FormDesignerPlugin_44", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        if (fieldType.equalsIgnoreCase(PICTURE)) {
            _Type_ = "PictureMobTableColumnAp";
            recommendType = ResManager.loadKDString((String)"\u6587\u672c", (String)"FormDesignerPlugin_45", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        if (content.get(FORM_META) != null && ((Map)content.get(FORM_META)).get(ITEMS) != null && ((List)(items = ((Map)content.get(FORM_META)).get(ITEMS))).get(0) != null && ((Map)((List)items).get(0)).get(MOB_META) != null && ((Map)((Map)((List)items).get(0)).get(MOB_META)).get(ITEMS) != null) {
            for (Map map : (List)((Map)((Map)((List)items).get(0)).get(MOB_META)).get(ITEMS)) {
                Object item2;
                if (_Type_.equals(map.get("_Type_"))) {
                    mapFieldKey = (String)map.get("MobTableField");
                    mobTableColKey = (String)map.get("Key");
                    mobTableColName = (String)map.get("Name");
                }
                if (!StringUtils.isNotBlank((CharSequence)mapFieldKey) || !StringUtils.isNotBlank((CharSequence)mobTableColKey) || !StringUtils.isNotBlank((CharSequence)mobTableColName)) continue;
                String baseFieldId = "";
                String displayProp = "";
                String baseFieldPropKey = "";
                String baseFieldPropName = "";
                if (content.get(ENTITY_META) == null || ((Map)content.get(ENTITY_META)).get(ITEMS) == null) continue;
                ArrayList entityItems = (ArrayList)((Map)content.get(ENTITY_META)).get(ITEMS);
                for (Object item2 : entityItems) {
                    if (!mapFieldKey.equals(item2.get("Key"))) continue;
                    baseFieldId = (String)item2.get("RefBaseFieldId");
                    displayProp = (String)item2.get("RefDisplayProp");
                    baseFieldPropKey = (String)item2.get("Key");
                    baseFieldPropName = (String)item2.get("Name");
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)baseFieldId)) continue;
                String baseEntityId = "";
                item2 = entityItems.iterator();
                while (item2.hasNext()) {
                    Map item3 = (Map)item2.next();
                    if (!baseFieldId.equalsIgnoreCase((String)item3.get("Id"))) continue;
                    baseEntityId = (String)item3.get("BaseEntityId");
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)baseEntityId) || !StringUtils.isNotBlank((CharSequence)displayProp)) continue;
                MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)baseEntityId);
                DynamicProperty property = entityType.getProperty(displayProp);
                if ((!fieldType.equalsIgnoreCase(TEXT) || !(property instanceof PictureProp)) && (!fieldType.equalsIgnoreCase(PICTURE) || property instanceof PictureProp)) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u7684%1$s(%2$s)\u4e0d\u53ef\u6620\u5c04\u8868\u5355\u7684%3$s(%4$s)\uff0c\u8bf7\u4f7f\u7528\u8868\u683c%5$s\u8fdb\u884c\u6620\u5c04\u3002", (String)"FormDesignerPlugin_36", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), mobTableColName, mobTableColKey, baseFieldPropName, baseFieldPropKey, recommendType);
                this.getView().showErrorNotification(errorMsg);
                return false;
            }
        }
        return true;
    }

    protected IFormDesignService getOrCreateDesignService() {
        if (formDesignService == null) {
            formDesignService = (IFormDesignService)TypesContainer.createInstance((String)"kd.bos.designer.PrintDesignerService");
        }
        return formDesignService;
    }

    private JSONObject devPermission() {
        String appId = this.getPageCache().get(BIZ_APPID);
        String id = this.getPageCache().get("id");
        if (appId == null || StringUtils.isBlank((CharSequence)appId)) {
            appId = GitPermissionUtil.getBizAppId((String)id);
        }
        String number = this.getPageCache().get(NUMBER);
        JSONObject arg = new JSONObject();
        arg.put(BIZ_APPID, (Object)appId);
        arg.put("biznumber", (Object)number);
        return arg;
    }

    private boolean verifyPermissionAndLock(JSONObject arg) {
        String bizAppId = arg.getString(BIZ_APPID);
        boolean isPermission = DevVerifyServiceHelper.verifyPermission(null, (String)bizAppId);
        if (!isPermission) {
            String tip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u4e0a\u8be5\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FormDesignerPlugin_34", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
            return false;
        }
        String bizNumber = arg.getString("biznumber");
        Map lockInfo = DevVerifyServiceHelper.verifyLock(null, (String)bizNumber);
        if (((Boolean)lockInfo.get("result")).booleanValue()) {
            String userName = (String)lockInfo.get("username");
            String tip = String.format(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u5df2\u88ab\u3010%s\u3011\u9501\u5b9a\u3002", (String)"FormDesignerPlugin_35", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), userName);
            this.getView().showTipNotification(tip);
            return false;
        }
        return true;
    }

    private void analyseSaveResult(Map<String, Object> content, Map<String, Object> result) {
        FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
        boolean success = (Boolean)result.get("success");
        if (success) {
            if (!"3".equals(FieldsType.getFieldCreateWay())) {
                this.saveFieldsMap(designer);
            }
            String originMetaCache = this.getPageCache().get("originMetadata");
            MetaIsvCheck.check(this.getView(), content, originMetaCache);
            this.getPageCache().put(OLD_METADATA, SerializationUtils.toJsonString(content));
            String openformId = (String)((Map)content.get(FORM_META)).get("Key");
            String oldKey = this.getPageCache().get(OPEN_FORM_ID);
            if (!openformId.equals(oldKey)) {
                this.getPageCache().put(OPEN_FORM_ID, openformId);
                BillTypeServiceHelper.updateBillTypeFormId((String)openformId, (String)oldKey);
            }
            Map contentMap = (Map)content.get(FORM_META);
            HashMap<String, String> cacheValues = new HashMap<String, String>(3);
            cacheValues.put(OPEN_FORM_ID, openformId);
            cacheValues.put("id", (String)contentMap.get("Id"));
            cacheValues.put(NUMBER, (String)contentMap.get("Key"));
            this.getPageCache().put(cacheValues);
            this.getPageCache().remove(REALTIME_METADATA);
            this.buildLogInfo(openformId);
            this.writeLog((String)contentMap.get("Id"), openformId);
            this.saveMetadataToRepository();
            if (Boolean.TRUE.equals(result.get("warning"))) {
                this.getView().showTipNotification((String)result.get("message"));
            } else {
                this.getView().showSuccessNotification((String)result.get("message"));
            }
        } else {
            List errorList = (List)result.get("errors");
            String strError = SerializationUtils.toJsonString((Object)errorList);
            List errorMaps = SerializationUtils.fromJsonStringToList((String)strError, Map.class);
            designer.showErrors(errorMaps);
            this.getView().showErrorNotification(this.buildErrMsg(errorList));
        }
    }

    private void saveMetadataToRepository() {
        try {
            GitSaveMetadata saveMetadata = new GitSaveMetadata();
            String gitSessionId = this.getPageCache().get("gitSessionId");
            String id = this.getPageCache().get("id");
            String bizAppId = this.getPageCache().get(BIZ_APPID);
            saveMetadata.saveMetadataToRepository(gitSessionId, bizAppId, id, "page");
        }
        catch (Exception e) {
            log.info("git save metadata error", (Object)e);
        }
    }

    private String buildErrMsg(List<ErrorInfo> errorList) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (ErrorInfo error : errorList) {
            list.add(error.getError());
        }
        StringBuilder str = new StringBuilder();
        for (String c : list) {
            str.append(c);
        }
        return str.toString();
    }

    public boolean commitSubDesignerData(Map<String, Object> content) {
        FormDesigner subdesigner = (FormDesigner)this.getView().getControl(SUB_FORM_DESIGNER);
        String modelType = this.getPageCache().get(MODE_TYPE);
        if (!"QueryListModel".equals(modelType)) {
            Map tmap = subdesigner.getContent();
            if (tmap == null) {
                return true;
            }
            String designerName = (String)tmap.get(DESIGNER);
            if (StringUtils.isBlank((CharSequence)designerName)) {
                return true;
            }
            AbstractFormDesignerPlugin plugin = null;
            if (LIST_META.equals(designerName) || MOB_LIST_META.equals(designerName)) {
                plugin = new BillListCDWDesignerPlugin();
            } else if (MOB_META.equals(designerName)) {
                plugin = new MobBillDesignerPlugin();
            }
            if (plugin != null) {
                if (plugin instanceof IFormPlugin) {
                    ((IFormPlugin)plugin).setView(this.getView());
                }
                Map params = (Map)tmap.get(DESIGNER_PARAMS);
                params.put(PROPERTY_NAME, designerName);
                Object v = plugin.getReturnData(subdesigner, params);
                if (v instanceof String) {
                    if (StringUtils.isNotBlank((Object)v)) {
                        this.getView().showTipNotification((String)v);
                    }
                    return false;
                }
                Map formMeta = (Map)content.get(FORM_META);
                List items = (List)formMeta.get(ITEMS);
                Map formAp = (Map)items.get(0);
                Map value = (Map)v;
                formAp.put((String)value.get(PROPERTY_NAME), value.get(VALUE));
            }
        } else {
            ListDesignerValidator listDesignerValidator = new ListDesignerValidator();
            String validate = listDesignerValidator.validate(content, null, (List)((Map)content.get(ENTITY_META)).get(ITEMS));
            if (StringUtils.isNotBlank((CharSequence)validate)) {
                this.getView().showErrorNotification(validate);
                return false;
            }
        }
        return true;
    }

    private void doPublish() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_parapublishconsole");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String appId = (String)params.get(BIZ_APPID);
        if (StringUtils.isBlank((CharSequence)appId)) {
            String id = (String)params.get("id");
            AbstractMetadata formMetadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
            appId = formMetadata.getBizappId();
        }
        String modelType = this.getPageCache().get(MODE_TYPE);
        DynamicObject cloudObj = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
        switch (modelType) {
            case "ParameterFormModel_public": {
                parameter.setCustomParam(PARAM_TYPE, (Object)"public");
                break;
            }
            case "ParameterFormModel_cloud": {
                parameter.setCustomParam(PARAM_TYPE, (Object)cloudObj.getString("id"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e91\u53c2\u6570\u53d1\u5e03\u3002", (String)"FormDesignerPlugin_26", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            case "ParameterFormModel_application": {
                parameter.setCustomParam(PARAM_TYPE, (Object)appId);
                break;
            }
            default: {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u516c\u5171\u53c2\u6570\u3001\u4e91\u4ea7\u54c1\u53c2\u6570\u3001\u5e94\u7528\u53c2\u6570\u7684\u53d1\u5e03", (String)"FormDesignerPlugin_20", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        parameter.setCustomParam(SHOW_FORM_LANG_PARAM, (Object)this.getPreviewLang());
        this.getView().showForm(parameter);
    }

    public void afterSetProperty(PropertyEvent e) {
        String propertyName = e.getPropertName();
        if ("Language".equals(propertyName)) {
            FormDesigner designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER);
            Map content = designer.getContent();
            String lang = (String)e.getParam().get(VALUE);
            content.put(LOCALE_ITEMS, SerializationUtils.fromJsonString((String)this.getPageCache().get(LOCALE_ITEMS), Map.class));
            DesignerData designerData = new DesignerData();
            Map<String, Object> tMap = designerData.getMeatadata(content, lang);
            String modelType = (String)tMap.get(MODE_TYPE);
            this.fillInheritProperty(tMap, lang);
            this.switchPreviewLang(lang);
            designer.open(modelType, tMap);
            designer.sendFieldProsLock(DesignerUtils.getSpecialPropsExtensible((String)((String)tMap.get("id"))));
            designer.sendMulLangProperty((Map)tMap.remove("clientLocaleItems"));
            this.getPageCache().put(LOCALE_ITEMS, SerializationUtils.toJsonString((Object)tMap.remove(LOCALE_ITEMS)));
        }
    }

    private void fillInheritProperty(Map<String, Object> designMeta, String lang) {
        if (null == designMeta) {
            return;
        }
        String id = (String)designMeta.get("id");
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        Map originDesignMeta = MetadataDao.loadDesignerMetadata((String)id, (String)lang);
        if (null == originDesignMeta) {
            return;
        }
        Map originFormMeta = (Map)originDesignMeta.get(FORM_META);
        Map originEntityMeta = (Map)originDesignMeta.get(ENTITY_META);
        Map<String, Boolean> originControlInheritMap = this.getInheritMap(originFormMeta);
        Map<String, Boolean> originEntityInheritMap = this.getInheritMap(originEntityMeta);
        Map formMeta = (Map)designMeta.get(FORM_META);
        Map entityMeta = (Map)designMeta.get(ENTITY_META);
        this.fillInherit(formMeta, originControlInheritMap);
        this.fillInherit(entityMeta, originEntityInheritMap);
    }

    private void fillInherit(Map<String, Object> meta, Map<String, Boolean> inheritMap) {
        if (null == meta) {
            return;
        }
        List items = (List)meta.get(ITEMS);
        if (null == items) {
            return;
        }
        for (Map item : items) {
            Boolean idValue;
            String id = (String)item.get("Id");
            if (!StringUtils.isNotBlank((CharSequence)id) || (idValue = inheritMap.get(id)) == null) continue;
            item.put("Inherit", idValue);
        }
    }

    private Map<String, Boolean> getInheritMap(Map<String, Object> meta) {
        HashMap<String, Boolean> inheritMap = new HashMap<String, Boolean>();
        if (null == meta) {
            return inheritMap;
        }
        List items = (List)meta.get(ITEMS);
        if (null == items) {
            return inheritMap;
        }
        for (Map item : items) {
            String id = (String)item.get("Id");
            Boolean inherit = (Boolean)item.get("Inherit");
            if (!StringUtils.isNotBlank((CharSequence)id) || null == inherit) continue;
            inheritMap.put(id, inherit);
        }
        return inheritMap;
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        long userID = 0L;
        long themeID = 0L;
        String userIDStr = null;
        String themeIDStr = null;
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        switch (key) {
            case "getUserTheme": {
                userIDStr = RequestContext.get().getUserId();
                try {
                    userID = Long.parseLong(userIDStr);
                }
                catch (Exception ex) {
                    return;
                }
                Map theme = UserServiceHelper.getUserTheme((Long)userID);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), GET_USER_THEME, new Object[]{theme});
                break;
            }
            case "setUserTheme": {
                userIDStr = RequestContext.get().getUserId();
                themeIDStr = e.getEventArgs();
                try {
                    userID = Long.parseLong(userIDStr);
                }
                catch (Exception ex) {
                    return;
                }
                try {
                    themeID = Long.parseLong(themeIDStr);
                }
                catch (Exception ex) {
                    themeID = 0L;
                }
                if (themeID == 0L) {
                    UserServiceHelper.setUserTheme((Long)userID, (String)themeIDStr);
                } else {
                    UserServiceHelper.setUserTheme((Long)userID, (Long)themeID);
                }
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("themeNum", themeIDStr);
                AppCache.get((String)"bos").put("theme" + userID, (Object)SerializationUtils.toJsonString(result));
                break;
            }
            case "getThemeCSS": {
                String themeNum = themeIDStr = e.getEventArgs();
                if (StringUtils.isEmpty((CharSequence)themeNum)) {
                    String errorMessage = ResManager.loadKDString((String)"\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a\u4e0d\u5b58\u5728\u53c2\u6570\u201cthemeNum\u201d\u3002", (String)"FormDesignerPlugin_21", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                    clientViewProxy.invokeControlMethod(this.getView().getPageId(), GET_USER_THEME, new Object[]{errorMessage});
                    return;
                }
                String css = UserServiceHelper.getThemeCSS((String)themeNum);
                clientViewProxy.invokeControlMethod(this.getView().getPageId(), "getThemeCSS", new Object[]{css});
                break;
            }
            case "showMobileCtrl": {
                this.preview("cos_component", "MobileBillFormModel");
                break;
            }
        }
    }

    public void keyDown(KeyPressArgs keys) {
        if (keys.isCtrlKey() && keys.getKeyCode() == 83) {
            this.saveData();
        }
    }

    public void afterAddControl(AfterAddControlEvent event) {
        Map params = event.getParams();
        ArrayList<Map<String, Object>> ops = new ArrayList(10);
        List dataList = new ArrayList(10);
        if (params.get("operations") != null && params.get("data") != null) {
            ops = (List)params.get("operations");
            dataList = (List)params.get("data");
        }
        if (ops.isEmpty() || dataList.isEmpty()) {
            return;
        }
        String rootId = "";
        for (Map data : dataList) {
            Map attributes;
            rootId = (String)data.get("rootId");
            String entryId = "";
            if ("CardEntryAp".equalsIgnoreCase((String)data.get("controlType"))) {
                entryId = (String)data.get("entryId");
            }
            if (StringUtils.isBlank((CharSequence)rootId) || StringUtils.isBlank((CharSequence)entryId) || (attributes = (Map)data.get("setAttr")) == null || attributes.isEmpty()) continue;
            ArrayList<Map<String, Object>> formDataList = new ArrayList<Map<String, Object>>(10);
            Map<String, Object> entityOpData = this.handleOperationData(attributes, formDataList, ops, entryId, rootId);
            this.setOperationAndContent(entityOpData, formDataList);
        }
    }

    private Map<String, Object> handleOperationData(Map<String, Object> attribute, List<Map<String, Object>> formDataList, List<Map<String, Object>> ops, String entryId, String rootId) {
        HashMap<String, Object> entityOpData = new HashMap<String, Object>(5);
        String itemId = (String)attribute.get("id");
        String propName = (String)attribute.get("prop");
        String opName = "";
        String opKey = "";
        List opTypes = (List)attribute.get("type");
        if (StringUtils.isBlank((CharSequence)itemId) || StringUtils.isBlank((CharSequence)propName) || opTypes == null || opTypes.isEmpty()) {
            return entityOpData;
        }
        ArrayList<Map<String, Object>> addOps = new ArrayList<Map<String, Object>>(10);
        for (String opType : opTypes) {
            Map<Object, Object> addOp = new HashMap(6);
            boolean existOp = false;
            for (Map<String, Object> op : ops) {
                Map par;
                if (op == null || !opType.equalsIgnoreCase((String)op.get("OperationType")) || (par = (Map)op.get("Parameter")) == null || !entryId.equalsIgnoreCase((String)par.get("EntryId"))) continue;
                addOp = op;
                existOp = true;
                break;
            }
            if (addOp.get("Id") == null || !existOp) {
                addOp = CreateOperationUtils.createOperationByTypeAndId((String)opType, (String)entryId);
            }
            opName = (String)addOp.get("Name");
            opKey = (String)addOp.get("Key");
            addOps.add(addOp);
            if (existOp) continue;
            ops.add(addOp);
        }
        if (entityOpData.get(VALUE) == null) {
            entityOpData.put("alias", this.getOperationAlias(ops));
            entityOpData.put("itemId", rootId);
            entityOpData.put("metaType", ENTITY_META);
            entityOpData.put(PROPERTY_NAME, "Operations");
            entityOpData.put(VALUE, ops);
        }
        HashMap<String, Object> formData = new HashMap<String, Object>(6);
        formData.put("itemId", itemId);
        formData.put("metaType", FORM_META);
        if ("OperationKey".equalsIgnoreCase(propName)) {
            formData.put(PROPERTY_NAME, propName);
            formData.put("opName", opName);
            formData.put("operations", entityOpData);
            formData.put(VALUE, opKey);
            formDataList.add(formData);
            HashMap<String, String> formData1 = new HashMap<String, String>(6);
            formData1.put("itemId", itemId);
            formData1.put("metaType", FORM_META);
            formData1.put(PROPERTY_NAME, "Name");
            formData1.put(VALUE, opName);
            formDataList.add(formData1);
        } else if ("CardOperationBar".equalsIgnoreCase(propName)) {
            formData.put("alias", this.getOperationAlias(addOps));
            formData.put(PROPERTY_NAME, propName);
            ArrayList valueList = new ArrayList(10);
            int index = 1;
            for (Map map : addOps) {
                HashMap<String, Object> value1 = new HashMap<String, Object>(5);
                value1.put("Id", Uuid16.create().toString());
                value1.put("Key", map.get("Key"));
                value1.put("Name", map.get("Name"));
                value1.put("Index", index++);
                value1.put("Visible", "init,new,edit,view,submit,audit");
                value1.put("OpKey", map.get("Key"));
                valueList.add(value1);
            }
            formData.put(VALUE, valueList);
            formDataList.add(formData);
        }
        return entityOpData;
    }

    private void setOperationAndContent(Map<String, Object> entityOpData, List<Map<String, Object>> formDataList) {
        IFormView formView = this.getView();
        FormDesigner designer = (FormDesigner)formView.getControl(FORM_DESIGNER);
        FormDesigner subDesigner = (FormDesigner)formView.getControl(SUB_FORM_DESIGNER);
        if (designer != null) {
            designer.setProperty(entityOpData);
            designer.setProperty(formDataList);
        }
        if (subDesigner != null) {
            subDesigner.setProperty(entityOpData);
            subDesigner.setProperty(formDataList);
        }
    }

    private String getOperationAlias(List<Map<String, Object>> ops) {
        StringBuilder alias = new StringBuilder();
        if (ops != null && !ops.isEmpty()) {
            for (Map<String, Object> op : ops) {
                if (op == null) continue;
                alias.append(alias.length() == 0 ? "" : ",").append(op.get("Name"));
            }
        }
        return alias.toString();
    }

    protected void buildLogInfo(String formId) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo logInfo = this.doBuildLogInfo(formId);
        logService.addLog((AppLogInfo)logInfo);
    }

    private OpLogAppInfo doBuildLogInfo(String formId) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)"ide"));
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge formDesignerSave = new MultiLangEnumBridge("\u4fdd\u5b58\u8868\u5355\u5143\u6570\u636e", "FormDesignerPlugin_48", BOS_DESIGNER_PLUGIN);
        MultiLangEnumBridge desc = new MultiLangEnumBridge("\u8868\u5355\u5143\u6570\u636e\u4fdd\u5b58\u6210\u529f", "FormDesignerPlugin_22", BOS_DESIGNER_PLUGIN);
        logInfo.setOpName("saveFormMeta", formDesignerSave);
        logInfo.setStatus("1");
        logInfo.setKeyWord(formId);
        logInfo.setOpDesc(desc, new String[0]);
        return logInfo;
    }

    private void writeLog(String formId, String formNumber) {
        try {
            long fid = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            if (this.isBizObjExt()) {
                String bizOperateKey = this.getPageCache().get(BIZ_OPERATE_KEY);
                if (TEST_SAVE.equals(bizOperateKey)) {
                    logService.addMetaLog(formId, formNumber, (int)MetaLogType.BizObjExtSave.getValue(), fid, (int)MetaType.Form.getValue());
                } else if (TEST_DEPLOY.equals(bizOperateKey)) {
                    logService.addMetaLog(formId, formNumber, (int)MetaLogType.BizObjExtDeploy.getValue(), fid, (int)MetaType.Form.getValue());
                }
            } else {
                logService.addMetaLog(formId, formNumber, (int)MetaLogType.FormDesign.getValue(), fid, (int)MetaType.Form.getValue());
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public String autoExtendedNumber(String number) {
        String isv = ISVService.getISVInfo().getId();
        number = number.toLowerCase(Locale.ENGLISH);
        if (!ISV_KINGDEE.equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv) && !number.startsWith(isv.toLowerCase() + "_")) {
            number = isv.toLowerCase() + "_" + number;
        }
        if ((number = number + FORM_EXT).length() > 25) {
            int tag_len = FORM_EXT.length();
            number = number.substring(0, 25 - tag_len) + FORM_EXT;
        }
        return number;
    }

    public String autoFormNumber(String formNumber, String tag, String formId, String masterId) {
        int formCounts = this.getExtFormCounts(formId, masterId);
        if (formNumber.length() <= 25) {
            if (formCounts > 0) {
                formNumber = formNumber + formCounts;
            }
        } else {
            int tag_len = tag.length();
            formNumber = formNumber.substring(0, 25 - tag_len) + tag;
            if (formCounts > 0) {
                int i_len = String.valueOf(formCounts).length();
                formNumber = formNumber.substring(0, 25 - tag_len - i_len) + tag + formCounts;
            }
        }
        return formNumber;
    }

    public int getExtFormCounts(String formId, String masterId) {
        String sql = String.format("select 1 from %s where FMASTERID = ? ", "T_META_FORMDESIGN");
        Object[] params = new SqlParameter[]{StringUtils.isBlank((CharSequence)masterId) ? new SqlParameter(":FMASTERID", 12, (Object)formId) : new SqlParameter(":FMASTERID", 12, (Object)masterId)};
        return (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                int isvcount = 0;
                if (rs.next()) {
                    isvcount = rs.getInt(1);
                }
                return isvcount;
            }
        });
    }

    private boolean isPrintModel() {
        boolean isPrint = false;
        try {
            String modelType = this.getPageCache().get(MODE_TYPE);
            if (StringUtils.isBlank((CharSequence)modelType)) {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String id = (String)showParameter.getCustomParam("id");
                modelType = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_formmeta", (String)"modeltype").getString("modeltype");
            }
            if ("PrintModel".equals(modelType)) {
                isPrint = true;
            }
        }
        catch (Exception e) {
            log.error("\u65e7\u6253\u5370\u8bbe\u8ba1\u5668\u5224\u65ad\u662f\u5426\u662f\u6253\u5370\u6a21\u578b\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
        return isPrint;
    }

    private boolean validateEntryPrimaryKey(Map<String, Object> content) {
        if (content.isEmpty()) {
            return true;
        }
        Map formMeta = (Map)content.get(ENTITY_META);
        if (formMeta == null || formMeta.size() == 0) {
            return true;
        }
        List items = (List)formMeta.get(ITEMS);
        if (items == null || items.size() == 0) {
            return true;
        }
        String routeKey = "";
        for (Map item : items) {
            String tableName;
            Object dbRoute = item.get("dbRoute");
            if (dbRoute != null) {
                routeKey = (String)dbRoute;
            }
            if (StringUtils.isEmpty((CharSequence)(tableName = (String)item.get("TableName")))) continue;
            String entryEntity = (String)item.get("Key");
            String primaryKey = "";
            String type = (String)item.get("_Type_");
            if ("LogBillEntity".equals(type)) {
                routeKey = "log";
            }
            Object pkkFieldName = item.get("PkFieldName");
            Object entryPkFieldName = item.get("EntryPkFieldName");
            Object subEntryPkFieldName = item.get("SubEntryPkFieldName");
            if (pkkFieldName != null) {
                primaryKey = (String)pkkFieldName;
            } else if (entryPkFieldName != null) {
                primaryKey = (String)entryPkFieldName;
            } else if (subEntryPkFieldName != null) {
                primaryKey = (String)subEntryPkFieldName;
            } else {
                if (StringUtils.isEmpty((CharSequence)type) || type.contains("Field")) continue;
                switch (type) {
                    case "EntryEntity": 
                    case "TreeEntryEntity": {
                        primaryKey = "FEntryId";
                        break;
                    }
                    case "EmbedSubEntryEntity": 
                    case "TreeSubEntryEntity": 
                    case "SubEntryEntity": {
                        primaryKey = "FDetailID";
                        break;
                    }
                    default: {
                        primaryKey = "FId";
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)primaryKey)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u7684\u4e3b\u952e\u3002", (String)"FormDesignerPlugin_40", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entryEntity));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)routeKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u5355\u7684\u8def\u7531\u4e3a\u7a7a\uff0c\u8bf7\u7ed9\u672c\u5355\u6240\u5728\u5e94\u7528\u6307\u5b9a\u6570\u636e\u5e93\u3002", (String)"FormDesignerPlugin_39", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return false;
            }
            List primaryFields = DB.getPrimaryKeys((DBRoute)DBRoute.of((String)routeKey), (String)tableName);
            if (primaryFields == null || primaryFields.size() == 0 || !StringUtils.isNotEmpty((CharSequence)primaryKey) || primaryKey.equalsIgnoreCase((String)primaryFields.get(0))) continue;
            if ("EntryEntity".equals(type) || "TreeEntryEntity".equals(type) || "SubEntryEntity".equalsIgnoreCase(type) || "TreeSubEntryEntity".equalsIgnoreCase(type) || "EmbedSubEntryEntity".equalsIgnoreCase(type)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5355\u636e\u4f53%1$s\u4e2d\uff0c\u8868%2$s\u5df2\u5b58\u5728\u4e3b\u952e%3$s\uff0c\u8bf7\u52ff\u4fee\u6539\u3002", (String)"FormDesignerPlugin_37", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entryEntity, tableName, primaryFields.get(0)));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u8868%1$s\u4e2d\uff0c\u5df2\u5b58\u5728\u4e3b\u952e%2$s\uff0c\u8bf7\u52ff\u4fee\u6539\u3002", (String)"FormDesignerPlugin_38", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), tableName, primaryFields.get(0)));
            }
            return false;
        }
        return true;
    }

    private void saveFieldsMap(FormDesigner designer) {
        try {
            String entityId;
            MainEntityType entity;
            if (designer == null) {
                return;
            }
            Map designerContent = designer.getContent();
            if (designerContent == null || designerContent.size() == 0) {
                return;
            }
            Object entityMetaObject = designerContent.get(ENTITY_META);
            if (entityMetaObject == null) {
                return;
            }
            Object items = ((Map)entityMetaObject).get(ITEMS);
            if (items == null) {
                return;
            }
            ArrayList itemsList = (ArrayList)items;
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_devpn_field");
            String entityNumber = (String)((Map)itemsList.get(0)).get("Key");
            this.saveDeleteField2Db(entityNumber);
            if ("2".equalsIgnoreCase((String)designerContent.get("devType"))) {
                String masterId = (String)((Map)entityMetaObject).get("MasterId");
                entity = EntityMetadataCache.getDataEntityTypeById((String)masterId);
                entityId = entity.getName();
            } else {
                entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
                entityId = entityNumber;
            }
            for (int i = 0; i < itemsList.size(); ++i) {
                Object refField;
                Map item = (Map)itemsList.get(i);
                if (!FieldsType.FIELD_TYPE_MAPPER.containsKey(item.get("_Type_")) || (refField = item.get("RefField")) == null) continue;
                Map refFieldMap = (Map)SerializationUtils.fromJsonString((String)((String)refField), Map.class);
                Object id = refFieldMap.get("Id");
                DynamicObject fieldData = BusinessDataReader.loadSingle(id, (DynamicObjectType)type);
                DynamicObjectCollection entryRows = fieldData.getDynamicObjectCollection("entryentity");
                boolean refContainCurrentEntity = false;
                String relationType = "R";
                for (DynamicObject row : entryRows) {
                    Object entryentity = row.get("entityId");
                    if (!(entryentity instanceof DynamicObject)) continue;
                    relationType = (String)row.get("type");
                    if (entityId.equalsIgnoreCase((String)((DynamicObject)entryentity).get(NUMBER)) && "R".equalsIgnoreCase(relationType)) {
                        refContainCurrentEntity = true;
                        break;
                    }
                    if (!"A".equalsIgnoreCase(relationType)) continue;
                    row.set("type", (Object)"R");
                }
                if (refContainCurrentEntity) continue;
                if ("R".equalsIgnoreCase(relationType)) {
                    int startSeq = entryRows.size();
                    long[] ids = ID.genLongIds((int)1);
                    String fieldnumber = (String)item.get("Key");
                    IDataEntityProperty property = (IDataEntityProperty)entity.getAllFields().get(fieldnumber);
                    if (property == null) {
                        log.info("FormDesignerPlugin.saveFieldsMap property is null, refFieldKey is {}", (Object)fieldnumber);
                        return;
                    }
                    DynamicObject newRow = entryRows.addNew();
                    newRow.set("type", (Object)"R");
                    newRow.set("fieldkey", (Object)property.getName());
                    newRow.set("entityid_id", (Object)entityId);
                    newRow.set("fieldcaption", (Object)property.getDisplayName());
                    newRow.set("seq", (Object)startSeq++);
                    newRow.set("id", (Object)ids[0]);
                    BusinessDataWriter.save((IDataEntityType)type, (Object[])new Object[]{fieldData});
                    continue;
                }
                BusinessDataWriter.update((IDataEntityType)type, (Object[])new Object[]{fieldData});
            }
            this.getPageCache().remove("cacherefields");
            this.getPageCache().remove("deleterefieldids");
            this.getPageCache().remove("deletefiledkey");
        }
        catch (Exception e) {
            log.error("EntityDesignerPlugin.saveFieldsMap throw excption : {}", (Object)e.getMessage());
        }
    }

    private void cacheRefField(List<Map<String, Object>> cacheProperty) {
        for (int i = 0; i < cacheProperty.size(); ++i) {
            String entityNumber;
            Object entityMetaObject;
            FormDesigner designer;
            Map designerContent;
            Map<String, Object> prop = cacheProperty.get(i);
            if (!"RefField".equalsIgnoreCase((String)prop.get(PROPERTY_NAME))) continue;
            String refEntityFieldKey = this.getPageCache().get("refEntityFieldKey");
            if (StringUtils.isNotBlank((CharSequence)refEntityFieldKey) && (designerContent = (designer = (FormDesigner)this.getView().getControl(FORM_DESIGNER)).getContent()) != null && designerContent.size() > 0 && (entityMetaObject = designerContent.get(ENTITY_META)) instanceof Map && StringUtils.isNotBlank((CharSequence)(entityNumber = (String)((Map)entityMetaObject).get("Key")))) {
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid from t_meta_fieldsentry", new Object[0]).appendIn("where fentityid", (Object[])new String[]{entityNumber}).append(" and ffieldkey = ?", new Object[]{new kd.bos.db.SqlParameter(":ffieldkey", 12, (Object)refEntityFieldKey)});
                Set fieldsIds = (Set)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
                    HashSet<Object> fids = new HashSet<Object>(10);
                    while (rs.next()) {
                        fids.add(rs.getObject("fid"));
                    }
                    return fids;
                });
                if (fieldsIds.size() > 0) {
                    this.addFieldId2DeleteFieldCache(fieldsIds);
                }
            }
            String refFieldValue = (String)prop.get(VALUE);
            Map refFieldMap = (Map)SerializationUtils.fromJsonString((String)refFieldValue, Map.class);
            long fieldId = (Long)refFieldMap.get("Id");
            this.addFieldId2CacheRefFieldCache(fieldId, refFieldMap);
        }
    }

    private void addFieldId2CacheRefFieldCache(long fieldId, Map<String, Object> refFieldMap) {
        String cacheRefFields = this.getPageCache().get("cacherefields");
        Map cacheRefFieldMap = StringUtils.isBlank((CharSequence)cacheRefFields) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)cacheRefFields, Map.class);
        cacheRefFieldMap.put(Long.toString(fieldId), refFieldMap);
        this.getPageCache().put("cacherefields", SerializationUtils.toJsonString(cacheRefFieldMap));
    }

    @Override
    protected void deleteRefField(PropertyEvent e) {
        boolean deleteRefFieldFromDb = true;
        long deleteFieldId = 0L;
        String cacheRefFields = this.getPageCache().get("cacherefields");
        if (StringUtils.isNotBlank((CharSequence)cacheRefFields)) {
            Map refFieldMap;
            Map cacheRefFieldMap = (Map)SerializationUtils.fromJsonString((String)cacheRefFields, Map.class);
            String refFieldValue = (String)e.getParam().get("RefField");
            if (StringUtils.isNotBlank((CharSequence)refFieldValue) && (refFieldMap = (Map)SerializationUtils.fromJsonString((String)refFieldValue, Map.class)) != null && refFieldMap.size() > 0 && cacheRefFieldMap.containsKey(Long.toString(deleteFieldId = ((Long)refFieldMap.get("Id")).longValue()))) {
                deleteRefFieldFromDb = false;
                cacheRefFieldMap.remove(Long.toString(deleteFieldId));
                this.getPageCache().put("cacherefields", SerializationUtils.toJsonString((Object)cacheRefFieldMap));
            }
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("itemId", e.getItemId());
        propMap.put("metaType", e.getMetaType());
        propMap.put(PROPERTY_NAME, "RefField");
        propMap.put(VALUE, "");
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        designer.setProperty(propMap);
        if (deleteRefFieldFromDb && deleteFieldId == 0L) {
            Map refFieldMap;
            Object refFieldObject = e.getParam().get("RefField");
            if (refFieldObject instanceof String && StringUtils.isNotBlank(refFieldObject) && !"\"\"".equals(refFieldObject) && (refFieldMap = (Map)SerializationUtils.fromJsonString((String)((String)refFieldObject), Map.class)) != null && refFieldMap.size() > 0) {
                deleteFieldId = (Long)refFieldMap.get("Id");
            }
            HashSet<Object> deleteFields = new HashSet<Object>();
            deleteFields.add(deleteFieldId);
            this.addFieldId2DeleteFieldCache(deleteFields);
        }
    }

    private void addFieldId2DeleteFieldCache(Set<Object> deleteFieldId) {
        String deleteRefFieldStr = this.getPageCache().get("deleterefieldids");
        Set deleteIdsCache = StringUtils.isBlank((CharSequence)deleteRefFieldStr) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)deleteRefFieldStr, Set.class);
        deleteIdsCache.addAll(deleteFieldId);
        this.getPageCache().put("deleterefieldids", SerializationUtils.toJsonString(deleteIdsCache));
    }

    private void saveDeleteField2Db(String entityNumber) {
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            String deleteFieldStr;
            String deleteRefFieldStr = this.getPageCache().get("deleterefieldids");
            if (StringUtils.isNotBlank((CharSequence)deleteRefFieldStr)) {
                ArrayList<Object> fids = new ArrayList<Object>();
                Set deleteIdsCache = (Set)SerializationUtils.fromJsonString((String)deleteRefFieldStr, Set.class);
                for (Object id : deleteIdsCache) {
                    if (id instanceof String) {
                        fids.add(Long.valueOf((String)id));
                        continue;
                    }
                    fids.add(id);
                }
                if (fids.size() > 0) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("delete from t_meta_fieldsentry ", new Object[0]).appendIn("where fid", fids).appendIn(" and fentityid", (Object[])new String[]{entityNumber}).append(" and ftype= 'R'", new Object[0]);
                    DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sql);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(deleteFieldStr = this.getPageCache().get("deletefiledkey")))) {
                ArrayList fieldsNumbers = new ArrayList();
                Set cacheDeletField = (Set)SerializationUtils.fromJsonString((String)deleteFieldStr, Set.class);
                for (Object fieldNum : cacheDeletField) {
                    if (!(fieldNum instanceof String)) continue;
                    fieldsNumbers.add(fieldNum);
                }
                if (fieldsNumbers.size() > 0) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("delete from t_meta_fieldsentry ", new Object[0]).appendIn("where fentityid", (Object[])new String[]{entityNumber}).appendIn("and ffieldkey", fieldsNumbers);
                    DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sql);
                }
            }
        }
    }
}

