/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.designer.baserecordset.AbstractDataSetOperater;
import kd.bos.designer.dao.DesignerData;
import kd.bos.designer.dao.LibAddress;
import kd.bos.designer.dao.MetadataUtil;
import kd.bos.designer.dao.OperationInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataExtends;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.mvc.SessionManager;

public class FormListPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    public static final String BOS_MOBILEPREVIEW = "bos_mobilepreview";
    public static final String FORM_LIST = "formlist";
    public static final String PARAM_ID = "id";
    public static final String PARAM_NUMBER = "number";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_MODEL_TYPE = "modelType";
    public static final String PARAM_ENTITY_ID = "entityid";
    public static final String PARAM_SUBSYSTEM = "subsystem";
    public static final String PARAM_SYBSYSID = "subsysid";
    public static final String PARAM_INHERIT_PATH = "inheritpath";
    public static final String PARAM_MOB = "Mob";
    public static final String PARAM_ISPC = "isPC";
    public static final String NEW_FORM_CALLBACK = "newformcallback";
    public static final String NEW_LAYOUT_CALLBACK = "newlayoutcallback";
    public static final String SET_ADDRESS_CALLBACK = "setaddresscallback";
    public static final String LOGIN_CALLBACK = "logincallback";
    public static final String MESSAGE = "message";
    private static final String SUB_FNUMBER = "subFnumber";
    private static final String MODE_TYPE = "modeltype";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String FORM_LIST_PLUGIN_3 = "FormListPlugin_3";
    private static final String FNUMBER = "fNumber";
    private static final String TAB_AP = "tabap";

    public void initialize() {
        this.addClickListeners(new String[]{"btnnewform", "btnnewsubsystem", "btnopen", "btnaddplaylout", "btnaddprinttemplate", "btndel", "btnexp", "btnimp", "btnlist", "btnrefresh", "btnmoblist", "btnsvn", "btntest", "btnmodel", "btnexpdata", "btnimpdata", "btncheckindata", "btnunittest", "btnutrelease", "btnresetparent"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FORM_LIST);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        this.getData();
    }

    private void refresh() {
        this.getModel().beginInit();
        this.getData();
        this.getModel().updateCache();
        this.getModel().endInit();
    }

    private void getData() {
        List formList;
        Object[] params = new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN")};
        String sql = "select a.FID, b.FNumber,a.FNAME, b.FMODELTYPE,b.FEntityId,b.FInheritPath from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID where a.FLOCALEID = ? ";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>(16);
                        map.put(FormListPlugin.PARAM_ID, rs.getString(1));
                        map.put(FormListPlugin.PARAM_NUMBER, rs.getString(2));
                        map.put(FormListPlugin.PARAM_NAME, rs.getString(3));
                        String modelType = rs.getString(4);
                        map.put(FormListPlugin.PARAM_MODEL_TYPE, modelType);
                        map.put(FormListPlugin.PARAM_ENTITY_ID, rs.getString(5));
                        map.put(FormListPlugin.PARAM_SUBSYSTEM, "");
                        map.put(FormListPlugin.PARAM_SYBSYSID, 1);
                        map.put(FormListPlugin.PARAM_INHERIT_PATH, rs.getString(6));
                        if (modelType.startsWith(FormListPlugin.PARAM_MOB)) {
                            map.put(FormListPlugin.PARAM_ISPC, false);
                        } else {
                            map.put(FormListPlugin.PARAM_ISPC, true);
                        }
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (!formList.isEmpty()) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(FORM_LIST);
            if (formList.size() - count > 0) {
                model.batchCreateNewEntryRow(FORM_LIST, formList.size() - count);
                int i = 0;
                for (Map form : formList) {
                    model.setValue(PARAM_ID, form.get(PARAM_ID), i);
                    model.setValue(PARAM_NUMBER, form.get(PARAM_NUMBER), i);
                    model.setValue(PARAM_NAME, form.get(PARAM_NAME), i);
                    model.setValue(PARAM_MODEL_TYPE, form.get(PARAM_MODEL_TYPE), i);
                    model.setValue(PARAM_ENTITY_ID, form.get(PARAM_ENTITY_ID), i);
                    model.setValue(PARAM_SYBSYSID, form.get(PARAM_SYBSYSID), i);
                    model.setValue(PARAM_SUBSYSTEM, form.get(PARAM_SUBSYSTEM), i);
                    model.setValue(PARAM_INHERIT_PATH, form.get(PARAM_INHERIT_PATH), i);
                    ++i;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret;
        if (NEW_FORM_CALLBACK.equals(e.getActionId())) {
            if (e.getReturnData() != null) {
                Map param = (Map)e.getReturnData();
                this.showNewDesigner(param);
            }
        } else if (NEW_LAYOUT_CALLBACK.equals(e.getActionId())) {
            if (e.getReturnData() != null) {
                Map param = (Map)e.getReturnData();
                this.showNewDesigner(param);
            }
        } else if (SET_ADDRESS_CALLBACK.equals(e.getActionId())) {
            if (e.getReturnData() != null) {
                String libAddress = (String)e.getReturnData();
                SessionManager.getCurrent().put("libaddress", libAddress);
            }
        } else if (LOGIN_CALLBACK.equals(e.getActionId())) {
            if (e.getReturnData() != null) {
                this.listSVNForm();
            }
        } else if ("delForm".equals(e.getActionId()) && "ok".equals(e.getReturnData())) {
            MetadataUtil metadataUtil = new MetadataUtil();
            Map<String, String> sel = this.getCurrentSelector();
            Map<String, Object> result = metadataUtil.delFormMetadata(sel.get(PARAM_ID));
            if (((Boolean)result.get("success")).booleanValue()) {
                this.getModel().deleteEntryRow(FORM_LIST, this.getModel().getEntryCurrentRowIndex(FORM_LIST));
            }
            this.getView().showTipNotification(result.get(MESSAGE).toString());
        } else if ("resetparentback".equals(e.getActionId()) && (ret = (Map)e.getReturnData()) != null) {
            this.resetParent((String)ret.get(PARAM_ID));
        }
    }

    private void showDesigner(String id, String number, String modelType, String subSysId, String subFnumber) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam(PARAM_ID, (Object)id);
        parameter.setCustomParam(PARAM_NUMBER, (Object)number);
        parameter.setCustomParam(PARAM_SYBSYSID, (Object)subSysId);
        parameter.setCustomParam(SUB_FNUMBER, (Object)subFnumber);
        parameter.setClientParam(MODE_TYPE, (Object)modelType);
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(parameter);
    }

    private void showNewDesigner(Map<String, Object> param) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam("newParam", param);
        parameter.setCustomParam(SUB_FNUMBER, param.get(SUB_FNUMBER));
        parameter.setClientParam(MODE_TYPE, param.get(PARAM_MODEL_TYPE));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(parameter);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnnewform": {
                this.newForm();
                break;
            }
            case "btnaddprinttemplate": {
                this.addNewPrintTemplate();
                break;
            }
            case "btnopen": {
                this.openForm();
                break;
            }
            case "btnimp": {
                this.impForm();
                break;
            }
            case "btnexp": {
                this.expForm();
                break;
            }
            case "btndel": {
                this.delForm();
                break;
            }
            case "btnlist": {
                this.listForm();
                break;
            }
            case "btnmoblist": {
                this.previewMobList();
                break;
            }
            case "btnrefresh": {
                this.refresh();
                break;
            }
            case "btnsvn": {
                this.listSVNForm();
                break;
            }
            case "btnmodel": {
                this.listDomainModelType();
                break;
            }
            case "btntest": {
                this.photos();
                break;
            }
            case "btnexpdata": {
                this.expFormData();
                break;
            }
            case "btnimpdata": {
                this.impFormData();
                break;
            }
            case "btncheckindata": {
                this.checkInFormData();
                break;
            }
            case "btnunittest": {
                this.unitTest();
                break;
            }
            case "btnutrelease": {
                this.unitTestRelease();
                break;
            }
            case "btnresetparent": {
                this.resetParent();
                break;
            }
        }
    }

    private void expFormData() {
        List<Map<String, String>> sel = this.getMulSelector();
        if (sel == null || sel.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u7684\u8868\u5355\u3002", (String)"FormListPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        for (Map<String, String> map : sel) {
            if (map.get(MODE_TYPE).equalsIgnoreCase("BaseFormModel") || ((String)map.get(MODE_TYPE)).equalsIgnoreCase("BillFormModel")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bfc\u51fa\u57fa\u7840\u8d44\u6599\u6216\u5355\u636e\u7684\u6570\u636e\u3002", (String)"FormListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashSet subSystemList = new HashSet();
        for (Map map : sel) {
            subSystemList.add(map.get(PARAM_SUBSYSTEM));
        }
        if (subSystemList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u5b50\u7cfb\u7edf\u3002", (String)"FormListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String subFNumber = (String)subSystemList.iterator().next();
        LibAddress libAddress = this.checkAddress(subFNumber);
        if (libAddress == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormListPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)libAddress.getLibAddress())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u8def\u5f84\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)FORM_LIST_PLUGIN_3, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<String> messageList = new ArrayList<String>(10);
        for (Map<String, String> map : sel) {
            AbstractDataSetOperater dbOperator = new AbstractDataSetOperater(map.get(FNUMBER));
            JSONObject retMap = dbOperator.expBaseData("d:\\");
            messageList.add(retMap.get(MESSAGE).toString());
            if (retMap.get("retcode").equals("0")) continue;
            break;
        }
        this.getView().showTipNotification(StringUtils.join((Object[])messageList.toArray(new String[0]), (String)"\r\n"));
    }

    private void impFormData() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_impmeta");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, NEW_FORM_CALLBACK);
        parameter.setCloseCallBack(callBack);
        parameter.setCustomParam("isCallBaseDataImpAndExp", (Object)true);
        this.getView().showForm(parameter);
    }

    private void checkInFormData() {
        List<Map<String, String>> sel = this.getMulSelector();
        if (sel == null || sel.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b7e\u5165\u6570\u636e\u7684\u8868\u5355\u3002", (String)"FormListPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        for (Map<String, String> map : sel) {
            if (map.get(MODE_TYPE).equalsIgnoreCase("BaseFormModel") || ((String)map.get(MODE_TYPE)).equalsIgnoreCase("BillFormModel")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u7b7e\u5165\u57fa\u7840\u8d44\u6599\u6216\u5355\u636e\u7684\u6570\u636e\u3002", (String)"FormListPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashSet subSystemList = new HashSet();
        for (Map map : sel) {
            subSystemList.add(map.get(PARAM_SUBSYSTEM));
        }
        if (subSystemList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u80fd\u540c\u65f6\u7b7e\u5165\u591a\u4e2a\u5b50\u7cfb\u7edf\u7684\u6570\u636e\u3002", (String)"FormListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String subFNumber = (String)subSystemList.iterator().next();
        LibAddress libAddress = this.checkAddress(subFNumber);
        if (libAddress == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormListPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)libAddress.getLibAddress())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u8def\u5f84\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)FORM_LIST_PLUGIN_3, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<String> messageList = new ArrayList<String>(10);
        for (Map<String, String> map : sel) {
            String number = map.get(FNUMBER);
            AbstractDataSetOperater dbOperator = new AbstractDataSetOperater(number);
            JSONObject retMap = dbOperator.commitBaseDataToSvn();
            messageList.add(retMap.get(MESSAGE).toString());
            if (!retMap.get("retcode").equals("-2")) continue;
            this.showLoginForm(retMap.get(PARAM_SUBSYSTEM).toString());
            return;
        }
        this.getView().showTipNotification(StringUtils.join((Object[])messageList.toArray(new String[0]), (String)"\r\n"));
    }

    private void unitTest() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "ide_unit_test");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey(TAB_AP);
        this.getView().showForm(showParameter);
    }

    private void unitTestRelease() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("ide_unit_test_detail");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TAB_AP);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void listDomainModelType() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_domainmodeltype");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private LibAddress checkAddress(String subFNumber) {
        LibAddress libAddress = MetadataUtil.getLibAddress(subFNumber);
        if (libAddress != null && StringUtils.isEmpty((CharSequence)libAddress.getLibAddress())) {
            boolean ide_svn_choselibIsDeprecated = true;
            if (ide_svn_choselibIsDeprecated) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201ccheckAddress\u201d%s\u5931\u8d25\uff0c\u201cgetLibAddress\u201d\u4e3a\u7a7a\u3002", (String)"FormListPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), subFNumber));
                return null;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_svn_choselib");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(SUB_FNUMBER, (Object)subFNumber);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SET_ADDRESS_CALLBACK));
            this.getView().showForm(parameter);
            return null;
        }
        return libAddress;
    }

    private void showLoginForm(String subFNumber) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_svn_login");
        parameter.setCustomParam(PARAM_SUBSYSTEM, (Object)subFNumber);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, LOGIN_CALLBACK));
        this.getView().showForm(parameter);
    }

    private void listSVNForm() {
        String fNumber;
        List<Map<String, String>> sel = this.getMulSelector();
        if (sel == null || sel.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b7e\u5165\u5143\u6570\u636e\u3002", (String)"FormListPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashSet<String> subSystemList = new HashSet<String>();
        for (Map<String, String> map : sel) {
            subSystemList.add(map.get(PARAM_SUBSYSTEM));
        }
        if (subSystemList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u5165\u7684\u5143\u6570\u636e\u4e0d\u80fd\u540c\u65f6\u5305\u542b\u591a\u4e2a\u5b50\u7cfb\u7edf\u3002", (String)"FormListPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String subFNumber = (String)subSystemList.iterator().next();
        LibAddress libAddress = this.checkAddress(subFNumber);
        if (libAddress == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormListPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        MetadataUtil metadataUtil = new MetadataUtil();
        OperationInfo operationInfo = new OperationInfo();
        boolean flag = metadataUtil.authorize(subFNumber, operationInfo);
        if (!flag) {
            if (operationInfo.getErrorMessageString().equals(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"FormListPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])) || StringUtils.isEmpty((CharSequence)operationInfo.getErrorMessageString())) {
                this.showLoginForm(subFNumber);
                return;
            }
            this.getView().showTipNotification(operationInfo.getErrorMessageString());
            return;
        }
        ArrayList<String> fileList = new ArrayList<String>(10);
        ArrayList<String> numberList = new ArrayList<String>(10);
        for (Map<String, String> map : sel) {
            fNumber = map.get(FNUMBER);
            numberList.add(fNumber);
        }
        metadataUtil.checkOutFiles(subFNumber, libAddress, numberList.toArray(new String[0]), operationInfo);
        for (Map<String, String> map : sel) {
            fNumber = map.get(FNUMBER);
            String fid = map.get("fid");
            operationInfo = metadataUtil.expMetadata(fid, libAddress);
            List<String> thisFileList = metadataUtil.getExePath(fNumber, libAddress);
            fileList.addAll(thisFileList);
        }
        if (!fileList.isEmpty()) {
            operationInfo = metadataUtil.commitToSVN(fileList, subFNumber, libAddress);
            if (!operationInfo.getErrorMessage().isEmpty()) {
                if (operationInfo.getErrorMessageString().contains("Authentication required for ")) {
                    this.showLoginForm(subFNumber);
                    return;
                }
                String errMsg = "";
                errMsg = operationInfo.getFilePath().isEmpty() ? MessageFormat.format(ResManager.loadKDString((String)"\u7b7e\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u5982\u4e0b:\r\n{0}", (String)"FormListPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), operationInfo.getErrorMessageString()) : MessageFormat.format(ResManager.loadKDString((String)"\u7b7e\u5165\u5931\u8d25\r\n\u7b7e\u5165\u6210\u529f\u6709\u6587\u4ef6\u6709\uff1a\r\n{0}\r\n\u5931\u8d25\u539f\u56e0\u5982\u4e0b:\r\n{1}", (String)"FormListPlugin_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), operationInfo.getFilePathString(), operationInfo.getErrorMessageString());
                this.getView().showErrorNotification(errMsg);
                return;
            }
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u7b7e\u5165\u6210\u529f\u3002", (String)"FormListPlugin_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), String.join((CharSequence)",", numberList.toArray(new String[0]))));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b7e\u5165\u5931\u8d25\uff0c\u6ca1\u6709\u9700\u8981\u7b7e\u5165\u7684\u672c\u5730\u6587\u4ef6\u3002", (String)"FormListPlugin_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void addNewPrintTemplate() {
        Map<String, String> sel = this.getCurrentSelector();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_newprinttemplate");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, NEW_LAYOUT_CALLBACK);
        parameter.setCustomParam("selectRow", sel);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void impForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_impmeta");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, NEW_FORM_CALLBACK);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void expForm() {
        List<Map<String, String>> sel = this.getMulSelector();
        HashSet<String> subSystemList = new HashSet<String>();
        for (Map<String, String> map : sel) {
            subSystemList.add(map.get(PARAM_SUBSYSTEM));
        }
        if (subSystemList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u7684\u5143\u6570\u636e\u4e0d\u80fd\u540c\u65f6\u5305\u542b\u591a\u4e2a\u5b50\u7cfb\u7edf\u3002", (String)"FormListPlugin_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String subFNumber = (String)subSystemList.iterator().next();
        LibAddress libAddress = this.checkAddress(subFNumber);
        if (libAddress == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u7cfb\u7edf\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormListPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)libAddress.getLibAddress())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u8def\u5f84\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)FORM_LIST_PLUGIN_3, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        MetadataUtil metadataUtil = new MetadataUtil();
        if (sel == null || sel.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u5143\u6570\u636e\u3002", (String)"FormListPlugin_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        ArrayList<String> messageList = new ArrayList<String>();
        for (Map<String, String> map : sel) {
            String fid = map.get("fid");
            OperationInfo operationInfo = metadataUtil.expMetadata(fid, libAddress);
            if (operationInfo == null) continue;
            messageList.addAll(operationInfo.getErrorMessage());
            fileList.addAll(operationInfo.getFilePath());
        }
        String filePathString = StringUtils.join((Object[])fileList.toArray(new String[0]), (String)"\r\n");
        String errorMessageString = StringUtils.join((Object[])messageList.toArray(new String[0]), (String)"\r\n");
        if (messageList.isEmpty()) {
            this.getView().showSuccessNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002\u5bfc\u51fa\u6587\u4ef6\u5217\u8868\uff1a\r\n{0}", (String)"FormListPlugin_18", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), filePathString));
        } else {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002\u5bfc\u51fa\u6210\u529f\u6709\u6587\u4ef6\u6709\uff1a\r\n{0}\uff0c\u5931\u8d25\u539f\u56e0\u5982\u4e0b\uff1a\r\n{1}", (String)"FormListPlugin_19", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), filePathString, errorMessageString));
        }
    }

    private void delForm() {
        Map<String, String> sel = this.getCurrentSelector();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_confirmdlg");
        parameter.setCustomParam(MESSAGE, (Object)String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u201c%s\u201d\u5417\uff1f", (String)"FormListPlugin_25", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), sel.get(PARAM_NAME)));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "delForm"));
        this.getView().showForm(parameter);
    }

    private void listForm() {
        Map<String, String> sel = this.getCurrentSelector();
        if (sel.get(PARAM_MODEL_TYPE).equalsIgnoreCase("WidgetFormModel") || sel.get(PARAM_MODEL_TYPE).equalsIgnoreCase("DynamicFormModel")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u4e0d\u5b58\u5728\u5217\u8868\u3002", (String)"FormListPlugin_22", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String id = sel.get(PARAM_ID);
        String entityId = sel.get("entityId");
        String modelType = sel.get(PARAM_MODEL_TYPE);
        String number = DesignerData.getNumberById(id);
        String entityNumber = DesignerData.getEntityNumberById(entityId);
        if ("MobileListModel".equals(modelType)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String mobileListURL = "#/dform?formId=" + number;
            proxy.addAction("openUrl", (Object)mobileListURL);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(entityNumber);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey(TAB_AP);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void previewMobList() {
        Map<String, String> sel = this.getCurrentSelector();
        if ("WidgetFormModel".equalsIgnoreCase(sel.get(PARAM_MODEL_TYPE)) || "DynamicFormModel".equalsIgnoreCase(sel.get(PARAM_MODEL_TYPE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u4e0d\u5b58\u5728\u5217\u8868\u3002", (String)"FormListPlugin_22", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String id = sel.get(PARAM_ID);
        String tempNumber = DesignerData.getNumberById(id);
        HashMap<String, String> para = new HashMap<String, String>();
        String number = BOS_MOBILEPREVIEW;
        para.put("formId", number);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setCustomParam(PARAM_NUMBER, (Object)tempNumber);
        showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)"moblist");
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        showParameter.setClientParam("preview", (Object)"true");
        this.getView().showForm(showParameter);
    }

    private void openForm() {
        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff1a\u7531\u4e8e\u5206\u5e93\u5206\u8868\u7684\u9700\u8981\uff0c\u60a8\u5fc5\u987b\u6307\u5b9a\u5e94\u7528\u3002\u5728\u6b64\u5904\u6253\u5f00\u5143\u6570\u636e\u4fdd\u5b58\u4f1a\u51fa\u9519\uff0c\u5982\u9700\u4fee\u6539\u5143\u6570\u636e\uff0c\u8bf7\u524d\u5f80\u5f00\u53d1\u8005\u5e73\u53f0\u3002", (String)"FormListPlugin_23", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageTypes.Default, new ConfirmCallBackListener());
    }

    private Map<String, String> getCurrentSelector() {
        HashMap<String, String> sel = new HashMap<String, String>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FORM_LIST);
        int row = grid.getEntryState().getFocusRow();
        if (row >= 0) {
            sel.put(PARAM_ID, (String)this.getModel().getValue(PARAM_ID, row));
            sel.put(PARAM_MODEL_TYPE, (String)this.getModel().getValue(PARAM_MODEL_TYPE, row));
            sel.put("entityId", (String)this.getModel().getValue(PARAM_ENTITY_ID, row));
            sel.put(PARAM_NUMBER, (String)this.getModel().getValue(PARAM_NUMBER, row));
            sel.put(PARAM_NAME, (String)this.getModel().getValue(PARAM_NAME, row));
            sel.put(PARAM_SYBSYSID, (String)this.getModel().getValue(PARAM_SYBSYSID, row));
            sel.put(SUB_FNUMBER, (String)this.getModel().getValue(PARAM_SUBSYSTEM, row));
        }
        return sel;
    }

    private List<Map<String, String>> getMulSelector() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FORM_LIST);
        int[] row = grid.getEntryState().getSelectedRows();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
        for (int i = 0; i < row.length; ++i) {
            HashMap<String, String> sel = new HashMap<String, String>();
            sel.put("fid", (String)this.getModel().getValue(PARAM_ID, row[i]));
            sel.put(MODE_TYPE, (String)this.getModel().getValue(PARAM_MODEL_TYPE, row[i]));
            sel.put(PARAM_ENTITY_ID, (String)this.getModel().getValue(PARAM_ENTITY_ID, row[i]));
            sel.put(FNUMBER, (String)this.getModel().getValue(PARAM_NUMBER, row[i]));
            sel.put(PARAM_SUBSYSTEM, (String)this.getModel().getValue(PARAM_SUBSYSTEM, row[i]) == null ? "Bos" : (String)this.getModel().getValue(PARAM_SUBSYSTEM, row[i]));
            list.add(sel);
        }
        return list;
    }

    private void newForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_newform");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, NEW_FORM_CALLBACK);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.openForm();
    }

    private void photos() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("pageId", this.getView().getPageId());
        proxy.addAction("photos", arg);
    }

    private void resetParent() {
        Map<String, String> sel = this.getCurrentSelector();
        String modelType = sel.get(PARAM_MODEL_TYPE);
        if (modelType != null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ide_formselector");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(MODE_TYPE, (Object)modelType);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "resetparentback");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private void resetParent(String newParentId) {
        Map<String, String> sel = this.getCurrentSelector();
        MetadataExtends.resetParent((String)sel.get(PARAM_ID), (String)newParentId);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u8868\u5355\u5df2\u91cd\u65b0\u6307\u5b9a\u3002", (String)"FormListPlugin_24", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }
}

