/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class FormSelectorPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    public static final String SHOW_ALL = "showall";
    public static final String FORM_LIST = "formlist";
    public static final String SUBSYSID = "subsysid";
    public static final String SUBSYSNAME = "subsysname";

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btncancel");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (SHOW_ALL.equalsIgnoreCase(e.getProperty().getName())) {
            this.getModel().deleteEntryData(FORM_LIST);
            Boolean isTemplate = (Boolean)this.getModel().getValue(SHOW_ALL);
            this.formListSearch(isTemplate);
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.getView().returnDataToParent(this.getCurrentSelector());
        this.getView().close();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.getView().returnDataToParent(this.getCurrentSelector());
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eo) {
        Boolean isTemplate = (Boolean)this.getModel().getValue(SHOW_ALL);
        this.formListSearch(isTemplate);
    }

    private void formListSearch(Boolean isTemplate) {
        List formList;
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        ArrayList<SqlParameter> sqlList = new ArrayList<SqlParameter>();
        sqlList.add(new SqlParameter(":FMODELTYPE", -9, (Object)(modeltype + "%")));
        sqlList.add(new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN"));
        String sql = "select a.FID, a.FNumber,a.FNAME,b.FSUBSYSID from T_META_ENTITYDESIGN_L a inner join T_META_ENTITYDESIGN b on a.FID = b.FID where b.FMODELTYPE like ? AND FLOCALEID = ?";
        if (!isTemplate.booleanValue()) {
            String isTemplateChar = "1";
            sqlList.add(new SqlParameter(":FISTEMPLATE", 1, (Object)isTemplateChar));
            sql = sql + "AND  b.FISTEMPLATE = ? ";
        }
        Object[] params = new SqlParameter[sqlList.size()];
        params = sqlList.toArray(params);
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        map.put("number", rs.getString(2));
                        map.put("name", rs.getString(3));
                        map.put(FormSelectorPlugin.SUBSYSID, rs.getString(4));
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (!formList.isEmpty()) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(FORM_LIST, formList.size());
            int i = 0;
            for (Map form : formList) {
                model.setValue("fid", form.get("id"), i);
                model.setValue("fnumber", form.get("number"), i);
                model.setValue("fname", form.get("name"), i);
                model.setValue("fsubsystemid", form.get(SUBSYSID), i);
                model.setValue("fsubsystemname", (Object)"", i);
                ++i;
            }
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FORM_LIST);
        int row = grid.getEntryState().getFocusRow();
        if (row < 0) {
            return null;
        }
        ret.put("id", this.getModel().getValue("fid", row));
        ret.put("name", this.getModel().getValue("fname", row));
        ret.put(SUBSYSID, this.getModel().getValue("fsubsystemid", row));
        ret.put(SUBSYSNAME, this.getModel().getValue("fsubsystemname", row));
        return ret;
    }
}

